export _strap_base_defined="x"
_strap_base() {
  local cur prev opts STRAPURL PMID2003
  STRAPURL=http://www.bioinformatics.org/strap
  
  COMPREPLY=()
  cur="${COMP_WORDS[COMP_CWORD]}"
  prev="${COMP_WORDS[COMP_CWORD-1]}"
  opts="-align= -load=  -pdb= \
   -toFasta -toMultipleFasta -toMSF -toClustal -toHTML -toWord \
   -allowFileModification=true \
   -warnInstall -askExec=true -askUpload=true -noCache=true -noSound=true \
   -cp=  -dialog=  -laf= \
   -edtftp=true  -log3d=true  \
   -manual  -stdout \
   -noIdentical=true -noSeqres=true -probeWebProxy=true \
   -script= -scriptOutput= -geometry=
  "
  case $cur in
    JVM_*)            
           COMPREPLY=( $(compgen -W "JVM_-Xmx300M JVM_-ea  JVM_-DproxyHost=proxy JVM_-DproxyPort=888 " -- ${cur}) )
           return 0
           ;;        
    -geometry=*)
                 cur=${cur#*=}
                 COMPREPLY=( $(compgen -W "1400x900+100+10  999x444+11+22" -- ${cur}) )
                 return 0
                 ;;
    -script=*)
               cur=${cur#*=*}                              
               scripts=$STRAPURL/scripts/HbA_alignment.txt
               COMPREPLY=( $(compgen -W  "${scripts}" -- ${cur}) )
               return 0
               ;;

   -scriptH=*)
               cur=${cur#*=*}               
               scripts=$STRAPURL/scripts/HbA_with3D.txt
               COMPREPLY=( $(compgen -W  "${scripts}" -- ${cur}) )
               return 0
               ;;

   -script1=*)
               cur=${cur#*=*}               
               scripts=$STRAPURL/PDF/2003/PMID12595256/1.txt
               COMPREPLY=( $(compgen -W  "${scripts}" -- ${cur}) )
               return 0
               ;;

   -script6=*)
               cur=${cur#*=*}               
               scripts==$STRAPURL/PDF/2003/PMID12595256/6.txt
               COMPREPLY=( $(compgen -W  "${scripts}" -- ${cur}) )
               return 0
               ;;

   -scriptH1=*)
               cur=${cur#*=*}               
               scripts=$STRAPURL/dataFiles/scriptExamples/toHTML1.txt
               COMPREPLY=( $(compgen -W  "${scripts}" -- ${cur}) )
               return 0
               ;;
    -cp=*)
           cur=${cur#*=} 
           cp=$(ls   --color=never /usr/share/java/*laf.jar &> /dev/null)
           
           COMPREPLY=( $(compgen -W  "${cp}" -- ${cur}) )
           return 0
           ;;
    -stdout=*)
               cur=${cur#*=}
               COMPREPLY=( $(compgen -W  "true false" -- ${cur}) )  
               return 0
               ;;
    
    -laf=*)
            cur=${cur#*=}
            lafs="de.muntjak.tinylookandfeel.TinyLookAndFeel com.sun.java.swing.plaf.gtk.GTKLookAndFeel com.sun.java.swing.plaf.motif.MotifLookAndFeel com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel"
            COMPREPLY=( $(compgen -W  "${lafs}" -- ${cur}) )  
            return 0
            ;;
    
    -dialog=*)
               cur=${cur#*=}
               COMPREPLY=( $(compgen -W  "DialogAlign DialogAlignOneToAll DialogBarChart DialogBlast DialogCompareProteins DialogDifferentResidues DialogDotPlot DialogExportAlignment DialogExportWord DialogFetchPdb DialogFetchSRS DialogGenbank DialogHighlightPattern DialogImportMFA DialogInferCDS DialogNeighbors DialogNewProtein DialogPhylogeneticTree DialogPlot DialogPredictCoiledCoil DialogPredictSecondaryStructures DialogPredictTexshade DialogPredictTmHelices2 DialogPublishAlignment DialogRenameProteins DialogResidueAnnotationChanges DialogResidueAnnotationList DialogSelectionOfResiduesMain DialogSuperimpose3 DialogExportProteins Dialog_bl2seq" -- ${cur}) )  
               return 0
               ;;
    
    -*)
        COMPREPLY=( $(compgen  -o nospace -W "${opts}" -- ${cur}) )        
        #if [[ $COMPREPLY == *= ]]; then compopt -o nospace 2> /dev/null; fi
        
        return 0
        ;;
  esac
  
  COMPREPLY=( $(compgen -f -- ${cur}) )        
  
}




_strap_export() {
  local cur prev opts
  COMPREPLY=()
  cur="${COMP_WORDS[COMP_CWORD]}"
  prev="${COMP_WORDS[COMP_CWORD-1]}"
  opts=" -o \
   -script=  -scriptOutput= \
   -allowFileModification=true  -probeWebProxy=true \
   -warnInstall -askExec=true -askUpload=true -noCache=true \
   -noIdentical=true -noSeqres=true \
   "
  
  case $cur in
    -*)
        COMPREPLY=( $(compgen -o nospace -W  "${opts}" -- ${cur}) )  
        #if [[ $COMPREPLY == *= ]]; then compopt -o nospace 2> /dev/null; fi
        return 0
        ;;
  esac
  COMPREPLY=( $(compgen -f -- ${cur}) )     
  
}

complete -F _strap_base   strap_{protein_alignment,_base}

complete -F _strap_export strap_to_{fasta,multiple_fasta,word,msf,clustal,clustal,msf}





