#! /bin/bash -u
readonly PARAMETERS=66
_initialized=0
declare -A _methodInitialized
declare -A _macroDefined
readonly ANSI_FG_WHITE=$'\e[37m'
readonly ANSI_RED=$'\e[41m'
readonly ANSI_FG_CYAN=$'\e[36m'
readonly ANSI_MAGENTA=$'\e[45m'
readonly ANSI_RESET=$'\e[0m'
readonly ANSI_GREEN=$'\e[42m'
readonly ANSI_BLACK=$'\e[40m'
readonly ANSI_FG_GREEN=$'\e[32m'
readonly ANSI_FG_BLUE=$'\e[34m'
readonly ANSI_FG_RED=$'\e[31m'
readonly ANSI_FG_MAGENTA=$'\e[35m'
readonly ANSI_INVERSE=$'\e[7m'
readonly ANSI_UL=$'\e[4m'
readonly ANSI_BOLD=$'\e[1m'
readonly STYLE_JAVA=$ANSI_FG_CYAN
readonly STYLE_SH=$ANSI_FG_GREEN$ANSI_BLACK



Init(){
    echo -n '#define _MACRO_XXXX('
    for((i=0;i<PARAMETERS;i++)); do echo -n a$i,; done
    echo '...) ' a$((PARAMETERS-1))
    echo
    echo -n '#define MACRO_CHOOSER(m,...) _MACRO_XXXX(allowsZeroParameters,## __VA_ARGS__'
    for((i=PARAMETERS-1;--i>=0;)); do echo -n ,m##$i; done
    echo ')'
    echo
}
Macro(){
    local fn=$1
    ((_initialized++))||Init
    shift 1
    local givenParameters=
    local parameters=
    count=0
    for par in $*; do
        if [[ ${par%=*} == $par ]]; then
            givenParameters=$givenParameters,${par%=*}
            ((count++))
        fi
        parameters=$parameters,${par#*=}
    done
    if [[ -z ${_methodInitialized[$fn]:-} ]]; then
        _methodInitialized[$fn]=1
        echo
        echo '#define '$fn'(...) MACRO_CHOOSER('$fn'_MACRO,__VA_ARGS__)(__VA_ARGS__)'
        echo '#define '$fn'_MACRO'$#'(...) '$fn'(__VA_ARGS__)'
        _macroDefined[$fn'_MACRO'$#]=1
    fi
    local macro=$fn'_MACRO'$count
    if [[ -z ${_macroDefined[$macro]:-} ]]; then
        _macroDefined[$macro]=1
        echo '#define '$macro'('${givenParameters#,}') '$fn'('${parameters#,}')'
    else
        echo -e $ANSI_RED'Error: '$ANSI_RESET' Macro already defined for "'$fn'" with '$count' parameters' > /dev/stderr
    fi
}
MacroForMulti(){
    local fn=${1:-a}
    local macro=${2:-aa}
#    macro_chooser
    source cpp_env.sh || exit 1
    echo '#define '$macro'(...) MACRO_CHOOSER('$macro'_MACRO,__VA_ARGS__)(__VA_ARGS__)'
    echo '#define CASE_ARGV(...) MACRO_CHOOSER(CASE_ARGV_MACRO,__VA_ARGS__)(__VA_ARGS__)'
    for(( i=2; i<33; i++)); do
        echo -n '#define '$macro'_MACRO'$i'('
        local v=
        for(( a=1;a<i; a++)); do
            echo -n a$a,
            v=$v$fn'('a$a').'
        done
        echo a$i') '$v$fn'('a$i')'
    done
    echo
}

DA_EXAMPLE_1='Macro my_strstr options   needle haystack from=0 to=0x7fffffff'
DA_EXAMPLE_2='Macro my_strstr options=0 needle haystack from=0 to=0x7fffffff'
DA_EXAMPLE_M='MacroForMulti append appendMulti'

DA_EXAMPLE_F_DEF_BB='public static int my_strstr(int option_flags,byte[] needle,byte[] haystack,int f,int t) { .... return -1;}'
DA_EXAMPLE_F_DEF_SB='public static int my_strstr(int option_flags,String needle,byte[] haystack,int f,int t) { .... return -1;}'

DA_EXAMPLE_JAVA_1='my_strstr(STRSTR_WHOLE_WORD|STRSTR_IGNORE_CASE,"cat","cat dog and chicken");'
DA_EXAMPLE_JAVA_2='my_strstr("cat","cat dog and chicken");'
DA_EXAMPLE_JAVA_M="sb.appendMulti(i,' ',result.name(),' ',result.score(),'\n');"
DefaultArgumentsHelp(){
    cat <<EOF
$ANSI_UL${ANSI_BOLD}THIS SCRIPT GENERATES C-PREPROCESSOR MACROS TO IMPLEMENT DEFAULT ARGUMENTS$ANSI_RESET

A default argument is an argument to a function that a programmer is not required to specify.
See https://en.wikipedia.org/wiki/Default_argument
In C++ and Java this can easily be achieved using polymorphic functions i.e. functions with the same name but different types and numbers of arguments.
See https://en.wikipedia.org/wiki/Polymorphism_(computer_science)

For the language C however, this can only be accomplished with the C-preprocessor.
See https://gcc.gnu.org/onlinedocs/gcc-3.1/gcc/Variadic-Macros.html
It is however complicated and verbose.
This script generates the preprocessor macros in a convenient way.

$ANSI_BOLD EXAMPLE 1:$ANSI_RESET
Assume, there is a set of Java methods for seaching a text in another text.
The pattern and the text may be of type String, byte[] and char[].
 ${STYLE_JAVA}${DA_EXAMPLE_F_DEF_BB}
 ${DA_EXAMPLE_F_DEF_SB}${ANSI_RESET}
  ...
For convenience, you want to make the first and the last two arguments optional.
For searching the entire String, the last two parameters "from postion" and "to postion" can be left off
because the default values 0 and 0x7fffffff are defined implicitly.
If no special search option is required, the first parameter can be skipped as well.
After sourcing this script, a command will be available to generate the preprocessor macros.
There can be only one macro for each number of arguments.
The script will complain, if for example two different method calls both having 4 parameters are defined.
${STYLE_SH}  source ${BASH_SOURCE[0]}
  ${DA_EXAMPLE_1}
  ${DA_EXAMPLE_2}${ANSI_RESET}

In the source code (java or C-file) the optional parameters do not need to be given any more.
${STYLE_JAVA}${DA_EXAMPLE_JAVA_1}
${DA_EXAMPLE_JAVA_2}$ANSI_RESET

///
$ANSI_BOLD EXAMPLE 2: $ANSI_RESET Appending to StringBuffer
In Java, strings are constructed with the java.lang.StringBuffer class:
A code fragment could like like:
   ${STYLE_JAVA}final StringBuffer sb=new StringBuffer(999);
   for(int i=0;i<result.length;i++){
     sb.append(i).append(' ').append(result.name()).append(' ').append(result.score()).append('\n');
  }${ANSI_RESET}
Well, this looks ugly -  "append(...)" needs to be typed many times.
With preprocessor macros, the code could be written in a more compact way:
  ${STYLE_JAVA}${DA_EXAMPLE_JAVA_M}$ANSI_RESET
The respective preprocessor macros are generated with
   ${STYLE_SH}${DA_EXAMPLE_M} ${ANSI_RESET}

///
To see the generated preprocessor macros for above examples, start this script with the command line option -e
  ${STYLE_SH}${BASH_SOURCE[0]} -e ${ANSI_RESET}

To observe how these preprocessor macros affect the source code, feed the result into the C-preprocessor
  ${STYLE_SH}${BASH_SOURCE[0]} -e | cpp${ANSI_RESET}


EOF
}

while getopts he opt; do
	case $opt in
        h ) DefaultArgumentsHelp
            exit;;
	esac
	case $opt in
        e )
            echo '/* This goes into the header file */'
            eval $DA_EXAMPLE_1
            eval $DA_EXAMPLE_2
            eval $DA_EXAMPLE_M
            echo '/* ------------------------------ */'
            echo
            echo '/* This is in the source code */'
            echo $DA_EXAMPLE_JAVA_1
            echo $DA_EXAMPLE_JAVA_2
            echo $DA_EXAMPLE_JAVA_M
            exit;;
	esac

done
MacroForMulti
