#! /bin/bash -u
reset
set -o pipefail
cd ${BASH_SOURCE[0]%/*}
source $STRAP_SRC/SOURCE_ME_MAKE_STRAP.sh
cppSetCheckCode 0  || die cppSetCheckCode
cppSetTarget A || die cppSetTarget
source $STRAP_SRC/SOURCE_ME_MAKE_STRAP.sh
source cpp/cppGenerateHeader.sh >/dev/null ||die cppGenerateHeader.sh
src/noGui/generateCode/UpdateEnumerations.sh

readonly PREVIOUS=$STRAP_PREPROCESSED/../alignment2html.previousSize
xsetroot -solid darkgray >/dev/null;
readonly JAR=$STRAP_PREPROCESSED/alignment2html.jar
echo $ANSI_RESET " Make $JAR \007"
mkdir -p $STRAP_PREPROCESSED
DO_COMPILE=true
NO_JAR=
while getopts "cj" opt; do
    case $opt in
        c ) DO_COMPILE=;;
        j ) NO_JAR=true;;
    esac
done

shift $((OPTIND-1))
{
    if [[ $DO_COMPILE ]]; then
        RmPreprocessed.sh
        cpp/cppPreprocess.sh
        $STRAP_JAVAC -cp $STRAP_PREPROCESSED:$(echo /local/java/strap/otherPackages/compileTime/*.jar|tr ' ' ':') -Xmaxerrs 99 $STRAP_PREPROCESSED/CompileEverything.java||exit 1
    fi
    [[ $CPP_WITH_CHECK_CODE == 1 ]] && echo $ANSI_INVERSE CPP_WITH_CHECK_CODE $ANSI_RESET && exit
    pushd $STRAP_PREPROCESSED
    echo -e "Main-Class: charite.christo.strap.Strap\nPermissions: all-permissions">M
    readonly classes=$(find charite -name "[A-Z]*.class")
    [[ -z $classes ]] && echo $RED_ERROR No class files && exit 1
    grepValueOf $classes
    [[ -z $NO_JAR ]] || exit
    jar -cmf0 M $JAR $classes
    popd
    echo -e $ANSI_FG_MAGENTA 'Previous:'; cat $PREVIOUS; echo $ANSI_RESET
    [[ -f /usr/bin/espeak ]] && espeak "done "$(stat --printf="%s"  $JAR)&
}

pushd $STRAP_PREPROCESSED >/dev/null
readonly src=alignment2html.zip
rm -f $src
#tar -czf $src $(find . -name '*.class' |fgrep -v '$' |sed -e 's|class$|java|1' -e 's|^./||1')
zip -q -r $src $(find . -name '*.class' |fgrep -v '$' |sed -e 's|class$|java|1' -e 's|^./||1') src/aa/charite/christo/aaSetup/DownloadPdbCif.sh
ls -l $PWD/alignment2html.*|tee $PREVIOUS
popd >/dev/null
# if [[ $JAVASCRIPT ]]; then
#     mkdir -p ~/.tmp/misc
#     cat $DIR/web/toHTML/toHTML.js $DIR/web/toHTML/compl.js $DIR/web/replaceCrossRefs.js >~/.tmp/misc/t.js
#     ccencrypt -K f1000_2014 -f ~/.tmp/misc/t.js
#     mv ~/.tmp/misc/t.js.cpt ~/.tmp/misc/js
#     tar -uf  "$tar" -C ~/.tmp misc/js
# fi

for i in alignment2html.{jar,src.zip,rsc}; do
    if ! [[ -L /var/www/aa/$i ]]; then
        rm /var/www/aa/$i
        ln -s $STRAP_PREPROCESSED/$i /var/www/aa/
    fi
done
echo
echo AAsource
echo AA_proguard
echo 'JetSetEnvironment; ~/Project/strap/compileJet/build_alignment2html.sh'

## http://stackoverflow.com/questions/4692076/speed-up-application-start-by-adding-own-application-classes-to-classes-jsa
# http://www.webagesolutions.com/knowledgebase/waskb/waskb030/
# java -Xshareclasses:name=myCache -jar MyApp.jar
#  time java -Xshareclasses:name=myCache -jar $DIR/alignment2html.jar swiss.mfa -toHTML
