#! /bin/bash -u
# -- BEGIN CONFIGURATION ---
export STRAP_BUILD=${STRAP_BUILD:-~/strapBuild}


# ---      BEGIN CONFIGURATION      ---
# tmp could be a RAM disk of > 20MByte
#   Line in /etc/fstab tmpfs
#         /mnt/tmpfs tmpfs rw,user,noatime,nodiratime,size=66M,exec 0 0
#     Everyone can read and write
#        chmod a+w /mnt/tmpfs
#
#   Create soft link
[[ -d /mnt/tmpfs ]] && mkdir -p /mnt/tmpfs/Java
#   ln -s  /mnt/tmpfs/Java/preprocessed/ $STRAP_PREPROCESSED
#
#
#  If there is a web proxy
#  export http_proxy=type-host-name-here:8080
# --      END CONFIGURATION      ---


javac7=/local/java/jdk7/bin/javac
if [[ -x $javac7 ]]; then
    export STRAP_JAVAC=$javac7;
else
    export STRAP_JAVAC=javac;
fi
export CPP_GENERATED_RSC_CUT_THIS_OFF=_Rsc_Cut_This_Off_
export CPP_CLUSTALW_NAME=clustalw_2_1.3
export CPP_TM_ALIGN_NAME=TMalign.3
export SED_UNSTRINGIZE='s|-SED_DEL_FOLLOWING_DQ-"\?||g;s|"\?-SED_DEL_PRECEDING_DQ_||g;s|-SED_SPACE-| |g'
export ANSI_RED=$'\e[41m'
export ANSI_MAGENTA=$'\e[45m'
export ANSI_RESET=$'\e[0m'
export ANSI_GREEN=$'\e[42m'
export ANSI_FG_GREEN=$'\e[32m'
export ANSI_FG_RED=$'\e[31m'
export ANSI_FG_MAGENTA=$'\e[35m'
export RED_ERROR=$ANSI_RED' Error '$ANSI_RESET
export RED_WARNING=$ANSI_RED' Warning '$ANSI_RESET
export GREEN_SUCCESS=$ANSI_GREEN' Success '$ANSI_RESET
export ANSI_INVERSE=$'\e[7m'
export ANSI_UL=$'\e[4m'
export ANSI_BOLD=$'\e[1m'


pushd ${BASH_SOURCE[0]%/*} >/dev/null
export STRAP_SRC=$PWD
export STRAP_AUTHOR=${STRAP_AUTHOR:-0}
export STRAP_ENV=$STRAP_SRC/cpp/cpp_env.sh
source $STRAP_ENV
for i in  $(printenv  | grep '^CPP_' ); do export $i; done

export STRAP_PREPROCESSED=$STRAP_BUILD/tmp
export CPP_DIR_SRC_GENERATED=$STRAP_PREPROCESSED/generatedCode
mkdir -p $CPP_DIR_SRC_GENERATED

popd >/dev/null




rmComments() {
    sed  's|^ */\*.*\*/$||1;  s|^ *//.*||g;  /^$/d;  s| */\*X.*\*/$||1;  s|^#endif .*|#endif|1'
}
die() {
    echo -e $0 $RED_ERROR $* $ANSI_RESET
    sayError
    exit 1
}
sayError(){
    #xsetroot -solid red;
    # anypaper sm
    ##[[ -f /usr/bin/espeak ]] && espeak "Err "
    [[ -f /usr/bin/meltdown ]] && meltdown -wait -1
    [[ -f /usr/bin/notify-send ]] && notify-send -t 3333 -c im.error -i $STRAP_SRC/error.png $@
    ##read aaaaaaaaa
}
saySuccess(){
    xflip
    [[ -f /usr/bin/notify-send ]] && notify-send -t 1111 -i $STRAP_SRC/success.png $@
}

anyKey(){
    read -n1 -r -p 'Press any key to continue ...' key
}

RenameIfDifferent(){
    src=$1
    dst=$2
    if ! [[ -f $dst ]] || ! diff -q $src $dst; then
        mv -f $src $dst
    fi
}
compileCC() {
    local bin=$STRAP_BUILD/${1##*/}
    bin=${bin%.c}
    if [[ $1 -nt $bin ]]; then
        cmd='gcc '$1' -o '$bin; $cmd||die $cmd
    fi
    echo $bin
}

cppSearchPaths(){
    for d in $(find $JAVA_ROOTS -type d); do
        jj=($d/*Inc.java)
        [[ $jj != *\** ]] && echo -n ' -I'$d' '
    done
    echo
}

grepValueOf(){
    ff=$*
    (($#==0))&&ff=$(find $STRAP_PREPROCESSED/ -name '*.class')
    echo -e $ANSI_INVERSE fgrep -w -l valueOf $ANSI_RESET as_indicator_for_auto_boxing  $ANSI_RED
    fgrep -w -l valueOf $ff
    echo -n $ANSI_RESET
}
