#!/usr/bin/gawk
##  p=~/kannWeg/process.txt; echo hello  t1.java:40 world  > $p| cat ~/kannWeg/lines.txt | awk -f ~/java/cpp/cppConvert.awk -v process=$p
# Requires gawk !!!
function red(s)     { return "\033[1;31m" s "\033[0m";}
function green(s)   { return "\033[1;32m" s "\033[0m";}
function blue(s)    { return "\033[1;34m" s "\033[0m";}
function yellow(s)  { return "\033[1;43m" s "\033[0m";}
function inverse(s) { return "\033[1;7m" s "\033[0m";}

#Example input
#238	# 937 "/home/c/strapSrc/cpp/cpp_java.c" 2
#240	# 1 "<command-line>" 2
#241	# 1 "/home/c/strapSrc/src/noGui/charite/christo/strap/ResidueAnnotation.java"
#391	# 1 "/home/c/strapSrc/src/noGui/charite/christo/strap/ResidueAnnotation_EntryInclude.java" 1

function readLineMarks(clazz,line,ff) {
# Parameter clazz is the short clazz name without packages
    if (_prevClazz!=clazz) {
        _prevClazz=clazz
        delete lines
        if (debug) print green("readLineMarks for "clazz" dir=" STRAP_PREPROCESSED);
        cmd="cat $(find "STRAP_PREPROCESSED"/ -name "clazz".java.lines) "

        while ((cmd | getline line)>0) lines[line+0]=line
        close(cmd)
        if (debug) print green("readLineMarks done ========================================");
    }
}

BEGIN {
    ANSI_RESET="\033[0m"
    lines[1]="";
    debug=0;
    LINES_LINE_NUM=1;
    LINES_FILE=4;
    LINES_LINE_NUM_OTHER=3;
    if (debug) print "process";
}

 {
     print $0b
     if (match($0,"([A-Za-z0-9_]+).java\\)?:([0-9]+)(.*)",array)) {
         class=array[1];
         num=array[2];
         remaining=array[3]
         readLineMarks(class)
         # Write file colon num for lines like "charite.christo.ChUtils.viewFile(ChUtils.java:13866)"
         if (match($0,"([A-Za-z0-9_.]+\\.)\\w+\\.\\w+\\((\\w+\\.java:[0-9]+)\\)",array)) {
             path=array[1]
             gsub("\\.","/",path)
             print inverse(STRAP_PREPROCESSED "/" path array[2] "\n")
         } else print inverse($0);
         if (debug) print yellow(" class="class" num="num);
         for(i=num; i>=0; --i) {
             if (lines[i]) {
                 if (debug) print red(" lines["i"]="lines[i]);
                 split(lines[i],ff," ");
                 output=gensub("\"","","g",ff[LINES_FILE])":"(ff[LINES_LINE_NUM_OTHER]+num-ff[LINES_LINE_NUM]-2) remaining
                 gsub("\\)$","",output)
                 print ANSI_RESET output;
                 if (debug) print red(" lines["i"]="lines[i]);
                 break;
             }
         }
     }

 }
