#! /bin/bash -u
set -o pipefail
### URL  https://gcc.gnu.org/onlinedocs/cpp/Invocation.html#Invocation
# JAVA_ROOTS:
#    Directory where the *.java files are found.
#    Or space separated list of directories
#    Give absolute paths.
#    Trailing slash no matter.
# HEADERS
#    Contains all cpp makros.
# SEARCH_PATH
#    for #include statement
# STRAP_PREPROCESSED
#    should be a directory like $HOME/.tmp/Java/preprocessed for the intermediate files.
# DIR
#    The parent of this script and other related scripts
#    Will be assigned automatically
# PREVIOUS -rw-r--r-- 1 c c 2664970 Aug 15 13:20 $STRAP_SRC/strap.jar
# fstandalone  -nostdinc  -ffreestanding
readonly DEFS_FOR_CPP='-D CPP_TIME_1970='$(date +%s)' -D WRITE_CONCATENATED_JAVA=0'
export RUN_CPP='cpp -nostdinc -ffreestanding '$DEFS_FOR_CPP

stdErr() {
    retCode=$?
    (( $retCode )) && die "$RED_ERROR ${1:-} Exit-code=$retCode\n less $stdErr\n${2:-}";
}
delUnlessUptodate() {
    [[ -f $1 ]] || return 0
    local newest=$(ls -1 -t --color=never $* 2>/dev/null|head -1)
    if ! [[ $newest == $1 ]]; then
        [[ $1 == $STRAP_PREPROCESSED* ]] || die $RED_ERROR'delUnlessUptodate '$1
        echo delUnlessUptodate del $1
        rm $1
        return 0
    fi
    return 1
}
oneShiftLeftPrepare() {
    for (( i=0;  i<17;i++)); do  printf 's|(1<<'$i')|%d|1;'    $((1<<$i)); done
    for (( i=17; i<32;i++)); do  printf 's|(1<<'$i')|0x%x|1;'  $((1<<$i)); done
}
oneShiftLeft() {
    sed '/<</{ s|(1<<0)|1|1;s|(1<<1)|2|1;s|(1<<2)|4|1;s|(1<<3)|8|1;s|(1<<4)|16|1;s|(1<<5)|32|1;s|(1<<6)|64|1;s|(1<<7)|128|1;s|(1<<8)|256|1;s|(1<<9)|512|1;s|(1<<10)|1024|1;s|(1<<11)|2048|1;s|(1<<12)|4096|1;s|(1<<13)|8192|1;s|(1<<14)|16384|1;s|(1<<15)|32768|1;s|(1<<16)|65536|1;s|(1<<17)|0x20000|1;s|(1<<18)|0x40000|1;s|(1<<19)|0x80000|1;s|(1<<20)|0x100000|1;s|(1<<21)|0x200000|1;s|(1<<22)|0x400000|1;s|(1<<23)|0x800000|1;s|(1<<24)|0x1000000|1;s|(1<<25)|0x2000000|1;s|(1<<26)|0x4000000|1;s|(1<<27)|0x8000000|1;s|(1<<28)|0x10000000|1;s|(1<<29)|0x20000000|1;s|(1<<30)|0x40000000|1;s|(1<<31)|0x80000000|1 }'
}
makeDotH() {
    cd ${THIS%/*}
    echo $ANSI_INVERSE --- j.h and rsc.h --- $ANSI_RESET
    cp $HEADER $MACROS_JAVA.tmp
    cp $HEADER_FOR_RSC $MACROS_RSC.tmp
    local FF_HEADER=$(find $JAVA_ROOTS $CPP_DIR_SRC_GENERATED/ -name '[a-zA-Z]*.h')
    local FF_HEADER_RSC=$(echo $FF_HEADER|tr ' ' '\n'|fgrep _rsc)
    cat $FF_HEADER_RSC|rmComments|oneShiftLeft|fgrep -v '...)'>>$MACROS_RSC.tmp ||die $MACROS_RSC.tmp
    cat $FF_HEADER|rmComments|oneShiftLeft >>$MACROS_JAVA.tmp ||die $MACROS_JAVA.tmp
    echo '#define CPP_DATE "'$(date +'%Y_%m_%d')'"' >>$MACROS_RSC.tmp
    echo '#define CPP_HOUR_MINUTE "'$(date +'%H:%M')'"'>>$MACROS_RSC.tmp
    RenameIfDifferent $MACROS_JAVA.tmp $MACROS_JAVA
    RenameIfDifferent $MACROS_RSC.tmp $MACROS_RSC
    echo -n $ANSI_FG_GREEN
    ls -l $MACROS_JAVA $MACROS_RSC
    echo -n $ANSI_RESET
}
formatRsc() {
#-e 's|\bBUT_C2(\(\w\+\),\(\w\+\))|BUT_C_\1_\2|g'\
    # The preprocessor concatenation operator ## does not work. Makros BUT_C1 and BUT_C2 fail.
    sed -e 's|^#endif //.*|#endif|1' -e 's|\bBUT_C1(\(\w\+\))|BUT_C_\1|g'|\
        gpp -U '' '' '(' ',' ')' '(' ')' '$' '' -M '\n#\w' '\n' ' ' ' ' '\n' '' '' -n --include $1|\
        sed -e "s|$CPP_GENERATED_RSC_CUT_THIS_OFF||g" -e 's|\bCPP_HASH\b|#|g' -e "$SED_UNSTRINGIZE" -e 's|=alias(\([0-9]\+\))|=\1|g' |\
        grep .
}


makeManPage() {
    readonly header=$1
    # Wichtig: Erst preprocessor, dann nroff
    if [[ $MANUAL_SRC -nt $MANUAL_GENERATED ]] || [[ $THIS -nt $MANUAL_GENERATED ]]; then
        echo $ANSI_INVERSE --- man page ---  $0 $ANSI_RESET
        rm -f $MANUAL_GENERATED 2>/dev/null
        if (($CPP_PRG_AA)); then
            cat $MANUAL_SRC|formatRsc $header >$MANUAL_GENERATED || echo $0 $RED_ERROR man=$MANUAL_SRC
            chmod +x $MANUAL_GENERATED
        else
            echo '@*RSC_MAN_PAGE'|formatRsc $header >$MANUAL_GENERATED
            pushd ${MANUAL_SRC%/*}
            cat $MANUAL_SRC|formatRsc $header|nroff -man >>$MANUAL_GENERATED || echo $0 $RED_ERROR man=$MANUAL_SRC
            popd
            echo '*@'>>$MANUAL_GENERATED
        fi
        ls -l $MANUAL_GENERATED
        echo Man page $MANUAL_GENERATED $ANSI_FG_GREEN done $ANSI_RESET
    else
        echo Man page $MANUAL_GENERATED $ANSI_FG_GREEN Up-to-date $ANSI_RESET
    fi
}


makeRsc(){
    local h=$STRAP_PREPROCESSED/tmp/allRscDotH.h
    mkdir -p ${h%/*}
    cat $MACROS_RSC $STRAP_SRC/src/noGui/generateCode/*rsc*.h >$h.tmp
    RenameIfDifferent $h.tmp $h
    ls -l $h
    if (($CPP_PRG_AA)); then
        echo $ANSI_INVERSE CPP_PRG_AA $ANSI_RESET
        RSC_EARLY=$STRAP_PREPROCESSED/alignment2html.rsc
        local RSC_LATE=
    else
        echo $ANSI_INVERSE CPP_PRG_STRAP $ANSI_RESET
        local RSC_EARLY=$STRAP_PREPROCESSED/rscEarly.rsc
        local RSC_LATE=$STRAP_PREPROCESSED/rscLate.rsc
    fi
    makeManPage $h
    if ! (($CPP_WITH_CHECK_CODE)) && ( delUnlessUptodate $RSC_EARLY $CPP_GENERATED_RSC_EARLY $h $THIS || delUnlessUptodate $RSC_LATE $CPP_GENERATED_RSC_LATE $h $MANUAL_GENERATED $THIS); then
        echo Resource files
        ls -l $CPP_GENERATED_RSC_EARLY $h

        cat $CPP_GENERATED_RSC_EARLY |formatRsc $h|oneShiftLeft>$RSC_EARLY
        ls -l $RSC_EARLY
        stdErr genericPreprocessor
        if (($CPP_PRG_STRAP)); then
            ls -l $CPP_GENERATED_RSC_LATE
            cp $MANUAL_GENERATED $RSC_LATE
            cat $CPP_GENERATED_RSC_LATE|formatRsc $h>>$RSC_LATE
            ls -l $RSC_LATE
        fi
        stdErr genericPreprocessor
        grep '^/\*[A-Za-z_]' $RSC_EARLY $RSC_LATE |head && die SLASH_ASTERISK grep "'^/\*[A-Za-z_]'" $RSC_EARLY $RSC_LATE
        echo $ANSI_INVERSE Looks_like_constant_in_RSC  $ANSI_RESET $RSC_EARLY $RSC_LATE $ANSI_FG_RED
        local CheckRsc=$(compileCC $DIR/CheckRsc.c)

        local ALLOWED_UC=$STRAP_PREPROCESSED/tmp/allowedUC.h
        cp $DIR/CheckRsc_not_a_variable.txt $ALLOWED_UC
        cat $CPP_GENERATED_ALLOWED_UPPERCASEWORD >>$ALLOWED_UC
        cat $RSC_EARLY $RSC_LATE|$CheckRsc|uniq|cpp -P --imacros $ALLOWED_UC|grep .|sort|uniq |grep .&& die CheckRsc

#        ls -l $ALLOWED_UC;        exit 1
        #aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa
        echo $ANSI_RESET
    else
        echo $ANSI_FG_GREEN Resource files up-to-date $ANSI_RESET
    fi
    echo 'Resource files done  '  RSC_EARLY=$RSC_EARLY ' ; ' RSC_LATE=$RSC_LATE $ANSI_FG_GREEN  $ANSI_RESET
}
echo 'NOTE: Preprocessing with tcc -E is faster than cpp of GCC'
[[ -z ${http_proxy+x} ]] && readonly TCC=/local/c/tcc-0.9.27/tcc || readonly TCC=/local/c/tcc-0.9.27/tcc_oldGlibc
if [[ -f $TCC ]]; then
    USE_TCC=1
    echo $ANSI_GREEN Using tcc $ANSI_RESET
else
    USE_TCC=0
    echo $ANSI_MAGENTA Not using tcc $ANSI_RESET
fi

readonly THIS=${BASH_SOURCE[0]}
cd ${THIS%/*}
readonly DIR=$PWD
readonly CURRENT_DIR_SRC_GENERATED=$CPP_DIR_SRC_GENERATED/byPreprocess
readonly HEADER_FOR_RSC=$STRAP_PREPROCESSED/headerForRsc.h
readonly HEADER=$STRAP_PREPROCESSED/header.h
echo $ANSI_INVERSE Running cppPreprocess.sh $ANSI_RESET
source $DIR/cppGenerateHeader.sh >$HEADER ||die cppGenerateHeader.sh
sed -i '/^~/d' $HEADER # Where are the lines starting "~/strapSrc" comming from?
fgrep -v '(...)' $HEADER|fgrep -v '#define CLASS_' >$HEADER_FOR_RSC
#readonly FF_JAVA=$(find $JAVA_ROOTS -name '[A-Z]*.java' -or -name 'SRC_*.sh')
readonly FF_JAVA=$(find $JAVA_ROOTS -name '[A-Z]*.java')
 if (($CPP_PRG_AA)); then
     readonly MANUAL_SRC=$STRAP_SRC/man/alignment2html_man.1
     readonly MANUAL_GENERATED=$STRAP_BUILD/tmp/alignment2html.1
 else
     readonly MANUAL_SRC=$STRAP_SRC/man/strap_man.1
     readonly MANUAL_GENERATED=$CPP_DIR_SRC_GENERATED/man/manual_GENERATED.txt
 fi
 mkdir -p ${MANUAL_GENERATED%/*}
readonly stdErr=$STRAP_PREPROCESSED/stdErr
readonly PRG_EXTRACT=$(compileCC $DIR/cppExtractLineMarkers.c)
readonly MACROS_JAVA=$STRAP_PREPROCESSED/j.h
readonly MACROS_RSC=$STRAP_PREPROCESSED/rsc.h
makeDotH
makeRsc
processSrcUtil=0
# *************************
# *** Command line args ***
# *************************
while getopts Ru opt; do
	case $opt in
        R ) exit;;
        u ) processSrcUtil=1;;
	esac
done
shift $((OPTIND-1))
files=${1:-}
# | fgrep -v /src/util/
#if [[ $# == 1 ]] && [[ $files == */src/util/* ]]; then readonly processSrcUtil=1; else readonly processSrcUtil=0; fi
echo $ANSI_INVERSE processSrcUtil=$processSrcUtil $ANSI_RESET

checkIf=$files
ONLY_UPDATE=0
if [[ $files == 0 ]]; then
    files=
    checkIf=
elif [[ -z $files ]]; then
    files=$FF_JAVA
    ONLY_UPDATE=1
    # *** Remove unused Java files not in $files *** #
    pushd $STRAP_PREPROCESSED
    for f in $(find . -name '[A-Z]*.java'); do
        [[ $files == */${f#./}* ]] ||rm $f $f.* 2>/dev/null
    done
    popd
    # *** CheckCode ***
    if [[ -d ~/sh_strap/checkCode ]]; then
        checkIfEndif.sh || die checkIfEndif.sh $checkIf
    fi
fi
collectCASE_ARG() {
    find $STRAP_PREPROCESSED/ -name '*.argv' -delete
    for f in $(fgrep -l CASE_ARG $FF_JAVA); do
        local fake=$STRAP_PREPROCESSED/$(cppAbsToRelPath $f)
        [[ $f == *Inc.java ]] && fake=${fake%%_*}
        fake=${fake%.java}.argv
        [[ -d ${fake%/*} ]] || mkdir -p ${fake%/*}
        grep '^ *CASE_ARGV*(' $f |$RUN_CPP -P '-DCPP_AS_OBJECT(n)=n' |awk -F , -f $DIR/cppCase.awk  |sort|uniq | while read line; do
            [[ ! -f $fake ]] || ! fgrep -q "$line" $fake && echo $line|sed 's|\bImage\b|java.awt.&|g; s|java.awt.java.awt.|java.awt.|g; s|TYPE_FRAMEOPT|long|g' >>$fake
        done
    done
}
(( $CPP_WITH_CHECK_CODE )) && collectCASE_ARG

readonly mostRecent2=$(ls -1 -t --color=never $DIR/*.{awk,sh,c} $MACROS_JAVA $MACROS_RSC|head -1)
#readonly mostRecent2=$(ls -1 -t --color=never $mostRecent $STRAP_SRC/src/noGui/generateCode/*.h | head -1)
#Example $STRAP_PREPROCESSED/charite/christo/ChUtils.java.afterCPP.java
#  case 132:\define{north}{((Object)arg)}\define{BREAK}{\undef{north} break}\define{RETURN}{return $1\undef{north}} {
#        if (!pckgIsInstalled(22)) castToRunnable(((charite.christo.Fake_)null).ARGV__RUN_PCKG_DETECT_EDT|0x10000000(north,null));
#        else awtc(AWTC_REMOVE_FROM_PARENT,north);
#        BREAK;
#    }

echo $ANSI_INVERSE mostRecent=$mostRecent2 $ANSI_RESET
if (( $CPP_WITH_CHECK_CODE )); then
     fgrep -v -e '#define RUN_' -e '#define _RUN_' -e '#define PROVIDE_'  $MACROS_JAVA>$MACROS_JAVA.noRun
     fgrep    -e '#define RUN_' -e '#define _RUN_' -e '#define PROVIDE_' $MACROS_JAVA>$MACROS_JAVA.run
fi
#readonly IPATH=-I$STRAP_SRC/src/gui/charite/christo/' '-I$STRAP_SRC/src/gui/charite/christo/strap/
readonly IPATH=$(cppSearchPaths)
for src in $files; do
    [[ $src == *Inc.java ]] && continue
    ((!processSrcUtil)) && [[ $src == */src/util/* ]] && continue
    d=$(cppAbsToRelPath $src)
    [[ -z $d ]] && die' Problem turning to relative path: d="'$d'" src="'$src'"'
    L=$STRAP_PREPROCESSED/$d.lines # File for linemarks
    d=$STRAP_PREPROCESSED/$d # Processed Java file
    afterCPP=${d%.java}.afterCPP.java
    [[ -d ${d%/*} ]] ||mkdir -p ${d%/*}
    [[ -d ${L%/*} ]] ||mkdir -p ${L%/*}
    if (( ! $ONLY_UPDATE )) || [[ $src -nt $d  ||  $mostRecent2 -nt $d ]]; then
        if [[ -x $src ]]; then # --- Java files that do not need to be preprocessed are simply copied ---
            rmComments <$src > $d
        else
            echo Process $ANSI_INVERSE ${src/$HOME/\~} ' ==>  '$d $ANSI_RESET
            if (( $CPP_WITH_CHECK_CODE )); then
                 # sed takes care of vertical bar-option. E.g.  castToRunnable(((charite.christo.Fake_)null).ARGV__RUN_PCKG_DETECT_EDT|0x10000000(arg,null));
                $RUN_CPP -C --imacros $MACROS_JAVA.noRun $IPATH $src |sed 's,\.\(ARGV\?_[A-Za-z0-9_]*\)|[|0-9A-Za-z_]*,.\1,g' 2>$stdErr > $d.afterCPP1
                $RUN_CPP -C --imacros $MACROS_JAVA.run  $d.afterCPP1 > $afterCPP
            else
                if (($USE_TCC));then
                    echo -e '#include "'$MACROS_JAVA'"\n#include "'$src'"' | $TCC -E $DEFS_FOR_CPP $IPATH /dev/stdin 2>$stdErr > $afterCPP || die $stdErr
                else
                    echo -e '#include "'$MACROS_JAVA'"\n#include "'$src'"' | $RUN_CPP -C $IPATH 2>$stdErr >$afterCPP
                fi
            fi
            # The gpp takes care of \define{}{}, which results from CASE_ARG(...) and CASE_ARGV(...)
            # $PRG_EXTRACT writes the cpp line numbers to $L
            $PRG_EXTRACT <$afterCPP 2>$L | gpp -n -U '' '' '(' ')(' ')' '{(' ')}' '$' ''  -M '\' '\n' '{' '}{' '}' '{' '}'  +s '"' '"' '\'  +s "'" "'" '\' >$d
            if [[ -s $stdErr ]]; then
                ls -l $d
                echo -n $ANSI_FG_RED
                ls -l $stdErr
                echo -n $ANSI_RESET
                cat $stdErr
            fi

        fi
    fi
done
###############################################################################################################
# If CPP_WITH_CHECK_CODE is 1, then the compilation process detects errors that will normally not be identified
# However, the resulting code is not functional.
#
# Concept:
#   The method thrdM(option flags,method name,instance/class,paramters) creates thread objects for Java methods via reflection.
#   thrdCR(int id,instance,parameter list) and thrdCR1(id,instance,parameter) create thread objects from class instances implementing the interface ChRunnable.
#   runCR(int id,instance,parameter list) and runCR1(id,instance,parameter) call the run(int id,Object arg) method of a class instance implementing ChRunnable
#   The class implementing ChRunnable must use the macros CASE_ARG(...) CASE_ARGV(...) such that the parameter types can be parsed here.
#
# There will be checks whether
#    1. Method parameters of runCR1 and thrdCR1 match with CASE_ARG(id,parameter)
#    2. Method parameters of runCR and thrdCR match with CASE_ARGV(id,parameter list)
#    3. Method arguments are correct for thrdM
makeFakeClass() {
    grep '^\(import\|package\) ' $STRAP_PREPROCESSED/charite/christo/ChUtils.java
    echo 'import charite.christo.strap.*;'
    echo -e "import static charite.christo.ChUtils.*;\npublic class Fake_ {"
    cat $(find $STRAP_PREPROCESSED/ -name '*.argv') | sed 's|   *| |g' | $RUN_CPP -P --imacros $MACROS_JAVA |sort|uniq
    echo '}'
}
(( $CPP_WITH_CHECK_CODE )) && makeFakeClass >$STRAP_PREPROCESSED/charite/christo/Fake_.java
cp -n -r $STRAP_SRC/src/gui/charite/christo/myIcons $STRAP_PREPROCESSED/charite/christo/
cp -n -r $STRAP_SRC/web/install2/strap.sh $STRAP_PREPROCESSED/..
echo $GREEN_SUCCESS Reached end of ${0##*/}
