
export CPP1=$STRAP_SRC/cpp/cpp1.sh
source $CPP1

export JAVA_ROOTS="$STRAP_SRC/src/noGui $STRAP_SRC/src/util "
[[ $_CPP_P == S ]] && export JAVA_ROOTS="$JAVA_ROOTS $STRAP_SRC/src/gui"
[[ $_CPP_P == A ]] && export JAVA_ROOTS="$JAVA_ROOTS $STRAP_SRC/src/aa"

source ${BASH_SOURCE[0]%/*}/cppTools.sh || exit 1

##source $( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/cppTools.sh || exit 1

cppAbsToRelPath() {
    a=${1//\/\//\/}
    for root in $JAVA_ROOTS; do
        r=${a#$root}
        #echo root=$root a=$a  r=$r
        if [[ $a != $r ]]; then
            r=${r#/};
            echo $r
            return
        fi
    done
}
_cppSet() {
    local line='export '$1'='$2
    #echo line=$line
    if grep "^$line"'$' $CPP1; then
        echo $ANSI_INVERSE ${FUNCNAME[0]} Unchanged $ANSI_RESET
    else
        echo $ANSI_INVERSE ${FUNCNAME[0]} Changing $CPP1 $ANSI_RESET
        sed -i -e "s|export $1=.*||1" -e '/^ *$/ d' $CPP1
        echo $line >> $CPP1
        RmPreprocessed.sh
        $STRAP_SRC/src/noGui/charite/christo/mkFilePaths.sh
        $STRAP_SRC/src/noGui/generateCode/UpdateEnumerations.sh
    fi
    cat $CPP1
}
cppSetTarget() {
    if [[ $1==S || $1==A ]]; then
        _cppSet _CPP_P $1
    else
        echo Error: S or A
    fi
}

cppSetDebug() {
 if [[ $1==0 || $1==1 ]]; then
    _cppSet CPP_WITH_MEIN_DEBUG $1
    else
        echo Error: 0 or 1
    fi
}
cppSetDebugThreads() {
 if [[ $1==0 || $1==1 ]]; then
    _cppSet CPP_WITH_DEBUG_THREADS $1
    else
        echo Error: 0 or 1
    fi
}

cppSetCheckCode() {
    if [[ $1==0 || $1==1 ]]; then
        _cppSet CPP_WITH_CHECK_CODE $1
    else
        echo Error: 0 or 1
    fi
}
cppClean() {
    echo rm -r $STRAP_PREPROCESSED
}
