#! /bin/bash -u
set -o pipefail
source $STRAP_SRC/SOURCE_ME_MAKE_STRAP.sh
readonly COPY=Copy_strap_jar.sh
reset
readonly JAR=$STRAP_BUILD/strap.jar
readonly PREVIOUS=$STRAP_PREPROCESSED/../strap.previousSize
which $COPY && $COPY $JAR delete

cd ${BASH_SOURCE[0]%/*}


source $STRAP_ENV || die STRAP_ENV
cppSetTarget S ||die cppSetTarget
source $STRAP_SRC/cpp/cppGenerateHeader.sh >/dev/null||die cppGenerateHeader.sh
DO_COMPILE=1
DO_JAR=1
MK_JAR_FOR_TESTING=0
DO_UPLOAD=$(($CPP_WITH_CHECK_CODE==0&&$CPP_WITH_MEIN_DEBUG==0))
while getopts UCjct opt; do
	case $opt in
        U ) UpdateEnumerations.sh;;
	    j ) DO_UPLOAD=0;DO_JAR=0;;
		c ) DO_UPLOAD=0;DO_COMPILE=0;;
        t ) MK_JAR_FOR_TESTING=1;;
	esac
done

#echo CPP_WITH_SubcellularLocalization=$CPP_WITH_SubcellularLocalization
echo $ANSI_INVERSE $0 CPP_WITH_CHECK_CODE=$CPP_WITH_CHECK_CODE DO_COMPILE=$DO_COMPILE DO_JAR=$DO_JAR $ANSI_RESET


readonly SKIP=$STRAP_BUILD/tmp/skipEverything
echo -e generateCode'\n'CompileEverything'\n'zipSize.rsc'\n'Pymol'\n'ChJmol > $SKIP
if (($DO_COMPILE)); then
    find $STRAP_PREPROCESSED/ -name '*.class' -delete
    $STRAP_SRC/RmPreprocessed.sh
    $STRAP_SRC/src/noGui/generateCode/UpdateEnumerations.sh
    cmd=$STRAP_SRC/cpp/cppPreprocess.sh; $cmd || die $cmd
    cmd=$STRAP_JAVAC' -Xlint:-unchecked,-rawtypes,-options -source 1.6 -target 1.6 -cp '$STRAP_PREPROCESSED':'$(echo $STRAP_BUILD/compileTimeJars/*.jar|tr ' ' ':')' -Xmaxerrs 20 '$STRAP_PREPROCESSED/CompileEverything.java;
    echo $cmd
    $cmd||die $cmd
    ls -l $STRAP_PREPROCESSED/CompileEverything.class|| die $cmd
    (($CPP_WITH_CHECK_CODE)) && echo $ANSI_INVERSE CPP_WITH_CHECK_CODE $ANSI_RESET && exit 0
    echo $ANSI_RESET
fi
pushd $STRAP_PREPROCESSED  ||die pushd $STRAP_PREPROCESSED
readonly classfiles=$(find . -name '*.class'|fgrep -v -f $SKIP)
grepValueOf $classfiles
(($DO_JAR)) ||exit 0
readonly M=$STRAP_BUILD/tmp/M
echo -e Main-Class: charite.christo.strap.Strap'\n'Permissions: all-permissions >$M
jar -cmf $M $JAR
if (($DO_COMPILE)); then
    JFILES=$(echo $classfiles |tr ' ' '\n' |fgrep -v '$' |sed 's|\.class$|.java|1' |fgrep -v -f $SKIP)
    sed -i 's|^  *||1' $JFILES
    zip -0  -r src.zip $JFILES >/dev/null
    #printf  '%(%s)T' -1 > S.rsc
fi
if ! (($MK_JAR_FOR_TESTING)); then
    bzip2 -f --best src.zip
    jar uf0 $JAR src.zip.bz2
fi
jar uf $JAR $(echo $classfiles rsc*.rsc |tr ' ' '\n'|fgrep -v -f $SKIP)
popd
pushd $STRAP_SRC/src/gui ||die pushd $STRAP_SRC/src/gui
jar uf0 $JAR charite/christo/myIcons/*.*
popd
echo -e $ANSI_FG_MAGENTA 'Previous:'; cat $PREVIOUS; echo $ANSI_RESET
ls -l $JAR | tee $PREVIOUS
if (($MK_JAR_FOR_TESTING));then
     echo scp $JAR  $STRAP_DIR_B/test.jar
elif (($DO_UPLOAD)) && [[ ! -z ${STRAP_DIR_B+x} ]] && CkIntegrity.sh $JAR; then
    echo ///////////////////////////////////////////
    echo
    echo scp $JAR  $STRAP_DIR_B/tmp.jar
    CURRENT_STRAP_VERSION=strap004
    DIR_STRAP_JNLPS=toHTML/jnlps
    echo SSH_B sh ${STRAP_DIR_B#*:}/install2/makeStrapOnServer.sh $DIR_STRAP_JNLPS/$CURRENT_STRAP_VERSION.jar
    echo
    echo ///////////////////////////////////////////
    find  ~/.java/deployment/cache -iname '*strap.jar' -delete &>/dev/null
fi




#Deployment/StrapFiles/

which $COPY && $COPY $JAR copy
