#! /bin/bash -u


makeCPP_FLAGS(){
    echo '#define CPP_FLAGS(...) MACRO_CHOOSER(CPP_FLAGS_MACRO,__VA_ARGS__)(__VA_ARGS__)'
     for(( i=1; i<10; i++)); do
        echo -n '#define CPP_FLAGS_MACRO'$i'('
        local v=
        local bar=
        local komma=
        for(( a=1;a<=i; a++)); do
            echo -n $komma'a'$a
            v=$v$bar'(1<<'a$a')'
            bar='|'
            komma=','
        done
        echo ') '$v
    done
    echo
}
makeCPP_CASE_ARG(){
    echo '#define CASE_ARG(ID,t,v) case ID:\define{v}{((t)arg)}\define{BREAK}{\undef{v} break}\define{RETURN}{return $1\undef{v}}'
    for((i=0;i<6;i++));do
        echo -n '#define CASE_ARGV_MACRO'$(($i*2+1))'(ID'
        local def=
        local udf=
        for(( a=0;a<i; a++)); do
            echo -n ,t$a,v$a;
            def=$def'\define{v'$a'}{((t'$a')xiThEl('$a',arg))}'
            udf=$udf'\undef{v'$a'}'
        done
        echo ') case ID:'$def'\define{BREAK}{'$udf'break}\define{RETURN}{return $1'$udf'}'
    done
    echo
}
makeDefaultArguments(){
    readonly MAX_INT=0x7fffffff
    echo
    # *** GUI ***
    Macro enableWordCompletion opt=COMPL_TAB collection lDelim rDelim
    Macro enableWordCompletion opt=COMPL_TAB collection lDelim=null rDelim=null
    Macro clipBnds g w=$MAX_INT/2 h=$MAX_INT/2

    Macro strchrBwd needle haystack from=$MAX_INT to=-1
    # *** String ***
    for method in hashCd hashCdL hashCdLUC hashCdUC atol atof;do
        Macro $method txt from=0 to=$MAX_INT
    done
    Macro atol txt from to=$MAX_INT
    for method in strstr nxt;do
        Macro $method opt needle haystack from=0 to=$MAX_INT
        Macro $method opt=0 needle haystack from=0 to=$MAX_INT
        Macro $method opt=0 needle haystack from to
    done

    Macro strEquAt opt needle haystack from to=$MAX_INT
    for method in strstrBwd nxtBwd;do
        Macro $method opt needle haystack from=$MAX_INT to=-1
        Macro $method opt=0 needle haystack from=$MAX_INT to=-1
        Macro $method opt=0 needle haystack from to
    done
    Macro strchr needle haystack from=0 to=$MAX_INT
    # public static int idxOfLetters(byte needle[],byte haystk[],int f,int t)
    Macro idxOfLetters needle haystack from=0 to=$MAX_INT
    Macro wordAt opt text from to=$MAX_INT
    Macro wordAt opt=-SPC text from to=$MAX_INT
    Macro looks  like text from to=$MAX_INT
    Macro looks  like text from=0 to=$MAX_INT
    Macro strplc opt  pattern replacement haystack from=0 to=$MAX_INT
    Macro strplc opt=0  pattern replacement haystack from=0 to=$MAX_INT
    echo
}
readonly out=$STRAP_SRC/src/noGui/cpp_BASIC_java_macros_generated.h
(
    source ${BASH_SOURCE[0]%/*}/DefaultArguments.sh
    echo '// Generated by '$BASH_SOURCE
    MacroForMulti
    makeCPP_FLAGS
    makeCPP_CASE_ARG
    makeDefaultArguments
) >$out
ls -l $out
