#! /bin/bash -u
set -o pipefail
###############################
### Check required software ###
###############################
missing=

check() {
    $1 $2| head -n 1 || missing=$missing"$3\n"
}
check javac      -version 'javac which is part of jdk'
#check jar       --version 'jar is part of jdk'
check unpack200 --version 'unpack200 which is part of jdk'
check gcc       --version 'gcc c-compiler'
check cpp       --version 'cpp-preprocessor which is part of gcc'
check gpp        --version 'gpp'
check wget      --version  'wget'
if  [[ $missing != '' ]]; then
    echo $ANSI_RED Please install
    echo -e $missing|sort|uniq
    echo -n $ANSI_RESET
    exit 1
fi
##################################
### Download compile time JARs ###
##################################
readonly DIRJARS=$STRAP_BUILD/compileTimeJars
mkdir -p $DIRJARS
cd $DIRJARS
#commons-httpclient-3.1.jar httpclient-cache-4.1.1.jar
readonly JARS='batik-all-1.9.jar  edtftpj-1.5.2.jar  OpenAstexViewer4.jar pdfbox-app-2.0.8.jar Structure_biojava.jar tar.jar'
for j in $JARS; do
    [[ -s $j ]] && jar -tf $j >/dev/null && continue
    echo Downloading $j
    rm $j 2>/dev/null
    [[ -s $j.pack.gz ]] || wget -O $j.pack.gz http://www.bioinformatics.org/strap/otherPackages/$j.pack.gz
    if [[ -s $j.pack.gz ]]; then
        unpack200 $j.pack.gz $j || rm $j.pack.gz
    fi
done
pwd
for j in $JARS; do ls -l $j || echo $RED_ERROR; done
