package charite.christo;
import java.io.*;
import java.util.*;
import static charite.christo.ChUtils.*;
@*H
 Some computations  such as BLAST searches or 3D superpositions take long time.
 Results are stored on HD in the directory ~/.StrapAlign/cached/
*@
#define KEY_DIRECTORY File.class
#define MAP mapNoClr(256)
#define saveK(cacheResutl,key,ba) synchronized(SYNC_CacheResult_SAVE_K){cacheResutl.archive().writeToRaf(key,ba);}
#define closeArchive(archive) synchronized(SYNC_ARCHIVE_FP){closeStrm(archive._fp);}
public class CacheResult implements Runnable{
    private static boolean _addedSDH,_exited;
    private Object _archive;
    private final File _f;
    private static int _countArchive;
    private Object _mapInRam;
    private final Map _mapInRam(){
        Map m=(Map)deref(_mapInRam);
        if(m==null) _mapInRam=newSoftRef(m=new HashMap());
        return m;
    }
    private CacheResult(Map cc,String division,String section){
        _f=cc==null?null:new File(new File((File)cc.get(KEY_DIRECTORY),division),section);
    }
    private Archive archive(){
        Archive a=(Archive)deref(_archive);
        if(_countArchive>99) save();
        if(a==null){
            _archive=newSoftRef(a=new Archive(_f));
            _countArchive++;
        }
        return a;
    }
    @Override protected void finalize()throws Throwable{
        logFinalize(ANSI_RED+ANSI_FG_WHITE+"CacheResult","");
        final Archive a=(Archive)deref(_archive);
        if(a!=null) a.dispose();
        super.finalize();
    }
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Save >>> */
    public static void save(){
        //IF_MEIN_DEBUG(if(isPrprty(IS_CACHE_WRITE)) baOut(ANSI_GREEN).a("CacheResult.save").aln(ANSI_RESET));;
        synchronized(SYNC_CacheResult_SAVE){
            _countArchive=0;
            for(Map.Entry entry:entryArry(MAP)){
                for(Map.Entry e:entryArry((Map)entry.getValue())){
                    final Object c=deref(e.getValue()); /*X may be File,see KEY_DIRECTORY*/
                    if(c instanceof CacheResult){
                        final Archive a=(Archive)deref(((CacheResult)c)._archive);
                        ((CacheResult)c)._archive=null;
                         if(a!=null){
                             a.dispose();
                             closeArchive(a);
                         }
                         }
                }
            }
        }
    }
    OVERRIDE_PUBLIC void run(){
        if(!_exited){
            _exited=true;
            save();
        }
    }
/* <<< Save <<< */
/* ---------------------------------------- */
/* >>> Static accessors >>> */
#if CPP_DEACTIVATED
    public static BA getValueCheckAge(String clas,String key,BA buffer,int daysValid){
        if(daysValid!=INT_NAN){
            removeOutOfDate(clas,daysValid);
            if(System.currentTimeMillis()-getLastModified(clas,key)>daysValid* 1000L* 3600*24) return null;
        }
        return getValue(clas,key,buffer);
    }
    private static void removeOutOfDate(String clas,int days){
        synchronized(SYNC_REMOVE_OUT_OF_DATE){
            if(onlyOnceHC(291,clas)){
                final Map cc=mapForSection(clas);
                if(!isWin()){
                    final File dir=(File)cc.get(KEY_DIRECTORY);
                    final BA result=toBA(rtExecOutput(0,"find",dir,"-maxdepth","1","-mtime",new BA(9).aa('+',days),"-and","-name","*.entries"));
                    baOut("CacheResult: looking for out_of_date data").aln(result);
                    if(result!=null){
                        final byte[]T=result.bytes();
                        final BA buf=new BA(99);
                        final int[]ee=result.eol();
                        FORiL(0,ee.length){
                            fileDel(0,clr(buf).aFT(T,BOL0(iL,ee),ee[iL]));
                            fileDel(0,buf.del(".entries"));
                        }
                    }
                }
            }
        }
    }
#endif //CPP_DEACTIVATED
/** Get the cached text */
    public static BA getValue(String section,String key,BA buffer){
        if(key==null) return null;
        final CacheResult r=_cacheResult(section,key,false);
        BA ba=null;
        if(r!=null && 0==sze(ba=(BA)deref(r._mapInRam().get(key))))  ba=r.archive().get(key,buffer);
        IF_CACHE_JDBC(if(ba==null && CacheResultJdbc.instance().init()) {final BA val=CacheResultJdbc.instance().get(section,key);if (val!=null) return val;});;
        return ba;
    }
    public static synchronized void putValue(int opt,String section,String k,BA v){
        if(!isPrprty(IS_CACHE_WRITE) || section==null || k==null || v==null|| isPrprty(IS_SHUTTING_DOWN)) return;
        if(strchr(0,v.bytes(),v.begin(),v.end())>=0){
            IF_MEIN_DEBUG(if(onlyOnce(140)) baOut(RED_ERROR).aa(ANSI_FG_RED+"CacheResult put value contains 0x0 ",section,' ',ANSI_RESET).aln(k));;
            v.replaceChar(0,' ');
        }
        IF_CACHE_JDBC(if(0==(opt&CACHE_NO_SQL) && CacheResultJdbc.instance().init() && CacheResultJdbc.instance().put(section,k,v.a1('\n').newBytes(),hashCd(v))) return;);;
        if(!_addedSDH){
            _addedSDH=true;
            final Runnable r=new CacheResult(null,null,null);
            addShutdownHook1(r);
            try{Runtime.getRuntime().addShutdownHook(toThrd(r));}catch(IllegalStateException ex){errorEx(ex,"addShutdownHook");}
        }
        final CacheResult r=_cacheResult(section,k,true);
        if(0==(opt&CACHE_NOT_RAM)){
            r._mapInRam().put(k,v);
            IF_MEIN_DEBUG(if(v._flags==(v._flags|=BA_FLAG_IN_CACHE))  baOut(RED_ERROR).a(section).aln(" BA_FLAG_IN_CACHE").special(DIE_NOW));;
        }
        if(0==(opt&CACHE_NOT_OVERWRITE) || r.archive().getEntry(k)==null) saveK(r,k,v);
        //if(0==(opt&CACHE_NOT_OVERWRITE)) r.saveK(k,v);
    }
/* When was the Result modified? */
/* This is not thread save ! */
    public static long cacheLastModified(String clas,String k){
        final CacheResult r=k==null?null: _cacheResult(clas,k,false);
        return r==null?0:r.archive().archiveLastModified(k);
    }
    public static CacheResult _cacheResult(String clas,String k,boolean createIfNull){
        if(clas==null)return null;
        final Map cc=mapForSection(clas);
        final int hc=k.hashCode();
        final String section=Integer.toHexString(hc%4096);
        CacheResult r=(CacheResult)deref(cc.get(section));
        if(r==null){
            r=new CacheResult(cc,Integer.toHexString((hc<0?-hc:hc)%64),section);
            if(!createIfNull && r._f.length()==0) r=null;
            else cc.put(section,newSoftRef(r));
        }
        return r;
    }
/* <<< static Accessor <<< */
/* ---------------------------------------- */
/* >>> CacheOfClass  >>> */
    private static Map mapForSection(String clas){
        if(clas==null) return null;
        Map cc=(Map)MAP.get(clas);
        if(cc==null){
            final String fn=delPfx("http://",delPfx("https://",clas)).replace('/','_');
            (cc=new HashMap()).put(KEY_DIRECTORY,mkdrsErr(newFile(iFile(DIR_CACHE_CURRENT_VERSION),fn)));
            MAP.put(clas,cc);
            fileDel(DEL_FILE_TREE,newFile(iFile(DIR_CACHE),fn));/*X  Old files */
        }
        return cc;
    }
/* <<< CacheOfClass  <<< */
/* ---------------------------------------- */
#undef KEY_DIRECTORY
#include "CacheResult_Archive_Inc.java"
}
