package charite.christo;
import javax.swing.*;
import java.awt.*;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
/* (NUM1 0) */
#define FLAG_TAB_INITIALIZES (1<<0)
#define FLAG_TAB_SELECTED (1<<1)
#define FLAG_SHOWING_POPUP (1<<2)
public final class ChButton extends JButton implements HasWRef,ChRunnable{
    {assrtEdtGui(85);}
    private static boolean _noLi;
    private String _withAccelerator;
    private boolean _contains,_handleEvt=true;
    private int _modi,_height=-1,_actPerfWhen,_bool,_propId;
    int _mc,_opt;
    public final int _bid;
    final Object[]_oIcon=new Object[2];
    public ChButton cp(int k,Object v){
        pcp(k,v,this);
        return this;
    }

    void beforePcpHook(int k,Object v){
#if CPP_WITH_MEIN_DEBUG
        if((k==BUTTN_KEY_COLLAPSE||k==BUTTN_KEY_COLLAPSE_HIDE) && 0==(_opt&BUTTN_CB)) assrt();
#endif //CPP_WITH_MEIN_DEBUG
        if(k==BUTTN_KEY_ENABLE && 0!=(_opt&BUTTN_CB)) setEnbld(isSelected(),v);
        if(k==KEY_DND_OBJ){
            if(v!=null) setHorizontalAlignment(LEFT);
            if((v!=null)!=(gcp(KEY_DND_OBJ,this)!=null)) awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,this);
        }
        if(k==BUTTN_KEY_COLLAPSE) pcp(_KEY_TOGGLE_COLLAPSE|PCP_OPT_ARRAY_RECURSIVE|PCP_OPT_WREF,this,v);
        if(k==BUTTN_KEY_COLLAPSE_HIDE) pcp(_KEY_TOGGLE_COLLAPSE_HIDE|PCP_OPT_ARRAY_RECURSIVE|PCP_OPT_WREF,this,v);
        if(k==BUTTN_KEY_CLOSE && sze(getText())==0 && _oIcon[0]==null) setTip("Close",rover(IC_CLOSE));
        if(k==BUTTN_KEY_CUSTOMIZE_DIALOG) addActLiUtils(this);
    }

    // ----------------------------------------
/* >>> Constructor >>> */
    public ChButton opt(int o){
        _opt=o|(_opt&(BUTTN_L|BUTTN_CB));
        if(0!=(o&BUTTN_SELECT)) awtc(AWTC_SET_SELECTED_ON,this);
        if(0!=(o&BUTTN_NO_FILL)  IF_MAC(&& !(M_PV_DEFAULT_VIEWER==_bid && isMac()))) setContentAreaFilled(false);
/* As a result,setOpaque(false) will be invoked */
        if(0!=(o&BUTTN_NO_BORDER)) setBorderPainted(false);
        if(0!=(o&BUTTN_HIDE_IF_DISABLED)) cp(KOPT_HIDE_IF_DISABLED,"");
        if(0!=(o&BUTTN_DISABLED)) awtc(AWTC_SET_DISABLED,this);
        if(0!=(o&BUTTN_MAC_TYPE_ICON)) putClientProperty("JButton.buttonType","icon");
        if(0!=(o&BUTTN_ICON_SIZE)){
            cp(KEY_PREF_SIZE,dim(ICON_HGT,ICON_HGT));
            setMargin(new Insets(0,0,0,0));
        }
        if(0!=(o&(BUTTN_PAINT_IF_ENABLED))) setOpaque(false);
        if(0!=(o&BUTTN_HEIGHT_I)) _height=ICON_HGT;
        return this;
    }
    private final static ButtonModel _sharedModel=new DefaultButtonModel();
     public ChButton(String s) {this(0,s);}
    public ChButton(int opt,String s) {this(opt,s,null);}
    public ChButton(int opt,String s,ChRunnable li){
        _bid=opt&BUTTN_BID_MASK;
        if(s==null && _bid==BUTS_GO) s=BUTTON_GO;
        if(s!=null) t(s);
        setAlignmentX(LEFT_ALIGNMENT);
        setAlignmentY(CENTER_ALIGNMENT);
        setDefaultCapable(false);
        if(0!=(opt&BUTTN_L)){
            setModel(_sharedModel);
            setHorizontalAlignment(LEADING);
            setBrdrC(null,this);
        }else{
            if(0!=(opt&BUTTN_CB)) setModel(new JToggleButton.ToggleButtonModel());
            if(s==null && _bid>0) s=s(_bid);
            if(s!=null) setActionCommand(s);
            addLiUtils(LSTNR_ACT,getModel());
            mapButtonModel.put(getModel(),this);
        }
        if(isPrprty(IS_MAC_LAF)) setOpaque(false);
        opt(opt);
        if(!_noLi)addActLi(li,this);
    }
/* <<< Constructor <<< */
/* ---------------------------------------- */
/* >>> Paint >>> */
    OVERRIDE_PUBLIC void setForeground(Color c){
        if("123".equals(getText())) stckTrcCT(80);
        super.setForeground(c);
    }
    OVERRIDE_PUBLIC void paintComponent(Graphics g){
        //if (_tabInitialized++==0 && gcp(_BUTTN_KEY_JTabbedPane,this)!=null){
        if(_bool!=(_bool|=FLAG_TAB_INITIALIZES) && gcp(_BUTTN_KEY_JTabbedPane,this)!=null) addLi(this,LSTNR_MO,getParent());
        if(g==null) return;/*X  See ChJMenu.paintComponent(null); */
        final int w=getWidth(),h=getHeight();
        if(_bid==BUTS_RAM_SIZE){
            super.paintComponent(g);
            final long totalFree=(_memMax=Runtime.getRuntime().maxMemory()>>>10) - (_memTotal=Runtime.getRuntime().totalMemory()>>>10) + _memFree;
            final float freeByMax=totalFree/(float)_memMax;
            setColorRGB(0,g);
            g.drawString(_baClrTip().format10(totalFree,8).toString(),0,(h-charH(g))/2+charA(g));
            g.setColor(blueYellowRed(1-freeByMax));
            final int h0=(int)(h*(1-Math.sqrt(freeByMax)));
            g.fill3DRect(3,h-h0,4,h0,true);
#if WRITE_CONCATENATED_JAVA||defined _KOPT_THREAD_STARTED
            if(gcpSetToTrue(_KOPT_THREAD_STARTED,this)==null)
#endif //WRITE_CONCATENATED_JAVA||defined _KOPT_THREAD_STARTED
                callPeriodically(333,thrdCR(_RUN_BUT_FREE_MEM,this));
            return;
        }
        runCR(_RUN_BUT_UPDATE_ICON,this);
        {
            final Object ic=_oIcon[0!=(BUTTN_CB&_opt) && isSlct(this)?1:0];
            if(ic instanceof Icon && ic!=getIcon()) setIcon((Icon)ic);
        }
        if(runCR(_RUN_BUT_IS_SMALL_COLLAPSE,this)!=null){
            setColorRGB(0xFFffFF,g);
            g.fillRect(0,0,h,h);
            setColorRGB(0,g);
            g.drawRect(0,0,h-1,h-1);
            g.drawLine(3,h/2,h-4,h/2);
            if(!isSlct(this)) g.drawLine(h/2,3,h/2,h-4);
            return;
        }
        if(!isEnabled()&&(null!=gcp(BUTTN_KEY_SRC,this)||
                            null!=gcp(BUTTN_KEY_HLP,this)||
                            null!=gcp(BUTTN_KEY_CUST,this)||
                            null!=gcp(BUTTN_KEY_SHARED_CTRL,this)||
                            0!=(_opt&BUTTN_PAINT_IF_ENABLED))) return;
        antiAlsng(g);
        if(paintHooks(this,g,false)){
            if(getModel().isEnabled()!=isEnabled()) super.setEnabled(isEnabled());
            if(isPrprty(IS_MAC_LAF)) setOpaque(false);
            {
                final int[]drawFromTo=(int[])gcp(BUTTN_KEY_DRAW_FROM_TO,this);
                if(gcp(BUTTN_KEY_DRAW_FROM_TO,this)!=null){
                    g.setColor(C(null!=gcp(KOPT_IS_SELECTED,this)?FG_SELECTED:RGBA_GRAY));
                    g.drawRect(0,0,w-1,h-1);
                    g.fillRect(2+drawFromTo[0]*(w-4)/100,h/4,(drawFromTo[1]-drawFromTo[0])*(w-4)/100,h/2);
                    return;
                }
            }
            {
                final String txt=getText();
                final Font font=getFont();
                if(strStarts(BUTTN_PFX_VERTICAL,txt)){
                    g.setFont(font);
                    g.setColor(getForeground());
                    ((Graphics2D)g).rotate(-Math.PI/2,h/2f,h/2f);
                    g.drawString(delPfx(BUTTN_PFX_VERTICAL,txt),2,charA(font));
                    ((Graphics2D)g).rotate(Math.PI/2,h/2f,h/2f);
                }else{
                    if(0!=(_opt&BUTTN_PAINT_USING_DRAW_STRING) && 0!=sze(txt)){
                        {
                            Color c;
                            final int hght=(getHeight()-8)/2;
                            if(null!=(c=getColr(gcp(BUTTN_KEY_COLOR_BOX_L,this)))){
                                g.setColor(c);
                                g.fillRect(0,hght,4,8);
                            }else if(null!=(c=getColr(gcp(BUTTN_KEY_COLOR_BOX_R,this)))){
                                g.setColor(c);
                                g.fillRect(getWidth()-4,hght,4,8);
                            }else{
                                g.setColor(C(DEFAULT_BACKGROUND));
                                g.fillRect(0,0,999,999);
                            }
                        }
                        g.setColor(getForeground());
                        g.setFont(font);
                        final Insets m=getMargin();
                        g.drawString(txt,
                                     x(m)+(w-strgWidth(font,txt)-x(m)-m.right)/2,
                                     y(m)+charA(this)+(h-charH(font)-y(m)-m.bottom)/2);
                    }else{
                        Color bg=(Color)gcp(KEY_BACKGROUND,this);
                        if(0!=(_opt&BUTTN_NO_FILL)){/*X Used as render component in JList and JTable */
                            if(null!=gcp(KOPT_IS_SELECTED,this)){
                                setForeground(C(FG_SELECTED));
                                bg=bgSelected();
                            }else{
                                setForeground((Color)orO(gcp(KEY_FOREGROUND,this),C(0)));
                                if(null==(bg=gcp(KOPT_IS_IN_TABLE_HEADER,this)!=null?C(DEFAULT_BACKGROUND):(Color)gcp(KEY_BACKGROUND,this))) bg=(Color)gcp(KEY_NOT_EDITABLE_BG,this);
                            }
                        }
                        if(bg!=null){
                            g.setColor(bg);
                            g.fillRect(0,0,w,h);
                        }
                        try{super.paintComponent(g);}catch(Throwable e){}
                    }
                }
            }
            if(gcp(KOPT_IS_IN_TABLE_HEADER,this)!=null){
                setColorRGB(0,g);
                g.drawLine(w-1,0,w-1,h);
                g.drawLine(0,h-1,w,h-1);
            }
            if(0!=(_opt&BUTTN_ROLLOVER) && _contains){
                setColorRGB(0xFF,g);
                g.drawRect(0,0,w-1,h-1);
            }
            if(0!=(_opt&BUTTN_CROSSING_OUT)){
                setColorRGB(0xFF0000,g);
                final int d=h/3;
                g.drawLine(0,d,w,h-d);
                g.drawLine(0,h-d,w,d);
            }
        }
        paintHooks(this,g,true);
    }
/* ---------------------------------------- */
/* >>> Icon >>> */
    public ChButton rover(String icon) {return t(null).opt(BUTTN_ROLLOVER_OPTS).i(icon);}
    public ChButton i(Object o){
        // IF_MEIN_DEBUG(if(o instanceof String[]) assrt());;
        if(0==(_opt&BUTTN_CB)) _oIcon[0]=o;
        else{
            if(o instanceof String) _oIcon[1]=addSfx(SFX_PRESSED,_oIcon[0]=o);
            else if(o instanceof Object[]){
                _oIcon[0]=iThEl(0,o);
                _oIcon[1]=iThEl(1,o);
            }
        }
        setIcon(_oIcon[0] instanceof String?iicon(IC_BLANK):derefZ(_oIcon[0],Icon.class));
        final Object bb=gcp(KEY_CLONES,this);
        ROFi0(szeVA(bb)){
            final Object b=iThEl(i,bb);
            if(b instanceof ChButton) ((ChButton)b).i(o);
        }
        return this;
    }
/* <<< Icon <<< */
/* ---------------------------------------- */
/* >>> Label Text >>> */
    public ChButton t(String t){
        if(!isEDT())  thrdCR1(_RUN_BUT_T|THRDCR_EDT_LATER,this,t);
        else if(BUTTON_GO.equals(t)) setFG(0x007c00,largerFnt(1.2f,t(" Go ")));
        else setText(sze(t)==0?null:
                    t instanceof String && (((String)t).indexOf('&')>=0 || ((String)t).indexOf('^')>=0)?miSetShortCut(_withAccelerator=(String)t,this):
                    s(addHtmlTags(t)));
        return this;
    }
/* <<< Label Text <<< */
/* ---------------------------------------- */
/* >>> ToolTip >>> */
    private Object _item(Object q,Object mouseEvt){
        if(q==null || 0!=(evtModi(mouseEvt)&SHIFT_MASK) || gcp(BUTTN_KEY_SRC,this)!=null) return _baClrTip().and(iConst(SARRAY_BID_TO_ALIAS,bidForClass(q)),"<BR>").a(clasNamOrS(q));
        final String s=miSetShortCut(text(q),null);
        return 0<sze(s)?s:shrtClasNamOrAlias(q);
    }
@*SARRAY_BALLOON_MEMORY
     <PRE>How much memory [kilobyte] is left? ( max-total+free):|total Memory:|free Memory:|max Memory:
*@
@*~RSC_BALLOON_BUT_MEMORY
     Click to run garbage collection i.e. remove unused data.
     Max memory can be increased in the Java control panel or with the command line option -Xmx.
     Example for -Xmx:
     <PRE>java -Xmx100M -jar strap.jar</PRE>
*@
    OVERRIDE_PUBLIC String getToolTipText(java.awt.event.MouseEvent ev){
        if(!super.isVisible()) return null;
        final BA sb=baClr(33);
        if(_bid==BUTS_RAM_SIZE){
            final String[]ss=arry(SARRAY_BALLOON_MEMORY);
            sb.a(ss[0]).format10(_memMax-_memTotal+_memFree,8).aln(" kb")
                .a(ss[1]).format10(_memTotal,8).aln(" kb")
                .a(ss[2]).format10(_memFree,8).aln(" kb")
                .a(ss[3]).format10(_memMax,8).aln(" kb")
                .aln(rsc(RSC_BALLOON_BUT_MEMORY));
        }else{
            Object o;
            if((o=gcp(KEY_CLONED_FROM,this)) instanceof ChButton) return((ChButton)o).getToolTipText();
            appndTooltips(ev,super.getToolTipText(),sb);
            if(null!=(o=orO(gcp(BUTTN_KEY_HLP,this),gcp(BUTTN_KEY_SRC,this)))){
                if(gcp(BUTTN_KEY_SRC,this)!=null) sb.a("Source code of<BR>");
                for(Object q:oo(o)) sb.and(_item(q,ev),"  ");
                sb.htmlBR();
            }
            if(null!=(o=gcp(BUTTN_KEY_SHARED_CTRL,this)) || null!=(o=gcp(BUTTN_KEY_CUST,this))){
                cp(KOPT_HIDE_IF_DISABLED,"");
                sb.aa("Settings for ",_item(o,ev)).htmlBR();
            }
        }
        {
            final Customize[]cc=toArrayOfCustomize(gcp(BUTTN_KEY_CUSTOMIZE_DIALOG,this));
            if(sze(cc)>0){
                sb.aa("Settings for ","<UL>");
                FORi(0,sze(cc)) sb.aa("<LI>",nam(cc[i]),"</LI>");
                sb.a("</UL>");
            }
        }
        return sze(sb.del("<BR>"))==0?null: s(addHtmlTags(sb));
    }
#if CPP_WITH_MEIN_DEBUG
    OVERRIDE_PUBLIC String toString(){
        return s(_baClrToStrg().aa(0!=(BUTTN_L&_opt)?"ChLabel\"":0!=(_opt&BUTTN_CB)?"ChToggle\"": "ChButton\"",getText()));
    }
#endif //CPP_WITH_MEIN_DEBUG
/* <<< Label Text <<< */
/* ---------------------------------------- */
/* >>> Appearance >>> */
/* public ChButton like(Component protoType){ */
/*     if(protoType==null) return this; */
/*     t(getTxt(protoType)); */
/*     setIcn(getIcn(protoType),this); */
/*     setForeground(protoType.getForeground()); */
/*     setFont(protoType.getFont()); */
/*     tt(tipTxtC(protoType)); */
/*     if(protoType instanceof AbstractButton){ */
/*         final Icon i= ((AbstractButton)protoType).getSelectedIcon(); */
/*         if(i!=null) setSelectedIcon(i); */
/*         if(isSlct(protoType) && 0!=(_opt&BUTTN_CB)) awtc(AWTC_SET_SELECTED_ON,this); */
/*     } */
/*     final ChButton b=derefZ(protoType,ChButton.class); */
/*     if(b!=null) {_oIcon[0]=b._oIcon[0];_oIcon[1]=b._oIcon[1];} */
/*     return this; */
/* } */
/* <<< Appearance <<< */
/* ---------------------------------------- */
/* >>> Size >>> */
    OVERRIDE_PUBLIC Dimension getMinimumSize(){
        if(0!=(BUTTN_L&_opt)) return getPreferredSize();
        try{
            return super.getMinimumSize();
        }catch(Throwable e){return dim(32,32);}
    }
    OVERRIDE_PUBLIC Dimension getMaximumSize(){
        if(prefSzeZero(this)) return dim(0,0);
        if(runCR(_RUN_BUT_IS_SMALL_COLLAPSE,this)!=null) return dim(EX,EX);
        try{return super.getMaximumSize();}catch(Throwable e){return dim(32,32);}
    }
    OVERRIDE_PUBLIC Dimension getPreferredSize(){
        if(runCR(_RUN_BUT_IS_SMALL_COLLAPSE,this)!=null) return dim(EX,EX);
        Dimension ps=_prefSzeThis(this);
        if(ps==null){
            final Object cloned=gcp(KEY_CLONED_FROM,this);
            if(cloned instanceof ChButton && gcp(KOPT_HIDE_IF_DISABLED,cloned)!=null && !((ChButton)cloned).isEnabled()) ps=dim(0,0);
        }
        if(ps==null && strStarts(BUTTN_PFX_VERTICAL,getText())) ps=dim(charH(getFont()),4+strgWidth(getFont(),delPfx(BUTTN_PFX_VERTICAL,getText())));
        try{/*X  NullPointer  at javax.swing.plaf.synth.SynthLookAndFeel.paintRegion(SynthLookAndFeel.java:352) */
            if(ps==null) ps=super.getPreferredSize();
        }catch(Throwable e) {ps=dim(EM*10,EX);}
        {
            final int h=_height>0?_height: _oIcon[0] instanceof String && sze(_oIcon[0])>0?ICON_HGT: -1;
            if(h>=0) ps=dim(ps.width,h);
        }
        if(tipDnd(this,null)>0) return dim(ps.width+ICON_HGT,ps.height);
        return ps;
    }
    public ChButton setHeight(int h) {_height=h; return this;}
/* <<< Size <<< */
/* ---------------------------------------- */
/* >>> Event >>> */
    OVERRIDE_PUBLIC void processEvent(AWTEvent ev){
/* No ActionEvent even with  enableEvents(ACTION_EVENT_MASK|MOUSE_EVENT_MASK); */
        if(evtShouldProcess(ev)){
            final int evId=ev.getID();
            if(evId==MOUSE_PRESSED){
                final JTabbedPane tp=(JTabbedPane)gcp(_BUTTN_KEY_JTabbedPane,this);
                final int i=tp==null?-1:tp.indexOfTabComponent(childC(this,ChButton.class));
                if(i>=0) setSelIdx(i,tp);
            }
            if(gcp(KEY_DND_OBJ,this)!=null && jListDoDnD(ev)) _handleEvt=false;
            else{
                if(evId==MOUSE_RELEASED) _handleEvt=true;
                if(evId==MOUSE_MOVED && !_contains || (evId==MOUSE_RELEASED || evId==MOUSE_EXITED) && _contains){
                    _contains=!_contains;
                    awtc(AWTC_OPT_REPAINT,this);
                }
                super.processEvent(ev);
            }
        }
        if(0!=(_opt&BUTTN_UNDOCKABLE)) undockItmEv(ev);
    }
/* <<< Event <<< */
/* ---------------------------------------- */
/* <<< When pressed <<< */
    private static MenuElement[]_menuPath;
    public Component mi(String txt){
        if(0!=(_opt&BUTTN_L)) return this;/*X  z.B. sxmV3dGeneric*/
        if(null==txt && null==(txt=_withAccelerator)) txt=getText();
        final JMenuItem mi;
        if(0!=(_opt&BUTTN_CB)){
            mi=new JCheckBoxMenuItem(){
                {enableEvents(ACTION_EVENT_MASK|MOUSE_EVENT_MASK);}
                OVERRIDE_PUBLIC Icon getIcon(){return strstr(0,"WindowsLookAndFeel",clazz(UIManager.getLookAndFeel()))>0?null: toIcn(_oIcon[0]);}
                OVERRIDE_PUBLIC void doClick(int pressTime) {super.doClick(pressTime);MenuSelectionManager.defaultManager().setSelectedPath(_menuPath);}
                OVERRIDE_PUBLIC void processEvent(AWTEvent ev){undockItmEv(ev);super.processEvent(ev);}
            };
            //addLi(this,LSTNR_MO,mi); // Wozu LSTNR_MO? /*DEBUG_NOW*/
            addLi(this,LSTNR_CHANGE,mi);/*X Required for Menu stays open */
        }else{
            mi=new MItem();
            if(txt!=JMENU_GAP && _oIcon[0]==null) runCR1(RUN_SET_ICON,mi,IC_BLANK);
        }
        mi.setModel(getModel());
        setTxt(txt,pcp(KEY_CLONED_FROM,this,mi));
        cp(KEY_MENU_ITEMS|PCP_OPT_ADD_TO_ARRAY|PCP_OPT_WREF,mi);
        //addLi(this,LSTNR_ACT,mi);
        final String tt=getToolTipText();
        if(sze(tt)>0) setTip(tt,mi);
        return mi;
    }
/* <<< Clone <<< */
/* ---------------------------------------- */
/* Bugfix,it does not notice isEnabled(); */
    OVERRIDE_PUBLIC boolean isEnabled(){return isButtonEnabled(this,super.isEnabled());}
    public static ChButton doColor(int opt,int color,Object target){
        final Object c=C(color);
        final ChButton b=new ChButton(BUTS_COLOR_CHOSER|opt,null);
        setColrO(c,setTip("Change color",b));
        return b.i(IC_COLOR).cp(COLORBUT_KEY_COLORED,target).cp(COLORBUT_KEY_COLOR,c).cp(COLORBUT_KEY_DEFAULT,c);
    }
    public static ChButton doView(Object msg){
        return
            msg instanceof Integer?new ChButton(text(msg)).i(icon(msg)).cp(BUTTN_KEY_VIEW_MSG,msg):
            msg instanceof JMenu?new ChButton(addSfx("\u25bc",getTxt(msg))).cp(BUTTN_KEY_VIEW_MSG,jPopupMenu(msg)):
            new ChButton(null).cp(BUTTN_KEY_VIEW_MSG,msg);
    }
    public static ChButton doOpenURL(Object o){
        final String url,s;
        if(o instanceof java.io.File){
            s=fPathTildeForHome(o);
            url=s(url(o));
        }else{
            url=hrefToUrlString(HREF_WEB_LINK|HREF_PLAIN_TEXT|HREF_PROTEIN_FILE,s=s(o));
        }
        return (ChButton)pcp(BUTTN_KEY_OPENURL,url,setTip(url,new ChButton(lstChar(s)=='*'?delChrSfx('*',s).replace('_',' '):s).i(IC_WWW)));
    }
    private static long _memFree,_memMax,_memTotal;
    public static Object doSharedCtrl(Object o){
        final ChButton b=new ChButton(null).rover(IC_CONTROLPANEL);
        if(o instanceof ChJCombo) updateOn(CHANGED_COMBOBOX,b);
        return pcp(BUTTN_KEY_SHARED_CTRL,wref(o),b);
    }
/* <<< Specific Actions <<< */
/* ---------------------------------------- */
/* >>> UI >>> */
#if 0
/* AbstractButton creates UI before constructor is called. */
/* This could be avoided but gain of speed is not significant. */
/* Since I use JToggleButton only with different Icons indicating selected and unselected state,I do not need ToggleButtonUI */
    @Override public String getUIClassID(){return 0!=(_opt&BUTTN_CB)?"ToggleButtonUI": super.getUIClassID();}
    @Override public javax.swing.plaf.ButtonUI getUI(){
        if(super.getUI()==null) super.updateUI();
        return super.getUI();
    }
    @Override public void addNotify(){
        if(super.getUI()==null) super.updateUI();
        super.addNotify();
    }
    @Override public void updateUI(){if(super.getUI()!=null) super.updateUI();}
#endif //0
/* <<< UI <<< */
/* ---------------------------------------- */
/* >>> ChToggle >>> */
/* public ChButton s(boolean selected) { */
/*     if(0!=(_opt&BUTTN_CB)) { */
/*         _handleEvt=false; */
/*         setSelected(selected); */
/*         _handleEvt=true; */
/*     }else MEIN_ASSRT(); */
/*     return this; */
/* } */
    public ChButton savePrprty(int id){
        if(id!=0) setSlct(isTrue(getPrpty(_propId=id,isSlct(this)?"true":"false")),this);
        return this;
    }
/** Used in ChTabPane. Invoked in paint hook */
    public boolean setTabSelected(Graphics g,boolean b){
        if(g!=null && b){
            setColorRGB(BG_SELECTED,g);
            g.fillRect(0,0,999,999);
        }
        if(0!=(_bool&FLAG_TAB_SELECTED)!=b){
            _bool^=FLAG_TAB_SELECTED;
            setFG(b?FG_SELECTED:0,this);
            setContentAreaFilled(!b);
            setBorderPainted(!b);
            return true;
        }
        return false;
    }
/* <<< ChToggle <<< */
/* ---------------------------------------- */
/* >>> Threading >>> */
    private void butColorPushed(){ChFrame.frame(FRAME_PACK|CLOSE_CtrlW_ESC,orS(gcps(KEY_FRAME_TITLE,this),"color"),runCR(RUN_GET_PANEL,this)).shw(FRAME_AT_CLICK);}
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARG(RUN_SET_SELECTED,Object,on){
                _mc++;
                _handleEvt=false;
                setSelected(on!=null);
                _handleEvt=true;

                BREAK;
            }
            CASE_ARGV(_RUN_BUT_UPDATE_ICON){
                ROFi0(2)if (_oIcon[i] instanceof String && _oIcon[i]!=ERROR_STRING) _oIcon[i]=orO(iicon((String)_oIcon[i]),ERROR_STRING);
                break;
            }
            CASE_ARGV(_RUN_BUT_IS_SMALL_COLLAPSE){
                return sze(getText())==0 && getIcon()==null && (gcp(BUTTN_KEY_COLLAPSE,this)!=null||gcp(BUTTN_KEY_COLLAPSE_HIDE,this)!=null)?TRUEr:null;
            }
            CASE_ARGV(RUN_GET_COLOR){
                if(_bid==BUTS_COLOR_CHOSER) return gcp(COLORBUT_KEY_COLOR,this);
                BREAK;
            }
            CASE_ARG(RUN_SET_COLOR,Object,color){
                pcp(COLORBUT_KEY_COLOR,color,this);
                return TRUEr;
            }
            CASE_ARG(RUN_M_actionPerformed,Object,ev){
                awtc(AWTC_REMOVE_FROM_PARENT,gcp(BUTTN_KEY_RM_FROM_PARENT,this));
                setPrprtyB(gcpi(BUTTN_KEY_SET_SYSPRPRTY,this));
                BREAK;
            }
            CASE_ARG(RUN_M_stateChanged,Object,ev){
                {
                    final JCheckBoxMenuItem m=derefZ(evtSrc(ev),JCheckBoxMenuItem.class);
                    if(m!=null && m.isArmed() && m.isShowing())  _menuPath=MenuSelectionManager.defaultManager().getSelectedPath();
                }
                {
                    final Object slider=gcp(COLORBUT_KEY_SLIDER,this),q=evtSrc(ev);
                    final JColorChooser chooser=(JColorChooser)gcp(COLORBUT_KEY_CHOOSER,this);
                    wndw(WNDW_DO_AOT_EVT,ev);
                    if(chooser!=null && (q==slider || q==chooser.getSelectionModel())){
                        Color c=chooser.getColor();
                        {
                            final int alpha=slider==null?-1: ((255-intValueC(slider))&255);
                            if(/*c==_bcolorReset || */c==null || gcp(COLORBUT_KEY_PANEL,this)==null) return null;
                            if(alpha>=0) c=argbToColor((c.getRGB()&0xFFffFF)|(alpha<<24));
                        }
                        cp(COLORBUT_KEY_COLOR,c);
                        if(isVsblC(this)) awtc(AWTC_OPT_REPAINT,i(imgNewFilteredIcon(imgNewFilterMonochrome(c.getRGB()),iicon(IC_COLOR))));
                        runCR1(RUN_SET_COLOR,gcp(COLORBUT_KEY_COLORED,this),c);
                        handleActCmdI(ACTION_COLOR_CHANGED,this,0);
                        //if(q==chooser.getSelectionModel()) chooser.getSelectionModel().setSelectedColor(_bcolorReset);
                        return null;
                    }
                }
                BREAK;
            }
            CASE_ARGV(RUN_GET_PANEL){
                if(_bid==BUTS_COLOR_CHOSER){
                    Object pnl=gcp(COLORBUT_KEY_PANEL,this);
                    JColorChooser cc=(JColorChooser)gcp(COLORBUT_KEY_CHOOSER,this);
                    if(cc==null){
                        specifcLstnrWithChilds(MOMOLI_DRAG_WIN,cp(COLORBUT_KEY_CHOOSER,cc=new JColorChooser()));
                        addLi(this,LSTNR_CHANGE,cc.getSelectionModel());
                        addLi(this,LSTNR_MO|LSTNR_KEY,childsR(cc,Component.class));
                        cc.setPreviewPanel(new JLabel());
                        final Object defaultColor=gcp(COLORBUT_KEY_DEFAULT,this);
                        //#define rgbAlpha (defaultColor!=null?rgba(defaultColor)>>>24: 255)
                        //final Object slider=new JSlider(0,255,255-rgbAlpha&255);
                        final Object slider=new JSlider(0,255,255-(rgba(defaultColor,0xFFFFFFFF)>>>24)&255);
                        cp(COLORBUT_KEY_SLIDER,addLi(this,LSTNR_CHANGE,slider));
                        cp(COLORBUT_KEY_PANEL,pnl=pnl(CNSEW,cc,pnl(HB,"Transparency ",slider),gcp(KEY_SOUTH_PANEL,this)));
                    }
                    return pnl;
                }
                BREAK;
            }
            CASE_ARG(RUN_SHOW_IN_FRAME,TYPE_FRAMEOPT,optUnused) if(_bid==BUTS_COLOR_CHOSER) butColorPushed();BREAK;
            CASE_ARGV(RUN_CLONE){
                _noLi=true;
                final ChButton b=new ChButton(_opt,null).cp(KEY_CLONED_FROM,this).cp(KEY_PREF_SIZE,gcp(KEY_PREF_SIZE,this)).t(getText()).i(_oIcon[0]);
                _noLi=false;
                cp(KEY_CLONES|PCP_OPT_ADD_TO_ARRAY|PCP_OPT_WREF,setTip(getToolTipText(),b));
                b.setModel(getModel());
                return b;
            }
            CASE_ARGV(_RUN_BUT_FREE_MEM){
                final long f=Runtime.getRuntime().freeMemory()>>>10;
                if((f/32)!=(_memFree/32)) {_memFree=f;repaint();}
                break;
            }
            CASE_ARGV(RUN_GET_TEXT) return getText();
            CASE_ARG(RUN_SET_TEXT,Object,o) t(s(o)); RETURN(this);
            CASE_ARG(RUN_SET_ICON,Object,im) i(im); RETURN(this);
            CASE_ARG(RUN_GET_RENDERER_COMP,int,opt) RETURN(this);
            CASE_ARG(_RUN_ACTION_EVENT_DELAYED,Object,ev){
                // if(_bid!=0 && (bidOpt(TITI_OPT_ADD_LISTENER,_bid)||_bid==BUT_RENDR_EDITOR))  runCR1(RUN_M_actionPerformed,IF_STRAP(SBUT_AAA<_bid?_main:) chUtils(),ev);
                //if(!(evtSrc(q) instanceof MItem)) _modi=evtModi(ev);
                if((getParent()==null || getParent() instanceof ChJTable) && timeOn()-_actPerfWhen<333) return null;/*X  Occasionally two events for buttons in a table. In ResidueAnnotation getParent() is the table */
                _actPerfWhen=timeOn();
                setPrpty(_propId,isSlct(this)?"true":"false");
                _mc++;
                if(_bid==BUTS_COLOR_CHOSER) butColorPushed();
                else if(_handleEvt){
                    if(_bid==BUTS_RAM_SIZE) {Runtime.getRuntime().gc();System.gc();System.runFinalization();}
                    shwCtrlPnl(0,null,gcp(BUTTN_KEY_CTRLPNL,this));
                    customizeAddDialog(gcp(BUTTN_KEY_CUST,this));
                    {
                        final Object hlp=gcp(BUTTN_KEY_HLP,this),hs=orO(hlp,gcp(BUTTN_KEY_SRC,this));
                        if(hs!=null){
                            IF_STRAP(wndw(WNDW_DO_AOT_OFF,JCC[JFRAME_START_DIALOG]));
                            final ChTabPane tp=wndw(0,this)instanceof JDialog?null:TABBEDPANES[hlp!=null?TABBEDPANE_HELP:TABBEDPANE_SOURCE];
                            boolean success=false;
                            for(Object x:oo(hs)){
                                if((x=selItemOrSelf(x))==null || x instanceof Boolean) continue;
                                if(0!=(_modi&SHIFT_MASK)) editFile(0,javaSrcFile(clas(x)));
                                else{
                                    final ChTabPane tpHJ=TABBEDPANES[hlp!=null?TABBEDPANE_HELP:TABBEDPANE_SOURCE];
                                    final int count=tpHJ==null?0:tp.tabComponents().length;
                                    if(hlp!=null) showHelp(x);
                                    else showJavaSrc(clasNamOrS(x));
                                    success=tpHJ!=null&&count!=tp.tabComponents().length;
                                }
                            }
                            if(tp!=null && success){
                                Component c=tp;
                                ROFt0(2){
                                    final JSplitPane sp=derefZ(parentC(c),JSplitPane.class);
                                    if(sp instanceof JSplitPane){
                                        final int max=sp.getMaximumDividerLocation(),div=intValueC(sp);
                                        if(sp.getBottomComponent()==c && div>(int)(max*(1-.7f))) setDividerLctn(1-.7f,sp);
                                        if(sp.getTopComponent()==c && div<(int)(max*.7f)) setDividerLctn(.7f,sp);
                                    }
                                    c=parentC(c);
                                }
                            }
                            aotOffIfOtherWndw(this,tp);
                        }
                    }
                    if(bidOpt(TITI_OPT_VIEW_RSC,_bid)) runCR1(RUN_ADD_DIALOG,_main,io(_bid));
                    Object o;
                    if((o=gcp(BUTTN_KEY_CLICK,this)) instanceof AbstractButton) ((AbstractButton)o).doClick();
                    if((o=gcp(BUTTN_KEY_SHARED_CTRL,this))!=null){
                        final Object cp=sharedCtrlPnl(o);
                        if(cp!=null) ChFrame.frame(FRAME_SCROLLPANE|CLOSE_CtrlW_ESC,o instanceof ChJCombo?"Settings":addPfx("Settings for ",shrtClasNamOrAlias(o)),cp).shw(FRAME_PACK_SMALLER_SCREEN2|FRAME_TO_FRONT|FRAME_AT_CLICK);
                    }
#if WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_ENABLE
                    if((o=gcp(BUTTN_KEY_ENABLE,this))!=null) setEnbld(0!=(_opt&BUTTN_CB)?isSlct(this):true,o);
#endif //WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_ENABLE
                    if((o=gcp(BUTTN_KEY_VIEW_FILE,this))!=null) viewFile(file(o));
#if WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_EDIT_FILE
                    if((o=gcp(BUTTN_KEY_EDIT_FILE,this))!=null) editFile(0,file(o));
#endif //WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_EDIT_FILE
#if WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_UNSEL
                    if((o=gcp(BUTTN_KEY_UNSEL,this)) instanceof AbstractButton && isSlct(this)) ((AbstractButton)o).setSelected(false);
#endif //WRITE_CONCATENATED_JAVA||defined BUTTN_KEY_UNSEL
                    runR(gcp(KEY_RUN_ON_CLICK,this));
                    //handleActCmd(orS(getText(),""),this,_modi);
                    _modi=0;
                    FORk(_BUT_KEY_COLLAPSE_AAA+1,_BUT_KEY_COLLAPSE_ZZZ){
                        for(Object collapse:oo(gcp(k,this))){
#if WRITE_CONCATENATED_JAVA||defined _BUT_KEY_COLLAPSE
                            {
                                final JMenu jm=derefZ(collapse,JMenu.class);
                                final Dimension pfs=gcp(_BUT_KEY_COLLAPSE,jm,Dimension.class);
                                if(pfs!=null) jm.setPreferredSize(isSlct(this)?pfs:dim(0,0));
                            }
#endif //WRITE_CONCATENATED_JAVA||defined _BUT_KEY_COLLAPSE
                            awtc(AWTC_ADAPT_SMALL_SIZE_PARENT,awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_ALL_PARENTS,collapse));
                        }
                    }
                    if((o=gcp(BUTTN_KEY_PACK,this))!=null) wndw(WNDW_DO_PACK|(222<<WNDW_SHIFT_MS),orO(derefZ(o,Window.class),orO(wndw(0,this),wndw(0,o))));
                }
                _contains=false;
                if(null!=gcp(BUTTN_KOPT_AOT_OFF,this)) wndw(WNDW_DO_AOT_OFF,this);
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,gcp(BUTTN_KEY_COLLAPSE,this));
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,gcp(BUTTN_KEY_COLLAPSE_HIDE,this));
                awtc(AWTC_OPT_REPAINT,gcp(BUTTN_KEY_REPAINT,this));
                Object para=null;
                if((para=gcp(BUTTN_KEY_SET_TO_TRUE,this))!=null) ((boolean[])para)[0]=true;
                if(null!=gcp(_BUTTN_KEY_WEB_SETTINGS,this))  pnlProxyInfo(true);
                else if(null!=(para=gcp(_BUT_KEY_STRINGMATCH,this))){
                    final Object[]pp=(Object[])para;
                    if(pp[3]==null) pp[3]=new DialogStringMatch(xatoi(pp[0]),(String)pp[2],pp[1]);
                    runCR1(RUN_SHOW_IN_FRAME,pp[3],NULL_AS_INT);
                }else if((para=gcp(KEY_detach_component,this))!=null){
                    if(gcp(_KEY_detach_frame,para)!=null) pnlDock(para);
                    else pnlUndock(PNL_UNDOCK_ASK,para,-1,-1);
                }else if((para=gcp(BUTTN_KEY_CLEAR_TEXTFIELD,this))!=null){
                    setTxt("",para);
                    if(para instanceof ChTextView && clr(((ChTextView)para).ba(true))!=null) awtc(AWTC_OPT_REPAINT,para);
                }else if((para=gcp(BUTTN_KEY_VIEW_MSG,this))!=null || gcp(BUTTN_KOPT_DO_VIEW_OWN_TIP,this)!=null&& null!=(para=tip(_bid))){
                    IF_STRAP(wndw(WNDW_DO_AOT_OFF,JCC[JFRAME_START_DIALOG]));
                    if(para instanceof ChExec) para=ctrlPnl(para);
                    else if(para instanceof Integer){
                        runCR1(RUN_ADD_DIALOG,_main,io(xatoi(para)));
                        return null;
                    }else if(para instanceof String && strEnds(splitTkns(".html .txt .rsc"),para)){
                        final BA txt=readBytes(rscAsStrm(RSC2STREAM_TRY_ALL_PACKAGES,(String)para));
                        if(txt!=null) para=txt;
                    }
                    if(para instanceof BA) for(Object o:((BA)para).getSendTo()) if(o instanceof java.io.File || o instanceof ChRunnable) para=o;
                    if(para instanceof ChRunnable) runCR(RUN_GET_PANEL,para);/*X WAS_SOLL_DAS?*/
                    if((para=orO(runCR(RUN_FILEPOPUP_GET_JPopupMenu,para),para)) instanceof JPopupMenu){
                        _bool|=FLAG_SHOWING_POPUP;
                        ((JPopupMenu)para).show(this,EM,EX);
                    }else if(para instanceof ChFrame){
                        ((ChFrame)para).shw(FRAME_AT_CLICK);
                    }else{
                        Object m=para instanceof java.io.File?readBytes(para): para;
                        final BA rsc=readBytes(rscAsStrm(RSC2STREAM_TRY,s(m)));
                        if(sze(rsc)>0) m=rsc.trimSize();
                        if(m instanceof java.util.Map){
                            final BA sb=new BA(999);
                            for(java.util.Map.Entry e: entryArry((java.util.Map)m)) if(e.getValue()!=null) sb.aln(e);
                            m=sb;
                        }
                        final Component jc=getPnl(m);
                        final String title=orS(gcps(KEY_TITLE,this),txtForTitle(this));
                        if(jc==null){
                            final BA cs=toBA(addHtmlTags(m));
                            if(cs!=null){
                                shwTxtInW(title,
                                          pcp(KEY_SOUTH_PANEL|PCP_OPT_WREF,gcp(KEY_SOUTH_PANEL,this),
                                              pcp(KEY_NORTH_PANEL|PCP_OPT_WREF,gcp(KEY_NORTH_PANEL,this),
                                                  textViewForCharsequence(cs))));
                            }
                        }else{
                            runCR1(RUN_SET_ICON,getIcon(),ChFrame.frame(CLOSE_CtrlW_ESC|FRAME_PACK_SMALLER_SCREEN,title,jc).shw(FRAME_AT_CLICK));
                            amsDo(AMS_REVALIDATE,3333,jc,null);
                        }
                    }
                }else if((para=gcp(BUTTN_KEY_CLOSE,this))!=null){
                    //if (toBeClosed instanceof ChExec) runCR1(RUN_STOP,toBeClosed,null); else
                    closC(gcpi(BUTTN_KEY_CLOSE_OPT,this),para==ALIAS_PARENT_WINDOW?wndw(0,this): para);//parentC(this));
                }
                visitURL(0,gcp(BUTTN_KEY_OPENURL,this));
                runCR1(RUN_M_actionPerformed,gcp(KEY_LISTENERS,this),ev);
                undockEnblDsbl(null);/*X E.g.  Show/Hide in 3D-backbone */
                BREAK;
            }/*X _RUN_ACTION_EVENT_DELAYED*/
            CASE_ARG(_RUN_BUT_T,String,txt) t(txt);BREAK;
#if WRITE_CONCATENATED_JAVA||defined _RUN_BUT_DOCLICK
            CASE_ARG(_RUN_BUT_DOCLICK,AbstractButton,b) if(timeOn()-_actPerfWhen>500) b.doClick();BREAK;
#endif //WRITE_CONCATENATED_JAVA||defined _RUN_BUT_DOCLICK
            CASE_ARG(RUN_SET_ICON_IMAGE,Object,image){
                if(!isEDT()) return inEdtNow(thrdCR1(RUN_SET_ICON_IMAGE,this,image));
                if(image!=null){
                    Object im=image;
#if WRITE_CONCATENATED_JAVA||defined KEY_REQUEST_IMAGE_MAX_WIDTH
                    {
                        final int maxWidth=gcpi(KEY_REQUEST_IMAGE_MAX_WIDTH,this),w=wdth(im);
                        if(maxWidth>0 && w>maxWidth) im=(Image)scaledImageAsObj(im,maxWidth,hght(im)*maxWidth/w,0xFFffFFff);
                    }
#endif //WRITE_CONCATENATED_JAVA||defined KEY_REQUEST_IMAGE_MAX_WIDTH
#if WRITE_CONCATENATED_JAVA||defined KEY_REQUEST_IMAGE_OPTIONS
                    {
                        final int opt=gcpi(KEY_REQUEST_IMAGE_OPTIONS,this);
                        if(0!=(opt&REQUEST_IMAGE_REMOVE_TEXT)) setText(null);
                        if(0!=(opt&REQUEST_IMAGE_REMOVE_BORDER)) setBrdrC(null,this);
                        if(0!=(opt&REQUEST_IMAGE_PACK)) wndw(WNDW_DO_PACK|WNDW_UNLESS_MAIN_WINDOW,this);
                    }
#endif //WRITE_CONCATENATED_JAVA||defined KEY_REQUEST_IMAGE_OPTIONS
                    final Object icon=img2ic(im);
                    runCR1(RUN_SET_ICON,this,icon);
                    runCR1(RUN_SET_ICON,gcp(KEY_MENU_ITEMS,this),icon);
                    }else runCR1(RUN_SET_ICON,this,null);
                BREAK;
            }
        }
        return null;
    }
    OVERRIDE_PUBLIC Point getLocationOnScreen(){
        if((0==(_bool&FLAG_SHOWING_POPUP) || isDisplayable()) && isShowing()) return super.getLocationOnScreen();
        return mouseLctn();
    }
    CPP_CODE_HasWRef();
    class MItem extends JMenuItem implements HasWRef{
        CPP_CODE_HasWRef1(_r);
        private boolean _init;
        {enableEvents(ACTION_EVENT_MASK|MOUSE_EVENT_MASK);}
        OVERRIDE_PUBLIC void setBackground(Color bg){}
        OVERRIDE_PUBLIC Dimension getPreferredSize(){
            try{
                return
                    getText()==JMENU_GAP?dim(1,EX):
                    !ChButton.this.isEnabled() && null!=gcp(KOPT_HIDE_IF_DISABLED,ChButton.this)?dim(0,0):
                    super.getPreferredSize();
            }catch(Exception ex){return dim(99,EX);}
        }
        OVERRIDE_PUBLIC boolean isEnabled(){return ChButton.this.isEnabled();}
        OVERRIDE_PUBLIC void paintComponent(Graphics g){
            if(g==null || !_init) {_init=true; ChButton.this.paintComponent(null);}
            if(g!=null && isValid()){
                if(getText()==JMENU_GAP){
                    try{super.paintComponent(g);}catch(Exception ex){}
                }else{
                    setFG(ChButton.this.isEnabled()?0:RGBA_GRAY,this);
                    if(gcp(KEY_BACKGROUND,this)!=null){
                        g.setColor((Color)gcp(KEY_BACKGROUND,this));
                        g.fillRect(0,0,3333,3333);
                    }
                    g.setColor(Color.BLACK);/*X  sonst weiss auf weiss  MetalLAF in jlUndock */
                    super.paintComponent(g);
                    drawSmallButtons(this,g);
                }
            }
        }
        OVERRIDE_PUBLIC Icon getIcon(){
            if(isCbSlct(TOG_MENUICONS)){
                runCR(_RUN_BUT_UPDATE_ICON,ChButton.this);
                if(_oIcon[0]instanceof Icon) return(Icon)_oIcon[0];
            }
            return iicon(IC_BLANK);
        }
        OVERRIDE_PUBLIC void processEvent(AWTEvent ev){
            if(getText()!=JMENU_GAP)undockItmEv(ev);
            for(AWTEvent ev2:lockSubmenuOnClick(ev)){
                if(evtShouldProcess(ev2)){
/* _modi Workaround: shift not in ActionEvent if JMenu.getPopupMenu().setLightWeightPopupEnabled(false); */
                    if(ev2.getID()==MOUSE_PRESSED) ChButton.this._modi=evtModi(ev);
                    super.processEvent(ev2);
                }
            }
        }
    }
/* ---------------------------------------- */
/* >>> DnD >>> */
    REFLECTION_PUBLIC Object getDndDateien(){
        final Object o=gcp(KEY_PROVIDE_DND_FILES,this);
        return o!=null?adAllNotNullNew((java.io.File[])runCR(RUN_PROVIDE_DND_FILES,o),null): dndV(this);
    }
}
