package charite.christo;
import java.net.URL;
import java.util.*;
import java.io.File;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
public final class ChClassLoader extends java.net.URLClassLoader implements HasWRef{
    private final Map<String,Object>mapClasses=new IdentityHashMap();
/* ---------------------------------------- */
/* >>> Instance >>> */
    private static int nextID=1;
    ChClassLoader(URL[]urls,ClassLoader parent){
        super(urls,parent);
        IF_MEIN_DEBUG(baLog(LOG_CLASSLOADER).a(ANSI_GREEN+" Constructor ChClassLoader "+ANSI_RESET).joinSpc(urls).aln());;
    }
    CPP_CODE_HasWRef();
    public static String computeKey(File[]files,File dir){
        final BA tmp=new BA(444);
        String[]ss=new String[sze(files)+1];
        ROFi0(ss.length){
            final File f=i<sze(files)?files[i]:dir;
            if(isDir(f)||sze(f)>0) ss[i]=s(clr(tmp).aFile(f));
        }
        Arrays.sort(ss=rmNullS(ss),comparator(COMPARE_ALPHABET));
        return s(clr(tmp).joinSpc(ss));
    }
    public static ChClassLoader getInstance(boolean newInstance,File[]files,File dir){
        final Map m=mapNoClr(257);
        final String key=computeKey(files,dir);
        ChClassLoader cl=newInstance?null: (ChClassLoader)deref(m.get(key));
        if(cl==null){
            baLog(LOG_CLASSLOADER).aa('#',nextID," "+ANSI_GREEN+" new ChClassLoader "+ANSI_RESET).aln(dir);
            Collection<URL>urls=new ArrayList();
            ROFi0(files.length){
                baLog(LOG_CLASSLOADER).an(' ',2).aln(files[i]);
                adUniq(url(files[i]),urls);
            }
            baLog(LOG_CLASSLOADER).aln();
            adUniq(url(dir),urls);
            adUniq(jarFileOrClasspath(),urls);
            cl=new ChClassLoader(toArry(urls,URL.class),ChClassLoader.class.getClassLoader());
            if(!newInstance) m.put(key,wref(cl));
        }
        return cl;
    }
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> loadClass >>> */
@*SARRAY_CLASSLOADER_NOT_FINDCLASS
     charite|javax|java|com.sun|apple.awt|sun|org.xml.sax|org.w3c.dom|org.ietf|org.omg
*@
    OVERRIDE_PUBLIC synchronized Class loadClass(String cn)throws ClassNotFoundException{
        if(!isPrprty(IS_CLASSLOADING)) return null;
        final boolean findClass=!strStarts(STR_w,arry(SARRAY_CLASSLOADER_NOT_FINDCLASS),cn)||strStarts(0,arry(SARRAY_CLASSLOADER_NO_PARENT_DELEGATION),cn);
        try{
            return findClass?findClass(cn): super.loadClass(cn);
        }catch(ClassNotFoundException t){
            final Class cRet=findClass?null:findClass(cn);
            if(cRet==null) throw t;
            return cRet;
        }
    }
    OVERRIDE_PUBLIC synchronized Class findClass(String cn)throws ClassNotFoundException{
        if(!isPrprty(IS_CLASSLOADING)) {MEIN_ASSRT(); return null;}
        //if (cn!=null && cn.startsWith("com.sun.tools.javac.resources.compiler")) cn="com.sun.tools.javac.resources.compiler";
        Class c=(Class)deref(mapClasses.get(cn));
        if(c!=null) return c;
        if(cn.startsWith("org.openscience.jmol.Properties")) throw(new ClassNotFoundException());
        baLog(LOG_CLASSLOADER).aa(cn.indexOf('$')<0?ANSI_CYAN: ANSI_RESET,"ChClassLoader#findClass "+ANSI_RESET,cn);
        try{
            try{
                c=super.findClass(cn);

                if(c!=null) mapClasses.put(cn,wref(c));
                baLog(LOG_CLASSLOADER).aln(GREEN_SUCCESS);
                return c;
            }catch(ClassNotFoundException ex){
                baLog(LOG_CLASSLOADER).a(ANSI_RED+"findClass "+ANSI_RESET).aln(ex);
                throw(ex);
            }
        }catch(NoClassDefFoundError er){
            baLog(LOG_CLASSLOADER).a(ANSI_RED+"findClass "+ANSI_RESET).aln(er);
            throw(new ClassNotFoundException());
        }

    }
/* <<< loadClass <<< */
/* ---------------------------------------- */
/* >>> findLibrary >>> */
#if CPP_DEACTIVATED
    OVERRIDE_PUBLIC String findLibrary(String libname){
        if(!isPrprty(IS_CLASSLOADING)) {MEIN_ASSRT(); return null;}
        final File f=newFile(iFile(DIR_JAVADIR_JARS),System.mapLibraryName(libname));
        if(f.exists()){
            baLog(LOG_CLASSLOADER).aa(ANSI_CYAN+"ChClassLoader.findLibrary("+ANSI_WHITE,libname,") ==> ").aln(f);
            return f.toString();
        }
        return super.findLibrary(libname);
    }
#endif //CPP_DEACTIVATED
/* <<< findLibrary <<< */
/* ---------------------------------------- */
/* >>> Security  >>> */
    static{
        try{setSecurityPolicy();}catch(Throwable t){}
    }
    private static java.security.Policy _policy;
    public static void setSecurityPolicy(){
        if(_policy==null){
            _policy=new java.security.Policy(){
                    OVERRIDE_PUBLIC java.security.PermissionCollection getPermissions(java.security.CodeSource codesource){
                        final java.security.Permissions perms=new java.security.Permissions();
                        perms.add(new java.security.AllPermission());
                        return perms;
                    }
                    OVERRIDE_PUBLIC void refresh(){}
                };
            try{java.security.Policy.setPolicy(_policy);}catch(Throwable e){
                stckTrc(99,e);
            }
        }
    }
}

/*  http://docs.oracle.com/javase/7/docs/technotes/guides/net/ClassLoader.html */
