package charite.christo;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.io.File;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
//  See MetalFileChooserUI AquaFileChooserUI
#define CACHE_SCROLL _maps[0]
#define CACHE_SELF _maps[1]
#define _filePopup1 _X[71]
/* --- */
@*~RSC_FILECHOOSER_HINT_COMPLETION
 Hint:<br>The text field supports auto-completion:<br>Hit the tabulator-key to complete file name
*@
@*~RSC_FILECHOOSER_HINT_COMPLETION_SHORT
 The tabulator key completes file names
*@
#if CPP_WITH_MEIN_DEBUG
#define APPROVE_BUTTON_TEXT_CHANGED_PROPERTY "ApproveButtonTextChangedProperty"
#define APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY "ApproveButtonToolTipTextChangedProperty"
#define APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY "ApproveButtonMnemonicChangedProperty"
#define CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY "ControlButtonsAreShownChangedProperty"
#define SELECTED_FILE_CHANGED_PROPERTY "SelectedFileChangedProperty"
#define MULTI_SELECTION_ENABLED_CHANGED_PROPERTY "MultiSelectionEnabledChangedProperty"
#define FILE_SYSTEM_VIEW_CHANGED_PROPERTY "FileSystemViewChanged"
#define FILE_VIEW_CHANGED_PROPERTY "fileViewChanged"
#define FILE_HIDING_CHANGED_PROPERTY "FileHidingChanged"
#define FILE_SELECTION_MODE_CHANGED_PROPERTY "fileSelectionChanged"
#define ACCESSORY_CHANGED_PROPERTY "AccessoryChangedProperty"
#define ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY "acceptAllFileFilterUsedChanged"
#define DIALOG_TITLE_CHANGED_PROPERTY "DialogTitleChangedProperty"
#define DIALOG_TYPE_CHANGED_PROPERTY "DialogTypeChangedProperty"
#define CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY "ChoosableFileFilterChangedProperty"
#endif //CPP_WITH_MEIN_DEBUG
#define FILE_FILTER_CHANGED_PROPERTY "fileFilterChanged"
#define DIRECTORY_CHANGED_PROPERTY "directoryChanged"
#define SELECTED_FILES_CHANGED_PROPERTY   "SelectedFilesChangedProperty"
public class ChFileChooser extends JFileChooser implements ChRunnable{
    {assert CLOSE_MASK<(1<<11);}
    private final Map[]_maps={new HashMap(),new HashMap()};
    private int _propId,_opt;
    private final Collection _vSel=new HashSet();/*X  Bugfix Windows LAF does not display setSelectedFiles(ff) */
    private Object _filters,_tf,_vGoProject[],_fPane,_stringMatch,_filePopup2;
    private long _lm,_count;

/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Keep selection >>> */
    private String key(){
        final javax.swing.filechooser.FileFilter f=getFileFilter();
        return f==null?null:s(new BA(99).aa(f.getDescription(),childC(this,JTable.class)!=null?"_t_":"_",getCurrentDirectory()));
    }
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_GET_BID) return io(BUT_C1(ChFileChooser));
            CASE_ARG(RUN_FCHOOSER_INIT,int,opt_id){
                _propId=(_opt=opt_id)&FCHOOSER_MASK_PRPRTY;
                {
                    final File dir=_propId==0?iFile(DIR_WORKING):file(getPrpty(id,null));
                    if(isDir(dir)) setCurrentDirectory(dir);
                }
                setDragEnabled(true);
                setMinSze(4*EM,4*EX,addLi(this,LSTNR_PROP_CHANGE|LSTNR_ACT,this));
                setDialogType(0!=(_opt&FCHOOSER_TYPE_SAVE_DIALOG)?JFileChooser_SAVE_DIALOG:JFileChooser_OPEN_DIALOG);
                setControlButtonsAreShown(true);
                callPeriodically(1000,thrdCR(_RUN_FCHOOSER_SCAN,this));
                setMultiSelectionEnabled(0!=(_opt&FCHOOSER_MULTI));
                setFileSelectionMode(0!=(_opt&FCHOOSER_FOLDERS)?DIRECTORIES_ONLY:FILES_AND_DIRECTORIES);
                setAcceptAllFileFilterUsed(0==(_opt&FCHOOSER_NOT_ALL));
                break;
            }
            CASE_ARG(RUN_FCHOOSER_saveSelection,File[],files){
                final File[]ff=files;
                if(ff!=null){
                    final BA ba=new BA(ff.length*20);
                    FORi(0,ff.length) ba.aln(ff[i].getName());
                    CACHE_SELF.put(key(),ba.trimSize());
                    awtc(AWTC_OPT_REPAINT,_fPane);
                }
                BREAK;
            }
            CASE_ARG(RUN_FCHOOSER_addFilter,Object,rules){
                if(rules instanceof CharSequence){
                    if(sze(rules)>0) addChoosableFileFilter(new ChFileFilter(s(rules)));
                }else if(rules!=null){
                    addSrvc(RUN_FileChooser_APPROVE_SELECTION,this,_filters=rules);
                    runCR1(RUN_CUSTOMIZE_CHANGED,this,null);
                }
                BREAK;
            }
            CASE_ARGV(RUN_FCHOOSER_getCurrentDirectory) return getCurrentDirectory();
            CASE_ARG(RUN_FCHOOSER_setSelectedFile,File,f){setSelectedFile(f);BREAK;}
            CASE_ARG(RUN_FCHOOSER_setCurrentDirectory,File,f){setCurrentDirectory(f);BREAK;}
            CASE_ARGV(RUN_DISPOSE){
                clr(_vSel);
                clr(_maps);
                return TRUEr;
            }
            CASE_ARG(RUN_CUSTOMIZE_CHANGED,Object,c){
                if(_filters!=null){
                    resetChoosableFileFilters();
                    setAcceptAllFileFilterUsed(true);
                    final String[]ss=((Customize)_filters).lines();
                    final ChFileFilter[]xx=new ChFileFilter[ss.length];
                    FORi(0,ss.length){
                        final String s=ss[i].trim();
                        if(0<sze(s))addChoosableFileFilter(xx[i]=new ChFileFilter(s.indexOf('.')>=0?addPfx("-iz ",s):s));
                    }
                    addChoosableFileFilter(new ChFileFilter(xx));
                }
                BREAK;
            }
            CASE_ARGV(RUN_FCHOOSER_selectedFile) return getSelectedFile();
            CASE_ARGV(RUN_selectedObjects) return orO(getSelectedFiles(),NO_File);
            CASE_ARG(RUN_FCHOOSER_setSelectedFiles,File[],ff){

                setSelectedFiles(ff);
                BREAK;
            }
            CASE_ARGV(RUN_FCHOOSER_getFileFilter) return getFileFilter();
            CASE_ARGV(RUN_FCHOOSER_MK_MENUITEMS){
                return new Object[]{io(MENU_FILE_CHOOSER),
                                        null,
                                        //newButtonOpenDialogStringMatch(0,this,"FileChooser3"),
                                        buttn(CUSTOM_proteinFileExtensions),
                                        runCR(_RUN_FCHOOSER_NEW_BUT_GOPROJECTDIR,this),
                                        "-",
                                        rsc(RSC_FILECHOOSER_HINT_COMPLETION)};

            }
            CASE_ARG(_RUN_FILEPOPUP_FOR_JLIST_OR_JTABLE,Object,c){
                if(_filePopup1==null) runCR1(RUN_FILEPOPUP_SET_FILE_CHOOSER,pcp(KEY_FILE_DialogStringMatch,"FileChooser2",_filePopup1=mkInstanceBid(BUT_C1(FilePopup))),this);
                final Container jpm=c==null?null:((JComponent)c).getComponentPopupMenu();
                if(jpm==null) runCR1(RUN_FILEPOPUP_ACTIVATE_COMPONENT,_filePopup1,c);
                else if(gcpSetToTrue(_KOPT_FILECHOOSER_ADDED_TOOLS,jpm)==null) jpm.add(ChButton.doView(_filePopup1).i(IC_TOOLS).mi("Tools \u25bc"),0);
                BREAK;
            }
            CASE_ARGV(_RUN_FCHOOSER_SELECTION_FOR_SCROLLBAR)
                CASE_ARGV(_RUN_FCHOOSER_UPDATE_SCROLLPANE){
                final Object c=_fPane;
                if(gcp(FCHOOSER_KEY_FPANE,this)!=c){
                    if(pcp(KOPT_SUPPORTS_CTRL_F,"",specifcLstnr(FOLI_FOCUS,c)) instanceof JTable && ((JTable)c).getAutoResizeMode()==JTable_AUTO_RESIZE_OFF){
                        ((JTable)c).setAutoResizeMode(JTable_AUTO_RESIZE_LAST_COLUMN);
                    }
                    pcp(FCHOOSER_KEY_FPANE,c,this);
                }
                final JScrollPane sp=derefZ(parentC(parentC(c)),JScrollPane.class);
                if(sp!=null && null==gcpSetToTrue(FCHOOSER_KOPT_REPLACED_SB,sp)){
                    addLi(this,LSTNR_MO,scrllSetSP(sp,mkScrllBar(Adjustable_VERTICAL)));
                    addLi(this,LSTNR_MO,scrllSetSP(sp,mkScrllBar(Adjustable_HORIZONTAL)));
                    addLi(this,LSTNR_COMPONENT,sp);
                }
                if(id==_RUN_FCHOOSER_SELECTION_FOR_SCROLLBAR) selectionToScrollBarC(0,c);
                break;
            }
            CASE_ARGV(_RUN_FCHOOSER_SCAN_EDT) rescanCurrentDirectory();break;
            CASE_ARGV(_RUN_FCHOOSER_SCAN){
                if(isVsblC(this)){
                    final File dir=getCurrentDirectory();
                    if(dir!=null && DIFF_MC(_lm,dir.lastModified())) thrdCR(_RUN_FCHOOSER_SCAN_EDT|THRDCR_EDT_LATER,this);
                }
                break;
            }
            CASE_ARG(_RUN_FCHOOSER_SELECTED_CP,File[],files){
                if(awtc(AWTC_IF_HAS_FOCUS,_fPane)!=null) runCR1(RUN_FCHOOSER_saveSelection,this,files);
                if(_propId!=0) setPrpty(_propId,s(getCurrentDirectory()));
                inEDTms(thrdCR(_RUN_FCHOOSER_SELECTION_FOR_SCROLLBAR,this),111);
                BREAK;
            }
            CASE_ARGV(_RUN_FCHOOSER_FILTER_CP)
                CASE_ARGV(_RUN_FCHOOSER_DIR_CP){
                {
                    final JViewport vp=childC(this,JViewport.class);
                    final Point p=(Point)CACHE_SCROLL.get(key());
                    if(vp!=null && p!=null) vp.setViewPosition(p);
                }
                final String[]nn=splitLns(CACHE_SELF.get(key()));
                final File dir=getCurrentDirectory(),ff[]=new File[nn.length];
                ROFi0(nn.length)ff[i]=new File(dir,nn[i]);
                setSelectedFiles(ff);
                BREAK;
            }
            CASE_ARGV(_RUN_FCHOOSER_TF){
                final Graphics g=awtGraphics(_tf);
                if(g!=null && nxt(0,chrClas(-SPC),getTxt(_tf))<0){
                    setColorRGB(0x888888,g);
                    g.drawString(s(rsc(RSC_FILECHOOSER_HINT_COMPLETION_SHORT)),10,charA(_tf)+(hght(_tf)-charH(_tf))/2);
                }
                break;
            }
            CASE_ARGV(_RUN_FCHOOSER_NEW_BUT_GOPROJECTDIR){
                final Object b=newBut(BUTS_FILECHOOSER_GO_PROJECTDIR,this);
                _vGoProject=adToArry(0,wref(b),_vGoProject,null);
                return setTip(addPfx("Go to working directory<BR>",iFile(DIR_WORKING)),b);
            }
            CASE_ARG(RUN_M_propertyChange,java.beans.PropertyChangeEvent,pev){
                switch(pev.getPropertyName().hashCode()){
#if CPP_WITH_CHECK_CODE
                case CPP_HASHCD(APPROVE_BUTTON_TEXT_CHANGED_PROPERTY):break;
                case CPP_HASHCD(APPROVE_BUTTON_TOOL_TIP_TEXT_CHANGED_PROPERTY):break;
                case CPP_HASHCD(APPROVE_BUTTON_MNEMONIC_CHANGED_PROPERTY):break;
                case CPP_HASHCD(CONTROL_BUTTONS_ARE_SHOWN_CHANGED_PROPERTY):break;
                case CPP_HASHCD(SELECTED_FILE_CHANGED_PROPERTY):break;
                case CPP_HASHCD(MULTI_SELECTION_ENABLED_CHANGED_PROPERTY):break;
                case CPP_HASHCD(FILE_SYSTEM_VIEW_CHANGED_PROPERTY):break;
                case CPP_HASHCD(FILE_VIEW_CHANGED_PROPERTY):break;
                case CPP_HASHCD(FILE_HIDING_CHANGED_PROPERTY):break;
                case CPP_HASHCD(FILE_SELECTION_MODE_CHANGED_PROPERTY):break;
                case CPP_HASHCD(ACCESSORY_CHANGED_PROPERTY):break;
                case CPP_HASHCD(ACCEPT_ALL_FILE_FILTER_USED_CHANGED_PROPERTY):break;
                case CPP_HASHCD(DIALOG_TITLE_CHANGED_PROPERTY):break;
                case CPP_HASHCD(DIALOG_TYPE_CHANGED_PROPERTY):break;
                case CPP_HASHCD(CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY):break;
#endif //CPP_WITH_CHECK_CODE
                case CPP_HASHCD(FILE_FILTER_CHANGED_PROPERTY): inEDTms(thrdCR(_RUN_FCHOOSER_FILTER_CP,this),222);break;
                case CPP_HASHCD(DIRECTORY_CHANGED_PROPERTY):
                    inEDTms(thrdCR(_RUN_FCHOOSER_DIR_CP,this),222);
                    setEnbldAndRepaint(!getCurrentDirectory().equals(iFile(DIR_WORKING)),_vGoProject);
                    break;
                case CPP_HASHCD(SELECTED_FILES_CHANGED_PROPERTY):{
                    File[]ff=derefZ(pev.getNewValue(),File[].class);
                    if(ff==null) ff=getSelectedFiles();
                    adAll(ff,clr(_vSel));
                    inEDTms(thrdCR1(_RUN_FCHOOSER_SELECTED_CP,this,ff),222);
                    break;
                }
                }
                awtc(AWTC_OPT_REPAINT,getSB(SB_VERTICAL,_fPane));
                awtc(AWTC_OPT_REPAINT,this);
                RETURN TRUEr;
            }
        }
#define ev arg
#define bid evtBid(ev)
        if(RUN_M_EVT(id)){
            wndw(WNDW_DO_AOT_EVT,ev);
            final Object q=evtSrc(ev);
            if(id==RUN_M_actionPerformed) _walkComponentTree(this,null);
            selectNxtPrev(derefZ(q,JComboBox.class),evtWheel(ev));
            runCR1(RUN_FILEPOPUP_SET_FOCUS_JComponent,_filePopup1,q);
            if(id==RUN_M_mouseMoved && (q instanceof JList||q instanceof JTable)){
                final Point p=evtPoint(ev);
                if(p!=null){
                    final File f=derefZ(objectAt(p,q),File.class);
                    if(f!=null){
                        runCR1(_RUN_FILEPOPUP_FOR_JLIST_OR_JTABLE,this,q);
                        runCR1(RUN_FILEPOPUP_SET_FOCUSED_FILE,_filePopup1,f);
                        runCR1(RUN_FILEPOPUP_SET_FOCUS_JComponent,_filePopup1,q);
                    }
                }
                _fPane=q;
            }
            if(bid==BUTS_FILECHOOSER_FILETOOLS){
                if(_filePopup2==null) runCR1(RUN_FILEPOPUP_SET_FILE_CHOOSER,pcp(KEY_FILE_DialogStringMatch,"FileChooser1",_filePopup2=mkInstanceBid(BUT_C1(FilePopup))),this);
                shwPopupMenu(runCR(RUN_FILEPOPUP_GET_JPopupMenu,_filePopup2));
/*This FilePopup instance not associated with JComponent to avoid problems with file at click. Files are obtained only with runCR(RUN_selectedObjects,this) */
            }
            if((id==RUN_M_mouseReleased && q instanceof JScrollBar || id==RUN_M_componentResized)){
                final JViewport vp=childC(this,JViewport.class);
                if(vp!=null) CACHE_SCROLL.put(key(),vp.getViewPosition());
            }
            if(q==_tf) runCR(_RUN_FCHOOSER_TF,this);
            if(id==RUN_M_keyPressed){
                {
                    final ChUtils t=derefZ(gcp(_TXTC_KEY,evtSrc(ev)),ChUtils.class);
                    if(t!=null && t._id==INST_TEXTCOMPONENT) t._tcProcessEvt(ev);
                }
                switch(evtKeyCode(ev)){
                case VK_F:
                    if(evtIsShrtCut(ev) && 0==(evtModi(ev)&SHIFT_MASK)){
                        if(_stringMatch==null) _stringMatch=new DialogStringMatch(0,"File Chooser",this);
                        wndw(WNDW_UNLESS_MAIN_WINDOW|WNDW_DO_AOT_OFF,this);
                        runCR1(RUN_SHOW_IN_FRAME,_stringMatch,NULL_AS_INT);
                        IF_STRAP(inEDTms(thrdRRR(thrdCR1(RUN_ADD_DIALOG,_main,this),thrdCR1(RUN_SHOW_IN_FRAME,_stringMatch,io(FRAME_TO_FRONT))),333));;
                    }
                    break;
                case VK_ENTER:{
                    final String t=toStrgTrim(getTxt(q));
                    final File f=fileJoinSlsh(looks(LIKE_FILEPATH,t)?null:getCurrentDirectory(),t);
                    if(isDir(f)){
                        setCurrentDirectory(f);
                        if(!looks(LIKE_FILEPATH,t)) setTxt("",q);
                    }else if(fileExsts(f)){
                        setCurrentDirectory(f.getParentFile());
                        if(getFileFilter()==null||getFileFilter().accept(f)) setSelectedFile(f);
                    }
                    break;
                }
                }
            }
            if(bid==BUTS_FILECHOOSER_GO_PROJECTDIR) setCurrentDirectory(iFile(DIR_WORKING));
            final String cmd=evtCmd(ev);
            if(cmd!=null){
                inEDTms(thrdCR(_RUN_FCHOOSER_SELECTION_FOR_SCROLLBAR,this),444);
                if(JFileChooser_APPROVE_SELECTION==cmd){
                    if(0!=(FCHOOSER_CLOSE&_opt)) wndw(WNDW_DO_HIDE,this);
                    runServices(RUN_FileChooser_APPROVE_SELECTION,this);
                }
                if(JFileChooser_CANCEL_SELECTION==cmd && 0!=(FCHOOSER_CLOSE&_opt)) awtc(AWTC_SET_VISIBLE_OFF,wndw(0,this));
            }
        }
        return null;
    }
#undef ev
#undef bid
/* <<< Keep selection <<< */
/* ---------------------------------------- */
/* >>> Paint >>> */
    OVERRIDE_PUBLIC void paintChildren(Graphics g){
        try{super.paintChildren(g);}catch(Throwable ex){}
        final Collection toolbars=_count++==0?new ArrayList():null;
        _walkComponentTree(this,toolbars);
        runCR(_RUN_FCHOOSER_UPDATE_SCROLLPANE,this);
        ROFk0(sze(toolbars)){
            boolean bottom=false;
            for(Component c:childsC(iThEl(k,toolbars))){
                if(c instanceof AbstractButton && (bottom=((AbstractButton)c).getVerticalTextPosition()==SWC_BOTTOM)) break;
            }
            ROFi0(0!=(_opt&FCHOOSER_BUT_PROJECT_FOLDER)?2:1){
                if(isPrprty(IS_MAC_LAF) && i==k && sze(toolbars)>1) continue; /*X One button to top,and the other to bottom */
                final ChButton b=(ChButton)(i==0?(newBut(BUTS_FILECHOOSER_FILETOOLS,this)):runCR(_RUN_FCHOOSER_NEW_BUT_GOPROJECTDIR,this));
                b.setFocusable(false);
                if(!bottom) b.i(null);
                else{
                    b.setHorizontalTextPosition(SWC_CENTER);
                    b.setVerticalTextPosition(SWC_BOTTOM);
                    b.setAlignmentX(CENTER_ALIGNMENT);
                }
                adConstraintC(b,iThEl(k,toolbars),"0");
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,b);
            }
        }
        runCR(_RUN_FCHOOSER_TF,this);
        inEDTms(thrdCR(_RUN_FCHOOSER_TF,this),999);
    }
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Components >>> */
    //adUniq(io(System.identityHashCode(c)),vNoClr(59));
    private void _walkComponentTree(Component c,Collection toolbars){
        final boolean fstTime=null==gcpSetToTrue(_KOPT_INITIALIZED,c);
        if(c instanceof JList||c instanceof JTable){
            if(fstTime) addLi(this,LSTNR_MO|LSTNR_MOMO|LSTNR_KEY,c);
            ROFi0(2){
#define current c instanceof JList?((JList)c).getCellRenderer():((JTable)c).getDefaultRenderer(i==0?Object.class:File.class)
                setCellRendr(i*SET_CELLRENDERER_File,newRendererFromOrigRenderer(current,_vSel),
                             awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_800,c));

#undef current
            }
        }
        if(isPrprty(IS_MAC_LAF) && !c.isVisible() && childC(c,JTextField.class)!=null) c.setVisible(true);
        if(fstTime && 0!=(_opt&CLOSE_CtrlW)) closeOnKey(CLOSE_CtrlW,c,this);
        if(c instanceof Box || c instanceof Box.Filler || c instanceof JPanel || c instanceof JLabel){
            specifcLstnr(MOMOLI_DRAG_WIN,c);
        }else if(c instanceof JComboBox){
            if(sze(c.getListeners(java.awt.event.MouseWheelListener.class))==0) addLi(this,LSTNR_WHEEL,c);
            ((JComboBox)c).setMaximumRowCount(maxi(33,((JComboBox)c).getMaximumRowCount()));
        }else if(c instanceof JTextField){
            if(isPrprty(IS_MAC_LAF)) awtc(AWTC_REMOVE_FROM_PARENT,childC(parentC(c),JLabel.class));
/*for(EventListener li:((Component)c).getListeners(KeyListener.class)) putln(DEBUG_LONGER+" li="+clazz(li));*/
/* The JLabel says: "File: Tabulator-key to expand File"  Nevertheless,this is not working. */
/* AquaFileChooserUI has its own completion */
#define tc pcp(_TXTC_KEY,new ChUtils(INST_TEXTCOMPONENT,0).tcInit(c).enableWordCompletion(COMPL_TAB|COMPL_ALLOW_SPC_IN_FILE,this,chrClas(SLASH),null),c)
            pcp(KEY_AVOID_GARBAGE_COLLECT,addLi(this,LSTNR_KEY,tc),c);
#undef tc
            final Container p=(Container)parentC(addLi(this,LSTNR_FOCUS,_tf=c));
            if(p!=null){
/* AquaFileChooserUI: The text field is invisible in OPEN_DIALOG. */
                awtc(AWTC_SET_VISIBLE_ON|AWTC_OPT_PARENT,
                     awtc(AWTC_SET_VISIBLE_ON|AWTC_OPT_PARENT,
                          awtc(AWTC_SET_VISIBLE_ON,p)));
                if(p.getLayout() instanceof FlowLayout) p.setLayout(new BoxLayout(p,LINE_AXIS));
            }
        }
        boolean isToolbar=false;
        for(Component child:childsC(c)){
            if(fstTime && toolbars!=null){
                if(isPrprty(IS_MAC_LAF) && child instanceof JComboBox){
                    isToolbar=true;
                    if(((Container)c).getLayout() instanceof BoxLayout && ((BoxLayout)((Container)c).getLayout()).getAxis()!=LINE_AXIS){
                        ((Container)c).setLayout(new BoxLayout((Container)c,LINE_AXIS));
                    }
                }else if(child instanceof AbstractButton){
                    if(getIcn(addLi(this,LSTNR_ACT,child))!=null) isToolbar=true;
                }else if(child instanceof JTextField){
                    isToolbar=false;
                    pcp(KOPT_NO_SEARCH_DIALOG,"",child);
                    break;
                }
            }
            _walkComponentTree(child,toolbars);
        }
        if(isToolbar) adUniq(c,toolbars);
    }
}
#undef CACHE_SCROLL
#undef CACHE_SELF
#undef maps
