package charite.christo;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
public final class ChJSlider extends javax.swing.JSlider{
    int _mc;
    private boolean _lastEnabled=true;
    private String[]_labels;
/* >>> Constructor  >>> */
    public ChJSlider(int mi,int ma,int ini,ChRunnable r){
        super(mi,ma,maxi(mi,ini));
        addLiUtils(LSTNR_CHANGE|LSTNR_WHEEL,addLi(r,LSTNR_CHANGE,this));
    }


/* SDialogs_TAB_COMPARE_SEQUENCES_Inc.java:39:        _bb[BB_sliderH]=new ChJSlider(1,50,16,this).endLabels("Height",null); */
/* SDialogs_TAB_COMPARE_SEQUENCES_Inc.java:40:        _bb[BB_sliderS]=new ChJSlider(1,100,20,this).endLabels("Scale",null); */
/*         if(_sliderDistDna==null) _sliderDistDna=new ChJSlider(0,100,30,this).endLabels(arry(SARRAY_Simple3D_close_and_distant)); */
/*         Strap_Gui_Inc.java:90:setTip(rsc(RSC_SBALLOON_SLIDER_RESIDUE_SIMILARITY),_sliderSimilarity=new ChJSlider(-100,100,50,_main).endLabels(splitTkns("Diff All Conserv"))))))); */
/* SDialogs_TAB_ALIGN_ONE_ALL_Inc.java:16:        _bb[BB_sliderMatch]=new ChJSlider(-100,100,0,this).endLabels(arry(SARRAY_TabAlignOneAll_all_high)); */

    //    final ChJSlider sl=it==DISTANCE_CURSOR?new ChJSlider(0,1600,0,this):new ChJSlider(0,DISTANCE_HETERO_MAX_VALUE*100,DISTANCE_HETERO_MAX_VALUE*100,this);

@*SARRAYeq_ChJSlider_LABELS
     Values that are higher than ...|=CHJSLIDER_DIA_PLOT_L
     Values that are lower than ...|=CHJSLIDER_DIA_PLOT_U
     Height|=CHJSLIDER_DIA_COMPARE_SEQUENCES_height
     Scale|=CHJSLIDER_DIA_COMPARE_SEQUENCES_scale
     Scale|=CHJSLIDER_GRAPH_SUN_SCALE
     Close|Distant=CHJSLIDER_Simple3DCanvas_distanceDna
     Diff|All|Conserv=CHJSLIDER_Strap_slider_similarity
     All|High matching=CHJSLIDER_DIA_ALIGN_ONE_ALL_match
*@

@*SARRAYeq_ChJSlider_VALUES
     0 100 0=CHJSLIDER_DIA_PLOT_L
     0 100 40=CHJSLIDER_DIA_PLOT_U
     1 50 16=CHJSLIDER_DIA_COMPARE_SEQUENCES_height
     1 100 20=CHJSLIDER_DIA_COMPARE_SEQUENCES_scale
     0 100 30=CHJSLIDER_Simple3DCanvas_distanceDna
     -100 100 50=CHJSLIDER_Strap_slider_similarity
     -100 100 0=CHJSLIDER_DIA_ALIGN_ONE_ALL_match
     0 1600 0=CHJSLIDER_DISTANCE_CURSOR_L
     0 1600 DISTANCE_CURSOR_MAX_VALUE100=CHJSLIDER_DISTANCE_CURSOR_U
     0 1600 DISTANCE_HETERO_MAX_VALUE100=CHJSLIDER_DISTANCE_HETERO
     1 66 HYDROPHOB_WINDOW_INIT=CHJSLIDER_ValueOfImpl_HYDROPHOB_WINDOW
     1 COSINUS_SIZE_minus1 COSINUS_SIZE_by2=CHJSLIDER_DIA_DOTPLOT_lowPassWidth
     0 1024 256=CHJSLIDER_DIA_DOTPLOT_Brightness
     0 400 100=CHJSLIDER_GRAPH_SUN_SCALE
*@
@*SARRAYeq_ChJSlider_BALOON
     Highlighting sequence positions<UL><LI>Slider Left: Differing positions</LI><LI>Slider middle: All</LI><LI>Slider right: Conserved positions</LI></UL>=CHJSLIDER_Strap_slider_similarity
     Moving average low pass filter.<BR>Width of the cosinus curve<BR>#<SUB>weights</SUB>=2*n+1.=CHJSLIDER_DIA_DOTPLOT_lowPassWidth
     Intensity of the plot<BR>Values are first multiplied<BR>and then turned into gray color=CHJSLIDER_DIA_DOTPLOT_Brightness
*@
    public ChJSlider(int it,ChRunnable r){
        this(
             intArrys(SARRAYeq_ChJSlider_VALUES)[it][0],
             intArrys(SARRAYeq_ChJSlider_VALUES)[it][1],
             intArrys(SARRAYeq_ChJSlider_VALUES)[it][2],r);
        final String s=iConst(SARRAYeq_ChJSlider_LABELS,it);
        if(s!=null) endLabels(splitTkns(SPLIT_ALLOW_EMPTY_TOKENS|'|',s));
        setTip(iConst(SARRAYeq_ChJSlider_BALOON,it),this);
        if(it==CHJSLIDER_DISTANCE_CURSOR_L||it==CHJSLIDER_DISTANCE_CURSOR_U||it==CHJSLIDER_DISTANCE_HETERO){
            setMajorTickSpacing(100);
            setMajorTickSpacing(200);
            setPaintLabels(false);
            setPaintTicks(true);
        }
        if(it==CHJSLIDER_ValueOfImpl_HYDROPHOB_WINDOW){
            setPaintLabels(true);
            setPaintTicks(true);
            setMajorTickSpacing(10);
            setMinorTickSpacing(1);
            setSnapToTicks(true);
        }
        if(it==CHJSLIDER_DIA_DOTPLOT_lowPassWidth){
            setPaintLabels(true);
            setPaintTicks(true);
            setLabelTable(createStandardLabels(10));
            setMajorTickSpacing(8);
            setMinorTickSpacing(2);
        }
    }
    // intArry intArrys
/* <<< Value <<< */
/* ---------------------------------------- */
/* >>> Label >>> */
    public ChJSlider endLabels(String... labels){
        _labels=labels;
        if(fstNotNull(labels)!=null){
            final java.util.Hashtable ht=new java.util.Hashtable();
            ht.put(io(0),new javax.swing.JLabel(" "));
            setLabelTable(ht);
            setPaintLabels(true);
        }
        return this;
    }
/* <<< Label <<< */
/* ---------------------------------------- */
/* >>> paint >>> */
    public void paintComponent(java.awt.Graphics g){
        if(DIFF_MC(_lastEnabled,isEnabled())) awtc(AWTC_OPT_REVALIDATE,this);
        if(!isOpaque()) setBG(0xFFffFF,this);/*X  Nimbus bug */
        super.paintComponent(g);
        java.awt.Font f=null;
        int cb[]=null,xPrev=MAX_INT;
        ROFi0(sze(_labels)){
            if(sze(_labels[i])!=0){
                if(f==null){
                    g.setFont(f=mkFont(11,FNT_PROPORTIONAL));
                    cb=chrBnds(f);
                    setColorRGB(0,g);
                }
                final int sw=strgWidth(f,_labels[i]),x=mini(getWidth()-sw,maxi(0,getWidth()*i/(_labels.length-1)-sw/2));
                if(x+sw<xPrev) g.drawString(_labels[i],x,getHeight()-cb[RECTh]+cb[RECTy]);
                xPrev=x;
            }
        }
    }
/* <<< paint <<< */
/* ---------------------------------------- */
/* >>> layout >>> */
    OVERRIDE_PUBLIC java.awt.Dimension getPreferredSize(){
        final java.awt.Dimension d=_prefSzeThis(this);
        return d!=null?d:super.getPreferredSize();
    }
/* <<< layout <<< */
}
