package charite.christo;
import javax.swing.table.*;
import static charite.christo.ChUtils.*;
/* @author Christoph Gille */
/* See TableCellEditor ChTableModel */
public class ChJTable extends javax.swing.JTable implements ChRunnable{
    private String[]_headerTT;
    private boolean _initialized;
    private Object _dragRowSrc;
    private int _dragRowCols[],_mouseHeaderCol=-1,_decimal[];
    public ChJTable(int opt,TableModel m){
        if(m!=null){
            setModel(m);
            if((JTABLE_ROW_SORTER&opt)!=0) setRowSorter(null);
            runCR1(RUN_TABLEMODEL_setJTable,m,this);
        }
        if((JLIST_DEFAULT_RENDERER&opt)!=0) setDefaultEditor(Object.class,(ChUtils)(_renderer=newRenderer(0)));
        else _renderer=null;
        if((JLIST_ICON_ROW_HEIGHT&opt)!=0) setRowHeight(32);
        if((JLIST_EX_ROW_HEIGHT&opt)!=0) setRowHeight(EX);
        if((JLIST_EXX_ROW_HEIGHT&opt)!=0) setRowHeight(EX*3/2);
        addLi(this,LSTNR_MOMO|LSTNR_ACT,getTableHeader());
        if((opt&JLIST_NO_REORDER)!=0) getTableHeader().setReorderingAllowed(false);
        setShowHorizontalLines(true);
        setShowVerticalLines(true);
        setGridColor(C(0));
        setIntercellSpacing(dim(1,1));
        setBG(DEFAULT_BACKGROUND,
              specifcLstnr(WLI_SCROLL,
                  specifcLstnr(SELECTIONLI_CHANGE,this)));
    }
    OVERRIDE_PUBLIC void columnMoved(javax.swing.event.TableColumnModelEvent ev){
        super.columnMoved(ev);
        runServices(RUN_TABLE_COLUMN_MARGIN_CHANGED,this);
    }
    OVERRIDE_PUBLIC void columnMarginChanged(javax.swing.event.ChangeEvent ev){
        super.columnMarginChanged(ev);
        runServices(RUN_TABLE_COLUMN_MARGIN_CHANGED,this);
    }
    {pcp(KOPT_TRACKS_VIEWPORT_WIDTH,"",this);}
    OVERRIDE_PUBLIC boolean getScrollableTracksViewportWidth(){return gcp(KOPT_TRACKS_VIEWPORT_WIDTH,this)!=null;}
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Renderer >>> JTable */
    OVERRIDE_PUBLIC void paintComponent(java.awt.Graphics g){
        if(false || paintHooks(this,g,false)){
            try{
                super.paintComponent(g);
                if(!_initialized){
                    _initialized=true;
                    setBrdrC(null,getSP(this));
                }
            }catch(Throwable e){}
        }
        paintHooks(this,g,true);
    }
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Renderer >>> */
    private final ChUtils _renderer;
    public ChUtils getChRenderer(){return _renderer;}
    public ChJTable headerTip(String...tt){
        ROFi0((_headerTT=new String[sze(tt)]).length) _headerTT[i]=s(addHtmlTags(tt[i]));
        return this;
    }
    OVERRIDE_PUBLIC TableCellRenderer getCellRenderer(int row,int column){return(_renderer!=null)?_renderer:super.getCellRenderer(row,column);}
    OVERRIDE_PUBLIC String getToolTipText(java.awt.event.MouseEvent ev){return ballonMsg(ev,super.getToolTipText(ev));}
/* <<< Renderer <<< */
/* ---------------------------------------- */
/* >>> AWTEvent  >>> */
    {this.enableEvents(ENABLE_EVT_MASK);}
    OVERRIDE_PUBLIC void processEvent(java.awt.AWTEvent ev){
        if(!evtShouldProcess(ev)) return;
        final boolean ed=isEditing();
        if((ev.getID()==MOUSE_CLICKED || ev.getID()==MOUSE_PRESSED)){
            boolean clearSelection=false;
            final int row=rowAtPoint(evtPoint(ev)),col=columnAtPoint(evtPoint(ev));
            if(col>=0 && row>=0 && isCellEditable(row,col)){/*X  Workaround: Under Windows difficult to get the cursor into a cell */
                if(_renderer instanceof ChUtils && isEditing()){
                    final ChTextField tf=((ChUtils)_renderer).getRndrerTextfield();
                    if(awtc(AWTC_IF_HAS_FOCUS,tf)!=null) setValueAt(s(tf),getEditingRow(),getEditingColumn());
                }
                editCellAt(row,col);
                final TableCellEditor tce=getCellEditor(row,col);
                if(tce!=null){
                    final Object c=tce.getTableCellEditorComponent(this,getValueAt(row,col),false,row,col);
                    inEDTms(thread_requestFocus(derefZ(c,ChTextField.class)),99);
                    if(c instanceof ChButton && ev.getID()==MOUSE_CLICKED && 0==(evtModi(ev)&(CTRL_MASK|SHIFT_MASK|ALT_MASK)) && evtButtn(ev)==1) ((ChButton)c).doClick();
                }
            }else if(ev.getID()==MOUSE_PRESSED){
                final int[]sel=getSelectedRows();
                if(sze(sel)==1 && sel[0]==row) clearSelection=true;
                if(clearSelection){
                    clearSelection();
                    return;
                }
            }
        }
        if(ev.getID()==MOUSE_DRAGGED && (_dragRowSrc!=null || _dragRowCols!=null)){
            final int row=rowAtPoint(evtPoint(ev)),col=columnAtPoint(evtPoint(ev)),nC=getColumnCount();
            if(col>=0 && row>=0 && (_dragRowCols==null || idxOf(col,_dragRowCols)>=0)){
                if(ed && getCellEditor()!=null) getCellEditor().stopCellEditing();
                final BA sb=new BA(99);
                {
                    final int[]selRows=getSelectedRows();
                    final Object srcID=gcp(KEY_DRAG_SRC_ID,this);
                    for(int r:idxOf(row,selRows)>=0?selRows:new int[]{row}){
                        FORc(0,nC) sb.aa(getValueAt(r,c),'\t');
                        if(srcID!=null) sb.a(srcID); else sb.a(hashCode());
                        sb.aa('\t',r).aln();
                    }
                }
                if(sze(sb)>0){
                    if(gcps(TABLE_KEY_FILE_EXT_DND,this)!=null) adNotNull(wrte(file(iPath2(DIR_TMP,"tableRow.").a(gcps(TABLE_KEY_FILE_EXT_DND,this))),sb),clr(dndV(this)));
                    else clr(dndV(this)).add(s(sb));
                    exportDrg(this,ev,TransferHandler_COPY);
                }
            }
        }
        try{super.processEvent(ev);}catch(Throwable e){}
    }
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_JCOMPONENT_AS_TEXT_SELECTED)
                CASE_ARGV(RUN_JCOMPONENT_AS_TEXT){
                final BA sb=new BA(999);
                final int cols=getColumnCount();
                FORi(0,cols) sb.aa(getColumnName(i),'\t');
                sb.del('\t').aln();
                FORi(0,cols) sb.an('-',sze(getColumnName(i))).a('\t');
                sb.del('\t').aln();
                final int rows=getRowCount(),selected[]=getSelectedRows();
                FORr(0,rows){
                    if(id==RUN_JCOMPONENT_AS_TEXT || idxOf(r,selected)>=0){
                        FORi(0,cols){
                            final Object v=getValueAt(r,i);
                            if(sb.end()==sb.a(rendererTxt(v)).end()) sb.a(getTxt(getCellRenderer(r,i).getTableCellRendererComponent(this,v,false,false,r,i)));
                            sb.a('\t');
                        }
                        sb.del('\t').aln();
                    }
                }
                return sb;
            }
            CASE_ARGV(RUN_TABLE_GET_DECIMAL){
                if(sze(_decimal)<=ROW_COL[1]) _decimal=chSze(_decimal,ROW_COL[1]+9);
                return _decimal;
            }
        }
#define ev arg
        if(RUN_M_EVT(id)){
            final java.awt.Point p=evtPoint(ev);
            if(p!=null){
                final Object h=deref(evtSrc(ev));
                if(h instanceof JTableHeader && _mouseHeaderCol!=(_mouseHeaderCol=columnAtPoint(p))) setTip(iThEl(_mouseHeaderCol,_headerTT),h);
            }
        }
#undef ev
        return null;
    }
/* <<< AWTEvent <<< */
/* ---------------------------------------- */
/* >>> DnD >>> */
    public void enableDragRows(Object src,int[]fromCols){
        _dragRowSrc=wref(src);
        _dragRowCols=fromCols;
    }
    REFLECTION_PUBLIC Object getDndDateien(){return dndV(this);}
/* <<< DnD <<< */
/* ---------------------------------------- */
/* >>> Layout >>> */
    public TableColumn column(int col){
        if(col<0 || col>=getColumnCount()) return null;
        try{return getColumnModel().getColumn(col);}catch(Exception e){errorEx(e); return null;}
    }
    public void setColWidthC(Object c,int col){
        if(c!=null){
            IF_MEIN_DEBUG(if(!(c instanceof java.awt.Component || c instanceof Object[])) assrt());;
            setColWidth(wdth(getIntercellSpacing())+prefW(c)+JLIST_COLUMN_EXTRA_WIDTH,col);
        }
    }
    public ChJTable setColWidthPrefMiMa(int pref,int min,int max,int col){
        final TableColumn c=column(col);
        if(c!=null){
            c.setPreferredWidth(pref);
            c.setMinWidth(min==-1?pref:min);
            c.setMaxWidth(max==-1?pref:max);
        }
        return this;
    }
    public void setColWidth(int w,int col){
        final TableColumn c=column(col&~TABLE_COLUMN_RESIZABLE);
        if(c==null) return;
        if(w>=0){
            c.setPreferredWidth(w);
            if(0==(col&TABLE_COLUMN_RESIZABLE)) {c.setMaxWidth(w); c.setMinWidth(w);}
        }
    }
/* <<< Layout <<< */
/* ---------------------------------------- */
}
