package charite.christo;
import java.awt.*;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
#define BORDER 4
public final class ChSprite implements Runnable{
    private final String _txt;
    private final Object _cDest;
    private final Font _font=mkFont(12,0);
    private final int _w,_h,_xDst,_yDst,_xSrc,_ySrc,_mseconds;
    private int _lastX=MIN_INT,_lastY,_x,_y;/*X Screen Coordinates*/
    public ChSprite(Component cSrc,Point pSrc,Component cDest,Point point,String txt,int mseconds){
        _cDest=wref(cDest);
        _mseconds=mseconds;
        _txt=txt;
        if(txt instanceof String){
            _h=2*ChSprite_TEXT_MARGIN+charH(_font);
            _w=2*ChSprite_TEXT_MARGIN+strgWidth(_font,txt);
        }else{
            _w=_h=10;
        }
        _xDst=screenX(cDest)+x(point);
        _yDst=screenY(cDest)+y(point);
        _xSrc=screenX(cSrc)+x(pSrc);
        _ySrc=screenY(cSrc)+y(pSrc);
    }
/* <<< Constructor <<< */
/* ---------------------------------------- */
/* >>> canvas >>> */
    private Object _cPrev;
    private Component canvas(){
        final Component
             cRoot=awtc(AWTC_GET_ROOT_PANE,_cDest),
            cDeep=cRoot==null?null: javax.swing.SwingUtilities.getDeepestComponentAt(cRoot,_x,_y),
            c=cDeep instanceof Component || cDeep==null?cRoot: cDeep;
        if(c==null) return null;
        _canvasX=_x-screenX(c);
        _canvasY=_y-screenY(c);
        if(DIFF_MC(_cPrev,cDeep) && awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_100,_cPrev)!=null) _prevX=INT_NAN;
        return c;
    }
/* <<<  canvas <<< */
/* ---------------------------------------- */
/* >>>  offImage >>> */
    private Image _im,_im2;
    private int _offX,_offY,_offW,_offH,_prevX=INT_NAN,_prevY, _canvasX,_canvasY;
    private Image offImage(){
        final Component c=canvas();
        if(c==null) return null;
        final int x=_canvasX,dx=_prevX==INT_NAN?0:x-_prevX;
        final int y=_canvasY,dy=                  y-_prevY;
        if(_prevX==INT_NAN || _im==null||
            x<=_offX || x+_w >=_offX+_offW||
            y<=_offY || y+_h>=_offY+_offH){
            if(_im==null){
                _im=c.createImage(_offW=3*_w,_offH=3*_h);
                _im2=c.createImage(_offW,_offH);
            }
            if(_im==null) return null;
            _prevX=x;
            _prevY=y;
            _offX=x + (dx>0?-BORDER:dx<0?_w-_offW+BORDER:(_w-_offW)/2);
            _offY=y + (dy>0?-BORDER:dy<0?_h-_offH+BORDER:(_h-_offH)/2);
            final Graphics g=awtGraphics(_im);
            g.translate(-_offX,-_offY);
            c.paint(g);
            g.translate(_offX,_offY);
        }
        return _im;
    }
/* <<< offImage <<< */
/* ---------------------------------------- */
/* >>>  offImage >>> */
    private void stroke(){
        final Component c=canvas();
        final Image im=offImage();
        final Graphics g=awtGraphics(c),g2=awtGraphics(_im2);
        if(g==null||im==null||g2==null) return;
        g2.drawImage(im,0,0,c);
        final int x=_canvasX-_offX,y=_canvasY-_offY;
        if(_txt!=null){
            final int ax=_xSrc-_x,ay=_ySrc-_y,transp=32+(int)(2*Math.sqrt(ax*ax+ay*ay));
            g2.setColor(argbToColor(0xFFffFF|(transp<<24)));
            g2.fillRoundRect(x+1,y+1,_w-2,_h-2,ChSprite_TEXT_MARGIN/2,ChSprite_TEXT_MARGIN/2);
            setColorRGB(0,g2);
            g2.setFont(_font);
            g2.drawString(_txt,x+ChSprite_TEXT_MARGIN,y+ChSprite_TEXT_MARGIN+charA(_font));
        }
        g.drawImage(_im2,_offX,_offY,c);
    }

    OVERRIDE_PUBLIC void run(){
        if(isEDT()) stroke();
        else{
            final int STEPS=(int)Math.sqrt((_xDst-_xSrc)*(_xDst-_xSrc)+(_yDst-_ySrc)*(_yDst-_ySrc));
            FORi(0,STEPS){
                _x=(int)(_xSrc+(_xDst-_xSrc)*(float)i/STEPS)-_w/2;
                _y=(int)(_ySrc+(_yDst-_ySrc)*(float)i/STEPS)-_h/2;
                if(_lastX!=_x || _lastY!=_y || _prevX==INT_NAN){
                    inEdtLater(this);
                    _lastX=_x;
                    _lastY=_y;
                }
                int delay=_mseconds/STEPS;
                if(i<55) delay+=(55-i);
                if((STEPS-i)<55) delay+=(55-STEPS+i);
                sleepMS(delay);

            }
            awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_1600,canvas());
        }
    }
#if CPP_DEACTIVATED_MAIN
/*      java charite.christo.test.ChSpriteTest    */
    public final class ChSpriteTest implements ChRunnable{
        OVERRIDE_PUBLIC Object run(int id,Object ev){
            if(id==RUN_M_mousePressed){
                startThrd(new ChSprite(panel,new Point(wdth(panel)/2,hght(panel)/2),awtc(0,evtSrc(ev)),new Point(x(ev),y(ev)),"Hallo",1111));
            }
            return null;
        }
        private Component panel=new ChTextArea( "1\n2\n3");{tcTools(panel).saveInFile("TestChChase");}

        public ChSpriteTest(){
            new ChFrame("")
                .ad(pnl(CNSEW,
                        addLi(this,LSTNR_MO,panel),
                        addLi(this,LSTNR_MO,pnl("North")),
                        addLi(this,LSTNR_MO,pnl("South")),
                        addLi(this,LSTNR_MO,pnl("East")),
                        addLi(this,LSTNR_MO,pnl("West"))))
                .shw(0);
        }
        public static void main(String[]argv)throws Exception{
            if(mainInEDT(ChSpriteTest.class,argv)){
                new ChSpriteTest();
            }
        }
    }
#endif //CPP_DEACTIVATED_MAIN
}
#undef BORDER
