package charite.christo;
import static charite.christo.ChUtils.*;
import java.awt.*;
import javax.swing.table.TableColumn;
/* Container that arranges components horizontally. */
/* A header allows dragging of columns and resizing like in a JTable. */
/* @author Christoph Gille */
// BasicTableHeaderUI JScrollPane BasicScrollPaneUI

#define getColumnCount() sze(_v)
#define MIN_SIZE EM
#define DIVIDER EM
#define SQUEEZE 2*EM

public final class ChTableLayout extends ChPanel{
    private final static Rectangle RECT_ERROR=new Rectangle();
    private static String _msgUndock;
    private final Object LABEL=new ChButton(BUTTN_LABEL,null);
    private final int _opt;
    private boolean _dragged,likeDivider,likeDividerWhenMoved,_resizing;
    private int _resizingCol=-1,_selCol=-1,_labelCol,_colUnderMouse=-1;
    private Runnable _tDivider;
    private final java.util.ArrayList<Object>_v=new java.util.ArrayList();
    public final ChJTable _t;
    public ChTableLayout(int opt){
        _opt=opt;
        setLayout(null);
        setPrefSze(0,0,addSrvc(RUN_TABLE_COLUMN_MARGIN_CHANGED,this,_t=new ChJTable(opt|JLIST_DEFAULT_RENDERER,new ChTableModel(0,null,this))));
        final javax.swing.table.JTableHeader th=th();
        addLi(this,LSTNR_MOMO|LSTNR_MO,monospc(th));
        addLi(this,LSTNR_COMPONENT,this);
        if(0!=(opt&JTABLE_FOCUSED_BLACK)) th.setDefaultRenderer(_t.getChRenderer());
        setPrefSze(9999,EX,th);
        add(th);
        add(_t);
        setMinSze(0,0,addSrvc(RUN_SERVICE_PAINTHOOK,this,setTip(this,LABEL)));
        th.setResizingAllowed(true);
    }
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Event  >>> */
    private javax.swing.border.Border H_BORDER,BORDER;
    {
        try{
            H_BORDER=new javax.swing.plaf.metal.MetalBorders.TableHeaderBorder();
            BORDER=new javax.swing.plaf.metal.MetalBorders.TableHeaderBorder();
        }catch(Throwable t){}

    }
    private static int xButton(int type,int rw){
        final int xClose=-EM-(rw>4*EM?EM:EM/2);
        if(type==SMALLBUT_CLOSE) return xClose;
#if WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
        if(type==SMALLBUT_MAXIMIZE) return xClose-EM-(rw>3*EM?EM/2:2);
#endif //WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
        return 0;
    }

    public int getSelectedIndex(){return _selCol;}
/* <<< Event <<< */
/* ---------------------------------------- */
/* >>> Header >>> */
    public int columnWidth(int i) {return rectangleAt(i).width;}
    private Rectangle rectangleAt(int i){
        try{
            if(i>=0) return th().getHeaderRect(_t.convertColumnIndexToView(i));
        }catch(Throwable t){}
        return RECT_ERROR;
    }
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> Header >>> */
    public javax.swing.table.JTableHeader th(){return _t.getTableHeader();}
    public ChTableLayout setColumnTitle(int col,String title){
        final TableColumn c=colV(col);
        if(c!=null){
            c.setHeaderValue(toStrgN(title));
            awtc(AWTC_OPT_REPAINT,th());
        }
        return this;
    }
    private TableColumn colV(int col0){
        return col0<0||col0>=getColumnCount()?null:_t.column(_t.convertColumnIndexToView(col0));
    }
/* <<< Header <<< */
/* ---------------------------------------- */
/* >>> add remove get Columns >>> */
/*     private void recursiveAddMoli(Component c,Object item){ */
/*     addLi(this,LSTNR_MO|LSTNR_FOCUS,c); */
/*     if(c instanceof Container){ */
/*         for(Component child:((Container)c).getComponents()) recursiveAddMoli(child,item); */
/*     } */
/* } */

    public ChTableLayout addCol(int opt,Object p){
        {
            final Component panel=getPnl(p);
            if(panel!=null){
                if(0!=(_opt&JTABLE_FOCUSED_BLACK)) addSrvc(RUN_SERVICE_PAINTHOOK,this,panel);
                addLi(this,LSTNR_MOMO|LSTNR_MO|LSTNR_FOCUS,panel);
                //recursiveAddMoli(panel,wref(p)); See LSTNR_ALSO_CHILDS
            }
        }
        if(adUniq(p,_v)){
            fixColumnModel();
            handleActCmdI(ACTION_TLAYOUT_ADDED,this,0);
        }
        pcpAddOpt(KEY_CLOSE_OPT,opt&CLOSE_MASK,p);
        return this;
    }
    private void fixColumnModel(){
        _t.createDefaultColumnsFromModel();
        layoutColumns();

        awtc(AWTC_OPT_REPAINT,this);
        _t.tableChanged(new javax.swing.event.TableModelEvent(_t.getModel()));
    }
    public void removeColumn(Object... pp){
        if(pp==null) return;
        boolean changed=false;
        for(Object p:pp){
            if(_v.remove(p)){
                changed=true;
                addLi(this,LSTNR_REMOVE,p);
            }
        }
        if(changed){
            fixColumnModel();
            handleActCmdI(ACTION_TLAYOUT_REMOVED,this,0);
        }

    }
    public Object[]getAllComponents(){return _v.toArray();}
    public void layoutColumns(){
        for(Component c:getComponents()) if(c!=_t && c!=th()) remove(c);
        for(Object o:_v.toArray()){
            final Component c=getPnl(o);
            add(c!=null?c:(Component)setTxt("error",setBG(0x0FFffFF,setFG(0,LABEL))));
        }
    }
/* <<< add remove get Columns <<< */
/* ---------------------------------------- */
/* >>> Thread  >>> */
    private final Runnable THREAD_LOCATION=thrdCR(_RUN_TLAYOUT_B,this);
#define row ROW_COL[0]
#define col ROW_COL[1]
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_TABLE_getRowCount){
                ROW_COL[0]=0;
                break;
            }
            CASE_ARGV(RUN_TABLE_getColumnCount){
                ROW_COL[1]=getColumnCount();
                break;
            }
            CASE_ARG(RUN_TABLE_getTableCellRendererComponent,Object,v){
                RETURN(setBG((_labelCol=col)==_selCol?0xffFFff:DEFAULT_BACKGROUND,setBrdrC(H_BORDER,setTxt(titleForObject(iThEl(col,_v)),LABEL))));
            }
#undef row
#undef col
            CASE_ARG(RUN_PROVIDE_TOOLTIP,Object,objOrEv){
                if(objOrEv==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                if(evtSrc(objOrEv)==LABEL){
                    final String t=getTxt(LABEL);
                    if(strgWidth(LABEL,t)>columnWidth(_labelCol)) return t;
                }
                BREAK;
            }
            CASE_ARG(RUN_TABLE_COLUMN_MARGIN_CHANGED,Object,c){
                inEDTms(THREAD_LOCATION,99);
                THREAD_LOCATION.run();
                BREAK;
            }
            CASE_ARGV(_RUN_TLAYOUT_DSB){
                if(null!=gcp(KEY_LOOKS_LIKE_DIVIDER,th())) drawDivider(th(),null,0,0,-2*EM,EM);
                if(0==(_opt&JTABLE_FOCUSED_BLACK)) drawSmallButtons(th(),null);
                break;
            }
            CASE_ARGV(_RUN_TLAYOUT_B){
                int iDragged=-1;
                final TableColumn col=th().getDraggedColumn();
                if(col!=null)  iDragged=col.getModelIndex();
                final int width=getWidth(),headerH=prefH(th());
                th().setBounds(0,0,width,headerH);
                _t.setBounds(0,headerH,width,1);
                for(int n=getColumnCount(),h=getHeight(),iC=0;iC<n;iC++){
                    final Component c=getPnl(iThEl(iC,_v));
                    final Rectangle r=c==null?null:rectangleAt(iC);
                    if(r!=RECT_ERROR&&r!=null){
                        final int x=x(r) + (iC==iDragged?th().getDraggedDistance():0);
                        c.setBounds(x,y(r)+headerH,maxi(0,(iC==n-1?width:x2(r))-x),maxi(0,h-headerH));
                    }
                }
                awtc(AWTC_OPT_REVALIDATE,_t);
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,this);
                break;
            }
            CASE_ARG(RUN_PAINT_HOOK_AFTER,Object,c){
                if(c==LABEL){
                    if(_t.convertColumnIndexToModel(_labelCol)==_colUnderMouse && null==th().getResizingColumn()){
                        ROFi0(2){
                            final int type;
                            if(i==0){
                                type=SMALLBUT_CLOSE;
                                if(null==gcp(KEY_CLOSE_OPT,iThEl(_labelCol,_v))) continue;
                            }
#if WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
                            else{
                                if(0==(_opt&JTABLE_SHOW_BUT_MAXIM) || getColumnCount()<2) continue;
                                type=SMALLBUT_MAXIMIZE;
                            }
#endif //WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
                            final int xBut=xButton(type,wdth(c));
                            if(xBut<0) setSmallButtonX(type,xBut,c);
                        }
                        drawSmallButtons(c,_paintHookG);
                    }
                }else{
                    {
                        final Object r=gcp(KEY_LOOKS_LIKE_DIVIDER,c);
                        if(r instanceof Rectangle && !_dragged) drawDivider(c,_paintHookG,x(r),y(r),wdth(r),hght(r));
                    }
                    if(_msgUndock!=null && c==getPnl(iThEl(_colUnderMouse,_v))) drawMsgY(DRAW_MSG_SET_COLOR,_msgUndock,c,_paintHookG,0);
                }
                BREAK;
            }/*X RUN_PAINT_HOOK_AFTER*/
        }

#define ev arg
#define ownRenderer  (0!=(_opt&JTABLE_FOCUSED_BLACK))
        if(RUN_M_EVT(id)){
            final Object q=evtSrc(ev);
            if(q==th()){
                Object removeColumn=null;
                if(id==RUN_M_mouseExited || id==RUN_M_mouseReleased) awtc(AWTC_OPT_REPAINT,q);
                final int x=x(ev);
                ROFcol0(getColumnCount()){
                    final Object comp=iThEl(col,_v),headerCanResizeV=gcp(KEY_LOOKS_LIKE_DIVIDER,q);
                    final Rectangle rectCol=rectangleAt(col);
                    if(rectCol==RECT_ERROR) continue;
                    final boolean isInColumn=x(rectCol)<x && x<x2(rectCol);
                    if(isInColumn && (id==RUN_M_mouseMoved && col!=_colUnderMouse || id==RUN_M_mouseEntered || id==RUN_M_mousePressed || id==RUN_M_mouseClicked)){
                        if(headerCanResizeV!=null || !ownRenderer){
                            if(_tDivider==null) _tDivider=thrdCR(_RUN_TLAYOUT_DSB,this);
                            inEDTms(_tDivider,50);
                        }
                        ROFi0(2){
                            final int type;
                            if(i==0){
                                type=SMALLBUT_CLOSE;
                                if(null==gcp(KEY_CLOSE_OPT,comp)) continue;
                            }
#if WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
                            else{
                                if(0==(_opt&JTABLE_SHOW_BUT_MAXIM) || getColumnCount()<2) continue;
                                type=SMALLBUT_MAXIMIZE;
                            }
#endif //WRITE_CONCATENATED_JAVA||defined SMALLBUT_MAXIMIZE
                            final int xBut=x2(rectCol)+xButton(type,rectCol.width);
                            if(xBut>=0){
                                if(!ownRenderer){
                                    setSmallButtonX(type,xBut,q);
                                    drawSmallButtons(q,null);
                                }
                                if(xBut<x && x<xBut+EM && id==RUN_M_mouseClicked){
                                    if(type==SMALLBUT_CLOSE) removeColumn=comp;
                                    else narrowAllOthers(comp,3*EM);
                                }
                            }
                        }
                    }
                    if(id==RUN_M_mouseExited && (headerCanResizeV!=null || null!=gcp(KEY_CLOSE_OPT,comp))) awtc(AWTC_OPT_REPAINT,q);
                    if(id==RUN_M_mouseDragged && 0==undockEnbld() && gcp(KOPT_UNDOCKABLE,comp)!=null){
                        final Component pnl=getPnl(comp);
                        _msgUndock=ANSI_INVERSE+"Hint: Panels can be dragged out - so-called undocking";
                        if(!(pnl instanceof ChPanel))  drawMsgY(DRAW_MSG_SET_COLOR,_msgUndock,pnl,null,0);
                    }
                    if(_dragged
                       && id==RUN_M_mouseReleased
                       && gcp(KOPT_UNDOCKABLE,comp)!=null
                       && col==_colUnderMouse
                       && !_resizing
                       && null==((javax.swing.table.JTableHeader)q).getResizingColumn()
                       && (y(ev)<-EX || y(ev)>EX+hght(q) || x<-EX || x>EX+wdth(q))){
                        inEDTms(pnlUndock(RETURN_THREAD|(0!=(evtModi(ev)&CTRL_MASK)?0:PNL_UNDOCK_ASK),comp,screenX(ev)-EX,screenY(ev)-EX/2),333);
                    }
                    if(id==RUN_M_mouseMoved){
                        if(x(rectCol)+EM<x && x<x2(rectCol)-3*EM && headerCanResizeV!=null){
                            if(headerCanResizeV instanceof Cursor) ((Component)q).setCursor((Cursor)headerCanResizeV);
                            else setCursrC(Cursor_N_RESIZE_CURSOR,q);
                        }
                        if(isInColumn && DIFF_MC(_colUnderMouse,col)) awtc(AWTC_OPT_REPAINT,q);
                    }
                }
                if(removeColumn!=null) inEDTms(closC(RETURN_THREAD|(0!=(evtModi(ev)&CTRL_MASK)?0:CLOSE_ASK)|closeOpts(removeColumn),removeColumn),99);
            }/*X q==th()*/
/* >>> Focussed gets a Border >>> */
#if WRITE_CONCATENATED_JAVA||defined _TLAYOUT_KEY_ITEM
            final Object item=orO(gcp(_TLAYOUT_KEY_ITEM,q),q);
#else
#define item q
#endif //WRITE_CONCATENATED_JAVA||defined _TLAYOUT_KEY_ITEM
            final int col=item==null?-1:_v.indexOf(item);
            if(id==RUN_M_mousePressed || id==RUN_M_focusGained){
                    if(col>=0 && DIFF_MC(_selCol,col)){
                        if(ownRenderer && BORDER!=null) ROFi0(getColumnCount()) setBrdrC(i==_selCol?BORDER:null,getPnl(iThEl(i,_v)));
#if WRITE_CONCATENATED_JAVA||defined TLAYOUT_KEY_OFFSET_COMPONENT
                        final Component pnlOffset=gcp(TLAYOUT_KEY_OFFSET_COMPONENT,q,Component.class);
                        if(col>0) awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,setPrefSze((int)(EX*Math.log((col*8+1))),0,pnlOffset));
#endif //WRITE_CONCATENATED_JAVA||defined TLAYOUT_KEY_OFFSET_COMPONENT
                        awtc(AWTC_OPT_REPAINT,th());
                    }
                }

            {/*X  >>> Begin Divider >>> */
                int yMax=gcpi(TLAYOUT_KEY_HEIGHT_SOUTH_PANEL,q);
                final int colConv=_t.convertColumnIndexToView(col);
                if((yMax==0 || yMax>y(ev))&&
                   !(parentC(q) instanceof javax.swing.JViewport)&&
                   (!(q instanceof javax.swing.JScrollPane))&&
                   (!(q instanceof javax.swing.JViewport))&&
                   colConv>=0 && colConv<getColumnCount()-1 && q instanceof Component){
                    final Rectangle rectCol=rectangleAt(col);
                    final int w=wdth(rectCol);
                    if(yMax==0) yMax=hght(q);
                    final boolean resizeCursorOld=likeDivider || _resizingCol==col;

                    likeDivider=w-DIVIDER<=x(ev) && x(ev)<=w;
                    if(id==RUN_M_mouseDragged && (!_dragged && (likeDividerWhenMoved || likeDivider))){
                        _resizingCol=col;
                    }
                    if(id==RUN_M_mouseMoved){
                        _resizingCol=-1;
                        likeDividerWhenMoved=likeDivider;
                    }
                    if(_resizingCol==col){
                        pcp(KEY_IS_RESIZING,"",q);
                        chColSize(col,x(ev),w);
                    }else if(id==RUN_M_mouseMoved){
                        ROFi0(getColumnCount()){
                            pcp(KEY_IS_RESIZING,null,iThEl(i,_v));
                            pcp(KEY_IS_RESIZING,null,q);
                        }
                    }
                    {
                        Object r=gcp(KEY_LOOKS_LIKE_DIVIDER,q);
                        if(likeDivider && !_dragged && id!=RUN_M_mouseExited){
                            if(!(r instanceof Rectangle)) {r=new Rectangle(); awtc(AWTC_OPT_REPAINT,q);}
                            setRect(w-EM,0,EM,yMax,(Rectangle)r);
                            pcp(KEY_LOOKS_LIKE_DIVIDER,r,q);
                            pcp(KEY_LOOKS_LIKE_DIVIDER,r,item);
                        }else{
                            pcp(KEY_LOOKS_LIKE_DIVIDER,null,q);
                            pcp(KEY_LOOKS_LIKE_DIVIDER,null,item);
                            if(r!=null)awtc(AWTC_OPT_REPAINT,q);
                        }
                    }
                    if(likeDivider || _resizingCol>=0){
                        if(!(q instanceof ChPanel)) drawDivider(q,null,w-EM,0,EM,yMax);
                        setCursrC(Cursor_E_RESIZE_CURSOR,q);
                    }else if(resizeCursorOld){
                        setCursrC(-1,q);
                    }
                }
            }/*X End Divider */
            if(id==RUN_M_componentResized) inEDTms(THREAD_LOCATION,333);
            if(id==RUN_M_mouseDragged) _dragged=true;
            if(id==RUN_M_mouseMoved || id==RUN_M_mouseReleased){
                _dragged=_resizing=false;
                _msgUndock=null;
            }
        }
        return null;
    }
#undef item
#undef ev
/* <<< Thread <<< */
/* ---------------------------------------- */
/* >>> Layout >>> */
    REFLECTION_PUBLIC_VOID narrowAllOthers(Object c,int narrowWidth){
        if(!isEDT())  inEdtLater(CPP_thrdM(narrowAllOthers,ChTableLayout.this,c,io(narrowWidth)));
        else{
            final int column=_v.indexOf(c),N=getColumnCount();
            final TableColumn tCol=colV(column);
            if(column<0 || column>=N || tCol==null || N<2) REFLECTION_RETURN;
            final int prefW=maxi(narrowWidth,th().getWidth()-narrowWidth*(N-1));
            ROFcol0(N){
                final TableColumn tc=colV(col);
                if(tc!=null){
                    tc.setMaxWidth(30000);
                    tc.setMinWidth(MIN_SIZE);
                    tc.setResizable(true);
                    tc.setPreferredWidth(tc==tCol?prefW:narrowWidth);
                }
            }
        }
        REFLECTION_RETURN;
    }
    public void chColSize(int column,int newWidth,int oldWidth){
        final TableColumn tCol=colV(column);
        final int N=getColumnCount();
        if(N<2 || tCol==null) return;
        final int nW=maxi(newWidth=mini(newWidth,th().getWidth()-(N-1)*SQUEEZE),SQUEEZE);
        int reduce=nW-oldWidth;
        FORc(0,N){
            final TableColumn tc=colV(c);
            if(tc!=null){
                tc.setMaxWidth(30000);
                tc.setMinWidth(MIN_SIZE);
                final int oldW=tc.getWidth(),prefW;
                if(c>column) reduce-=(oldW-(prefW=maxi(SQUEEZE,oldW-reduce)));
                else prefW=oldW;
                tc.setPreferredWidth(prefW);
            }
        }
        tCol.setPreferredWidth(nW-reduce);
        if(0!= (reduce+=nW-newWidth)){
            tCol.setPreferredWidth(nW);
            for(int c=column;--c>=0 && reduce!=0;){
                final TableColumn tc=colV(c);
                if(tc!=null){
                    final int oldW=tc.getWidth(),newW=maxi(SQUEEZE,oldW-reduce);
                    reduce-=(oldW-newW);
                    tc.setPreferredWidth(newW);
                }
            }
        }
    }
    public Dimension getPreferredSize(){
        int h=0;
        for(Object o:getAllComponents()) h=maxi(h,prefH(o));
        return dim(EX,h+ EX+prefH(th()));
    }

}
#undef DIVIDER
#undef MIN_SIZE
#undef SQUEEZE
