package charite.christo;
import static charite.christo.ChUtils.*;
/** @author Christoph Gille */
public final class ChTextField extends javax.swing.JTextField implements HasWRef{
    private boolean _painting,_painted;
    public ChTextField(){this(0,"");}
    public ChTextField(Object defaultText) {this(0,defaultText);}
    public ChTextField(int opt,Object defaultT){
        if(defaultT instanceof java.io.File) opt|=COMPLETION_FILES_IN_WORKING_DIR;
        IF_MEIN_DEBUG(if(!(defaultT instanceof javax.swing.text.Document || defaultT instanceof javax.swing.JTextField || defaultT instanceof CharSequence || defaultT==null)) assrt());;
        final javax.swing.text.Document doc=defaultT instanceof javax.swing.text.Document?(javax.swing.text.Document)defaultT: defaultT instanceof javax.swing.JTextField?((javax.swing.JTextField)defaultT).getDocument():null;
        if(doc!=null) setDocument(doc);
        else{
            final String s=s(defaultT);
            if(s!=null) setText(s);
        }
        monospc(this);
        if(opt!=0){
            if((opt&(COMPLETION_DIRECTORY_PATH|COMPLETION_FILES_IN_WORKING_DIR))!=0){
                undrlneRefs(ULREFS_NOT_CLICKABLE,this);
                tcTools(this).enableUndo(true).enableWordCompletion(COMPL_TAB,(opt&COMPLETION_FILES_IN_WORKING_DIR)!=0?iFile(DIR_WORKING): new ChFileFilter("-d"),null,null);
                tcHighlightOccurrence(WRONG_CHARS_IN_FILEN,null,null,HIGHLIGHT_UPDATE_IF_TEXT_CHANGES|HIGHLIGHT_STYLE_WAVE,C(0xFF0000),this);
            }
            undrlneRefs(opt,this);
        }
    }
    public ChTextField cols(int columns){/*X ,boolean minimumSize,boolean maximize){ */
        if(0!=(columns&TF_MASK_COLUMNS)) setColumns(columns&TF_MASK_COLUMNS);
        if(0==(columns&TF_NOT_MAXIMIZE))    setMaxSze(-1,-1,this);
        if(0==(columns&TF_NOT_MINIMUMSIZE)) setMinSze(-1,-1,this);
        tcTools(this)._idata[IDATA_TC_contentType]=columns&TF_MASK_CONTENTTYPE;
        return this;
    }
    public ChTextField saveInFile(Object fileName) {tcTools(this).saveInFile(fileName); return this;}
    OVERRIDE_PUBLIC void processEvent(java.awt.AWTEvent ev){
                        if(!_painted) return;
        if(ev.getID()==KEY_PRESSED && evtKeyCode(ev)==VK_ENTER && gcp(TEXTFIELD_KOPT_IS_TABLE_EDITOR,this)!=null){/*X See getRndrerTextfield() */
            final javax.swing.JTable t=(javax.swing.JTable)deref(_editedTable);
            t.setValueAt(s(this),t.getEditingRow(),t.getEditingColumn());
            setFocusable(false);
            setFocusable(true);
            return;
        }
        if((ev=(java.awt.AWTEvent)tcTools(this)._tcProcessEvt(ev))!=null) super.processEvent(ev);
    }
    {this.enableEvents(ENABLE_EVT_MASK);}

    OVERRIDE_PUBLIC String getText(){
        IF_MEIN_DEBUG(if(isDisplayable() && !isEDT()) assrt());;
        return super.getText();
    }
    OVERRIDE_PUBLIC java.awt.Dimension getPreferredSize(){
        final java.awt.Dimension ps=_prefSzeThis(this);
        return ps!=null?ps: super.getPreferredSize();
    }
    OVERRIDE_PUBLIC String getToolTipText(java.awt.event.MouseEvent mev){
        final String tt=(String)runCR1(RUN_TXTC_TT,tcTools(this),mev);
        return tt!=null?tt: ballonMsg(mev,super.getToolTipText(mev));
    }
    OVERRIDE_PUBLIC boolean isOpaque(){return!_painting && super.isOpaque();}

    OVERRIDE_PUBLIC void paintComponent(java.awt.Graphics g){
        _painted=true;
        if(getBackground()!=null && isOpaque()){
            g.setColor(getBackground());
            fillRectBig(g,0,0,getWidth(),getHeight());
        }
        _paintHookG=g;
        if(FALSEr!=runCR1(RUN_PAINT_HOOK_BEFORE,tcTools(this),this)){
            _painting=true;
            super.paintComponent(g);
            _painting=false;
        }
        {
            final int ct=tcTools(this)._idata[IDATA_TC_contentType];
            if(ct!=0){
                final String txt=getText();
                int c=0x00b200;
                String s=null;
                if(sze(txt)>0){
                    if(ct==TF_CONTENTTYPE_FILE){
                        final java.io.File d=file(NEWFILE_NO_ERROR,txt);
                        if(d==null||!d.exists()) {s="No such file"; c=0xFF0000;}
                        else if(isDir(d)) {s="Directory"; c=RGBA_MAGENTA;}
                        else s="Exists";
                    }
                }else if((s=s(gcp(GCP_OPT_CLONED_FROM|KEY_IF_EMPTY,this)))!=null){
                    c=RGBA_GRAY;
                }
                if(ct==TF_CONTENTTYPE_PERCENT){
                    c=0;
                    s="%";
                }
                if(s!=null){
                    g.setColor(C(c));
                    g.drawString(s,strgWidth(g,txt)+EM,charA(g)+y(getInsets()));
                }
            }
        }
        _paintHookG=g;
        runCR1(RUN_PAINT_HOOK_AFTER,_tools,this);
    }

    OVERRIDE_PUBLIC String toString(){
        tcTools(this).loadSavedText();
        return toStrgN(getTxt(this));
    }
    final ChUtils[]_tools={null};
    REFLECTION_PUBLIC Object getDndDateien(){return dndV(this);}
    CPP_CODE_HasWRef();
}
