package charite.christo;
import java.awt.*;
import static charite.christo.ChUtils.*;
@*H
 Invoking Strap http://3d-alignment.eu with the option
 PAR_AS_TEXTVIEWER, Strap serves as a fast viewer for (large) WIKI:Plain_text files or binary files or files.

 Non-printable characters are drawn as open rectangles.

 <BR><BR>
 Upon start, a small green window appears and acts as a Drag-And-Drop target for the files to be displayed.
 The user needs to drag the (text-)file with the mouse and drop it there.
 The files will be displayed in read-only text panes.

 Type F1 for help. Advanced features:

 <UL>
 <LI>Support for WIKI:ANSI_colors</LI>
 <LI>Advanced search/highlight. Type Ctrl+F or (German keyboard strg-F).</LI>
 <LI>User definable Web-applications and shell commands that act on text selections. Right click to get the context menu.</LI>
 </UL>

 <U>Maximum file size:</U> For very large files the maximum heap size
 must be increased. About 120% of the file size is required.

 <BR>Use a command line option like -Xmx999M  to increase the
 maximum heap size such as to  999 Megabyte. If started from the Web add a web variable Xmx=999M to the URL.
*@
public final class ChTextView extends ChPanel{
#define _lineSkip LINESKIP_ChTextView
    final int[]_region={0,0};
    private int _mc,_lineNum=MIN_INT,_maxWidth,_posClicked=-1,_regionFrom,_regionTo,_gpsMC;
    private static Object[]_att;
    private Object _refText;
    private BA _ba;
    private TextMatches _region1;
    private long _baMc;
    void setSelection(int f,int t){
        _region[RANGE_FROM]=f;
        _region[RANGE_TO]=t;
#define regionColor argbToColor((0xFFFFFF&rgba(getBackground(),0))==0?0x66aaAAFF:0x300000ff)
        if (_region1==null) tcAddHighlight(_region1=new TextMatches(HIGHLIGHT_NOT_IN_SCROLLBAR|HIGHLIGHT_NEVER_REMOVE,_region,1,regionColor),this);
        _region1.setFromTo(_region,1);
    }
/* ---------------------------------------- */
/* >>> Constructor >>> */
    final ChUtils[]_tools={null};
    public ChTextView(Object csOrFile){
        super();
        _file=derefZ(csOrFile,java.io.File.class);
        if(csOrFile instanceof CharSequence) runCR1(RUN_SET_TEXT,this,csOrFile);
        pcp(SCRLLPN_KOPT_REPAINT_CHILD,"",specifcLstnr(MOMOLI_AUTO_SCROLL,monospc(setBG(0xFFffFF,this))));
        assrtEdtGui(89);
        IF_PUBMED(ChPubmed.vPUBMED_TC.add(wref(this)));;
    }
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> setText >>> */
    private void mayRevalidate(){
        if(gcp(KOPT_ALREADY_PAINTED,this)==null) return;
        final BA ba=ba(true);
        if(_baMc!=(_baMc=uintToLong(ba.mc())|(uintToLong(_mc)<<24)|((long)sze(ba)<<40))){
            awtc(AWTC_QUEUE_REVALIDATE|AWTC_AFTER_200,this);
            _maxWidth=0;
        }
    }
    public synchronized BA ba(boolean create){
        if(_ba!=null) return _ba;
        BA ba=(BA)deref(_refText);
        if(ba==null && create){
            _refText=newSoftRef(ba=readBytes(_file));
            if(ba!=null) undrlneRefs(ULREFS_BG,this);
            else (ba=_ba=new BA(0))._tv=this;
        }
        return ba;
    }
    private java.io.File _file;
    public java.io.File getFile(){return _file;}
    public void setFile(java.io.File f) {_file=f; _ba=null; _refText=null; awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_200,this);}
/* <<< setText  <<< */
/* ---------------------------------------- */
/* >>> _lineNum  >>> */
    int offsetX(){return _lineNum==MIN_INT?0: 7*charW(this);}
    public ChTextView setLineNumberStart(int b) {_lineNum=b; repaint(); return this;}
/* <<< _lineNum <<< */
/* ---------------------------------------- */
/* >>> Size >>> */
    OVERRIDE_PUBLIC Dimension getPreferredSize(){
        final Dimension ps=_prefSzeThis(this);
        if(ps!=null) return ps;
        final BA text=ba(true);
        if(sze(text)==0) return dim(1,1);
        final java.io.File f=_file;
        final int lines,fixedWidth=gcpi(CHTEXTVIEW_KEY_FOLD,this);
        if(fixedWidth>0) lines=(sze(text)-1)/(_maxWidth=fixedWidth)+1;
        else{
            final int[]ends=text.eol();
            lines=ends.length;
            if(_gpsMC!=(_gpsMC=text.mc()+(f!=null?(int)(f.lastModified()/1024):0)) || _maxWidth==0){
                for(int begin=0,i=0;i<lines;i++){
                    final int e=ends[i];
                    if(e-begin>_maxWidth) _maxWidth=e-begin;
                    begin=e;
                }
            }
        }
        return dim(maxi(1,charW(this)*_maxWidth+offsetX()),maxi(1,getFixedRowHeight(this)*lines));
    }
/* <<< Size  <<< */
/* ---------------------------------------- */
/* >>> paint >>> */
    OVERRIDE_PUBLIC void paintComponent(Graphics g){
        mayRevalidate();
        final Color background,forground;
        {
            final Color bg=getBackground(),fg=getForeground();
            forground=fg!=null?fg:C(0);
            background=!isOpaque()?null:bg!=null?bg:C(0xFFffFF);
        }
        if(_att==null) _att=ansiStyleReset(null); else ansiStyleReset(_att);
        final int[]clip=clipBnds(g,getWidth(),getHeight());
        if(isOpaque()) g.clearRect(x(clip),y(clip),x2(clip)-x(clip),y2(clip)-y(clip));
        _paintHookG=g;runCR1(RUN_PAINT_HOOK_BEFORE,tcTools(this),this);
         BA text=ba(true);
        final long[]ee=text.getAnsiStyles();
        final int eeL=ee==null?0:(int)ee[0],eol[]=text.eol(),fixedWidth=gcpi(CHTEXTVIEW_KEY_FOLD,this);
        final Font font0=mkFont(g.getFont().getSize(),0),fontBf=mkFont(font0.getSize(),Font_BOLD);
        final int charH=charH(font0),charW=charW(font0),firstRow=maxi(0,y(clip)/(charH+_lineSkip)),lastRow=(y2(clip)-1)/(charH+_lineSkip)+1;
        int escI=0,escPos=0;
        if(fixedWidth==0 && firstRow>0 && firstRow-1<eol.length){/*X  Search ANSI_RESET */
            final int pos0=eol[firstRow-1]+1;
            FORi(ANSIESC_START_IDX,eeL){
                final long e=ee[ANSIESC_START_IDX+i];
                final int pos=(int)(e&ANSIESC_MASK_POS);
                if(pos>pos0) break;
                if(0==(e&(255L<<ANSIESC_SHIFT_CODE))){
                    escPos=pos;
                    escI=i;
                }
            }
        }
        Color fg=null,bg=null;
        Font font=font0;
        final byte[]T=text.bytes();
        final int charA=charA(font0),
            xOff=offsetX(),
            maxRow=fixedWidth>0?(text.end()-1)/fixedWidth+1: mini(eol.length,lastRow+1),
            firstCol=maxi(0,(x(clip)-xOff)/charW),
            lastCol=(x2(clip)-1)/charW+1;
        FORr(firstRow,maxRow){
            final int
                y=r*(charH+_lineSkip),
                begin=fixedWidth>0?fixedWidth*r:r==0?text.begin():eol[r-1]+1,
                to=fixedWidth>0?mini(text.end(),begin+fixedWidth):mini(eol[r],begin+lastCol);
            for(int x=firstCol*charW+xOff,i=mini(to,begin+firstCol);i<to;i++,x+=charW){
                if(i>=escPos){
                    boolean changed=false;
                    escPos=MAX_INT;
                    for(;escI<eeL;escI++){
                        final long esc=ee[ANSIESC_START_IDX+escI];
                        if((esc&ANSIESC_MASK_POS)>i){
                            escPos=(int)(esc&ANSIESC_MASK_POS);
                            break;
                        }
                        ansiColorSet(esc,_att);
                        changed=true;
                    }
                    if(changed){
                        bg=(Color)_att[ANSI_ATTR_BG];
                        fg=(Color)_att[ANSI_ATTR_FG];
                    }
                }
                if((bg!=background || background==null) && bg!=null){
                    g.setColor(bg);
                    fillRectBig(g,x,y,charW,charH);
                }
                g.setColor(fg!=null?fg:forground);
                final int style=((int[])_att[ANSI_ATTR_STYLE])[0];
                final Font fontCurrent=(style&ANSIESC_BOLD)!=0?fontBf:font0;
                if(font!=fontCurrent) g.setFont(font=fontCurrent);
                g.drawString(T[i]=='\t'?"\u00bb":arry(SARRAYeq_STRGSLEN1)[127&T[i]],x,y+charA);
                if((style&ANSIESC_UNDERLINE)!=0) g.drawLine(x,y+charH,x+charW,y+charH);
            }
            if(_lineNum!=MIN_INT){
                setColorRGB(0xFF,g);
                final String s=baClr(35).a(r+_lineNum).toString();
                g.drawString(s,xOff-charW*(s.length()+1),y+charA);
            }
        }
        _paintHookG=g;runCR1(RUN_PAINT_HOOK_AFTER,_tools,this);
    }
/* <<< paint <<< */
/* ---------------------------------------- */
/* >>> Event >>> */
    OVERRIDE_PUBLIC void processEvent(AWTEvent ev){
        BA text=ba(true);
        if(text==null || (ev=(AWTEvent)tcTools(this)._tcProcessEvt(ev))==null) return;
        final int modi=evtModi(ev);
        {
            final int pos=tcViewToModel(new Point(x(ev),y(ev)),this);
            if(ev.getID()==MOUSE_DRAGGED && 0==(modi&(CTRL_MASK|ALT_MASK))){
                if(_posClicked>=0) _regionFrom=_posClicked;
                _regionTo=pos;
                repaint();
            }
            if(ev.getID()==MOUSE_PRESSED){
                if(SHIFT_MASK==(modi&(SHIFT_MASK|ALT_MASK)) && gcp(KOPT_NO_DRAG_PARWINDOW,this)!=null){
                    if(_posClicked>=0) _regionFrom=_posClicked;
                    _regionTo=pos;
                    repaint();
                }else{
                    awtc(AWTC_REQUEST_FOCUS,this);
                    if(0==(modi&SHIFT_MASK)||gcp(KOPT_NO_DRAG_PARWINDOW,this)==null) _posClicked=pos;
                }
            }
/* if(evtKeyCode(ev)==VK_RIGHT){ */
/*     if(_regionFrom>_regionTo) _regionFrom++; else _regionTo++; */
/*     repaint(); */
/* } */
        }
        setSelection(maxi(mini(_regionFrom,_regionTo),text.begin()),mini(maxi(_regionFrom,_regionTo),text.end()));
        if((ev.getID()==MOUSE_RELEASED||0!=(modi&CTRL_MASK) && evtKeyCode(ev)==VK_C) && _region[RANGE_TO]>_region[RANGE_FROM]) toClpbd(s(text.bytes(),_region[RANGE_FROM],_region[RANGE_TO]));
        if(ev.getID()==KEY_PRESSED && 0!=(modi&CTRL_MASK)){
            switch(evtKeyCode(ev)){
            case VK_L:setLineNumberStart(_lineNum==MIN_INT?0:MIN_INT);break;
            case VK_A:_regionFrom=0; _regionTo=text.end(); repaint();break;
            }
        }
        super.processEvent(ev);
        mayRevalidate();
    }

/* OVERRIDE_PUBLIC void aaaaaaaaaaaaaaaaaprocessEvent(AWTEvent ev){ */
/*     final BA text=ba(true); */
/*     if(text==null) return; */
/*     final Object newEv=tcTools(this)._tcProcessEvt(ev); */
/*     if(newEv!=null){ */
/*         final int evId=ev.getID(),modi=evtModi(ev); */
/*         { */
/*             final int pos=tcViewToModel(new Point(x(ev),y(ev)),this); */
/*             if(0==(modi&(CTRL_MASK|ALT_MASK))&&evId==MOUSE_DRAGGED || evId==MOUSE_PRESSED && SHIFT_MASK==(modi&(SHIFT_MASK|ALT_MASK))){ */
/*                 if(_posClicked>=0) _regionFrom=_posClicked; */
/*                 _regionTo=pos; */
/*                 repaint(); */
/*             } */
/*             if(evId==MOUSE_PRESSED){ */
/*                 requestFocus(); */
/*                 if(0==(modi&SHIFT_MASK)) _posClicked=pos; */
/*             } */
/*         } */
/*         setSelection(maxi(mini(_regionFrom,_regionTo),text.begin()),mini(maxi(_regionFrom,_regionTo),text.end())); */
/*         if((evId==MOUSE_RELEASED||0!=(modi&CTRL_MASK) && evtKeyCode(ev)==VK_C) && _region[RANGE_TO]>_region[RANGE_FROM]) toClpbd(text.bytes(),_region[RANGE_FROM],_region[RANGE_TO]); */
/*         if(evId==KEY_PRESSED && 0!=(modi&CTRL_MASK)){ */
/*             switch(evtKeyCode(ev)){ */
/*             case VK_L:setLineNumberStart(_lineNum==MIN_INT?0:MIN_INT);break; */
/*             case VK_A:_regionFrom=0; _regionTo=text.end(); repaint();break; */
/*             } */
/*         } */
/*         super.processEvent((AWTEvent)newEv); */
/*         mayRevalidate(); */
/*     } */
/* } */
    {this.enableEvents(ENABLE_EVT_MASK);}
/* <<< Event <<< */
/* ---------------------------------------- */
/* >>> TT >>> */
    OVERRIDE_PUBLIC String getToolTipText(java.awt.event.MouseEvent mev){
        final String tt=(String)runCR1(RUN_TXTC_TT,tcTools(this),mev);
        return tt!=null?tt:ballonMsg(mev,super.getToolTipText(mev));
    }
    REFLECTION_PUBLIC Object getDndDateien(){return dndV(this);}
/* <<< TT <<< */
/* ---------------------------------------- */
/* >>> Thread >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARG(RUN_SET_TEXT,Object,cs){
                BA ba=_ba;

                if(cs instanceof BA || ba==null) (ba=_ba=toBA(cs))._tv=this;
                else clr(ba).a(cs);
                _mc++;
                mayRevalidate();
               repaint();

                RETURN this;
            }
            CASE_ARG(RUN_APPEND,Object,o){
                if(o!=null){
                    final BA ba=ba(true);
                    if(o!=ba && ba!=null){
                        ba.aFilter(FILTER_BACKSPACE,o);
                        awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_200,awtc(AWTC_IF_VISIBLE,this));
                    }
                }
                RETURN TRUEr;
            }
            CASE_ARG(RUN_SHOW_IN_FRAME,TYPE_FRAMEOPT,opt) RETURN(ChFrame.frame(CLOSE_CtrlW|CLOSE_DISPOSE|FRAME_SCROLLPANE,"",this).shw(opt));
        }
        return super.run(id,arg);
    }
#if CPP_DEACTIVATED_MAIN
/*      java charite.christo.test.ChTextViewTest    */
    public final class ChTextViewTest implements Runnable{
        static BA _ba;
        public static void main(String[]argv)throws Exception{
            if(mainInEDT(ChTextViewTest.class,argv)){
                if(true){
                    final ChExec ex=new ChExec(EXEC_STDOUT).addCmdV("/bin/ls","-l","/home/c/m1");
                    new ChFrame("ChTextViewTest").ad(scrllpn(0,new ChTextView(ex.out(true,EXEC_FIELD_OUT)))).shw();
                    startThrd(ex);
                    return;
                }
                final ChTextView tv=new ChTextView(_ba=new BA(9999));
                new ChFrame("ChTextViewTest").ad(scrllpn(0,tv)).shw();
                startThrd(new ChTextViewTest());
            }
        }
        public void run(){
            FORi(0,100)_ba.a("Zeile ").a(i,5).aln();
        }
    }
#endif //CPP_DEACTIVATED_MAIN
}
#undef _lineSkip
