/* (shell-command-to-string  "scp ChUtils_InsecureInc.java  $STRAP_DIR_B/Insecure.java") */

/* Unless deactivated,all file modifications in Strap are restricted to the working directory (_insecure_allowedPath) and its subdirectories. */
/* There are only a few exceptions for files outside the working directory defined in insecure_canModify(). */
/* This mechanism prevents unintended modification or deletion of user files by errors in the program. */
/* For that purpose,all file modifications are checked in this program part. */

private final static String INSECURE_ERR="\u001B[45mError\u001B[0m in Insecure ";
private static String _insecure_pathLC(File f){
    if(f==null) return null;
    final String p=f.getAbsolutePath();
    return IF_WINDOWS(isWin()?p.toLowerCase():)p;
}
/* >>> Is file modification allowed?>>> */
public static String insecure_msgNotModify(Object f){
    return
        "SECURITY ERROR"+
        "\n  File: "+f+
        IF_ANY_WORKING_DIR("\n  Working dir="+_insecure_allowedPath+)
        "\nThe Strap security guard prevents files from being modified\nunless within the project directory or  file paths contains the string \"StrapAlign\".\n\nThis can be deactivated with the command line option "+PAR_allowFileModification+".\n";
}
private static boolean insecure_canModifyThrowEx(File f){
    if(f!=null){
        if(insecure_canModify(f)) return true;
        final String path=_insecure_pathLC(f),txt=insecure_msgNotModify(f);
        putln(INSECURE_ERR);
        putln(txt);
        if(INSECURE_VIOLATIONS.get(path)==null){
            final Throwable ex=new IllegalAccessException(txt);
            final ByteArrayOutputStream os=new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(os));
            INSECURE_VIOLATIONS.put(path,os.toString());
            putln(ex);
        }
    }
    return false;
}
public static boolean insecure_canModify(File f){
    if(f==null) return false;
    if(!_insecure_Enabled) return true;
    final String p=_insecure_pathLC(f);
    return
        _insecure_allowedPath==null||
        IF_ANY_WORKING_DIR((p.startsWith(_insecure_allowedPath)||p.length()+1==_insecure_allowedPath.length()&&_insecure_allowedPath.startsWith(p))||)
        p.startsWith("/mnt/tmpfs/")||
        p.endsWith(".jnlp")&&p.indexOf("strap")>=0||
        //IF_WINDOWS(p.indexOf("\\texmf.cnf")>0||)
        p.indexOf(IF_WINDOWS(isWin()?"strapalign":)"StrapAlign")>=0;

}
#if CPP_WITH_ANY_WORKING_DIR
private static String _insecure_allowedPath;
public static void insecure_securitySetAllowedPath(File dir){
    if(dir==null || (dir.exists()&&!dir.isDirectory())){
        putln(INSECURE_ERR);
        putln(dir);
        return;
    }
    final String ap=_insecure_pathLC(dir);
    ROFi0(ap.length()){
        final char c=ap.charAt(i);
        if(IS_UPPER_OR_LOWER(c)||IS_DIGIT(c)){
            _insecure_allowedPath=addSfx(s(File.separatorChar),ap);//ap.charAt(ap.length()-1)==File.separatorChar?ap:ap+File.separatorChar;
            return;
        }
    }
    putln(INSECURE_ERR);
    putln("No letters/digits in path=");
    putln(dir);
    return;
}
#endif //CPP_WITH_ANY_WORKING_DIR
private static boolean _insecure_Enabled;
public static void insecure_setFileModificationControl(boolean b) {_insecure_Enabled=b;}

/* <<< Is file modification allowed?<<< */
/* ---------------------------------------- */
/* >>> Directory >>> */

private static void insecure_mkdirs(File f,boolean printErr){
    if(f==null) return;
    if(insecure_canModifyThrowEx(f)) f.mkdirs();
    else if(printErr){
        putln(INSECURE_ERR);
        putln("File.mkdirs failed f=");
        putln(f);
    }
}
#if CPP_WITH_WINDOWS
private static void insecure_touchParentDir(File f){
    if(isWin()&&f!=null){
        final String path=f.getParent();
        final Map m=mapNoClr(258);
        File dir=(File)m.get(path);
        if(dir==null) m.put(path,dir=new File(path));
        dir.setLastModified(System.currentTimeMillis());
    }
}
#else
#define insecure_touchParentDir(f)
#endif //CPP_WITH_WINDOWS
/* <<< Directory <<< */
/* ---------------------------------------- */
/* >>> File modification >>> */
#if CPP_DEACTIVATED
private static boolean insecure_renameToIgnoreSecurity(File src,File dest){
    if(src!=null&&dest!=null&&src.renameTo(dest)){
        insecure_touchParentDir(src);
        insecure_touchParentDir(dest);
        return true;
    }
    return false;
}
#endif //CPP_DEACTIVATED
private static boolean insecure_renameFile(File src,File dest){
    if(insecure_canModifyThrowEx(src)&&insecure_canModifyThrowEx(dest)&&src.renameTo(dest)){
        insecure_touchParentDir(src);
        insecure_touchParentDir(dest);
        return true;
    }
    return false;
}
private static boolean insecure_delFile(File f){
    if(insecure_canModifyThrowEx(f)&&f.delete()){
        insecure_touchParentDir(f);
        return true;
    }
    return false;
}
private static OutputStream insecure_outStream(File f,boolean append)throws IOException{
    if(f==null) return null;
    if(insecure_canModifyThrowEx(f)){
        insecure_touchParentDir(f);
        return new FileOutputStream(f,append);
    }else{
        final String msg=INSECURE_ERR+f+"new FileOutputStream"+RED_FAILED;
        putln(msg);
        throw new IOException(msg);
    }
}
private static RandomAccessFile insecure_randomAccessFile(File f,String mode)throws IOException{
    if(f==null) return null;
    if(mode.indexOf("w")<0 || insecure_canModifyThrowEx(f)) return new RandomAccessFile(f,mode);
    else{
        final String msg=INSECURE_ERR+f+"new RandomAccessFile"+RED_FAILED;
        putln(msg);
        throw new IOException(msg);
    }
}
/* <<< File modification <<< */
/* ---------------------------------------- */
