// ~/Backup/strapSrc/strapSrc/src/gui/charite/christo/ChUtils_webProxy_Inc.java
// ~/strapSrc/src/noGui/charite/christo/cpp_java_rsc.h
// http://de.wikipedia.org/wiki/Web_Proxy_Autodiscovery_Protocol
// ChUtils_Cases_Inc.java
#define TEST_INTERNET_NUM_URLS 7
#define urlToTestInternet(i) iConst(SARRAY_TEST_INTERNET_URLS,i)
@*SARRAYeq_PROBE_PROXY_TITLE
 Direct-Connection=PROBE_PROXY_DIRECT proxy/proxy.pac=PROBE_PROXY_PAC1 wpad/wpad.dat=PROBE_PROXY_PAC2 Variable http_proxy=PROBE_PROXY_ENV_VARIABLE  CFG output=PROBE_PROXY_PROXYCFGOUTPUT Calling Script=PROBE_PROXY_CALLING_SCRIPT
 Last-successfull=PROBE_PROXY_LAST System-wide=PROBE_PROXY_SYSTEM  Default configuration=
*@
@*SARRAY_TEST_INTERNET_URLS
www.microsoft.com|github.com|www.wikipedia.org|twitter.com|www.ebay.com|www.instagram.com|www.office.com
*@
@*RSC_PROXYEXEC_LINUX_GSETTINGS_HOST
 gsettings get org.gnome.system.proxy.http host
*@
@*RSC_PROXYEXEC_LINUX_GSETTINGS_PORT
 gsettings get org.gnome.system.proxy.http port
*@
#if CPP_WITH_WINDOWS
@*RSC_PROXYEXEC_WIN_REG_ProxyServer
 REG#QUERY#HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings#/v#ProxyServer
*@
@*RSC_PROXYEXEC_WIN_REG_AutoConfigURL
 REG#QUERY#HKCU\Software\Microsoft\Windows\CurrentVersion\Internet Settings#/v#AutoConfigURL
*@
@*RSC_PROXYEXEC_WIN_netsh_diag
 netsh#diag#show#ieproxy
*@
@*RSC_PROXYEXEC_WIN_netsh_winhttp
 netsh#winhttp#show#proxy
*@
#endif //CPP_WITH_WINDOWS
#if CPP_WITH_MAC
@*RSC_PROXYEXEC_MAC_SCUTIL
 bash#-c#scutil --proxy|awk '/HTTPEnable/ {enabled=$3;} /HTTPProxy/ {s=$3;} /HTTPPort/ {p=$3;} END {if(enabled=="1") print s":"p;}'
*@
@*RSC_PROXYEXEC_MAC_SYSTEM_PROFILER
 system_profiler#SPNetworkDataType
*@
#endif //CPP_WITH_MAC
private static int _testInternetCountJobs;
//private static String proxyTitle(int m){return addPfx(" Probe web proxy using ",iConst(SARRAYeq_PROBE_PROXY_TITLE,m));}
private static String proxyTitle(int m){return s(new BA(99).aPlrl(m," %N Probe web proxy using ").a(iConst(SARRAYeq_PROBE_PROXY_TITLE,m)));}
private static ChTextView _tvLogProbeProxy;
private static boolean isProbeProxyContinue(){return _internetOK!=CTRUE||prgOptOn(iPAR_DEBUG_PROXY);}
public static void proxyProbeMethod(int m){
    if(!isProbeProxyContinue()) return;
    final BA log=baLog(m);/*X First line because prints title */
    final int urlOffset=timeOn();
    FORu(0,TEST_INTERNET_NUM_URLS){
        if(!prgOptOn(iPAR_DEBUG_PROXY)) sleepMS(u*u*999);
        else{
            if(u==2||!isProbeProxyContinue()) break;
        }
        final int url=(u+urlOffset)%TEST_INTERNET_NUM_URLS;
        if(m==PROBE_PROXY_LAST){
            log.aFile(iFile(F_PROXY_LAST)).aln();
            final BA txt=readBytes(iFile(F_PROXY_LAST));
            if(sze(txt)>0 && isProbeProxyContinue()){
                if(strchr(' ',txt.trim())>0) setProxyPac(PROBE_PROXY_LAST,url,txt);
                else{
                    log.aa(ANSI_FG_BLUE,txt).aln(ANSI_RESET);
                    _proxyTestConf(s(txt),PROBE_PROXY_ALIAS_H_COLON_P,PROBE_PROXY_LAST,url);
                }
            }
        }
        if(m==PROBE_PROXY_SYSTEM){
            if(isWin()){
                _proxyExec(RSC_PROXYEXEC_WIN_REG_ProxyServer,PROBE_PROXY_SYSTEM,url);
                _proxyExec(RSC_PROXYEXEC_WIN_REG_AutoConfigURL,PROBE_PROXY_SYSTEM,url);
                _proxyExec(RSC_PROXYEXEC_WIN_netsh_diag,PROBE_PROXY_SYSTEM,url);
                _proxyExec(RSC_PROXYEXEC_WIN_netsh_winhttp,PROBE_PROXY_SYSTEM,url);
            }else if(isMac()){
                _proxyExec(RSC_PROXYEXEC_MAC_SCUTIL,PROBE_PROXY_SYSTEM,url);
                _proxyExec(RSC_PROXYEXEC_MAC_SYSTEM_PROFILER,PROBE_PROXY_SYSTEM,url);
            }else{
                final String h,p;
                if(sze(h=toStrgTrim(rtExecOutputCached(EXEC_NO_ERROR|EXEC_NO_IOEXCEPTION,' ',toStrgTrim(rsc(RSC_PROXYEXEC_LINUX_GSETTINGS_HOST)),log)))>0&&
                   sze(p=toStrgTrim(rtExecOutputCached(EXEC_NO_ERROR|EXEC_NO_IOEXCEPTION,' ',toStrgTrim(rsc(RSC_PROXYEXEC_LINUX_GSETTINGS_PORT)),log)))>0){
                    _proxyTestConf(h,p,PROBE_PROXY_SYSTEM,url);
                }
            }
        }
        if(m==PROBE_PROXY_PROXYCFGOUTPUT){
            final File f=iFile(F_PRPRTY_iPAR_PROXY_CFG);
            if(sze(f)>0){
                log.aFile(f).aln();
                proxycfgOutput(readBytes(f),PROBE_PROXY_PROXYCFGOUTPUT,url);
            }
        }
        if(m==PROBE_PROXY_DIRECT) _proxyTestConf(PROBE_PROXY_ALIAS_DIRECT,null,PROBE_PROXY_DIRECT,url);
        if(m==PROBE_PROXY_PAC1 || m==PROBE_PROXY_PAC2) setProxyPac(m,-1,iConst(SARRAYeq_PROXY_PAC,m));
        if(m==PROBE_PROXY_ENV_VARIABLE) _proxyTestConf(prprty(ENV_http_proxy),PROBE_PROXY_ALIAS_H_COLON_P,m,url);
        if(m==PROBE_PROXY_CALLING_SCRIPT && prprty(SYS_PROXYHOST_FROM_CALLING_SCRIPT)!=null) _proxyTestConf(prprty(SYS_PROXYHOST_FROM_CALLING_SCRIPT),orS(prprty(SYS_PROXYPORT_FROM_CALLING_SCRIPT),s(8080)),m,url);
    }
}
private static void _proxyExec(int rsc,int m,int url){
    if(isProbeProxyContinue()){
        final String args=toStrgTrim(rsc(rsc));
        final BA log=baLog(m).aRplc('#',' ',args).aln(),out=rtExecOutputCached(EXEC_NO_ERROR|EXEC_NO_IOEXCEPTION|EXEC_ORIG_PATH,'#',args,baLog(m));
        log.aa(ANSI_FG_BLUE,out).aln(ANSI_RESET);
        proxycfgOutput(out,m,url);
    }
}
/* <<< proxyProbeMethod <<< */
/* ---------------------------------------- */
/* >>> Test URL and method >>> */
#define ALIAS_HOST_DO_NOT_CHANGE " "
private static boolean _proxyTestConf(String host,String port,int method,int iURL){
    if(port==PROBE_PROXY_ALIAS_H_COLON_P){
        final String[]ss=hostAndPort(s(host));
        if(ss==null) return false;
        host=ss[0];
        port=ss[1];
    }
    host=rmQuotes('\'',rmQuotes('"',host));
    port=rmQuotes('\'',rmQuotes('"',port));
    if(isProbeProxyContinue()){/*X if(httpResponseCode(urlToTestInternet(iURL))==200){ */
        boolean success=false;
        synchronized(SYNC_MAP){if(!setNoClr(59).add(longObjct(iURL+hashCdL(host,0,MAX_INT)+hashCd(port,0,MAX_INT)))) return false;}
        final String server=urlToTestInternet(iURL);
        final URL url=url("https://"+server+"/");
        String search=null;
        IOException iox=null;
        BA txt=null;
        try{
            final URLConnection c=host==null||host==ALIAS_HOST_DO_NOT_CHANGE?url.openConnection():url.openConnection(host==PROBE_PROXY_ALIAS_DIRECT?Proxy.NO_PROXY:new Proxy(Proxy.Type.HTTP,new InetSocketAddress(host,xatoi(port))));
            if(httpResponseCode(c)==200){

                if((txt=readBytes(c.getInputStream()))!=null && strstr(STR_IC|STR_w,search=wordAt(LETTR_DIGT_US,delPfx("www.",server),0,MAX_INT),txt.replace(0,"//:","xxx").replace(0,"ww.","xxx"))>0){
                    success=true;
                    if(host!=ALIAS_HOST_DO_NOT_CHANGE){
                        if(host!=null){
                            setSysPrpty(iConst(SARRAYeq_SYS,SYS_PROXYHOST),host);
                            setSysPrpty(iConst(SARRAYeq_SYS,SYS_PROXYPORT),port);
                        }
                        setInternetOK(CTRUE,method);
                        if(method!=PROBE_PROXY_LAST&&sze(host)>0) wrte(WRTE_IF_HC,iFile(F_PROXY_LAST),new BA(99).aa(host,':',port));
                    }
                }
            }
        }catch(IOException ex){iox=ex;}
        final BA sb=new BA(99).aa(proxyTitle(method),' ');
        if(success)sb.aa(GREEN_SUCCESS,ANSI_FG_GREEN); else sb.aa(RED_FAILED,ANSI_FG_RED);
        sb.aa(server,' ',host,':',port," text-size=",sze(txt)).and(" mustContain=",search).and(" iox=",iox).an('!',prgOptOn(iPAR_DEBUG_PROXY)?50:0).a(ANSI_RESET);
        (prgOptOn(iPAR_DEBUG_PROXY)?baOut(GREEN_SUCCESS).a(ANSI_GREEN).an('*',40).aln(ANSI_RESET):baLog(method)).aln(sb);
        if(success && prgOptOn(iPAR_DEBUG_PROXY)) ROFi0(TEST_INTERNET_NUM_URLS) if(i!=iURL) _proxyTestConf(ALIAS_HOST_DO_NOT_CHANGE,null,method,i);
        return success;
    }
    return false;
}
/* <<< proxyProbeMethod <<< */
/* ---------------------------------------- */
/* >>> proxycfgOutput >>> */
private static void proxycfgOutput(BA ba,int m,int url){
    if(sze(ba)==0) return;
    final ChTokenizer tok;
    {
        final boolean[]cc=chrClas(SPC_SEMICOLON).clone();
        cc['=']=true;
        tok=new ChTokenizer(cc);
    }
    String port=null,host=null;
    final byte[]T=ba.bytes();
    final int eol[]=ba.eol();
    FORiL(0,eol.length){
        final int b=BOL(iL,eol,ba),e=eol[iL];
        if(strstr(STR_IC,"bypass list",T,b,e)>=0) continue;
#if CPP_WITH_WINDOWS
        if(isWin()){
            final int REG_SZ=strstr(STR_IC|STR_w|STR_AFTER,"REG_SZ",T,b,e);
            if(REG_SZ>=0){
                if(strstr(STR_IC|STR_w,"AutoConfigURL",T,b,e)>=0) setProxyPac(m,url,toStrgTrim(T,REG_SZ,e));
                else _proxycfgTokenize(tok.setText(T,b,e),m,url);
            }else if(strstr(STR_IC,"Proxyserver",T,b,e)>=0 || strstr(STR_IC|STR_w,arry(SARRAY_WINDOWS_REGISTRY_DATA_TYPES),T,b,e)<0){
                _proxycfgTokenize(tok.setText(T,b,e),m,url);
            }
        }
        if(isMac()){/*X system_profiler SPNetworkDataType */
            if(m==PROBE_PROXY_PROXYCFGOUTPUT) _proxycfgTokenize(tok.setText(T,b,e),m,url);
            else{
                final int h=strstr(STR_AFTER," Proxy Port: ",T,b,e),p=strstr(STR_AFTER," Proxy Server: ",T,b,e);
                if(h>0) host=tok.setText(T,h,e).nextAsString();
                if(p>0) port=tok.setText(T,p,e).nextAsString();
                if(h>0||p>0 && sze(port)*sze(host)>0) _proxyTestConf(host,port,m,url);
            }
        }
#endif //CPP_WITH_WINDOWS
    }
}
private static void _proxycfgTokenize(ChTokenizer tok,int m,int url){
    while(tok.nextToken()){
        if(hostAndPort(tok.asString())!=null){
            baLog(m).a(ANSI_FG_GREEN+"Looks like Host-colon-Port: "+ANSI_RESET).aln(tok.asString());
            _proxyTestConf(tok.asString(),PROBE_PROXY_ALIAS_H_COLON_P,m,url);
            return;
        }
    }
}
/* <<< proxycfgOutput <<< */
/* ---------------------------------------- */
/* >>> Result of autodetection >>> */
private static void setInternetOK(int r,int log){
    IF_MEIN_DEBUG(final String[]ss=arry(SARRAY_TEST_INTERNET_URLS);if(TEST_INTERNET_NUM_URLS!=ss.length){baOut(RED_ERROR).aa(TEST_INTERNET_NUM_URLS,'~',ss.length,' ').aln(ss).special(DIE_NOW);});;
    _internetOK=r;
    if(r==CTRUE&&log>=0){
        final BA sb=new BA(99).aa(GREEN_SUCCESS,proxyTitle(log));
        if(prgOptOn(iPAR_LOGNETWORK)) putln(sb);
        baLog(LOG_PROXY).aln(sb);
        baLog(log).aln().aln(proxySelectorTest());
        _logSuccess[log]=CTRUE;
#if CPP_PRG_STRAP
        if(null!=prprty(iPAR_UPDATE_STRAP_JAR)&&iFile(F_THIS_JAR_MAYBE_COPY)!=null){
            final File fBackup=file(iPathExt(F_PREV_VERSION_STRAP_DOT_,dateToStrg(DATE_YYYY_MM_DD_d_HH_mm,iFile(F_THIS_JAR_MAYBE_COPY).lastModified()),FSUFFIX_jar));
            if(sze(fBackup)==0) {cpy(iFile(F_THIS_JAR_MAYBE_COPY),fBackup);baOut("Made a copy this strap version in ").aFile(fBackup).aln();}
            thrdCR(_RUN_newJarInit|THRDCR_START,_main);
        }
#endif //CPP_PRG_STRAP
    }
    if(r!=_internetOkPrev){
        _internetOkPrev=r;
        if(r==CTRUE){
            //baOut(DEBUG_NOW).a(ANSI_FG_GREEN).an('*',80).aln("Internet connection established.").aln(ANSI_RESET);
            if(!prgOptOn(iPAR_LOGNETWORK)){
                if(isPrprty(IS_CLOSE_WARN_PROXY_ON_SUCCESS)) awtc(AWTC_SET_DISABLED,JCC[JC_WARN_NO_INTERNET]);
                else setTxt("Internet connection established.",JCC[JC_WARN_NO_INTERNET_LABEL]);
                setTxt("",JCC[JC_WARN_NO_INTERNET_GOING_TO_AUTOPROBE]);
                // IF_STRAP(_mkUnixInstallers());;

                IF_WINDOWS(if(isWin())new BasicExecutable(BUT_C1(BEXEC_ansicon)));; /*X Simply install */
                new BasicExecutable(isWin()?BUT_C1(BEXEC_nativeTools_windows2):BUT_C1(BEXEC_nativeTools_unix2)); /*X Simply install */
            }
        }else{
            setTxt(addPfx("Autoprobe proxy ",_testInternetCountJobs==0?RED_FAILED:"No internet connection yet."),JCC[JC_WARN_NO_INTERNET_GOING_TO_AUTOPROBE]);
        }
        setBG(_internetOK==CTRUE?0x66FF66:0xFF6666,JCC[JC_WARN_NO_INTERNET]);
    }
}
public static BA setProxyScriptCommandForUrl(int opt,Object url,BA sb){
    final String h;
    final int p;
    {
        final Proxy x=(Proxy)getProxyForUrl(url(orO(url,iUrl(iURL_STRAP_SLASH))));
        final InetSocketAddress a=x!=null && x.type()!=Proxy.Type.DIRECT?(InetSocketAddress)x.address():null;
        if(a==null) return null;
        h=a.getHostName();
        p=a.getPort();
    }
    if(sb==null) sb=new BA(99);
    return
        opt==PROXY4URL_EXPORT_COMMANDS?sb.aa("export http_proxy=",h,':',p,"\nexport https_proxy=",h,':',p).aln():
        opt==PROXY4URL_JAVA_OPTIONS?sb.aa(" -DproxyHost=",h," -DproxyPort=",p):
        sb.aa(h,':',p);
}
private static Proxy getProxyForUrl(URL url){
    final ProxySelector ps=ProxySelector.getDefault();
    URI uri=null;
    if(ps!=null && url!=null) try{uri=new URI(s(url));}catch(Exception ex){errorEx(ex,"proxyForUrl",url);}
    if(uri!=null){
        final List v=ps.select(uri);
        FORi(0,sze(v)){
            final Proxy p=(Proxy)iThEl(i,v);
            if(p!=null && p.type()!=Proxy.Type.DIRECT) return p;
        }
    }
    return null;
}
/* <<< Result of autodetection <<< */
/* ---------------------------------------- */
/* >>> GUI  >>> */
#define _pnlProxy _X[39]
public static Object pnlProxyInfo(boolean show){
    if(_pnlProxy==null){
        final Object
            ta=new ChTextView(""),
            security=pnl(VBHB,buttn(TOG_NASK_DOWNLOAD),buttn(TOG_NASK_UPLOAD)),
            proxy=pnl(VBHB,
                      !isPrprty(IS_WEBSTARTED)&&!isMac()?null:pnl("Set proxy for Java-Web start applications: ",buttn(RSC_HELP_JAVACPL)),
                      " ","Here, the Web-Proxy setting cannot be changed.<br>They can be validated for different web addresses.<br>Click the web addresses to test web access.",
                      ta,
                      pnl(HBL,"The test URLs can be modified ",buttn(CUSTOM_testProxySelector)))
            IF_EDTFTP(UNLESS_ALWAYS_EDTFTP(ftp=pnl(VBHB,"The library edtFTPj may work for FTP-addresses where Java's built-in methods fail.",buttn(TOG_EDTFTP))));;
        _pnlProxy=pnl(VBHB,
                      pnl(HBL,"<H2>Internet settings</H2>","#",buttn(BUTS_MAN_PAGE_PROXY).t(null)),
                      pnl("If Strap fails to access the internet, then check the web proxy ",buttn(BUT_LOG_PROXY),newButtnViewLog(LOG_PROXY).i(IC_WWW_SETTINGS)),
                      " ",pnlTogglOpts(TOGGL_PNL_WebProxy|TOGGL_PNL_OPT_PACK,proxy),proxy,
                      IF_EDTFTP(UNLESS_ALWAYS_EDTFTP(pnlTogglOpts(TOGGL_PNL_Ftp|TOGGL_PNL_OPT_PACK,ftp),ftp))
                      " ",pnlTogglOpts(TOGGL_PNL_Security|TOGGL_PNL_OPT_PACK,security),security);
        pcp(_KEY_TA,ta,_pnlProxy);
    }
    undrlneRefs(0,setTxt(proxySelectorTest(),gcp(_KEY_TA,_pnlProxy)));
    if(show) ChFrame.frame(FRAME_AT_CLICK|FRAME_NO_SCROLLPANE,"Internet settings",_pnlProxy).shw(FRAME_PACK);
    return _pnlProxy;
}
private static BA proxySelectorTest(){
    final BA sb=new BA(999).a("ProxySelector=").aln(clazz(ProxySelector.getDefault()));
    for(String u:custSettings(CUSTOM_testProxySelector)){
        sb.aa(u," ==> ");
        if(null==setProxyScriptCommandForUrl(0,u,sb)) sb.a("None");
        sb.aln();
    }
    if(strstr(0,sb,baLog(LOG_PROXY))<0) baLog(LOG_PROXY).aln().aln(sb);
    return sb;
}
/* ---------------------------------------- */
/* >>> Utils  >>> */
private static String[]hostAndPort(String s){
    if(null==(s=delPfx("http://",delPfx("https://",s)))) return null;
    final int colon=s.indexOf(':');
    return colon>1&&colon+1<sze(s) && nxt(0,chrClas(-DIGT),s,colon+1,MAX_INT)<0?new String[]{s.substring(0,colon),s.substring(colon+1)}:null;
}
/* <<< Utils <<< */
