/*   Utilities for TextComponents   @author Christoph Gille*/
#define FLAG(a) 0!=(_chOpt&a)
#define NOT_FLAG(a) 0==(_chOpt&a)
#define _tcZoom ((float[])_data[DATA_TC_zoom])[0]
#define _cmplOpts _idata[IDATA_TC_complOptions]
#define _complNxtIdx _data[DATA_TC_complNxtIdx]
#define _complDelimR _data[DATA_TC_complDelimR]
#define _complDelimL _data[DATA_TC_complDelimL]
#define _vComplOffered _data[DATA_TC_vComplOffered]
#define _complDirListing _data[DATA_TC_complDirListing]

#define _isRunFile(f) nam(iFile(F_JAVACTRL_EXE)).equals(nam(f))
/* ---------------------------------------- */
/* >>> Instance >>> */
public static ChUtils tcTools(Object o){
    if((o=deref(o))==null) return null;
    final Class c=o.getClass();
    if(c==ChUtils.class && ((ChUtils)o)._id==INST_TEXTCOMPONENT) return(ChUtils)o;
    final ChUtils[]tt=
        c==ChTextField.class?((ChTextField)o)._tools:
        c==ChJTextPane.class?((ChJTextPane)o)._tools:
        c==ChTextArea.class?((ChTextArea)o)._tools:
        c==ChTextView.class?((ChTextView)o)._tools:
        null;
    if(tt==null) return null;
    if(tt[0]==null) tt[0]=new ChUtils(INST_TEXTCOMPONENT,0).tcInit(o);
    return tt[0];
}
ChUtils tcInit(Object jc){
    _data[DATA_TC_ref]=new WeakReference(jc);
    if(jc instanceof JTextComponent){
        addLi(this,LSTNR_DOC,tcDocument());
        ((JTextComponent)jc).setSelectionColor(argbToColor(0x550000FF));
        ((JTextComponent)jc).setHighlighter(new DefaultHighlighter(){
                OVERRIDE_PUBLIC void paintLayeredHighlights(Graphics g,int p0,int p1,Shape clip,JTextComponent editor,View view){
                    _tcPaintHighlights(p0,p1,false,g,clip instanceof Rectangle?(Rectangle)clip:null);
                    super.paintLayeredHighlights(g,p0,p1,clip,editor,view);
                }
            });
    }
    if(!(jc instanceof ChTextField)) periodicallyPreventGC(jc);
    // FIXME
    specifcLstnr(WLI_SCROLL,jc);
    // addLi(i,LSTNR_MOMO|LSTNR_MO|LSTNR_KEY,jc);/*X  ????*/
    _idata[IDATA_TC_mouseTextPos]=-99999;
    _chOpt=TC_FLAG_evEnabled|TC_FLAG_hlAuto;
    Arrays.fill((Object[])(_data[DATA_TC_TextMatches]=new TextMatches[TC_TEXTMATCHES_ZZZ][]),new TextMatches[0]);
    _data[DATA_TC_zoom]=new float[]{1};
    _data[DATA_TC_rectangle]=new Rectangle();
    return this;
}
public Component jc(){return awtc(0,_data[DATA_TC_ref]);}
private Document tcDocument(){
    final Object jc=deref(_data[DATA_TC_ref]);
    return jc instanceof JTextComponent?((JTextComponent)jc).getDocument():null;
}
/* <<< Instance <<< */
/* ---------------------------------------- */
/* >>> Undo/Redo >>> */
OVERRIDE_PUBLIC void undoableEditHappened(UndoableEditEvent e){
    UndoManager m=(UndoManager)deref(_data[DATA_TC_undoM]);
    if(m==null) {
        m=new UndoManager();
        _data[DATA_TC_undoM]=FLAG(TC_FLAG_undoSoft)?newSoftRef(m):m;
    }
    m.addEdit(e.getEdit());
}
public ChUtils enableUndo(boolean soft){
    if(soft) _chOpt|=TC_FLAG_undoSoft; else _chOpt&=~TC_FLAG_undoSoft;
    if(tcDocument()!=null) tcDocument().addUndoableEditListener(this);
    return this;
}
/* <<< Undo/Redo <<< */
/* ---------------------------------------- */
/* >>> Tab-Completion >>> */
/* private Object _vComplFirst; */
#define _vComplFirst null
public ChUtils enableWordCompletion(int opt,Object v,boolean[]lDelim,boolean[]rDelim){
    _cmplOpts=opt;
    if(v==null || !(jc() instanceof JTextComponent)){
        _data[DATA_TC_vComplLast]=null;
        return this;
    }
    if(null==(_data[DATA_TC_complFileFilter]=derefZ(v,FileFilter.class))){
        _data[DATA_TC_vComplLast]=_data[DATA_TC_vComplLast]==null?v: new Object[]{_data[DATA_TC_vComplLast],v};
    }
    _complDelimL=lDelim!=null?lDelim: chrClas(TAB_COMPL_DELIMl);
    _complDelimR=rDelim!=null?rDelim: chrClas(TAB_COMPL_DELIMr);
    if(jc()!=null && (opt&COMPL_TAB)!=0) jc().setFocusTraversalKeys(KeyboardFocusManager_FORWARD_TRAVERSAL_KEYS,Collections.EMPTY_SET);
    return this;
}
private void complClear(){
    clr(_vComplOffered);
    _complDirListing=null;
    clr(_complNxtIdx);
    _tcModi=_idata[IDATA_TC_complCaret]=0;
}
private static Object complObject(Object c){
    if(c instanceof JFileChooser) return c;
    if(null!=tcTools(c)) c=tcTools(c).byteArray();
    else if(c instanceof UniqueList) c=((UniqueList)c).asArray();
    else while(!(c instanceof BA) && c instanceof ChRunnable)  c=runCR(PROVIDE_WORD_COMPLETION_LIST,c);
    if((c instanceof ChRunnable || c instanceof File)){
        final String n=nam(c);
        if(n!=null) return n;
    }
    return c instanceof JTextComponent?getTxt(c): c==COMPL_HYPERREFS?hrefKeysToHighlight(): c;
}
#define strOpt ((opt&COMPL_IC)!=0?STR_IC:0)
private boolean completeRecursive(int opt,Object collection,int recursion){
    if(collection==null) return false;
    final int evEnabled=_chOpt&TC_FLAG_evEnabled;
    _chOpt&=~TC_FLAG_evEnabled;
    try{
        if(_vComplOffered==null) _vComplOffered=new HashSet();
        collection=complObject(collection);
        int[]nxtIdx=(int[])_complNxtIdx;
        if(sze(nxtIdx)<=recursion) _complNxtIdx=nxtIdx=chSze(nxtIdx,recursion+5);
        if(_idata[IDATA_TC_complCaret]>0){
            try{
                tcDocument().remove(_idata[IDATA_TC_complCaret],((JTextComponent)jc()).getCaretPosition()-_idata[IDATA_TC_complCaret]);
            }catch(Exception e){IF_MEIN_DEBUG(stckTrc(131,e);)}
        }
        final BA byteArray=byteArray();
        final byte[]T=byteArray.bytes();
        final int caret=((JTextComponent)jc()).getCaretPosition(),wordStart=nxtBwd(STR_E,(boolean[])_complDelimL,T,caret-1,-1)+1;
        String complWord=null;
        if(collection instanceof BA || collection instanceof byte[]){
            final byte[]colT;
            final int B,E;
            if(collection instanceof BA){
                colT=((BA)collection).bytes();
                E=((BA)collection).end();
                B=((BA)collection).begin();
            }else{B=0; E=(colT=(byte[])collection).length;}
            for(int j=maxi(B,nxtIdx[recursion]);j<E;j++){
                final int iCol=collection==byteArray && j<caret?caret-j-1: j;
                if(wordStart!=iCol && !iThBool(chrAt(iCol,colT),(boolean[])_complDelimL) && (iCol==0||iThBool(chrAt(iCol-1,colT),(boolean[])_complDelimL))&&
                   xstrEquAt(strOpt,colT,iCol,iCol+caret-wordStart,T,wordStart,E)){
                    final int wordEnd=nxt(STR_E,(boolean[])_complDelimR,colT,iCol+caret-wordStart,E);
                    if(wordEnd==iCol+caret-wordStart) continue;
                    final String s=byts2strg(colT,iCol,wordEnd);
                    if(((Collection)_vComplOffered).add(s)){
                        complWord=s;
                        nxtIdx[recursion]=j+1;
                        break;
                    }
                }
            }
        }else{
            final int N=collection instanceof String?1:szeVA(collection);
            if(N>0){
                for(int i=nxtIdx[recursion];i<N;i++){
                    Object o=collection instanceof String?collection: complObject(xiThEl(i,collection));
                    if(collection==_complDirListing && 0==(_cmplOpts&COMPL_ALLOW_SPC_IN_FILE)) o=s(strplc(0," ","%20",o));
                    if(instanceOfList(o) || o instanceof BA || o instanceof byte[]|| o instanceof Object[]){
                        if(recursion>16) baOut(RED_WARNING).aa("INST_TEXTCOMPONENT"," word completion: Recursion=",recursion).aln();
                        else if(completeRecursive(opt,o,recursion+1)) return true;
                    }else if(o instanceof CharSequence){
                        if(sze(o)>caret-wordStart && xstrEquAt(strOpt,T,wordStart,caret,o,0,MAX_INT)){
                            if(((Collection)_vComplOffered).add(o.toString())){
                                complWord=o.toString();
                                nxtIdx[recursion]=i+1;
                                break;
                            }
                        }
                    } IF_MEIN_DEBUG(else if(o!=null) baOut(RED_WARNING).aa("INST_TEXTCOMPONENT","unsupported word completion collection ").aln(shrtClasNamOrAlias(o)));;
                }
            }
        }
        if(complWord!=null){
            try{
                if(0==(opt&COMPL_INFER_CASE)){
                    tcDocument().insertString(caret,complWord.substring(caret-wordStart),null);
                }else{
                    tcDocument().remove(wordStart,caret-wordStart);
                    tcDocument().insertString(wordStart,complWord,null);
                }
            }catch(Exception e){stckTrc(132,e);
            }
            _idata[IDATA_TC_complCaret]=caret;
            return true;
        }
        return false;
    } finally{
        _chOpt=(_chOpt&~TC_FLAG_evEnabled)|evEnabled;
    }
}
#undef strOpt

public static String[]bidWordCompletion(int bid){
    if(bid<=0) return null;
    String[]ww=_mapWC[bid];
    if(ww==null){
        final BA sb=new BA(0);
        ROFi0(2){
            final Customize p=bidCustomize(bid,i==0?RSC_MULTI_WORD_COMPLETION: RSC_MULTI_EXAMPLE);
            if(p!=null) sb.joinLns(p.lines());
        }
        _mapWC[bid]=ww=toStrgArray(0,splitTknsT(new ChTokenizer(chrClas(CHARCLASS_TC_COMPL)).setText(sb),new HashSet()));
    }
    return ww;
}
/* <<< Tab-Completion <<<  */
/* ---------------------------------------- */
/* >>> Word under Mouse >>> */
private void _tcSetMousePos(int pos){
    _idata[IDATA_TC_mouseTextPos]=pos;
    final String lastW=_tcWord;
    final BA ba=byteArray();
    final byte[]T=ba.bytes();
/* --- java class --- */
    if(gcp(TXTC_KOPT_CLASS_AT_CURSOR,jc())!=null){
        final int[]r=tcWordAt(pos,ba,chrClas(CHARCLASS_TC_CLASS_DELIM_L),chrClas(CHARCLASS_TC_CLASS_DELIM_R),_range);
        _tcClass=r==null?null:fullClasNam(FULL_CLASSNAME_UPDATE|FULL_CLASSNAME_HTMLDOC_PACKAGES,ba.newString(r[RANGE_FROM],r[RANGE_TO]));
    }
    final int[]r=tcWordAt(pos,ba,chrClas(CHARCLASS_TC_WORD_L),chrClas(CHARCLASS_TC_WORD_R),_range);
    if(r!=null){
        final int from=r[RANGE_FROM],to=(iThByte(r[RANGE_TO],T)==')' && strEquAt(0,"WIKI",T,from))?r[RANGE_TO]+1:r[RANGE_TO];
        final boolean semicolonSpace=from>8 && T[from-1]==' ' && T[from-2]==';';
        if(_wordFrom!=from || _wordTo!=to || lastW==null || lastW.indexOf(':')>0 || semicolonSpace){
            final String w=ba.newString(from,to);
            final int colon=w.indexOf(':');
            if(colon<0 && looks(LIKE_MAILADDR,w)) _tcUrl=addPfx("mailto:",_tcWord=w);
            else if(!w.equals(lastW) || colon>0 || semicolonSpace){
                _tcFile=_tcUrl=_tcDBColonId=null;
                if(sze(_tcWord=w)>2){
                    if(looks(LIKE_FILE_COLON_SLASH,T,from)) _tcFile=file(NEWFILE_NO_ERROR,s(T,from,to));
                    else{
                        final int fFrom=T[from]=='['?from+1:from,fTo=tcFileEndsAt(T,fFrom,ba.end());
                        final File f=fTo<0?null: file(NEWFILE_NO_ERROR,ba.newString(fFrom,fTo));
                        _tcFile=f!=null?f:0>nxt(0,chrClas(-FILENM),w)?file(w):null;
                    }
                    String emblDB=null,url=hrefToUrlString(HREF_WEB_LINK|HREF_PLAIN_TEXT|HREF_PROTEIN_FILE,delChrSfx('.',w));
                    _tcID=looks(LIKE_EC,w,colon+1,MAX_INT)?substrg(w,colon+1,nxt(STR_E,chrClas(-DIGT_DOT),w,colon+1,MAX_INT)):
                        w.startsWith("PDB:") || w.startsWith("UNIPROT:") || guessDbFromId(false,w)=="UNIPROT:"?w:
                        url!=null?w:
                        null;
                EMBL_links:
                    if(semicolonSpace){/*X  --- EMBL; U13634; AAB03370.1;  --- */
                        for(int FROM=maxi(0,from-72),semicolon=from-1;--semicolon>FROM;){
                            if(T[semicolon]==';'&&T[semicolon+1]==' '){
                                for(int space=semicolon;--space>FROM;){
                                    if(T[space]==' '){
                                    nextKey:
                                        for(String key:hrefGetDB(HREF_WEB_LINK|HREF_PLAIN_TEXT|HREF_PROTEIN_FILE)[0]){
                                            if(sze(key)!=semicolon-space || lstChar(key)!=':') continue;
                                            ROFi0(semicolon-space-1) if(key.charAt(i)!=T[space+1+i]) continue nextKey;
                                            url=hrefToUrlString(HREF_WEB_LINK|HREF_PLAIN_TEXT|HREF_PROTEIN_FILE,
                                                                emblDB=key+delChrSfx('.',delChrSfx(';',w)));
                                            break EMBL_links;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    _tcUrl=url;
#if CPP_PRG_STRAP
                    {
                        final int middle=emblDB!=null?sze(w)/2: colon;
                        final String ew=orS(emblDB,w);
                        if(middle>=0&&
                           pos-from>middle&&
                           w.indexOf("://")<0&&
                           (hrefToUrlString(HREF_PROTEIN_FILE,ew)!=null||ew.startsWith("PDB:"))) _tcDBColonId=ew;
                    }
#endif //CPP_PRG_STRAP
                }
            }
        }
    }else{
        _tcClear();
    }
}
private static void _tcClear(){
    _tcWord=_tcUrl=_tcDBColonId=_tcID=null;
    _tcFile=null;
    _wordFrom=_wordTo=-99999;
}
/* <<< Word under Mouse <<< */
/* ---------------------------------------- */
/* >>> Word at position >>> */
#if CPP_DEACTIVATED
private static boolean pointInRect(Point p,int x0,int y0,int x1,int y1) {return x(p)>x0 && x(p)<x1 && y(p)>y0 && y(p)<y1;}
private static int[]tcWordAt(Point p,Component tc,boolean[]lDelimiters,boolean[]rDelimiters,int[]range){
    final int iCaret=tcViewToModel(p,tc);
    final ChUtils tools=tcTools(tc);
    if(tools==null) return null;
    tcWordAt(iCaret,tools.byteArray(),lDelimiters,rDelimiters,range);
    final int f=range==null?0:range[RANGE_FROM],t=range==null?0:range[RANGE_TO];
    if(t!=f){
        tcModelToView(f,tc,RECTf);
        tcModelToView(t,tc,RECTt);
        final int rH=RECTf.height,tH=RECTt.height>0?RECTt.height:rH;
        if(rH>0){
            final boolean contains=x(RECTf)<x(RECTt)?
                pointInRect(p,x(RECTf),y(RECTf),x2(RECTt),y(RECTt)+tH-1):
                pointInRect(p,x(RECTf),y(RECTf),99999,y(RECTf)+rH-2)||
                pointInRect(p,0,y(RECTt),x(RECTt),y(RECTt)+tH-2);
            return!contains?null: range;
        }
    }
    return null;
}
private static String tcWordAt(Point p,Component tc,boolean[]lDelimiters,boolean[]rDelimiters){
    final int[]r=tcWordAt(p,tc,lDelimiters,rDelimiters,_range);
    final ChUtils tools=tcTools(tc);
    if(r==null || tools==null) return null;
    final BA ba=tools.byteArray();
    return r[RANGE_FROM]>=0 && r[RANGE_FROM]<r[RANGE_TO] && r[RANGE_TO]<ba.end()?ba.newString(r[RANGE_FROM],r[RANGE_TO]):null;
}
private static String tcWordAt(int iCaret,BA ba,boolean[]lDelimiters,boolean[]rDelimiters){
    final int[]r=tcWordAt(iCaret,ba,lDelimiters,rDelimiters,_range);
    if(r==null) return null;
    final int f=r[RANGE_FROM],t=r[RANGE_TO];
    return f>=0 && f<t && t<ba.end()?ba.newString(f,t):null;
}
#endif //CPP_DEACTIVATED
private static int[]tcWordAt(int iCaret,BA ba,boolean[]lDelimiters,boolean[]rDelimiters,int[]range){
    if(ba==null || iCaret<0) return null;
    final boolean[]
        lD=lDelimiters!=null?lDelimiters: chrClas(SPC_PAROPEN),
        rD=rDelimiters!=null?rDelimiters: chrClas(SPC_PARCLOSE);
    final byte[]bb=ba.bytes();
    final int L=ba.end();
    int l=iCaret,r=iCaret;
    for(;l>0 && l<=L && !(bb[l-1]>=0 && lD[bb[l-1]]);l--){}
    for(;r>=0 && r< L && !(bb[r  ]>=0 && rD[bb[r  ]]);r++){}
    if(strchr('{',bb,l=mini(maxi(0,l),L),r=mini(maxi(0,r),L))>0){
        for(String key:hrefKeysWithBrace()){
            if(strEquAt(0,key,bb,l)){
                if((r=strchr('}',bb,l,L))<0) return null;
                break;
            }
        }
    }
    if(l>=r || r>L || l<0) return null;
    range[RANGE_FROM]=l;
    range[RANGE_TO]=r;
    return range;
}
/* <<< Word at position <<< */
/* ---------------------------------------- */
/* >>> Cursor >>> */
private Cursor tcCursor(){
    if(jc()==null) return null;
    final String w=_tcWord;
    if(w!=null){
        IF_PUBMED(if(pmid(w)>0)return null;else);;
        {
            final Object c=
                (_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NOT_CLICKABLE)!=0?null:
                _tcClass!=null?( 0==(_tcModi&(CTRL_MASK|ALT_MASK))?"Source\nJavadoc": 0!=(_tcModi&SHIFT_MASK)?"Edit": 0!=(_tcModi&CTRL_MASK)?"Source":"Javadoc"):
                fileExsts(_tcFile) && looks(LIKE_FILEPATH,w)?(_isRunFile(_tcFile)?"run": IC_FILE_BROWSER):
                looks(LIKE_MAILADDR,w)?"Mail":
                _tcDBColonId!=null?IF_STRAP("Load")UNLESS_STRAP(null):
                _tcUrl!=null || _tcID!=null || strStarts("Image:",w)? IC_WWW16:
                null;
            Cursor curs=awtcursorFromText(s(c));
            if(curs!=null) return curs;
        }
    }
    return null;
}
/* <<< Cursor <<< */
/* ---------------------------------------- */
/* >>> PMID >>> */
private static int pmid(String w){
    final int pos=strStarts("PMID",w)?4: strStarts("PUBMED",w)?6: -1;
    return pos<0?-1: atoi(w,pos+(chrAt(pos,w)==':'?1:0));
}
/* <<< PMID <<< */
/* ---------------------------------------- */
/* >>> AWTEvent >>> */
Object _tcProcessEvt(Object ev){
    final Object q=evtSrc(ev),jc=jc();
    final int evId=evtId(ev);
    _tcModi=evtModi(ev);
    final boolean isHtml=jc instanceof JTextComponent && tcDocument() instanceof HTMLDocument;
    if(q==jc && q!=null && !evtShouldProcess(ev)) return null;
    if(evtScaleUpDown(ev)!=0){
        final double f=isHtml?1.05: 1.1;
        largerFnt((float)(_tcZoom*=(evtScaleUpDown(ev)<0?1/f:f)),jc);
        _idata[IDATA_TC_MC]++;
        return null;
    }
    if(!(jc instanceof ChTextField) && (evId==MOUSE_PRESSED||evId==FOCUS_GAINED)) runCR1(RUN_SET_TEXTCOMPONENT,_tcDialogFind[evId==MOUSE_PRESSED?1:0],jc);
    if(evId==MOUSE_MOVED) tcSelection(_region,jc);
    if(evId==MOUSE_DRAGGED && (_tcModi&SHIFT_MASK)==0){
        if(NOT_FLAG(TC_FLAG_doingDnd) && (x(ev)<0||y(ev)<0 || x(ev)>EX+wdth(jc) || y(ev)>EX+hght(jc))){
            final Object export=orO(_tcFile,url(_tcUrl));
            if(export!=null){
                if(jc instanceof JTextComponent){
                    ((JTextComponent)jc).setSelectionStart(_region[0]);
                    ((JTextComponent)jc).setSelectionEnd(_region[1]);
                }else if(jc instanceof ChTextView) ((ChTextView)jc).setSelection(_region[0],_region[1]);
                _chOpt|=TC_FLAG_doingDnd;
                clr(dndV(jc)).add(export);
                exportDrg(jc,ev,TransferHandler_COPY);
            }
        }
        if(FLAG(TC_FLAG_doingDnd)) return null;
    }else{
        _chOpt&=~TC_FLAG_doingDnd;
    }
    boolean searchDialog=false;
    if(q==jc && jc!=null){
        final int k=evtKeyCode(ev);
        searchDialog=evId==KEY_PRESSED && (_tcModi&SHIFT_MASK)==0 && (k==VK_F&&evtIsShrtCut(ev) || k==VK_F3&& 0!=(_tcModi&CTRL_MASK)) && null==gcp(KOPT_NO_SEARCH_DIALOG,q);
        if(evId==KEY_PRESSED){
            _chOpt|=TC_FLAG_alreadyTyped;
            if(wndw(WNDW_DO_AOT_EVT,ev)!=null) return null;
            if((k==VK_V || k==VK_X) && evtIsShrtCut(ev)) _tcChanged(0,null);
            if(k==VK_I && evtIsShrtCut(ev) && jc instanceof JTextComponent){
                try{
                    tcDocument().insertString(maxi(0,((JTextComponent)jc).getCaretPosition()),"\t",null);
                }catch(Exception ex){errorEx(ex,"INST_TEXTCOMPONENT","insert tab");}
            }
            if(k==VK_ESCAPE) _tcEscKey=true;
#if CPP_WITH_SPELLCHECK
            if((_tcModi&(SHIFT_MASK|CTRL_MASK))==0 && k==VK_F7 && NOT_FLAG(TC_FLAG_jOrtho) && jc instanceof JTextComponent&&
               (_jOrthoInit || dlgYesNo("Word lists can be added with the program option "+PAR_spellcheckWords+"\"urls or file paths\"<BR>Start spell Check?"))){
                _jOrthoInit=_jOrtho=true;
                final Object po=mkInstance(cloadJavaClassWithJar(BUT_C1(ChJOrtho)));
                runCR1(RUN_ORTHO_ADD,po,ORTHO_COLLECTION);
                runCR1(RUN_ORTHO_GET_TXT_COMPONENT,po,tc);
            }
#endif //CPP_WITH_SPELLCHECK
@*SARRAY_CUSTOM_LINKS_AND_BROWSER
             CUSTOM_webLinks CUSTOM_webBrowser CUSTOM_fileBrowsers
*@
            if((_tcModi&(SHIFT_MASK|CTRL_MASK))==0 && k==VK_F6) customizeAddDialog(intArry(SARRAY_CUSTOM_LINKS_AND_BROWSER));
            if(k==VK_F1){
                if((_tcModi&SHIFT_MASK)==0 || !(jc instanceof JTextComponent)) runCR1(RUN_ADD_DIALOG,_main,io(RSC_HELP_TEXTPANE));
                else wrte(WRTE_EDIT_FILE,iFile(FSUFFIX_NONE),gcps(_KEY_TXTPANE_TEXT_CSS_JS,jc));
                return null;
            }
            if(_data[DATA_TC_undoM]!=null && evtIsShrtCut(ev)){
                final UndoManager um=(UndoManager)deref(_data[DATA_TC_undoM]);
                if(um!=null){
                    try{
                        if(k==VK_Y) um.redo();
                        if(k==VK_Z) if((_tcModi&SHIFT_MASK)!=0) um.redo(); else um.undo();
                    }catch(Exception e){}
                }
            }
            if(((_cmplOpts&COMPL_TAB)!=0 && k==VK_TAB||
                (k==VK_ENTER && CTRL_MASK==(_tcModi&(CTRL_MASK|ALT_MASK|SHIFT_MASK))) && gcp(KOPT_CTRL_ENTER,jc)==null||
                k==VK_SLASH && ALT_MASK==(_tcModi&(CTRL_MASK|ALT_MASK|SHIFT_MASK))) && jc instanceof JTextComponent && evId==KEY_PRESSED){
                final Object cmpl=_data[DATA_TC_vComplLast];
                File currentDir=null;

                {
                    File d=cmpl instanceof File?(File)cmpl:null;
                    if(d==null && (instanceOfList(cmpl) || cmpl instanceof Object[])){
                        ROFi0(sze(cmpl)) if((d=iThElZ(i,cmpl,File.class))!=null) break;
                    }
                    if(fileExsts(d)) currentDir=d;
                    else if(cmpl instanceof JFileChooser){
                        final String t=toStrgTrim(getTxt(jc));
                        currentDir=looks(LIKE_FILEPATH_EVALVAR,t)?null: file(new BA(99).a(runCR(RUN_FCHOOSER_getCurrentDirectory,cmpl)).a('/').aFT(t,0,nxtBwd(0,chrClas(SLASH),t,MAX_INT,0)));
                    }
                }
                final BA ba=byteArray();
                final boolean isPath;
                {
                    final int
                        caret=((JTextComponent)jc).getCaretPosition(),
                        from=0!=(_cmplOpts&COMPL_ALLOW_SPC_IN_FILE) && jc instanceof JTextField?nxt(0,chrClas(-SPC),ba.bytes(),0,ba.end()):nxtBwd(STR_E,chrClas(SPC),ba.bytes(),caret-1,-1)+1;
                    isPath=looks(LIKE_FILEPATH_EVALVAR,ba.bytes(),from);
                    if(_complDirListing==null && (currentDir!=null || isPath)){
                        final int to=nxt(STR_E,chrClas(SPC),ba.bytes(),caret,ba.end()),slash=nxtBwd(STR_E,chrClas(SLASH),ba.bytes(),to,from-1);
                        final File dir=isPath?file(ba.newString(from,slash>=0?slash+1:to)): currentDir;
                        if(isDir(dir)) sortArry(_complDirListing=_data[DATA_TC_complFileFilter]!=null?dir.listFiles((FileFilter)_data[DATA_TC_complFileFilter]): lstDirF(dir),comparator(COMPARE_ALPHABET));
                    }
                }
                final boolean notOnlyDir=(!isPath || sze(_complDirListing)==0) && !((cmpl instanceof File||cmpl instanceof JFileChooser||cmpl==null) && _vComplFirst==null && nxt(0,chrClas(SLASH),ba)>=0);
                if(!(completeRecursive(isWin()?(COMPL_INFER_CASE|COMPL_IC):0,_complDirListing,0)||
                     (notOnlyDir&&
                      completeRecursive(_cmplOpts&COMPL_IC,_vComplFirst,2)||
                      !(cmpl instanceof JFileChooser)&&(completeRecursive(_cmplOpts&COMPL_IC,ba,3)||_vComplFirst!=cmpl&&completeRecursive(_cmplOpts&COMPL_IC,cmpl,4))||
                      completeRecursive(0,arry(SARRAY_ENV_NAMES_FOR_WC),5)))) complClear();
                return null;
            }else if(k!=VK_SPACE) complClear();
            if(0!=(_tcModi&CTRL_MASK)){
                switch(k){
                case VK_P:
                    File fOut;
                    {
                        final BA txt=getHlp(gcp(KEY_BID,jc));
                        fOut=txt!=null?htmldocMain1(txt,s(gcp(KEY_BID,jc)),null): jc instanceof ChTextView?((ChTextView)jc).getFile():null;
                    }
                    if(fOut==null){
                        fOut=iFile(isHtml?FSUFFIX_html:FSUFFIX_txt);
                        if(isHtml){
                            final BA txt=toBA(gcp(_KEY_TXTPANE_TEXT_CSS_JS,jc));
                            if(txt!=null){
                                txt.replace(STRPLC_FILL_SPACES,"<CAPTION><BR>","<CAPTION>");
                                final int pos=gcpi(_KEY_TXTPANE_TEXT_CSS_JS_POS_JS,jc);
                                if(pos>0) txt.insert(pos,rsc(RSC_CSS_WITH_TAG));
                                wrte(fOut,addHtmlTags(htmldocRplcWIKI(htmldocProcess(txt,TXTC_DOCID_TMP,DOCTYPE_HTML))));
                            }
                        }else wrte(fOut,byteArray());
                    }
                    if(sze(fOut)>0){
                        if(isHtml) flushPngAndHtmlInBrowser(0,fOut,null);
                        else editFile(0,fOut);
                    }
                    return null;
                case VK_U:
                    if(awtc(AWTC_UPDATEUI,jc) instanceof ChTextView && ((ChTextView)jc).getFile()!=null) ((ChTextView)jc).setFile(((ChTextView)jc).getFile());
                    undrlneRefs(0,this);
                    return null;
                }
            }
            if(0!=(_tcModi&CTRL_MASK) && k==VK_L || 0==(_tcModi&CTRL_MASK) && k==VK_F10){
                if(jc instanceof ChTextArea) ((ChTextArea)jc).setLineWrap(!((ChTextArea)jc).getLineWrap());
                //else {pcp(KOPT_TRACKS_VIEWPORT_WIDTH,gcp(KOPT_TRACKS_VIEWPORT_WIDTH,jc)!=null?null: "",jc);awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,jc);}
            }
        }
#if CPP_DEACTIVATED
        {
            if(evId==MOUSE_PRESSED && SHIFT_MASK==(_tcModi&(SHIFT_MASK|CTRL_MASK)) && gcp(KOPT_NO_DRAG_PARWINDOW,jc)!=null){
                _data[DATA_TC_mPressEv]=ev;
                return null;
            }
            final Object le=_data[DATA_TC_mPressEv];
            _data[DATA_TC_mPressEv]=null;
            if(evId==MOUSE_RELEASED && (_tcModi&SHIFT_MASK)!=0 && le!=null) return le;
        }
#endif //CPP_DEACTIVATED
        //if (id==RUN_M_mouseMoved) {evLstnr(MOMOLI_DRAG_WITH_ALT).mouseMoved(mev);} !!!!!!!!!!!!!!!!!!!!!!!!!!11

        final boolean isNewCharacter;
        final int iP=x(ev)>=0 && y(ev)>=0?tcViewToModel(setXY(x(ev),y(ev),POINTv),jc): -1;
        if(evId==MOUSE_MOVED || evId==MOUSE_PRESSED || evId==MOUSE_CLICKED){
            tcModelToView(iP+1,jc,RECTf);
            final int pos=RECTf.height==0 || x(RECTf)<x(ev) || y(ev)>y2(RECTf)?-1: iP;
            if(isNewCharacter=_idata[IDATA_TC_mouseTextPos]!=pos) _tcSetMousePos(pos);
        }else isNewCharacter=false;
        final String w=_tcWord;
        if((evId==MOUSE_MOVED || evId==MOUSE_PRESSED || evId==MOUSE_CLICKED) && isNewCharacter && (_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NOT_CLICKABLE)==0 && !_tcEscKey){
            if(w!=null && (_idata[IDATA_TC_underlineRefsOpts]&ULREFS_PMID_DOWNLOAD)!=0 && (_tcModi&SHIFT_MASK)==0 && !(w.equals(_tcMouseMovedWord)&&_tcModi==_idata[IDATA_TC_mMovedModi])){
#if CPP_WITH_PUBMED
                final String d=strchr(':',w)<0 && guessDbFromId(w)=="UNIPROT:"?"UNIPROT:"+w: w;
                if(pmid(d)>0 || d.startsWith("SWISS:") || d.startsWith("UNIPROT") || d.startsWith("ENSG")){
                    final File f=ChPubmed.maybeDownload(d);
                    if(f!=null && _taForAbstract!=null) ChPubmed.showAbstract((_tcModi&ALT_MASK)!=0?PUBMED_SHOWABSTRACT_FULL_TEXT: 0,f,_taForAbstract);
                    if(pmid(d)>0 && d.indexOf('{')<0) ChPubmed.queueForDownload(d,true);
                }
#endif //CPP_WITH_PUBMED
            }
            _tcMouseMovedWord=w;
            _idata[IDATA_TC_mMovedModi]=_tcModi;
        }

        if(evId==MOUSE_CLICKED){
            _data[DATA_TC_textForContextMenu]=w;
            if(!evtIsPopupTrggr(ev)){
                if(0==(_tcModi&(CTRL_MASK|ALT_MASK|SHIFT_MASK))){
                    IF_PUBMED(if(pmid(w)>0) shwPopupMenu(ChPubmed.pubmedPopup(w)); else)
                        shwPopupMenu(javaSrcMenu(fullClasNam(FULL_CLASSNAME_UPDATE,_tcClass)));
                }
            }else{
                if(!(w!=null && shwCtrlPnl(FRAME_AT_CLICK,w,TC_MAP_OBJECTS.get(w)))){
                    if(_data[DATA_TC_contextMenu]==null) _data[DATA_TC_contextMenu]=adToMenu(0,
                                                                                             new Object[]{
                                                                                                 io(MENUHINT_ACTS_ON_SELECTED_TEXTREGION),
                                                                                                     buttn(_BUT_CTXT_W_CPY),
                                                                                                     buttn(_BUT_CTXT_W_WEB),
                                                                                                     "-",
                                                                                                     buttn(_BUT_CTXT_W_HL),
                                                                                                     buttn(_BUT_CTXT_W_RMHL),
                                                                                                     "-",
                                                                                                     buttn(_BUT_CTXT_W_EXEC),
                                                                                                     io(MENUHINT_ACTS_ON_SELECTED_TEXTREGION),
                                                                                                     "-",
                                                                                                     buttn(BUTS_CUSTOMIZE_Web),
                                                                                                     buttn(RSC_HELP_TEXTPANE)},
                                                                                             "Clicked");
                    for(Object c:((JPopupMenu)_data[DATA_TC_contextMenu]).getComponents()) if(gcp(_TXTC_KEY_POPUP,c)!=null) awtc(AWTC_REMOVE_FROM_PARENT,c);
                    for(int i=0,count=0;i<4;i++){
                        Object itm=null;
                        if(i==0){
                            Object r=null;
#if WRITE_CONCATENATED_JAVA||defined KEY_PROVIDE_JPopupMenu
                            r=gcp(KEY_PROVIDE_JPopupMenu,jc);
#endif //WRITE_CONCATENATED_JAVA||defined KEY_PROVIDE_JPopupMenu
                            itm=runCR1(PROVIDE_JPopupMenu,orO(r,_main),ev);
                        }else if(i==1){
                            if(fileExsts(_tcFile)) itm=((ChButton)setTip(s(_tcFile),pcp(_TXTC_KEY_POPUP_FILE,_tcFile,buttn(_BUTS_PROCESS_FILE).i(IC_DIRECTORY)))).mi(null);
                        }else if(i==2){
                            if(_tcClass!=null) itm=ChButton.doView(javaSrcMenu(_tcClass)).i(IC_JAVA).mi(addPfx("Class ",nam(_tcClass)));
                        }else if(i==3){
                            IF_PUBMED(if(pmid>0) itm=ChButton.doView(ChPubmed.pubmedPopup(w)).i(IC_PUBMED).mi("PMID"+pmid));;
                        }else if(count>0){
                            itm=new JSeparator();
                        }
                        for(Object o:oo(itm)){
                            final Component c=!(o instanceof JPopupMenu)?(Component)o: ChButton.doView(o).i(icon(o)).mi(orS(orS(text(o),getTxt(o)),"Special"));
                            if(null!=pcp(_TXTC_KEY_POPUP,"",c)) ((JPopupMenu)_data[DATA_TC_contextMenu]).add(c,count++);
                        }
                    }
                    _tcCurrent=wref(jc);
                    shwPopupMenu(_data[DATA_TC_contextMenu]);
                }
                return null;
            }
        }
        if(evId==MOUSE_CLICKED && !evtIsPopupTrggr(ev)){
            _data[DATA_TC_textForContextMenu]=w;
            if((_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NOT_CLICKABLE)==0){
                final int iPmid=atoi(_tcUrl,strstr(STR_AFTER,TXTC_PDF4PMID,_tcUrl));
                final String urlMouse=iPmid>0?s(strplc(0,".pdf+html",".pdf",delLstCmpnt('&',_tcUrl))): _tcUrl;
                final int db=
                    _tcID==null || strchr(':',w)>0 && iP-_range[RANGE_FROM]>strchr(':',w)?0:
                    strStarts("PDB:",_tcID)?CUSTOM_pdbLinks:
                    _tcID.startsWith("UNIPROT:") || guessDbFromId(false,_tcID)=="UNIPROT:"?CUSTOM_uniprotLinks:
                    looks(LIKE_EC,_tcID)?CUSTOM_ecClassLinks:0;
                if(db!=0 && 0==(_tcModi&(CTRL_MASK|ALT_MASK|SHIFT_MASK))){
                    String id_noDB=delPfx("PDB:",delPfx("UNIPROT:",_tcID));
                    if(strStarts("PDB:",_tcID)) id_noDB=delLstCmpnt(':',delLstCmpnt('_',id_noDB));
                    showWeblinks(db,new BA(0).joinLns(webLinks(id_noDB,custSettings(db))),"B");
                }else if(urlMouse!=null){
                    //   if(_tcDBColonId!=null && (iPmid<=0 || gcp(TXTC_KEY_LOAD_DB_ITEM,jc)!=null && pmid(_tcDBColonId)<=0)){
                    if(_tcDBColonId!=null && (iPmid<=0 IF_STRAP(||pmid(_tcDBColonId)<=0))){
#if CPP_PRG_STRAP
                        String id=delChrSfx(',',delChrSfx('.',_tcDBColonId));
                        if(id.startsWith("PDB:")) id=id.replaceAll(":_","");
                        //startThrd(Strap.webAlignment(RETURN_THREAD|LOADP_EV_PP_ADDED,id,ALIAS_TARGET_ALIPANEL));
                        thrdCR(RUN_STRAP_WEBALIGNMENT|THRDCR_START,_main,io(LOADP_EV_PP_ADDED),id,ALIAS_TARGET_ALIPANEL);
#endif //CPP_PRG_STRAP
                    }else if(idxOfStrg(0,urlMouse,custSettings(CUSTOM_testProxySelector))>=0){
                        setTxt("Test network",runCR1(RUN_SHOW_IN_FRAME,clr(baLog(LOG_TEST_URL)).aa(ANSI_INVERSE,urlMouse).aln(ANSI_RESET).textView(true),NULL_AS_INT));
                        thrdCR1(_RUN_TEST_URL|THRDCR_START,chUtils(),urlMouse);
                    }else{
                        final BA log=0!=(_tcModi&CTRL_MASK)?new BA(99):null;
                        if(localhostSendData(urlMouse,log))  shwTxtInW(FRAME_OPTS|FRAME_ALWAYS_ON_TOP,"localhost",log);
                        else if((_tcModi&SHIFT_MASK)==0){
                            tcProcessFile(IF_PUBMED(w,)delChrSfx('.',urlMouse));
                            IF_PUBMED(ChPubmed.maybeAssociatePdf(iPmid));;
                        }
                    }
                }else{
                    for(ChTextArea taL:_taWWW) if(jc==taL) awtc(AWTC_SET_VISIBLE_OFF,ChFrame.frame(0,"",taL));
                }
                if((_tcModi&SHIFT_MASK)==0){
                    final File f=(File)_tcFile;
                    if(f!=null&&w!=null){
                        boolean success=false;
                        for(String V:arry(SARRAY_FILE_RANGE_SUFX)){
                            final int viewR=strstr(STR_AFTER,V,w);
                            if(viewR>0){
                                final int from=atoi(w,viewR),to=mini(atoi(w,w.indexOf('-',viewR)+1),sze(f));
                                if(from>0 && to>from){
                                    InputStream is=null;
                                    try{
                                        (is=new FileInputStream(f)).skip(from);
                                        final byte[]buf=new byte[to-from];
                                        final BA txt=new BA(buf,0,is.read(buf));
                                        if(txt.length()>0){
                                            shwTxtInW(fPathTildeForHome(f),new ChTextView(txt));
                                            success=true;
                                        }
                                    }catch(IOException ex){errorEx(ex,"INST_TEXTCOMPONENT",f);}
                                    closeStrm(is);
                                }
                                break;
                            }
                        }
                        if(!success && fileExsts(f) && looks(LIKE_FILEPATH,w)){
                            if(_isRunFile(f)) rtExecOutput(0,oo(f));
                            else tcProcessFile(IF_PUBMED("",)s(f));
                        }
                    }
                }
                if(evtButtn(ev)==2) _tcChanged(0,null);
            }
        }
        if(evId==MOUSE_PRESSED || searchDialog){
            int count=0;
            for(Map.Entry e:entryArry(_mapDialogFindInText)){ /* <DialogFindInText,Object>*/
                final Object d=e.getKey(),v=deref(e.getValue());
                if(v==null || d==null) _mapDialogFindInText.entrySet().remove(e);
                else if(v==jc){
                    if(evId==MOUSE_PRESSED) runCR1(RUN_SET_TEXT_POSITION,d,io(iP));
                    if(searchDialog) shwTxtInW(count++==0?FRAME_AT_CLICK:FRAME_STAGGER,null,d);
                }
            }
#if 0
            final Collection v=_vDialogFindInText;
            ROFi0(sze(v)){
                final Object d=iThElRmNull(i,v);
                if(runCR(RUN_GET_TEXT_COMPONENT,d)==jc){
                    if(evId==MOUSE_PRESSED) runCR1(RUN_SET_TEXT_POSITION,d,io(iP));
                    if(searchDialog) shwTxtInW(count++==0?FRAME_AT_CLICK:FRAME_STAGGER,null,d);
                }
            }
#endif //0
            if(searchDialog && count==0) shwTxtInW(FRAME_AT_CLICK,null,new DialogFindInText(jc));
/* if(evtButtn(ev)==2) inEDTms(tc_thrdCR(RUN_TXTTOOLS_M),333); */
        }
        if(evId==MOUSE_ENTERED && q==jc){
            _tcEscKey=false;
            _tcClear();
            if(0!=(_idata[IDATA_TC_underlineRefsOpts]&ULREFS_DISABLE_UNTIL_MOUSE) && NOT_FLAG(TC_FLAG_hlAuto)) {_chOpt|=TC_FLAG_hlAuto; tc_thrdCR(RUN_TXTTOOLS_HL).run();}
            if(FLAG(TC_FLAG_hlMouseEnter)) tc_thrdCR(RUN_TXTTOOLS_HL).run();
        }
        // if(evId==FOCUS_GAINED) _mcFocus=_idata[IDATA_TC_MC];
        {
            final int ct=_idata[IDATA_TC_contentType];
            if(evId==FOCUS_LOST || evId==MOUSE_EXITED || (jc instanceof ChTextField&&evId==ACTION_PERFORMED)){
                if(FLAG(TC_FLAG_saveNeeded)){
                    wrte((File)_data[DATA_TC_saveFile],byteArray());
                    _chOpt&=~TC_FLAG_saveNeeded;
#if defined PRPRTY_email
                    if(ct==TF_CONTENTTYPE_EMAIL) setPrpty(PRPRTY_email,s(jc));
#endif //defined PRPRTY_email
                }
                if(gcp(KEY_IF_EMPTY,jc)!=null) awtc(AWTC_OPT_REPAINT,jc);
                _tcClear();
            }
            if(jc instanceof ChTextField && evId==KEY_PRESSED && evtKeyChar(ev)=='\n') handleActCmdI(ACTION_ENTER,jc,0);
            if(0!=(ct&TF_MASK_CONTENTTYPE)){
                final String s0=getTxt(jc).trim();
                String s=null;
                if(ct==TF_CONTENTTYPE_INT||ct==TF_CONTENTTYPE_UINT||ct==TF_CONTENTTYPE_PERCENT){
                    final int n=xatoi(ct==TF_CONTENTTYPE_INT?delToChr('-',s0):s0);
                    s=s(ct==TF_CONTENTTYPE_PERCENT?maxi(0,mini(100,n)):n);
                    if(ct==TF_CONTENTTYPE_INT && "0".equals(s) && s0.indexOf('-')>=0) s="-0";
                }
                if(ct==TF_CONTENTTYPE_FLOAT) s=Double.toString(atof(s0));
                if(s!=null && !s0.equals(s)) runCR1(RUN_SET_TEXT,this,s);
            }
        }
        if((evId==MOUSE_MOVED || evId==KEY_PRESSED || evId==KEY_RELEASED)){
            Cursor c=tcCursor();
            if(c==null) c=cursr(jc instanceof JTextComponent && ((JTextComponent)jc).isEditable()?Cursor_TEXT_CURSOR:Cursor_DEFAULT_CURSOR);
            if(DIFF_MC(_data[DATA_TC_cursor],c)) ((Component)jc).setCursor(c);
        }
        if((evId==MOUSE_PRESSED || evId==MOUSE_CLICKED) && jc instanceof JTextComponent) ((JTextComponent)jc).getCaret().setVisible(true);
    }
    {
        final BA append=(BA)gcp(BA_KEY_SEND_TO,jc);
        if(append!=null) append.send();
    }
    return searchDialog?null:derefZ(evtCtrl2Mac(ev),EventObject.class); /*X ev not always instanceof EventObject */
}
/* <<< AWTEvent <<< */
/* ---------------------------------------- */
/* >>> Run >>> */
public Runnable tc_thrdCR(int id){
    if(_data[DATA_TC_run]==null) _data[DATA_TC_run]=new Runnable[16];
    Runnable r=((Runnable[])_data[DATA_TC_run])[id&0xF];
    UNLESS_CHECK_CODE(if(r==null) thrdRecordTime(r=((Runnable[])_data[DATA_TC_run])[id&0xF]=thrdCR1(id,this,null)));;
    return r;
#if WRITE_CONCATENATED_JAVA
    runCR(RUN_TXTTOOLS_HL,this);
    runCR(RUN_TXTTOOLS_HL_REPAINT,this);
    runCR(RUN_TXTTOOLS_TEXT_CHANGED,this);
#endif //WRITE_CONCATENATED_JAVA
}
/* <<< Run <<< */
/* ---------------------------------------- */
/* >>> Paint >>> */
private static int[]_tcYY(TextMatches tm,Object jc){
    final ChUtils tools=tcTools(jc);
    if(tools==null) return NO_int;
    final BA ba=tools.byteArray();
    int[]yy=tm._yy;
    if(DIFF_MC(tm._mcYY,tools.mc()+ba.mc()) || yy==null){
        final int ft[]=tm.fromTo(0),h=getFixedRowHeight(jc);
        tm._yy=yy=new int[idxOfNotPositive(ft)/2];
        FORi(0,yy.length){
            final int f=ft[2*i];
            if(f<0) break;
            if(h>=0) yy[i]=h*ba.idxToRow(f);
            else{
                tcModelToView(f,jc,RECTtm);
                yy[i]=y(RECTtm);
            }
        }
    }
    return yy;
}
private void _tcShiftHighlights(int from,int len){
    TC_LOOP_TEXTMATCHES(){
        final int[]ft=h==null?null:h.fromTo(FROM_TO_TRIM);
        if(sze(ft)>0){
            int ins=Arrays.binarySearch(ft,from);
            if(ins<0)ins=-(ins+1);
            FORk(ins,ft.length) ft[k]+=len;
        }
    }
}
private void _tcPaintTabs(int from,int to,Graphics g){
    final BA ba=byteArray();
    if(jc() instanceof JTextComponent && sze(ba)>0){
        final byte[]T=ba.bytes();
        setColorRGB(0xFF,g);
        for(int t=mini(to,ba.end(),T.length),charH=charH(g)+1,charA=charA(g),i=maxi(0,from);i<t;i++){
            if(T[i]=='\t'){
                Rectangle r=null;
                try{r=((JTextComponent)jc()).modelToView(i);}catch(Exception ex){}
                if(r!=null) g.drawString("\u00bb",EX/2+r.x,r.y+charA+ (r.height-charH)/2);
            }
        }
    }
}
private void _tcPaintHighlights(int from,int to,boolean after,Graphics g,Rectangle clip){
    final Component jc=jc();
    final boolean isEditableFocus=jc instanceof JTextComponent && ((JTextComponent)jc).isEditable() && jc.hasFocus();
    int fstPxlTilde=-1;
    TC_LOOP_TEXTMATCHES(){
        if(h==null) continue;
        final int style=h._opt&HIGHLIGHT_STYLE_MASK,ft[]=h.fromTo(FROM_TO_TRIM);
        int fromToL=0;
        FORk(0,ft.length) if(ft[k]>=0) fromToL=k;
        if(fromToL==0) continue;
        final ImageIcon ic=h._colorOrIcon instanceof ImageIcon && (_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NO_ICON)==0?(ImageIcon)h._colorOrIcon:null;
        final Image im=img(ic);
        final Color col=h._colorOrIcon instanceof Color?(Color)h._colorOrIcon: C((_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NOT_CLICKABLE)!=0?COLOR_REF_GRAY:COLOR_REF);
        if(after!=(im!=null || style==HIGHLIGHT_STYLE_WAVE || style==HIGHLIGHT_STYLE_UL)) continue;
#define ul style==HIGHLIGHT_STYLE_UL || im!=null && isEditableFocus
#define insPoint (binSearch<0?-(binSearch+1):binSearch)
        for(int binSearch=Arrays.binarySearch(ft,from),k=insPoint&~1;k<fromToL; k+=2){
#undef insPoint
            final int iFrom=ft[k],iTo=ft[k+1];
            if(iFrom==iTo) continue;
            if(iFrom>to) break;
            tcModelToView(iFrom,jc,RECTf);
            tcModelToView(iTo-1,jc,RECTt);
            final int
                w1=RECTt.width<2?charW(jc):RECTt.width,
                y0=y(RECTf),
                x0=x(RECTf),x1=x(RECTt),y1=y(RECTt),
                h0=RECTf.height,h1=RECTt.height,
                clipX1=clip!=null?x(clip)+clip.width:MAX_INT;
            if(x0+RECTf.width<x(clip) && x1+w1<x(clip) || x0>clipX1 && x1>clipX1) continue;
            if(y1>=0 && y0>=0 && col!=null){
                g.setColor(col);
                if(y0==y1){
                    if(style==HIGHLIGHT_STYLE_WAVE){
                        if(fstPxlTilde<0) fstPxlTilde=getCharBoundsForFont('~',g.getFont())[RECTy];
                        g.drawString(chrTimes('~',iTo-iFrom),x0,y0+charA(jc)+fstPxlTilde+1);
                    }else if(ul){
                        g.drawLine(x0,y1+h1,x1+w1,y1+h1);
                    }else if(im==null){
                        final int yf=maxi(y(clip),y0),wf=x1+w1-x0,hf=y1+h0-y0-1;
                        if(style==HIGHLIGHT_STYLE_RRECT) g.fillRoundRect(x0,yf+1,wf,hf-1,charW(jc),RECTf.height);
                        else fillRectBig(g,x0,yf,wf,hf);
                    }
                }else{
                    if(ul){
                        g.drawLine(x0,y0+h0,99999,y0+h0);
                        g.drawLine(0,y1+h1,x1+w1,y1+h1);
                    }else if(im==null){
                        fillRectBig(g,x0,y0+1,wdth(jc)-x0,h0-2);
                        if(y1>y0+h0) fillRectBig(g,0,y0+h0,wdth(jc),y1-y0-h0); g.setColor(col);
                        fillRectBig(g,0,y1+1,x1+w1,h1-2);
                    }
                }
            }
            if(im!=null && x0<x1 && (_idata[IDATA_TC_underlineRefsOpts]&ULREFS_NO_ICON)==0 && !isEditableFocus){
                final int colon=nxt(0,chrClas(-LETTR),byteArray(),iFrom,iTo),xr;
                //,cColon=chrAt(colon,byteArray())
                final boolean flushr=is(COLON_BAR,chrAt(colon,byteArray()));
                if(flushr){
                    tcModelToView(colon+1,jc,RECTt);
                    xr=x(RECTt)-1;
                }else xr=x1;
                if(xr>x0){
                    g.setColor(jc.getBackground());
                    fillRectBig(g,x0,y0,xr-x0,h0);
                    final int icw=wdth(ic),ich=hght(ic),h2=ic==iicon("wikipedia")?mini(EX,h0): h0;
                    if(icw>0&&ich>0){
                        if(icw*h2<ich*(xr-x0)){
                            final int d=icw*h2/ich,destX=maxi(x0,flushr?xr-d: x0+(xr-x0-d)*2/3),y=y0+(h0-h2)/2;
                            g.drawImage(im,destX,y,destX+d,y+h2,0,0,icw,ich,jc);
                        }else{
                            final int d=ich*(xr-x0)/icw,destY=maxi(y0,y0 + (y0+h0-y0-d)/2);
                            g.drawImage(im,x0,destY,xr,destY+d,0,0,icw,ich,jc);
                        }
                    }
                }
            }
        }
    }
}
#undef ul
/* <<< Paint <<< */
/* ---------------------------------------- */
/* >>> highlightOccurrence >>> */
private TextMatches _tcHighlight(Object needle,boolean[]delimL,boolean[]delimR,int opt,Color color,TextMatches highlight){
    final Object provided=!(needle instanceof BA || needle instanceof Collection) && needle instanceof ChRunnable?runCR(PROVIDE_HIGHLIGHTS,needle):null;
    final int[]buffer=highlight!=null?highlight.fromTo(FROM_TO_TRIM):null,fromTo;
    final byte[][][]lookup;
    if(needle instanceof Object[]||provided!=null){
        lookup=
            provided!=null?(byte[][][]) provided:
            needle instanceof byte[][][]?(byte[][][]) needle:
            occurInTextToLookupTable((Object[])needle,null);
        fromTo=occurInTextLU(lookup,byteArray(),delimL,delimR,buffer);
    }else{
        fromTo=occurInText(opt,toBytsCached(needle),delimL,delimR,byteArray(),buffer);
        lookup=null;
    }
    if((opt&HIGHLIGHT_UPDATE_ON_MOUSE_ENTER)!=0) _chOpt|=TC_FLAG_hlMouseEnter;/*X return null; */
    if((opt&HIGHLIGHT_UPDATE_IF_TEXT_CHANGES)!=0) _chOpt|=TC_FLAG_hlAuto;
    final int L=idxOfNotPositive(fromTo),ft[]=chSze(fromTo,L);
    final TextMatches h=highlight==null && (ft.length>0 || (opt&HIGHLIGHT_UPDATE_IF_TEXT_CHANGES)!=0)?new TextMatches(opt,ft,L/2,color): highlight;
    if(h!=null){
        h._needle=provided==null&&lookup!=null?lookup: needle;
        h._delimiterL=delimL;
        h._delimiterR=delimR;
        h.setFromTo(ft,MAX_INT);
        if(h!=highlight) tcAddHighlight(h,jc());
        if((opt&HIGHLIGHT_REPAINT)!=0){
            awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_100,jc());
            awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_800,getSB(SB_VERTICAL,jc()));
        }
    }
    return h;
}
/* <<< highlightOccurrence <<< */
/* ---------------------------------------- */
/* >>> Save >>> */
public ChUtils saveInFile(Object f){
    _data[DATA_TC_saveFile]=f instanceof String?newFile(iFile(DIR_SAVED_TEXT),new BA(99).aFilter(FILTER_NO_MATCH_TO_US|FILEP,f).a(".txt")): (File)f;
    return this;
}
public void loadSavedText(){
    if(sze(_data[DATA_TC_saveFile])>0 && _idata[IDATA_TC_saveLoaded]++==0) runCR1(RUN_SET_TEXT,this,readBytes(_data[DATA_TC_saveFile]));
}
/* <<< Save <<< */
/* ---------------------------------------- */
/* >>> Text >>> */
public BA byteArray(){
    loadSavedText();
    if(jc() instanceof ChTextView) return((ChTextView)jc()).ba(true);
    BA ba=(BA)deref(_data[DATA_TC_refBA]);
    if(ba==null) {_data[DATA_TC_refBA]=newSoftRef(ba=new BA(0)); _chOpt&=~TC_FLAG_byteArrayValid;}
    if(NOT_FLAG(TC_FLAG_byteArrayValid)){
        final Segment s=_tcAsSegment();
        final int B=s.getBeginIndex(),E=s.getEndIndex();
        byte[]bb=ba.bytes();
        if(sze(bb)<=E-B) bb=new byte[E-B+101];
        final char[]cc=s.array;
        int iB=0;
        for(int iS=B;iS<E;iS++) if(cc[iS]!='\r' && cc[iS]!=0) bb[iB++]=(byte)cc[iS];
        ba.set(bb,0,iB);
        _chOpt|=TC_FLAG_byteArrayValid;
    }
    return ba;
}
private Segment _tcAsSegment(){
    if(!isEDT()) return(Segment)inEdtNow(thrdCR(_RUN_getTextAsSegment,this));
    if(jc() instanceof JTextComponent){
        Segment segm=(Segment)deref(_data[DATA_TC_segment]);
        if(NOT_FLAG(TC_FLAG_segmentValid) || segm==null){
            if(segm==null) _data[DATA_TC_segment]=newSoftRef(segm=new Segment());
            _chOpt|=TC_FLAG_segmentValid;
            try{
                segm.array=null;
                tcDocument().getText(0,sze(tcDocument()),segm);
            }catch(Exception e){stckTrc(133,e);}
        }
        return segm;
    }
    return null;
}
/* <<< Text<<< */
/* ---------------------------------------- */
/* >>> Text Change >>> */
public int mc(){return _idata[IDATA_TC_MC];}
public void setChanged(){
    _idata[IDATA_TC_MC]++;
    _chOpt&=~(TC_FLAG_byteArrayValid|TC_FLAG_segmentValid);
    //_byteArrayValid=_segmentValid=false;
}

private void _tcChanged(int id,DocumentEvent ev){
    //putln(DEBUG_NOW+" _tcChanged "+id+" "+(ev==null?"NULL":ev.getType()));
    setChanged();
    if(FLAG(TC_FLAG_painted)){
        final TextMatches[][]hhh=(TextMatches[][])_data[DATA_TC_TextMatches];
        boolean doRunHL=sze(hhh[TC_TEXTMATCHES_RM_ON_CHANGE])>0 || FLAG(TC_FLAG_hlAuto);
        for(TextMatches h:hhh[TC_TEXTMATCHES_REMOVABEL]){
            if(doRunHL)break;
            if(h!=null && (h._opt&HIGHLIGHT_UPDATE_IF_TEXT_CHANGES)!=0) doRunHL=true;
        }
        _chOpt|=TC_FLAG_saveNeeded;
        if(doRunHL && FLAG(TC_FLAG_hlAuto) && ev!=null){
            final Rectangle r=(Rectangle)_data[DATA_TC_rectangle];
            //if(ev.getType()!=DocumentEvent.EventType.INSERT && ev.getType()!=DocumentEvent.EventType.REMOVE || ev.getLength()>1){
            if(id!=RUN_M_insertUpdate && id!=RUN_M_removeUpdate || ev.getLength()>1){
                r.add(0,0);
                r.add(wdth(jc()),hght(jc()));
            }else{
                //_tcShiftHighlights(ev.getOffset(),ev.getLength()*(ev.getType()==DocumentEvent.EventType.INSERT?1:-1));
                _tcShiftHighlights(ev.getOffset(),ev.getLength()*(id==RUN_M_insertUpdate?1:-1));
                tcModelToView(ev.getOffset(),jc(),RECTf);
                final int h=charH(jc()),y=y(RECTf);
                if(r.height==0) r.setBounds(0,y,0,0);
                r.add(0,y-h);
                r.add(wdth(jc()),y+2*h);
            }
           inEDTms(tc_thrdCR(RUN_TXTTOOLS_HL),333+10*thrdHowLong(tc_thrdCR(RUN_TXTTOOLS_HL)));
        }
        if(gcp(KOPT_NO_EVENT,jc())==null && FLAG(TC_FLAG_evEnabled) && FLAG(TC_FLAG_alreadyTyped) && ev!=null){
/* --- Event dispatching needs delay because the caret position is adjusted later --- */
            //if (ev.getType()==DocumentEvent.EventType.INSERT && ev.getLength()>2) inEDTms(tc_thrdCR(RUN_TXTTOOLS_I),333);
            inEDTms(tc_thrdCR(RUN_TXTTOOLS_TEXT_CHANGED),thrdHowLong(tc_thrdCR(RUN_TXTTOOLS_TEXT_CHANGED))*2+111);
        }
    }
}
/* <<< Text  Change<<< */
/* ---------------------------------------- */
/* >>> Selection >>> */
void tcMarchingAnts(int id,int from,int to){
    tcModelToView(from,jc(),RECTf);
    tcModelToView(to,jc(),RECTt);
    if(RECTf.height>0 && RECTt.height>0){
        final int[]r=new int[]{x(RECTf),y(RECTf),x2(RECTt)-x(RECTf),y2(RECTt)-y(RECTf)};
        scrllLock(0,getSB(SB_VERTICAL,jc()));
        scrllTo(new int[]{x(r)-8,y(r)-8,r[RECTw]+16,r[RECTh]+16},jc());
        addMarchingAnt(ANTS_SET|id,jc(),r,C(0xFF00ff),C(0xFF0000));
    }
}
/* <<< Selection <<< */
/* ---------------------------------------- */
/* >>> DefaultHighlighter  >>> */
public static Object tcAddColoredBg(int from,int to,Color color,Object tc){
    if(color!=null){
        final Map m=mapNoClr(196);
        Highlighter.HighlightPainter hp=(Highlighter.HighlightPainter)m.get(color);
        if(hp==null) m.put(color,hp=new DefaultHighlighter.DefaultHighlightPainter(color));
        if(tc instanceof JTextComponent){
            final Highlighter hl=((JTextComponent)tc).getHighlighter();
            if(hl!=null) try{return hl.addHighlight(from,to,hp);}catch(Exception e){stckTrcCT(77);}
        }
    }
    return null;
}
#undef FLAG
#undef NOT_FLAG
#undef _cmplOpts
#undef _isRunFile
