package charite.christo;
import java.util.*;
import static charite.christo.ChUtils.*;
@*H
 This dialog allows to run programs on selected text or the current word under the mouse pointer.

 All registered programs with a matching filter for the current text are displayed in an expandable tree. They can
 be started by mouse click. For details,
 hold ctrl while clicking.

 <DIV class="figure" >
 <TABLE style="caption-side: bottom">
 <CAPTION><B>Figure</B> Dialog to apply shell scripts or  Web addresses to selected text.
 Each  node in the tree represents a shell script which can be started by left click.
 The text in the text box "Argument for shell scripts" replaces the placeholder in the script (asterisk). Users can define own scripts.
 </CAPTION>
 <TR><TD><i>HTMLDOC_JCOMPONENT:HTMLDOC_JC_DialogApps</i></TD></TR>
 </TABLE>
 </DIV>

 <BR><BR>
 The list of shell-scripts / URLS is editable (<i>HTMLDOC_BUTTON:CUSTOM_apps</i>).
 Each line contains three tab-separated fields (Type Ctrl+I for  WIKI:Tab_character).

 Example:
 <PRE class="data">
 demo\Example google&#09;.*&#09;http://www.google.com/search?q=*
 demo\Example: Matches starting with M&#09;^M.*$&#09; echo starts with letter M *
 </PRE>
 Each line contains three fields separated by tab:
 <OL>
 <LI>The display name which may consist of several path components separated by slash.</LI>
 <LI>Optional a regular expression which. If the test matches the regular expression,
 the entry is displayed.</LI>
 <LI>An executable file or shell script or the URL of a web service. The asterisk is replaced by the current text.</LI>
 </OL>
 <BR><BR>
*@
//   <B>For administrators:</B>Alternatively,the program option "-addPreferenceApps" can be used to specify a file with shell-scripts.
//   @author Christoph Gille
public final class DialogApps implements ChRunnable{
    private final static DialogApps[]_inst=new DialogApps[CUSTOM_ZZZ];
    private final int _c;
    private final Collection _vName=new UniqueList(iCLASS_String),_jobs=NEW_VECTOR();
    private final Map _map=new HashMap();
    private ChJTree _jT;
    private ChRunnable _run;
    private Object _panel,_jlJobs,_help,_title,_cbSelected,_ta,_labError;
    private int _aotOff,_aotResult=FRAME_ALWAYS_ON_TOP;
    DialogApps(int customize){_c=customize;}
#if CPP_WITH_CHECK_CODE
    public static Object appsPanel(int customize,String para,String title,BA help) {return null;}
    public static Object appsPanel(int customize,ChRunnable para,String title,BA help) {return null;}
#else
    public static Object appsPanel(int customize,Object para,String title,BA help){
        DialogApps i=_inst[customize];
        if(i==null) _inst[customize]=i=new DialogApps(customize);
        i._help=help;
        i._title=title;
        if(para instanceof String){
            runCR(_RUN_APPS_UPDATE,i);
            runCR(_RUN_APPS_GET_PANEL,i);
            setTxt(para,i._ta);
        }else{
            i._run=(ChRunnable)para;
            runCR(_RUN_APPS_UPDATE,i);
        }
        return runCR(_RUN_APPS_GET_PANEL,i);
    }
#endif //CPP_WITH_CHECK_CODE
    private void addDir(java.io.File f,String path){
        if(f==null) return;
        final String path2=sze(path)==0?"":s(baClr(51).aa(path,'/',f.getName()));
        if(isDir(f)){
            for(java.io.File c:lstDirF(f)) addDir(c,path2);
        }else if(strEnds(".list",f)){
            adLines(readLns(f),null);
        }else ad(path2,s(f));
    }
    private void ad(String name,String script){
        if(sze(name)*sze(script)==0) return;
        _map.put(name,toStrgTrim(script));
        _vName.add(name);
        setTiti("",delToLstChr1('/',delToLstChr1('\\',name)),script,looks(LIKE_EXTURL,script)?IC_WWW:IC_EXEC,name);
    }
    private String adLines(String[]lines,String txt){
        String error="";
        for(String line:lines){
            if((line=toStrgTrim(line))!=null && chrAt(0,line)!='#'){
                final String cols[]=line.split(line.indexOf('\t')>0?"\t":"%09"),name=toStrgTrim(iThStrg(0,cols)),script=iThStrg(_c==CUSTOM_apps?2:1,cols);
                if(sze(name)*sze(script)==0) continue;
                if(_c==CUSTOM_apps && sze(cols[1])>0){
                    java.util.regex.Pattern p=null;
                    try{p=regexPattern(cols[1]);}catch(Exception ex){errorEx(ex,DialogApps.class,cols[1]);}
                    if(p==null) {error=addPfx("Error regular expr: ",cols[1]); continue;}
                    if(!p.matcher(txt).matches()) continue;
                }
                ad(name,script);
            }
        }
        return error;
    }
#define q evtSrc(ev)
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(_RUN_APPS_GET_PANEL){
                if(_panel==null){
                    (_jT=new ChJTree(0)).setModel(new ChTreeModel(STREE_LEAFS_CONTAIN_ENTIRE_PATH,_vName,chrClas(SLASH)));
                    _jT.setRootVisible(false);
                    _jT.setShowsRootHandles(true);
                    _jT.setRowHeight(ICON_HGT);
                    setChRenderer(RNDRER_LAST_PATH_COMPONENT_SLASH,addLi(this,LSTNR_MO,pcp(JTREE_KEY_NUM_EXPAND,"4",rtt(_jT))));
                    if(_c!=CUSTOM_apps){
                        _cbSelected=buttn(TOGS_DialogApps_ACT_SELECTED);
                        _jlJobs=new ChJList(0,_jobs);
                    }
                    final Object north,south,east=pnl(smallSourceBut(DialogApps.class),buttn(_c).rover(IC_CUSTOM));
                    addSrvc(RUN_CUSTOMIZE_CHANGED,this,Customize.customize(_c));
                    if(_c==CUSTOM_apps){
                        tcTools(addActLi(this,_ta=new ChTextArea(3,3))).saveInFile("ta_Apps");
                        south=setFG(0xFF0000,_labError=new ChPanel());
                        north=pnl(CNSEW,"<H2>Shell scripts and web apps</H2>",
                                  null,
                                  pnl(CNSEW,_ta,"\nArgument for shell script","Click on item to run shell scripts/open URL."," "," "),
                                  east,buttn(BUTTN_CLASS_HELP_SMALL|BUT_C1(DialogApps)));
                    }else{
                        south=pnl(CNSEW,_jlJobs,_cbSelected,_jlJobs);
                        north=pnl(CNSEW,_title,
                                  null,
                                  "Click on item to run shell scripts or web service. Hold Ctrl-key for log message.",
                                  east,sze(_help)==0?null:pcp(KEY_TITLE,_title,pcp(BUTTN_KOPT_AOT_OFF,"",ChButton.doView(_help).rover(IC_HELP))));
                    }
                    _panel=pnl(CNSEW,scrllpn(SCRLLPN_SIZE_56x24,_jT),north,south);
                    runCR(_RUN_APPS_UPDATE,this);
                }
                return _panel;
            }
            CASE_ARGV(PROVIDE_SCREENSHOT){
                runCR1(RUN_CHJTREE_expandAllNodes,_jT,null);
                return setPrefSze(50*EM,20*EX,runCR(_RUN_APPS_GET_PANEL,this));
            }
            CASE_ARG(RUN_CUSTOMIZE_CHANGED,Object,c){
                run(_RUN_APPS_UPDATE,null);
                BREAK;
            }
            CASE_ARGV(_RUN_APPS_UPDATE){
                clr(_vName);
                clr(_map);
                if(_c!=CUSTOM_apps){
                    addDir(iFile(DIR_STRAP_APPS_ETC),null);
                    addDir(iFile(DIR_STRAP_APPS_PRGDATA),null);
                }
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,setTxt(adLines(custSettings(_c),toStrgN(_ta)),_labError));
                runCR1(RUN_CHJTREE_updateKeepState,_jT,null);
                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jT);
                BREAK;
            }
            CASE_ARGV(_RUN_APPS_EXE,int,modi,String,script,String,title){
                final BA out=new ChExec((modi&CTRL_MASK)!=0?EXEC_SHOW_STREAMS|EXEC_DEBUG:EXEC_DEBUG).setCommandLines(script).stdoutAndDispose();
                if(!looks(LIKE_EXTURL,out) && !strEquAt(STR_w,"<?xml",out,nxt(0,chrClas(-SPC),out))){
                    thrdCR(_RUN_APPS_SHW_TXT|THRDCR_EDT_LATER,this,title,out);
                    //setTxt(title,runCR1(RUN_SHOW_IN_FRAME,_clr(output).a(out).send().textView(true),TYPE_FRAMEOPT_OBJ(FRAME_AT_CLICK|FRAME_TO_FRONT|_aotResult)));
                }else if(!shwTxtInBrwsr(out)){
                    shwTxtInW(title,out);
                }
                _aotResult=0;
                BREAK;
            }
            CASE_ARGV(_RUN_APPS_SHW_TXT,String,title,BA,out){
                setTxt(title,runCR1(RUN_SHOW_IN_FRAME,baClr(52).aln(out).textView(true),TYPE_FRAMEOPT_OBJ(FRAME_AT_CLICK|FRAME_TO_FRONT|_aotResult)));
                BREAK;
            }
            CASE_ARG(RUN_M_mouseClicked,Object,ev){
                if(q==_jT){
                    final String script=(String)gcp(objectAt(null,ev),_map);
                    if(script!=null){
                        if(_c==CUSTOM_apps){/*X ChUtils_TextComponent_Inc */
                            final String txt=toStrgTrim(_ta);
                            if(sze(txt)>0){
                                if(_aotOff++==0) wndw(WNDW_DO_AOT_OFF,runCR(_RUN_APPS_GET_PANEL,this));
                                final Object command0=strplc(0,"*",txt,script);
                                final BA log=0!=(evtModi(ev)&CTRL_MASK)?new BA(99):null;
                                if(evtIsPopupTrggr(ev)) shwTxtInW(FRAME_OPTS|FRAME_ALWAYS_ON_TOP,"Command",toBA(command0));
                                else if(id==RUN_M_mouseClicked){
                                    if(localhostSendData(s(command0),log)) shwTxtInW(FRAME_OPTS|FRAME_ALWAYS_ON_TOP,"localhost",log);
                                    else if(looks(LIKE_EXTURL,script)) visitURL(0,toStrgTrim(command0));
                                    else thrdCR(_RUN_APPS_EXE|THRDCR_START,this,io(evtModi(ev)),s(strplc(0,"*",txt,script)),script);
                                }
                            }
                        }else{ /*X Strap Apps */
                            if(_aotOff++==0) wndw(WNDW_DO_AOT_OFF,runCR(_RUN_APPS_GET_PANEL,this));
                            if(_run!=null){
                                final String job=addPfx("Running ",script);
                                _jobs.add(job);
                                awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_jlJobs);
                                runCR(RUN_APPS_SCRIPT,_run,script,io((isSlct(_cbSelected)?P_XML_ONLY_SELECTED_P:0)|(0==(evtModi(ev)&CTRL_MASK)?0:APPS_VERBOSE)));
                                _jobs.remove(job);
                                awtc(AWTC_QUEUE_REVALIDATE|AWTC_AFTER_200,_jlJobs);
                            }
                        }
                    }
                }
                BREAK;
            }
            CASE_ARG(RUN_M_actionPerformed,Object,ev){
                if(q==_ta && evtBid(ev)==ACTION_ENTER) run(_RUN_APPS_UPDATE,null);
               BREAK;
            }
        }
#undef q

        return null;
    }
/* <<< ChRunnable <<< */
}
