package charite.christo;
import java.io.File;
import java.util.*;
import java.util.regex.*;
import static charite.christo.ChUtils.*;
@*H
   Items in lists can be selected by text patterns.
   See WIKI:Regular_expression.
*@
@*SARRAYeq_DialogStringMatch_STROPT
STR_IC=STOGS_STRGMATCH_I_IC STR_w_L=STOGS_STRGMATCH_I_BWORD STR_w_R=STOGS_STRGMATCH_I_EWORD STR_BEGIN_OF_LINE=STOGS_STRGMATCH_I_STARTSWITH STR_EOL=STOGS_STRGMATCH_I_ENDSWITH 0=SBUTS_STRGMATCH_I_ZZZ
*@

public class DialogStringMatch implements ChRunnable{
    private Object __vB,__panFile,__panel,__component,__haystacks,__tfSize,__labCount,__butOr,__butAnd;
    private ChFrame __frame;
    private Collection __vMatching,__vRows;
    private String __fileName;
    private int __opts;
    public DialogStringMatch(int opt,String fileName,Object c){
        __opts=opt;
        __fileName=fileName;
        __component=c;
    }
    public DialogStringMatch(int opt,Object haystacks,Collection vMatching,String fileName){
        __haystacks=haystacks;
        __vMatching=vMatching;
        __opts=opt;
        __fileName=fileName;
    }
/* <<< Parent Instance <<< */
/* ---------------------------------------- */
/* >>> selectElements >>> */
    private static int selectJListElements(Object c,DialogStringMatch isEnabled){
        c=deref(c);
        c=orO(runCR(RUN_GET_JLIST_WITH_FILES,c),c);
        int count=xatoi(runCR1(RUN_CHJTREE_selectObjects,c,isEnabled));
        if(c instanceof ChJList){
            final javax.swing.ListModel lm=lstMdl(c);
            final int N=sze(lm),iiOld[]=selIndices(c),ii[]=chSze(iiOld,N+iiOld.length);
            FORj(0,N){
                ii[j+iiOld.length]=-1;
                if(TRUEr==runCR1(RUN_IS_OBJECT_ENABLED,isEnabled,lm.getElementAt(j))){
                    ii[j+iiOld.length]=j;
                    count++;
                }
            }
            runCR1(RUN_CHJLIST_setSelectedIndices,c,ii);
        }else if(c instanceof javax.swing.JTable){
            final int cols=((javax.swing.JTable)c).getColumnCount();
            ROFr0(((javax.swing.JTable)c).getRowCount()){
                ROFcol0(cols){
                    final Object o=((javax.swing.JTable)c).getValueAt(r,col);
                    //final javax.swing.table.TableCellRenderer tcr=o==null || 0==(options&DIA_MATCH_FROM_RENDERER_COMPONENT)?null: ((javax.swing.JTable)c).getDefaultRenderer(o.getClass());
                    //if (tcr!=null) o=getTxt(tcr.getTableCellRendererComponent(((javax.swing.JTable)c),o,false,false,r,col));
                    if(o!=null && TRUEr==runCR1(RUN_IS_OBJECT_ENABLED,isEnabled,o)){
                        ((javax.swing.JTable)c).addRowSelectionInterval(r,r);
                        count++;
                        break;
                    }
                }
            }
        }else if(bidForClass(c)==BUT_C1(ChFileChooser)){
            final File[]ss=lstDirF((File)runCR(RUN_FCHOOSER_getCurrentDirectory,c));
            if(ss.length>0){
                final Object fil=runCR(RUN_FCHOOSER_getFileFilter,c);
                File[]ff=new File[ss.length];
                ROFi0(ss.length) if(TRUEr==runCR1(RUN_IS_OBJECT_ENABLED,isEnabled,ss[i]) && (fil==null || ((javax.swing.filechooser.FileFilter)fil).accept(ss[i]))) ff[i]=ss[i];
                runCR1(RUN_FCHOOSER_setSelectedFiles,c,ff=rmNullA(ff,File.class));
                inEDTms(selectionToScrollBarC(RETURN_THREAD,gcp(FCHOOSER_KEY_FPANE,c)),222);
                runCR1(RUN_FCHOOSER_saveSelection,c,ff);
                count=ff.length;
            }
        }
        return count;
    }
    private static void recursiveSelect(Object haystacks,DialogStringMatch isEnabled,Collection matching){
        if(haystacks==null) return;
        int i=szeVA(haystacks);
        if(i>=0){
            while(--i>=0) recursiveSelect(xiThEl(i,haystacks),isEnabled,matching);
            return;
        }
        if(haystacks instanceof ChRunnable) recursiveSelect(runCR(PROVIDE_STRINGMATCH_HAYSTACK,haystacks),isEnabled,matching);
        if(TRUEr==runCR1(RUN_IS_OBJECT_ENABLED,isEnabled,haystacks)) matching.add(haystacks);
    }
    private void selectUnselect(DialogStringMatch isEnabled){
        runServices(RUN_DialogStringMatch_BEFORE,this);
        int count=0;
        if(__haystacks!=null){
            recursiveSelect(__haystacks,isEnabled,clr(__vMatching));
            count=sze(__vMatching);
        }else{
            final Object jc=deref(__component);
            if(jc!=null)count=selectJListElements(jc,isEnabled);
        }
        setTxt(count+"items matched",awtc(AWTC_QUEUE_REVALIDATE|AWTC_AFTER_200,__labCount));
        runServices(RUN_DialogStringMatch_FINISHED,this);
    }
/* <<< selectElements <<< */
/* ---------------------------------------- */
/* >>> Here starts the former inner class >>> */
    private Object _tf,_bb[];
    private DialogStringMatch _parent;
    private boolean _isAnd;
    private DialogStringMatch(DialogStringMatch parent){
        __opts=(_parent=parent).__opts;
        awtc(AWTC_REQUEST_FOCUS,setTip("Enter a search String",addSrvc(RUN_TEXT_CHANGED,this,_tf=new ChTextField())));
        if(sze(parent.__fileName)>0) tcTools(_tf).saveInFile("DialogStringMatch_"+parent.__fileName+"_"+sze(parent.__vRows));
        tcTools(pcp(KEY_IF_EMPTY,"Enter search string",_tf)).enableWordCompletion(parent.__haystacks);
        tcHighlightOccurrence(" ",null,null,HIGHLIGHT_UPDATE_IF_TEXT_CHANGES,C(DEFAULT_BACKGROUND),_tf);
        tcHighlightOccurrence("\t",null,null,HIGHLIGHT_UPDATE_IF_TEXT_CHANGES,C(0x444444),_tf);
        _bb=newButtns(this,SBUTS_STRGMATCH_I_AAA|(SBUTS_STRGMATCH_I_ZZZ<<16));
        __panel=pnl(CNSEW,
                    pnl(GRIDLAYOUT(2,1),_tf,pnl(
                                                _bb[STOGS_STRGMATCH_I_NOT]," ",
                                                _bb[STOGS_STRGMATCH_I_REGEX],
                                                _bb[STOGS_STRGMATCH_I_IC],
                                                _bb[STOGS_STRGMATCH_I_STARTSWITH],
                                                _bb[STOGS_STRGMATCH_I_ENDSWITH],
                                                _bb[STOGS_STRGMATCH_I_BWORD],
                                                _bb[STOGS_STRGMATCH_I_EWORD],
                                                (parent.__opts&DIA_MATCH_NEVER_FILE_CONTENT)==0?_bb[STOGS_STRGMATCH_I_FILECONTENT]:null)),
                    null,null,null,
                    pnl(_bb[parent.__haystacks!=null?SBUTS_STRGMATCH_I_FIND:SBUTS_STRGMATCH_I_SELECT]));
        parent.__vRows.add(this);
        adC(__panel,parent.__vB);
        runCR(RUN_ENABLE_DISABLE,parent);
    }
    private static boolean recursiveMatches(String needle,Object o,Pattern pattern,int strOpt,int fileKB){
        if(o==null) return false;
        int i=szeVA(o);
        if(i>=0){
            while(--i>=0)if (recursiveMatches(needle,xiThEl(i,o),pattern,strOpt,fileKB)) return true;
        }else if(o instanceof ChRunnable && recursiveMatches(needle,runCR(PROVIDE_STRINGMATCH_STRINGS,o),pattern,strOpt,fileKB)){
            return true;
        }
        CharSequence txt=o instanceof CharSequence?(CharSequence)o:null;
        if(txt==null && fileKB>0 && o instanceof File) txt=readBytesMX((File)o,1024*fileKB,clr(baSoft(116)));
        if(txt==null && (o instanceof ChRunnable || o instanceof File)) txt=nam(o);
        if(txt==null) return false;
        if(pattern!=null){
            final Matcher m=pattern.matcher(txt);
            while(m!=null && m.find()){
                if((0==(strOpt&STR_w_R) || !is(LETTR_DIGT_US,chrAt(m.end(),txt)))&&
                   (0==(strOpt&STR_w_L) || !is(LETTR_DIGT_US,chrAt(m.start()-1,txt)))) return true;
            }
            return false;
        }
        return strstr(strOpt,needle,txt)>=0;
    }
/* <<< Match <<< */
/* ---------------------------------------- */
/* >>> AWTEvent >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_ENABLE_DISABLE_ADD_ROW)
                CASE_ARGV(RUN_ENABLE_DISABLE){
                int countTxt=0,countEmpty=0,countF=0;
                final int R=sze(__vRows);
                if(R==0) new DialogStringMatch(this);
                FORi(0,R){
                    final DialogStringMatch m=(DialogStringMatch)iThEl(i,__vRows);
                    final boolean empty=sze(getTxt(m._tf))==0;
                    if(!empty) countTxt++; else countEmpty++;
                    setEnbld(!empty,m._bb[SBUTS_STRGMATCH_I_SELECT]);
                    setEnbld(!empty,m._bb[SBUTS_STRGMATCH_I_FIND]);
                    if(isSlct(m._bb[STOGS_STRGMATCH_I_FILECONTENT])) countF++;
                }
                setEnbld(countTxt>1,__butOr);
                setEnbld(countTxt>1,__butAnd);
                setEnbld(countF>0,__tfSize);
                setEnbld(countF>0,__panFile);
                if(id==RUN_ENABLE_DISABLE_ADD_ROW && countEmpty==0){
                    new DialogStringMatch(this);
                    if(__frame!=null) __frame.size(prefW(__panel)+32,prefH(__panel)+32);
                }
                break;
            }
            CASE_ARG(RUN_SHOW_IN_FRAME,TYPE_FRAMEOPT,opt){
                if(__frame==null){
                    final Object north=gcp(KEY_NORTH_PANEL,this),pnl=runCR(RUN_GET_PANEL,this);
                    __frame=new ChFrame(orS(gcp(KEY_TITLE,this),"Select by text patterns")).ad(north==null?pnl:pnl(CNSEW,pnl,north));
                    awtc(AWTC_REQUEST_FOCUS,childC(__vB,ChTextField.class));
                }
                RETURN(__frame.shw(FRAME_TO_FRONT|FRAME_AT_CLICK|FRAME_PACK_SMALLER_SCREEN|CLOSE_CtrlW_ESC));
            }
            CASE_ARG(RUN_IS_OBJECT_ENABLED,Object,o){
                boolean success=false;
                if(o!=null){
                    if(_parent==null){/*X Is the parent */
                        FORi(0,sze(__vRows)){
                            final DialogStringMatch m=(DialogStringMatch)iThEl(i,__vRows);
                            if(m!=null && sze(getTxt(m._tf))>0){
                                final boolean b=TRUEr==runCR1(RUN_IS_OBJECT_ENABLED,m,o);
                                if(b!=_isAnd){
                                    success=b;
                                    break;
                                }
                                success|=b;
                            }
                        }
                    }else{/*X Single fields */
                        Pattern pattern=null;
                        int opt=0;
                        FORi(SBUTS_STRGMATCH_I_AAA,SBUTS_STRGMATCH_I_ZZZ) if(isSlct(_bb[i])) opt|=intArry(SARRAYeq_DialogStringMatch_STROPT)[i];
                        if(isSlct(_bb[STOGS_STRGMATCH_I_REGEX])){
                            try{
                                pattern=Pattern.compile(getTxt(_tf),(0!=(opt&STR_IC)?Pattern_CASE_INSENSITIVE:0)|Pattern_MULTILINE|Pattern_DOTALL);
                            }catch(Exception e){error(s(e));}
                        }
                        success=!isSlct(_bb[STOGS_STRGMATCH_I_NOT])==recursiveMatches(getTxt(_tf),o,pattern,opt,!isSlct(_bb[STOGS_STRGMATCH_I_FILECONTENT])?0:xatoi(_parent.__tfSize));
                    }
                }
                RETURN(success?TRUEr:FALSEr);
            }
            CASE_ARGV(RUN_GET_PANEL){
                if(__panel==null && _parent==null){
                    __tfSize=new ChTextField("10").cols(TF_CONTENTTYPE_UINT|TF_NOT_MAXIMIZE|9);
                    __labCount=labl(null);
                    __butAnd=addActLi(this,buttn(BUTS_DIA_STRINGMATCH_AND));
                    __butOr=addActLi(this,buttn(BUTS_DIA_STRINGMATCH_OR));
                    if(0==(__opts&DIA_MATCH_NEVER_FILE_CONTENT)) pcp(KOPT_HIDE_IF_DISABLED,"",__panFile=pnl(HB,"   Limit search within files to ",__tfSize,"kByte"));
                    __vRows=new ArrayList();
                    __panel=pnl(CNSEW,
                                __vB=pnl(VB,pnl(CNSEW,setTxt("Select by text patterns",pnl(pcpKey(KOPT_SCROLLTEXT))),null,null,smallSourceBut(DialogStringMatch.class),buttn(BUTTN_CLASS_HELP_SMALL|BUT_C1(DialogStringMatch)))),
                                gcp(KEY_NORTH_PANEL,this),pnl(__butAnd,__butOr,__labCount,__panFile));
                    runCR(RUN_ENABLE_DISABLE_ADD_ROW,this);
                }
                return __panel;
            }
            CASE_ARG(RUN_TEXT_CHANGED,Object,q){
                setEnbld(sze(q)>0,new Object[]{_bb[SBUTS_STRGMATCH_I_FIND],_bb[SBUTS_STRGMATCH_I_SELECT]});
                if(q==_tf) runCR(RUN_ENABLE_DISABLE_ADD_ROW,_parent);
                BREAK;
            }
            CASE_ARG(RUN_M_actionPerformed,Object,ev){
                final int bid=evtBid(ev);
                if(_parent!=null){
                    if(isSlct(_bb[STOGS_STRGMATCH_I_FILECONTENT])) awtc(AWTC_SET_SELECTED_OFF,_bb[STOGS_STRGMATCH_I_REGEX]);
                    if(bid==SBUTS_STRGMATCH_I_SELECT||bid==SBUTS_STRGMATCH_I_FIND || bid==ACTION_ENTER){/*X  Matcher  &&evtSrc(ev)==_tf*/
                        setTxt("Computing ...",_parent.__labCount);
                        _parent.selectUnselect(this);
                    }
                    //if(q==_tf || bid==STOGS_STRGMATCH_I_FILECONTENT) _parent.enableDisable(q==_tf);
                    if(bid==STOGS_STRGMATCH_I_FILECONTENT) runCR(RUN_ENABLE_DISABLE,_parent);
                }else if(bid==BUTS_DIA_STRINGMATCH_AND || bid==BUTS_DIA_STRINGMATCH_OR){
                    _isAnd=bid==BUTS_DIA_STRINGMATCH_AND;
                    selectUnselect(this);
                }
                BREAK;
            }
        }
        return null;
    }
}
#undef bid
#undef ev
