package charite.christo;
import java.io.File;
import java.nio.file.Files;
import static charite.christo.ChUtils.*;
public class RunIf17 implements ChRunnable{
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_17_hardLink,File,src,File,dst){
                try{
                     if(!dst.exists()) Files.createLink(dst.toPath(),src.toPath());
                    return TRUEr;
                }catch(Exception ex){if(onlyOnceHC(302,s(dst))) errorEx(ex," hardLink ",src," ==> ",dst);}
                BREAK;
            }
            CASE_ARGV(RUN_17_symLink,File,src,File,dst){
                try{
                    if(!dst.exists())
                    Files.createSymbolicLink(dst.toPath(),src.toPath());
                    return TRUEr;
                }catch(Exception ex){
                    if(onlyOnceHC(303,s(dst))) errorEx(ex," symLink ",src," ==> ",dst);
                }
                BREAK;
            }
            CASE_ARGV(RUN_17_FILE_CONTENT_EQ,File,f0,File,f1){
                try{
                    RETURN(compareFiles(f0.toPath(),f1.toPath())?TRUEr:null);
                }catch(java.io.IOException iox){
                    return EXCEPTIONr;
                }
            }
        default:return NO_SUCH_METHOD;
        }

        return null;
    }

    public final static boolean compareFiles(java.nio.file.Path f1,java.nio.file.Path f2)throws java.io.IOException{
        final long size=Files.size(f1);
        final int mapspan=1024*1024;
        try{
            final java.nio.channels.FileChannel c1=(java.nio.channels.FileChannel)Files.newByteChannel(f1),c2=(java.nio.channels.FileChannel)Files.newByteChannel(f2);
            for(long pos=0;pos<size; pos+=mapspan){
                if(mapChannel(c1,pos,size,mapspan).compareTo(mapChannel(c2,pos,size,mapspan))!=0) return false;
            }
        }catch(Exception ex){IF_MEIN_DEBUG(errorEx(ex,"compareFiles",f1,f2));;}
        return true;
    }

    private static java.nio.MappedByteBuffer mapChannel(java.nio.channels.FileChannel channel,long pos,long size,int mapspan)throws java.io.IOException{
        long end=pos+mapspan;
        if(size<end)end=size;
        return channel.map(java.nio.channels.FileChannel.MapMode.READ_ONLY,pos,end-pos);
    }

}
