@*SARRAYeq_CUSTOM_TYPE_HELP
Program application. If more than one is given, the first one that runs successfully, is used.
For example PDF files may be opened with different viewers: Evince Viewer, Acrobat Reader, Foxit Reader or Xpdf.
The list may also contain programs which are not installed.
The programs in the list are tried one after the other until one succeeds.

<p>HTMLDOC_OS_WIN{
The environment variable %PATH% is not systematically used in Windows.
There are two workarounds:
<UL>
<LI>Entering the full path to the exe file.
<LI>The prefix "<B>start</B>" is a mechanism
to start applications without knowing the exact location on the file system.
Note that the start command does not
return a valid exit value and Strap cannot detect failure to start.
</LI>
<LI>Add search paths <i>HTMLDOC_BUTTON:CUSTOM_execSearchPath!</i>
</UL>
}HTMLDOC_OS_WIN</p>=CUSTOM_TYPE_EXECUTABLES

List of command lines that are executed one after the other.=CUSTOM_TYPE_SHELL_SCRIPT
LaTeX code.=CUSTOM_TYPE_LATEX
List of Java classes.=CUSTOM_TYPE_JAVA_CLASSES
List of text lines.=CUSTOM_TYPE_LIST
Text.=CUSTOM_TYPE_TEXT
*@

@*?CUSTOM_openFileWith
Shell programs to process files from the context menu.
*@
@*?CUSTOM_execResidueSelection
Shell programs to process residue selections from the context menu.
*@
@**CUSTOM_execResidueSelection
SH echo $*
SH echo $* | sed 's|[a-z]||g'
*@
@*?CUSTOM_execGappedSeq
@*?CUSTOM_execAminoSeq
Shell programs to process amino acid sequences from the context menu.
*@
@**CUSTOM_execAminoSeq
@**CUSTOM_execGappedSeq
SH echo $*
*@
@*?CUSTOM_apps
Script which can act on a text selection.
Three columns:<OL>
<LI>Display name</LI>
<LI>Regular expression, that can match or not match the text to be process. Optional.</LI>
<LI>Shell command or URL.</LI>
</OL>
*@
@**CUSTOM_apps
#Tab-separated Columns (Insert tab by typing Ctrl+I):
#  1st Column: Display name *
#  2nd Column: A regular expression *
#  3rd Column: A shell script *
demo/Example: Matches any\t.*\t SH echo Hello, this matches any "*"
demo/Example google\t.*\thttp://www.google.com/search?q=*
demo/Example: Matches starting with M\t^M.*$\t SH echo starts with letter M "*"
demo/Example: Matches numbers\t^.*[0-9]$\t SH echo ends with a digit "*"
demo/Example: local host port\t.*\t http://localhost:1234?blabla_*
#if CPP_PRG_METAN
util/GEO_Datasets\t^ENSG[0-9][0-9].*\t fgrep 'ARGUMENT' ~/testMetannogenExpr/GEO_Datasets.txt
#endif //CPP_PRG_METAN
*@
@*?CUSTOM_execSequenceFile
Shell programs for sequence files
*@
@*?CUSTOM_latexEditors
@*?CUSTOM_textEditors
@*?CUSTOM_javaSourceEditor
Editor for source code.
J_JAVA_EDITOR denotes an editor with syntax highlighting which will be automatically installed. ECLIPSE denotes the Eclipse IDE.
*@
@*!CUSTOM_webLinks
Spice-Browser* http://www.efamily.org.uk/software/dasclients/spice/
CE_CL* http://cl.sdsc.edu/
Vast* https://www.ncbi.nlm.nih.gov/Structure/VAST/vasthelp.html
GangstaPlus* http://agknapp.chemie.fu-berlin.de/gplus/
BioDAS* http://www.biodas.org/
Dali* http://ekhidna.biocenter.helsinki.fi/dali
Launch_STRAP* http://www.bioinformatics.org/strap/strap.jnlp
Image:Cust_mac_mouse* http://www.bioinformatics.org/strap/images/macSettingsMouse.jpg
File_example: http://www.bioinformatics.org/strap/dataFiles/proteinFileExamples/*.txt
Drop_Web_Link* http://www.bioinformatics.org/strap/dragProteinLink.html
Adobe_flash_movies* http://www.bioinformatics.org/strap/index2.html#DOCUMENTATION
*@
@*?CUSTOM_pdbLinks
A list of PDB links. Asterisk is place-holder for PDB id.
*@
@**CUSTOM_pdbLinks
PDBj:*
PDB_SUM:*
PDB_RCSB:*
PDBe:*
VIPERDB:
*@
@*?CUSTOM_uniprotLinks
A listUniprot links. Asterisk is place-holder for UNIPROT id.
*@
@**CUSTOM_uniprotLinks
UNIPROT_EBI:*
BLAST{UNIPROT:*}
LOC{UNIPROT:*}
PFAM_PROTEIN:*
*@
@*?CUSTOM_ecClassLinks
A list of URLs for creation external links by EC number. Asterisk is place-holder for EC number.
*@
@**CUSTOM_ecClassLinks
STRAPec{*}
METACYCec{*}
NISTec{*}
BRENDAec{*}
REACTOMEec{*}
EXPASYec{*}
KEGGec{*}
IUBMBec{*}
UMBBDec{*}
UNIPROT{*}
ENSG{*}
*@
@*?CUSTOM_speciesIcons
Mapping of species names to icon files.
The text contains lines with base URLs.
The other lines contain two columns separated by space:
<OL><LI>scientific-species-name</LI><LI>icon file</LI></OL>
*@
@*?CUSTOM_proteinInfoRplc
Text replacements to shorten the sequence information such as organism name.
The goal is to make the text more compact by abbreviating/deleting unnecessary text.
Each text line contains a regular expression and an optional replacement text, separated by tab (Type Ctrl-I for tabulator).
Text matches are deleted or replaced with the text right from the tab.
*@
@**CUSTOM_proteinInfoRplc
subunit \t
*@
@*?CUSTOM_trustExe
Trusted native programs. On Windows these executables have the suffix .exe.
*@
@*?CUSTOM_refuseExe
Native programs which should not be run because you do not trust them.
*@
@*?CUSTOM_pdfViewer
Document viewer for PDF files
*@
@*?CUSTOM_psViewer
File path of the PostScript document viewer.
*@
@**CUSTOM_psViewer
gv
kgv
ggv
kghostview
evince
xdg-open
*@
@**CUSTOM_pdfViewer
evince
xpdf
acroread
xdg-open
*@
@*?CUSTOM_fileBrowsers
File browser
*@
@**CUSTOM_fileBrowsers
rox
nautilus
pcmanfm
thunar
konqueror
kbear
xfe
gcmd
emacs
sh -c xterm%20-title%20*%20-e%20'cd%20*;ls%20-l;/bin/sh'
xfce4-terminal --title * --working-directory=*
gnome-terminal --title * --working-directory=*
konsole -T * --workdir *
*@
@*?CUSTOM_webBrowser
Web browser for displaying HTML pages.
*@
@*?CUSTOM_htmlEditors
WYSIWYG Word-Processor for html files such as MS-Word.
*@
@*?CUSTOM_watchLogFile
Shell command to watch a log file.
*@
@*?CUSTOM_laf
Look and Feel
*@
@*?CUSTOM_webSearches
A list of URLs for looking up a word or phrase. Used in context menu of text components.
*@
@**CUSTOM_webSearches
WIKIPEDIA{*}
GOOGLE{*}
PUBMED{*}
UNIPROT{*}
TDB{*}
ENSG{*}
ISI{*}
CITEXPLORE{*}
METACYC{*}
*@
@*?CUSTOM_testProxySelector
A list of Web-addresses to test what web proxy is assigned.
*@
@**CUSTOM_testProxySelector
http://www.bioinformatics.org/strap/index.html
http://www.google.de/
http://localhost/
https://www.wikipedia.org/
ftp://ftp.ebi.ac.uk
ftp://ftp.embl-heidelberg.de
ftp://ftp.ncbi.nih.gov/pub
*@
@**CUSTOM_execSequenceFile
@**CUSTOM_latexEditors
@**CUSTOM_textEditors
#nohup gnuclient
#nohup emacsclient
kwrite
kedit
gedit
emacs
xemacs
nedit
# xterm -e vi
# xterm -e pico
J_JAVA_EDITOR
*@
@**CUSTOM_htmlEditors
gwrite
wps
bluegriffon
nvu
kompozer
*@
@**CUSTOM_watchLogFile
SH (xterm -title less_$* -e less -r $*&);(xterm -title tail_-f_$* -e tail -n 999 -f $*)
*@
@**CUSTOM_openOffice
wps
libreoffice
ooffice3
ooffice2
ooffice
openoffice
soffice
*@
@**CUSTOM_javaSourceEditor
#ECLIPSE
nohup gnuclient
nohup emacsclient
kwrite
gedit
kedit
J_JAVA_EDITOR
*@
@**CUSTOM_webBrowser
iridium
google-chrome
chromium
firefox
iceweasel
icecat
gnome-www-browser
rekonq
konqueror
mozilla
opera
epiphany
xdg-open
*@
