package charite.christo.strap;
import charite.christo.*;
import static charite.christo.strap.Strap.*;
import static charite.christo.ChUtils.*;
@*H
  <H2>Drag-and-Drop for proteins and Residue selections</H2>
  Dropping proteins here, will display these proteins in the current 3D-view.
  <i>HTMLDOC_BUTTON:BUTS_MOVIE_Drag_protein_to_3D!</i><BR>
  This is particular important for those 3D-views such as Pymol that are not implemented in Java because their 3D-panes cannot serve as drop target.<BR>
  By dragged residue selections from the alignment panel into advanced 3D view (not the simple backbone representation),
the respective amino acids will be selected in the 3D-view.
  <H2>Keep windows always on top</H2>
  Windows hidden behind other windows cannot act as a drop target.<BR>
  Workaround: Typing Ctrl+T, toggles floating on top on/off for all Strap windows.
*@
public abstract class AbstractView3dCanvas extends ChPanel{
    protected Object _g,_canvas;
    protected UniqueList _vPV;
/* ---------------------------------------- */
/* >>> ChRunnable >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_DISPOSE){
                if(gcpSetToTrue(KOPT_DISPOSED,this)==null){
                    _g=null;
                    ROFi0(sze(_vPV)){
                        final View3d pv=(View3d)iThEl(i,_vPV);
                        rmFromParentProt(pv);
                        dispos(pv);
                        if(i==0) awtc(AWTC_REMOVE_FROM_PARENT,runCR(RUN_VIEW3D_GET_CANVAS,this));
                    }
                    clr(_vPV);
                    awtc(AWTC_REMOVE_FROM_PARENT,_canvas);
                }
                return TRUEr;
            }
            CASE_ARGV(RUN_VIEW3D_GET_CANVAS) return orO(deref(_canvas),this);
            CASE_ARGV(RUN_GET_COLUMN_TITLE) return v3dTitle(_vPV);
            CASE_ARG(RUN_AVIEW3D_TO_CANVAS,Object,pv){
                (_vPV=(UniqueList)((View3d)pv).getProperty(VIEW3D_GET_SHARED_VIEWS)).add(pv);
                runCR1(RUN_V3D_TO_CANVAS_IMPL,this,pv);
                //if (_canvas!=this) pcp(KEY_COLUMN_TITLE,this,deref(_canvas));
                BREAK;
            }
        }
        return null;
    }
/* <<< ChRunnable <<< */
/* ---------------------------------------- */
/* >>> static utils  >>> */
    PUBLIC_SUPERCLASS final View3d pvWithName(String n){
        ROFi0(n==null?0:sze(_vPV)){
            final View3d pv=(View3d)iThEl(i,_vPV);
            if(pv!=null && n.equals(pv.getProperty(VIEW3D_GET_PNAME))) return pv;
        }
        return null;
    }
/* ---------------------------------------- */
/* >>> StrapEvent >>> */
    PUBLIC_SUPERCLASS static void mkEvtPickedV3d(View3d pv,int resNum,String chain,char ins,int awtModi){
        if(sp(pv)!=null){
            final Selection3D sel=new Selection3D(0,resNum,ins,resNum,ins,chain,null);
            final Object[]evt=new Object[SEVT_DATA_SIZE];
            evt[SEVT_DATA_SRC]=pv;
            evt[SEVT_DATA_SEL3D]=sel;
            evt[SEVT_DATA_AWTMODI]=io(awtModi);
            strapEvtData(EVT_V3D_PICKED,evt);
        }
    }
/* <<< Event <<< */

}
