package charite.christo.strap;
#define THIS_CLAS() BUT_C_##ChAstex
@*H
   <B>License:</B> WIKI:LGPL<BR>
   <B>Authors:</B> Mike Hartshorn, Tom Oldfield<BR><BR>
*@
@*RSC_MULTI_WORD_COMPLETION THIS_CLAS()
 select schematic secstruc display center remove
 -object molecule aminoacid group surface current default
 -alltube
 -arrowheadwidth
 -arrowsmoothing
 -arrowthickness
 -arrowwidth
 -quality
 -ribboncylinders
 -ribbonellipse
 -ribbonminwidth
 -ribbonthickness
 -ribbonwidth
 -tuberadius
 -tubesmoothing
 -tubetaper
 -tubetaperradius
 true false
*@

@*RSC_MULTI_INIT THIS_CLAS()
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_FIRST_LAST)
 3D_lines off
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_FIRST_LAST).C.CA.CB.N.O
 3D_lines
 3D_native ASTEX, secstruc (molecule '$PROTEIN');
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_HETERO) CPP_UNSTRINGIZE(V3D_SELECT_DNA) CPP_UNSTRINGIZE(V3D_SELECT_RNA)
 3D_sticks
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_FIRST_LAST)
 3D_cartoon  CPP_UNSTRINGIZE(V3DVAR_PROTEIN_COLOR)
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_NTERM)
 3D_ribbons -name=NTERM_$PROTEIN -width=5 CPP_UNSTRINGIZE(V3DVAR_PROTEIN_COLOR)
 3D_select CPP_UNSTRINGIZE(V3D_SELECT_CTERM)
 3D_ribbons -name=CTERM_$PROTEIN -width=5 CPP_UNSTRINGIZE(V3DVAR_PROTEIN_COLOR)
*@

@*RSC_MULTI_EXAMPLE THIS_CLAS()
 display spheres on current;
 display spheres off current;
 display cylinders on current;
 display cylinders off current;
 display sticks on current;
 display sticks off current;
 display lines on current;
 display lines off current;
 color blue current;
 schematic -name 'schematic_RESIDUES' -alltube true -ribbonwidth 20 current;
 object remove 'schematic_PROTEIN';
 surface -solid true 'surface_RESIDUES' pink current;
 object remove 'surface_PROTEIN';
*@

public final class ChAstex extends AbstractView3d{
    public ChAstex(){
        super(V3D_ASTEX,new Integer(BUT_C1(ChAstexCanvas)));
    }
}
#undef THIS_CLAS
