package charite.christo.strap;
import charite.christo.*;
import static charite.christo.strap.Strap.*;
import static charite.christo.ChUtils.*;
import astex.*;
import java.lang.reflect.*;
@*SARRAY_RPLC_MENU_ASTEX
 Exit|
 Save Molecule|
 Save All|
 Run Script...|Load view / Run Script...
 Write BMP...|Write image in BMP format
*@
public class ChAstexCanvas extends AbstractView3dCanvas{ //implements MoleculeRendererListener
    private final Object _mb;
    public ChAstexCanvas(){
        final MoleculeViewer mv=new MoleculeViewer();
        mv.setApplication(true);
        _mb=menuBar2j(mv.createMenuBar(),SARRAY_RPLC_MENU_ASTEX);
        mv.setUsePopupMenu(true);
        addLi(this,LSTNR_MO|LSTNR_WHEEL,pcp(KEY_AVOID_GARBAGE_COLLECT,_mb,_canvas=mv));
    }
    CPP_RUN_ID_ARG(){
        final Object ret=super.run(id,arg);
        final MoleculeViewer mv=derefZ(_canvas,MoleculeViewer.class);
        switch(id){
            CASE_ARG(RUN_AVIEW3D_TO_CANVAS,Object,pv) _molecule((ChAstex)pv); BREAK;/*X  Force loading */
            CASE_ARG(RUN_M_mouseClicked,Object,ev){
                final MoleculeRenderer mr=_moleculeRenderer();
                if(mr!=null){
                    final Atom a=mr.getNearestAtom(x(ev),y(ev));
                    if(a!=null){
                        final Residue r=a.getResidue();
                        if(r!=null && r.isStandardAminoAcid()){
                            final Chain c=r.getParent();
                            mkEvtPickedV3d(pvWithName(a.getMolecule().getName()),r.getNumber(),c==null?null:c.getName(),r.getInsertionCode(),evtModi(ev));
                            runCR(RUN_AVIEW3D_REPAINT,this);
                        }
                    }
                }
                BREAK;
            }
            CASE_ARGV(RUN_VIEW3D_GET_JMENUBAR) return _mb;
            CASE_ARGV(RUN_AVIEW3D_REPAINT) if(mv!=null) mv.dirtyRepaint();break;
            CASE_ARGV(RUN_AVIEW3D_HIGHLIGHT_ATOMS,Selection3D[],atoms,Object,pv){
                final MoleculeRenderer mr=_moleculeRenderer();
                final Renderer rend=mr==null?null: mr.renderer;
                for(int iA=sze(atoms);--iA>=0 && rend!=null && mv!=null;){
                    final Selection3D a=atoms[iA];
                    if(a!=null){
                        final int fst=s3dFirst(a),lst=s3dLast(a)+1;
/*INSCODE Was ist mit a.getInsLast()*/
                        FORj(fst,lst){
                            final Residue r=_residue(j,j==fst?s3dFirstInsCode(a):'\0',s3dChain(a),(ChAstex)pv);
                            if(r!=null)
                                ROFi0(r.getAtomCount())
                                    if(idxOfStrg(0,r.getAtom(i).getAtomLabel(),s3dAtoms(a))>=0||sze(s3dAtoms(a))==0) v3dHighlightAtoms(mv,
                                                                                                                                       r.getAtom(i).xs>>Renderer.FixedBits,
                                                                                                                                       r.getAtom(i).ys>>Renderer.FixedBits);
                        }
                    }
                }
                RETURN TRUEr;
            }
            CASE_ARGV(RUN_AVIEW3D_INTERPRET,BA,argCommand,AbstractView3d,pv){
                final BA c=argCommand.trim().a1(';');//              ,send=c;
#define send c
                final MoleculeRenderer mr=_moleculeRenderer();
                final Renderer renderer=mr!=null?mr.renderer:null;
                if(renderer==null||sze(c)<2) return null;
                //final Selection3D[]atoms=(Selection3D[])pv.getProperty(AVIEW3D_GET_SELECTION3D);
                boolean noSend=true;/*X iV3DCMD_center generic2native */
                final int cmd=v3dCmdInLine(c),L0=sze(iConst(SARRAY_STRAP_SCRIPT_CMD,cmd));
                if(cmd==iV3DCMD_set_rotation_translation){
                    final Matrix3D m3d=new Matrix3D();
                    final byte[]T=c.bytes();
                    final int e=c.end(),b=nxt(0,chrClas(-SPC),T,CPP_STRLEN(V3DCMD_set_rotation_translation)+c.begin(),e);
                    if(!(e-b>=4 && strEquAt(STR_w_R,"null",T,b)) && !m3d.parseMatrixPlain(T,b,e-1)) baOut(RED_ERROR).aln(c);
                    final Molecule m=mr.getMolecule((String)pv.getProperty(VIEW3D_GET_PNAME));
                    if(m!=null){
                        final int N=m.getAtomCount();
                        float[]xyzORIG=((ChAstex)pv)._xyzORIG;
                        if(xyzORIG==null){
                            ROFi0(mini(N,(xyzORIG=((ChAstex)pv)._xyzORIG=new float[N*3]).length/3)){
                                final Atom a=m.getAtom(i);
                                ROFj0(3)xyzORIG[i*3+j]=(float)a.get(j);
                            }
                        }
                        IF_MEIN_DEBUG(if(xyzORIG.length!=3*N) baOut(RED_WARNING).aa(" xyzORIG=",xyzORIG.length," N3=",N*3).special(DIE_NOW));;
                        {
                            final float[]xyz=isUnitOrNull(m3d)?xyzORIG: m3d.transformPoints(xyzORIG,0,N,null);
                            ROFi0(mini(N,xyz.length/3)) m.getAtom(i).set(xyz[i*3],xyz[i*3+1],xyz[i*3+2]);
                        }
                        runCR(RUN_AVIEW3D_INTERPRET,this,new BA(99).aa("center ( sphere 20 around ( molecule '",pv.getProperty(VIEW3D_GET_PNAME),"'));"),pv);
                        runCR(RUN_AVIEW3D_REPAINT,this);
                    }
                }else if(cmd==iV3DCMD_reset){
                    mr.resetView();
                }else if(cmd==iV3DCMD_zoom){
                    renderer.setZoom(0.01*atof(c,L0,MAX_INT));
                }else if(cmd==iV3DCMD_rotate){
                    final int para=nxt(STR_E,chrClas(-SPC),c,L0,999);
                    final double f=atof(c,para+1,MAX_INT);
                    switch(chrAt(para,c)){
                    case'x':renderer.rotateX(f);break;
                    case'y':renderer.rotateY(f);break;
                    case'z':renderer.rotateZ(f);break;
                    }
                }else noSend=false;
                if(!noSend){
                    if(sze(send)>0){
                        if(!strStarts("3D_",send)){
                            mr.executeInternal(s(send));
                            if(cmd!=iV3DCMD_highlight_selected_atoms && cmd!=iV3DCMD_highlight_selected_amino_acids) mr.repaint();
                        }
                        IF_MEIN_DEBUG(else if(cmd!=iV3DCMD_highlight_selected_atoms && cmd!=iV3DCMD_highlight_selected_amino_acids) baOut(RED_ERROR).aa(" !send  send=",send).special(DIE_NOW));
                    }
/* FIXME iV3DCMD_highlight_selected_atoms not yet implemented*/
                }
                if(cmd==iV3DCMD_center || cmd==iV3DCMD_zoom) runCR(RUN_AVIEW3D_REPAINT,this);
#undef send
                BREAK;
            }
            CASE_ARG(RUN_M_moleculeRemoved,Object[],aa){  /*X MoleculeRenderer r,Molecule m*/
                dispos(pvWithName(((Molecule)aa[1]).getName()));
                BREAK;
            }
        }
        return ret;
    }
/* ---------------------------------------- */
/* >>> Conversions >>> */
    private boolean _mrLis;
    private MoleculeRenderer _moleculeRenderer(){
        final MoleculeViewer mv=derefZ(_canvas,MoleculeViewer.class);
        if(mv==null) return null;
        final MoleculeRenderer mr=mv.getMoleculeRenderer();
        if(!_mrLis) {
            _mrLis=true;
            pcp(KEY_LISTENERS,wref(this),mr);
            mr.addMoleculeRendererListener((MoleculeRendererListener)Proxy.newProxyInstance(getClass().getClassLoader(),new Class[]{MoleculeRendererListener.class},chUtils(INST_EVT_ADAPTER)));
        }
        return mr;
    }
    private Molecule _molecule(ChAstex a){
        final MoleculeRenderer mr=_moleculeRenderer();
        final Protein p=sp(a);
        Molecule m=mr==null||p==null?null:mr.getMolecule((String)a.getProperty(VIEW3D_GET_PNAME));
        if(m==null){
            final Object file=pdbFileWrite(SEQW_NO_OCCUPANCY|SEQW_HETEROS|SEQW_NT_STRUCTURE|SEQW_SHORT_ATOM_LINES|SEQW_GZ,spp(p));
            if(file==null) return null;
            try{
                m=astex.MoleculeIO.readPDB(new astex.FILE(inStrm(0,s(file))));
            }catch(Exception ex){IF_MEIN_DEBUG(errorEx(ex,ChAstex.class,file));}
            if(m!=null){
                m.setSymmetry(null);
                m.setFilename(s(file));
                m.setName(v3dProtName(p));
                mr.addMolecule(m);
            }
        }
    return m;
    }
    private Residue _residue(int rN,char rI,String rC,ChAstex a){
        final Molecule m=_molecule(a);
        if(m!=null && sp(a)!=null)
            ROFi0(m.getChainCount()){
                final Chain c=m.getChain(i);
                if(rC==null||rC.equals(c.getName())){
                    ROFr0(c.getResidueCount()){
                        final Residue res=c.getResidue(r);
                        if(res.getNumber()==rN && (rI==0||res.getInsertionCode()==rI)) return res;
                    }
                }
            }
        return null;
    }
}
/* <<< Conversions <<< */
/* ---------------------------------------- */
/* >>> MoleculeRendererListener >>> */
/* OVERRIDE_PUBLIC_IF void moleculeAdded(MoleculeRenderer r,Molecule m){} */
/* OVERRIDE_PUBLIC_IF void genericAdded(MoleculeRenderer r,astex.generic.Generic g){} */
/* OVERRIDE_PUBLIC_IF void genericRemoved(MoleculeRenderer r,astex.generic.Generic g){} */
/* OVERRIDE_PUBLIC_IF void mapAdded(MoleculeRenderer r,astex.Map m){} */
/* OVERRIDE_PUBLIC_IF void mapRemoved(MoleculeRenderer r,astex.Map m){} */
/* OVERRIDE_PUBLIC_IF void atomSelected(MoleculeRenderer r,Atom a){} */
/* OVERRIDE_PUBLIC_IF void moleculeRemoved(MoleculeRenderer r,Molecule m){dispos(pvWithName(m.getName()));} */
