package charite.christo.strap;
import charite.christo.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
@*H

<B>Context menus in Strap:</B>

The term WIKI:Context_menu is commonly used for menus which pop up when right
clicking (<B>right mouse button</B>) an item in a graphical user interface,
offering a list of options which vary depending on the item selected.
Watch movie <i>HTMLDOC_BUTTON:BUTS_MOVIE_Context_Menu!</i>
<BR><BR>
<i>HTMLDOC_OS_MAC{On Macintosh computers the right mouse button is often deactivated.
It can be activated: Image:Cust_mac_mouse*.
Alternatively,
the right mouse button can be simulated by  Alt+Ctrl+left-click.
}HTMLDOC_OS_MAC</i>
<BR><BR>
Context menus are available for example for sequences,
for residue selections,
for the alignment panel and for the rubber band selection.

<BR><BR><B>Selecting single items:</B>
List items are selected simply by left-click the respective node.
Single residue selections in the alignment panel can be selected by clicking with the Ctrl-key.

<BR><BR><B>Selecting more than one item:</B>
Selecting more than one list item requires the <B>Shift</B> and <B>Ctrl</B> keys.
The Ctrl-key is located at the lower left of the key board and is sometimes labeled  <B>Strg</B> and
the Shift-key is sometimes termed "Umschalt".

<BR><BR><B>Selecting residue selections:</B>
Residue selections which are highlighted in the alignment panel can be selected by Ctrl-left-click.
Selected residue selections are indicated by marching ants.

By dragging a rectangular region in the alignment,
all contained
residue selections are selected. With the Shift or Ctrl-key the
union-set or cut-set is formed between already selected items and those inside the
rectangle.

<BR><BR><B>Frequently used menu items</B> can be dragged out the menu and placed on the desktop.
Instead of clicking a menu-item the user drags the menu-item to the desktop.
Being on the desktop,
it can now be accessed much easier.
When the menu-item on the desktop is not needed any more,
it can be   deleted.

<BR><BR><B>The tree view</B> is located at the left of the application.
It is usually  hidden and can be opened by dragging the vertical divider bar.
The tree contains all loaded proteins and their child objects.

*@
public final class ContextObjects{
    private final UniqueList[]_vv=new UniqueList[SOBJECT_ZZZ];
    private final Strap[]_popup=new Strap[SOBJECT_ZZZ];
    private final boolean _immutable;
    private final Object _vObjects;
    private int _mc=-1;
    private Object _lastV;
/* <<< Fields <<< */
/* ---------------------------------------- */
/* >>> Constructor  >>> */
    public ContextObjects(boolean immutable,Object v){
        _immutable=immutable;
        _vObjects=v;
    }
    UniqueList _v(int t){
        if((t&CONTEXTOBJECTS_OPT_NO_UPDATE)==0){
            final Object v=_vObjects==CNTXT_OBJCTS?getCntxtObj():_vObjects;
            int mc=modic(v);
            if(szeVA(v)>=0){
                ROFi0(szeVA(v)){
                    final Object o=xiThEl(i,v);
                    if(o!=null) mc+=o.hashCode();
                }
            }else if(v!=null){
                mc+=v.hashCode();
            }
            if(DIFF_MC(_mc,mc) || _lastV!=v || mc<0){
                final Object[]oo=selValues(_lastV=v);
                clr(_vv);
                FORi(0,oo.length){
                    final Object o=iThEl(i,oo);
                    if(o instanceof UniqueList){
                        for(Object el:((UniqueList)o).asArray()) _add(el);
                    }else _add(o);
                }
            }

        }
        t&=255;
        if(t==CHAINTYPE_DNA||t==CHAINTYPE_RNA) t=CHAINTYPE_HET;
        if(_vv[t]==null) _vv[t]=new UniqueList(iThIntOr(t,intArry(SARRAYeq_SOBJECT_TO_CLASS),0));
        return _vv[t];
    }
/* <<< Constructor <<< */
/* ---------------------------------------- */
/* >>>  >>> */
    public Strap smenu(int id){
        if(id==SOBJECT_SEQFEAT || id==SOBJECT_RESAN || id==SOBJECT_RESSEL) id=SOBJECT_RESSEL_AND_RESAN;
        if(id==CHAINTYPE_DNA||id==CHAINTYPE_RNA) id=CHAINTYPE_HET;
        Strap m=_popup[id];
        if(m==null) _popup[id]=m=newCtxtMenu((_immutable?SXM_FLAG_IMMUTABLE:0)|id,this);
        return m;
    }

    private void _add(Object o){
        ROFi0(SOBJECT_ZZZ) if(isSobjectType(i,o)) _v(i|CONTEXTOBJECTS_OPT_NO_UPDATE).add(o);
    }
/* <<< Update  <<< */
/* ---------------------------------------- */

}
