package charite.christo.strap;
import charite.christo.*;
import java.io.File;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;

//SARRAYeq_TXSHD_PRPRTY_FOR_ID
#if !WRITE_CONCATENATED_JAVA
#define txshdSaved(a) txshd(a)
#endif //!WRITE_CONCATENATED_JAVA

#define BUT_LABEL_TXSHD_MAKE_PDF "Make PDF (pdflatex)"
#define BUT_LABEL_TXSHD_VIEW "View graphics"
/* --- */
#define LOCATION_NON 0
#define LOCATION_TTOP 1
#define LOCATION_TOP 2
#define LOCATION_BOTTOM 3
#define LOCATION_bBOTTOM 4
/* --- */

#define THIS_CLAS() BUT_C_##DialogTEXshade
@*H
 Multiple sequence alignments are exported as PDF documents using the WIKI:LaTeX
 package <i>HTMLDOC_URL:iURL_TEXSHADE_PDF</i>
 by Eric Beitz. If at least one sequence is selected as indicated by blue background in the alignment row header then
 all selected sequences are used.
 Alternatively, a rectangular region surrounded by marching ants can be opened by dragging the mouse in the alignment pane.
 Otherwise all sequences are processed. The result can be viewed in a PDF viewer.

Example output  <i>HTMLDOC_URL:iURL_FIG_alignAlphasHydropathy_pdf</i>.

 <BR><BR><B>Installation of TeXshade</B><BR>
 TeXshade will be downloaded automatically from the Strap server. However, a different version can be placed in <i>HTMLDOC_FILE:F_TXSHD_STY_BY_USER</i>.

 <BR><BR><B>Installation of LaTeX</B><BR>
 <P>HTMLDOC_OS_win{
 Unless LATeX is already installed, LaTeX (Texlive basic) will be automatically installed from source code in <i>HTMLDOC_FILE:DIR_UNIX</i>.
 This will take some time.
 This also applies to <I>pdfcrop</I> which will remove the margins and the converter SVG-to-EMF-format.
 }HTMLDOC_OS_win</P>

 <P>HTMLDOC_OS_WIN{For <B>Windows</B>
 <UL>
 <LI>LaTeX is installed from source. WIKI:MSYS2 provides the compiler infrastructure.</LI>
 <LI>WIKI:Miktex: If there is already a Miktex installation, it will be recognized and used.</LI>
 </UL>
 }HTMLDOC_OS_WIN</P>

 <BR><BR><B>Running pdflatex</B><BR>

 By pressing BUT_LABEL_TXSHD_MAKE_PDF in the main card of the TeXshade-Dialog, two files are generated: The LaTeX file with ending <I>.tex</I>
 and the alignment file with ending <I>.msf</I>. These two files are then processed by <I>pdflatex</I>.

 The resulting PDF file appears in the file list and can be displayed with the button BUT_LABEL_TXSHD_VIEW.
 It can also be coppied by drag and drop or dragged into a PDF-viewer.

 <BR><BR><B>PDF Tricks</B><BR>
 <UL>
 <LI><B>Big alignment: </B>Use page size A0. To print on normal printer, tile the image with the program <B>pdfposter</B></LI>
 </UL>

 <BR><BR><B>PDF File conversions</B><BR>

 The PDF file can be converted to the vector file formats Post-Script (PS), SVG and EMF.

 Several PDF conversion and processing utilities are accessible by buttons. Unless already installed, they are downloaded and installed in three different ways.
 <UL>
 <LI>Methods marked <B>"(Java)"</B> or "(Perl)" are computer system independent and will be automatically loaded from the Strap server.</LI>
 <LI>Utilities marked <B>"(<I>C++</I>)"</B> are compiled to native code using the <I>C++</I> compiler and <I>make</I>.
 On Mac OSX, the Xcode command line tools is sufficient. On Windows, MSYS2 is required.
 On Linux, <I>C++</I> and <I>make</I> are installable with the native package manager.
 </LI>
 <LI>Prgrams labeled <B>"(Native)"</B> must be installed with the Linux package manager or Windows-MSYS2 or MacOSX-MacPorts, respectively</LI>
 </UL>

 <BR><BR><B>Insertion in Office documents</B><BR>

 For optimal quality, it is anticipated to insert the alignment figure in office documents or web pages not as raster graphics (PNG, JPG, GIF, BMP), but as vector graphics.
 <UL>
 <LI>MS-Word:  EMF documents can be dragged directly into the MS-Office documents.
 Tested with office 2010.
 However it did not work with Office 2016.
 Please share your experience.</LI>
 <LI>Libreoffice and Openoffice: The SVG-files can be dragged directly into the Libreoffice document.</LI>
 <LI>Web pages:<PRE class="data">&lt;IMG width="333" src="align.svg" /&gt;</PRE>
 If you prefer an interactive HTML5 image of the alignment, then use <i>HTMLDOC_BUTTON:BUT_C1(DialogExportHTML)!</i>.</LI>
 </UL>

 Articles on this topic:
 <UL>
 <LI>http://atastypixel.com/blog/inserting-vector-graphics-in-office-documents/</LI>
 </UL>

 <BR><BR><B>Residue Annotations</B><BR>

 Residue selections can contain TeXshade commands.
 The variables <I>PROTEIN</I> and <I>RESIDUES</I> are placehoder for the  numeric number identifying a sequence the sequence position of a residue selection.

 <DIV class="figure">
 <TABLE>
 <CAPTION>Useful TeXshade-expressions  which can be added to selections</caption>

 <TR><TD><PRE class="data" >
 \feature{top}{PROTEIN}{RESIDUES}{box[Red]}{peptide}
 \feature{ttop}{PROTEIN}{RESIDUES}{box[Red]}{peptide}
 \feature{bottom}{PROTEIN}{RESIDUES}{fill:$\downarrow}{$S_{129}$}
 \feature{bbottom}{PROTEIN}{RESIDUES}{fill:X}{cleavage}
 \fingerprint{300}
 </PRE></TD></TR>
 </TABLE>
 </DIV>

 <DIV class="figure">
 <TABLE>
 <CAPTION>TeXshade examples with  variables </caption>

 <TR><TD><PRE class="data">
 \feature{bottom}{PROTEIN}{RESIDUES}{fill:$\downarrow$}{$$FIRST_Aaa_{$FIRST_INDEX}$}
 \feature{bottom}{PROTEIN}{RESIDUES}{fill:$\downarrow$}{$$FIRST_A_{$FIRST_INDEX}$}
 </PRE></TD></TR>
 </TABLE>
 </DIV>

 <BR><BR><B>Plotting</B><BR>With the card <I>Plot</I>, numeric values can be computed for each residue of a sequence and plotted along the sequence alignment.
 The plot can be placed at four locations: <B>top</B>, <B>bottom</B>, <B>ttop</B>, <B>bbottom</B>.

 <BR><BR><B>Problems</B><BR>

File locking is a Windows specific Phenomenon.
If a PDF is opened in Acrobat Reader, LaTeX fails to create a new PDF output.
The PDF needs to be closed before generating a new LaTeX file.
Sumatra PDF is a light PDF viewer without this problem.

<BR><BR>

 The LaTeX compiler stops when the text contains syntax errors.

 LaTeX reports the line number where the error occurred. For
 example <I>1.42</I>  indicates an error at line 42.

 Typically the error occurs in TeXshade commands assigned to
 residue selections. Frequent problems are unbalanced
 parentheses or characters that have a special syntactical meaning like
 <B>underscore</B> or "%".

 <BR><BR><B>Memory limitation:</B>

 With large alignments the pdflatex-run may terminate with an <I>... memory exceeded ...</I>-error.

 If this happens the  LaTeX heap size must be increased.
<P>HTMLDOC_OS_WIN{
 Miktex users should set <I>pdf_mem_size</I> to a higher values in the file <I>miktex.ini</I>.
}HTMLDOC_OS_WIN</P>

 For other LaTeX systems the memory settings in <I>texmf.cnf</I> must
 be increased (e.g. multiplied by 10). To activate the settings, run <I>fmtutil</I> as root.

 Typical locations of the <I>texmf.cnf</I> are /etc/texmf/texmf.cnf /usr/share/texmf/web2c/texmf.cnf and
 /usr/local/teTeX/share/texmf/web2c/texmf.cnf.

 <PRE class="terminal">
 -SED_SPACE- CPP_HASH fmtutil --byfmt=pdflatex
 </PRE>

 <BR><BR><B>Restore default settings:</B>
Close Strap and delete
 <UL>
 <LI>respective lines in the file <i>HTMLDOC_FILE:F_PROPERTIES</i> or the entire file</LI>
 <LI>files in the folder <i>HTMLDOC_FILE:DIR_TEX_SAVE</i></LI>
 </UL>
*@

@*SARRAYeq_TXSHD_PRPRTY_FOR_ID
 xx=1
*@
@*RSC_MULTI_EXAMPLE THIS_CLAS()
 /feature{top}{$TEX_PROTEIN}{$TEX_RESIDUES}{box[Red]}{peptide}
 /feature{ttop}{$TEX_PROTEIN}{$TEX_RESIDUES}{box[Red]}{peptide}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/uparrow$}{active site}
 /feature{top}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/downarrow$}{active site}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/uparrow$}{$FIRST_A$_{$FIRST_INDEX}$ - $LAST_A$_{$LAST_INDEX}$}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/uparrow$}{$FIRST_A$_{$FIRST_NUMBER}$ - $LAST_A$_{$LAST_NUMBER}$}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/uparrow$}{$FIRST_A$_{$FIRST_NUMBER:$CHAIN}$ - $LAST_A$_{$LAST_NUMBER:$CHAIN}$}
 /frameblock{$TEX_PROTEIN}{$TEX_RESIDUES}{Red[2pt]}
 /emphregion{$TEX_PROTEIN}{$TEX_RESIDUES}
 /emphblock{$TEX_PROTEIN}{$TEX_RESIDUES}
 /shaderegion{$TEX_PROTEIN}{$TEX_RESIDUES}{Red}{Green}
 /shadeblock{$TEX_PROTEIN}{$TEX_RESIDUES}{Red}{Green}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:$/uparrow$}{$FIRST_Aaa$_{$FIRST_INDEX}$}
 /feature{bbottom}{$TEX_PROTEIN}{$TEX_RESIDUES}{fill:X}{cleavage}
 /fingerprint{300}
 /separationline{$TEX_PROTEIN}
*@

@*SARRAY_TXSHD_CMD_FMTUTILS
 fmtutil|--byfmt=pdflatex|fmtutil|--byfmt=latex
*@

@*SARRAYeq_TXSHD_BID_TO_INFILESFX
 .pdf=TXSHD_but_SPLIT
 .pdf=TXSHD_but_PDF2PS
 .pdf=TXSHD_but_PDF_TO_PS
 .pdf=TXSHD_but_PDF2PDF_CROP
 .pdf=TXSHD_but_PDF2SVG
 .pdf=TXSHD_but_PDF2SVG_JAVA
 .ps=TXSHD_but_PS2EPS
 .svg=TXSHD_but_SVG2EMF
 .svg=TXSHD_but_SVG2GIF
*@

// _crop_J.pdf=TXSHD_but_CROP_JAVA_MK
// _inkscape.svg=bTXSHD_butPDF2SVG_INKSCAPE
@*SARRAYeq_TXSHD_BID_TO_OUTFILESFX
 _crop.pdf=TXSHD_but_PDF2PDF_CROP
 .ps=TXSHD_but_PDF2PS
 .ps=TXSHD_but_PDF_TO_PS
 _J.svg=TXSHD_but_PDF2SVG_JAVA
 .svg=TXSHD_but_PDF2SVG
 .emf=TXSHD_but_SVG2EMF
 .gif=TXSHD_but_SVG2GIF
 .eps=TXSHD_but_PS2EPS
*@
// pdf2svg (Inkscape)=TXSHD_but_PDF2SVG_INKSCAPE
// pdfcrop (Java)=TXSHD_but_CROP_JAVA_MK
@*SARRAYeq_TXSHD_BUT_TITLE
 See tex and msf-file=TXSHD_BUT_SRC  Choose other sequence=TXSHD_g_butOtherSeq Delete=TXSHD_but_DEL CPP_UNSTRINGIZE(BUT_LABEL_TXSHD_VIEW)=TXSHD_but_View CPP_UNSTRINGIZE(BUT_LABEL_TXSHD_MAKE_PDF)=TXSHD_but_TEX2PDF Split pages (Java)=TXSHD_but_SPLIT pdf2ps (native)=TXSHD_but_PDF2PS pdftops (native)=TXSHD_but_PDF_TO_PS ps2eps (Perl)=TXSHD_but_PS2EPS pdf2svg (Java)=TXSHD_but_PDF2SVG_JAVA pdf2svg (native, recommended)=TXSHD_but_PDF2SVG svg2emf (Java)=TXSHD_but_SVG2EMF svg2gif (ImageMagick)=TXSHD_but_SVG2GIF pdfcrop (C++)=TXSHD_but_PDF2PDF_CROP)
*@

@*SARRAYeq_TXSHD_SAVE_INT_FILE
 before.txt=TXSHD_taBefore
 within.txt=TXSHD_taIn
 subfamilyName=TXSHD_tfSubfamilyName
 geometry=TXSHD_tfGeometry
 bargraphstretch=TXSHD_tfBarstretch
 vblockspace=TXSHD_tfVbspace
 residuesperline=TXSHD_tfResPerLine
*@
// rulerstep=TXSHD_tfRulerstep
@*SARRAYeq_TXSHD_TF
 x=TXSHD_tfGeometry 1.0=TXSHD_tfBarstretch 10.0=TXSHD_tfVbspace auto=TXSHD_tfResPerLine xxxx50=TXSHD_tfGifQuality
*@
//10.0=TXSHD_tfRulerstep
@*SARRAYeq_TXSHD_TF_IF_EMPTY
 Generated graphics files will be shown here=TXSHD_jListFF
 You can type addition LaTeX/TeXshade commands=TXSHD_taBefore
 You can type addition LaTeX/TeXshade commands=TXSHD_taIn
 Enter the name of the logo=TXSHD_tfSubfamilyName
 Additional options=TXSHD_tfGeometry
*@

@*SARRAYeq_TXSHD_CB
 skip sequence=TXSHD_ss_cbSkip
 ^Landscape=TXSHD_cbLandscape
 Additional space after alignment=TXSHD_cbSeparation
 Use upper case only=TXSHD_cbUpperCase
 Hide legend=TXSHD_cbHideLegend
 Fingerprint=TXSHD_cbFinger
 Hide consensus=TXSHD_cbNoConsens
 \dofrequencycorrection=TXSHD_cbDoFreqCorrect
 \hideseqs=TXSHD_cbHideSeqs
 Apply substitutions of sequence names=TXSHD_cbSeqNames
 ^Suppress file suffix in sequence file names=TXSHD_cbNoSfx
 ^No page margin=TXSHD_cbNoMargin
 ^View a copy of the PDF-file rather then the PDF file itself.=TXSHD_cbCopyBeforeView
*@
@*SARRAYeq_TXSHD_LOCATION
 non=LOCATION_NON ttop=LOCATION_TTOP top=LOCATION_TOP bottom=LOCATION_BOTTOM bbottom=LOCATION_bBOTTOM
*@
@*SARRAYeq_TXSHD_COMBO
 non ttop top bottom bbottom=TXSHD_choiceConsensusL
 ColdHot BlueRed GreenRed Blue Red Green Brown Black Yellow Orange Pink=TXSHD_txshd_g_color
 A4 A3 A2 A1 A0 =TXSHD_choiceSize
 non top bottom=TXSHD_choiceSubfamilyL
 Gray BlueRed RedBlue GreenRed RedGreen ColdHot=TXSHD_choiceConsensus
 functional identical similar diverse none=TXSHD_choiceShading
 left right none=TXSHD_choiceShowNames
 left right none=TXSHD_choiceNumbering
 bf md up it sl rm sf tt=TXSHD_choiceEmph
 non top bottom=TXSHD_choiceSeqLogo
*@
@*~RSC_TXSHD_INFO_MEMORY
<H2>LaTeX reports low memory</H2>
 <BR>Please include less sequences or set the memory limits in the LaTeX configuration file <PRE>texmf.cnf</PRE>
 Keep a copy of the original file content.<BR>
 Increase (multiply by 10 or 100) all memory values that have two or more zero digits at the end.<BR>
 Then run as superuser<PRE class="terminal">   fmtutil --byfmt=pdflatex</PRE>
*@

@*~RSC_TXSHD_HELP_BARCHART
 Bar charts can be drawn at four different locations: ttop, top, bottom, bbottom<BR>
 The values are calculated by instances of the interface <I>ValueOfResidue</I> / <I>ValueOfAlignPosition</I>
 with the specified aligned sequences.<BR>
*@

@*~RSC_TXSHD_HELP_SUBSTITUTE_NAMES
 Normally, the sequence names are used. Alternatively, different names can be defined using simple text or complex LaTeX expressions.<BR><BR>
 Remember that <B>underscore</B> "_" has a special meaning in LaTeX and needs to be quoted.
*@

@*~RSC_TXSHD_HELP_SEQ_LOGO
 A sequence logo visualizes the degree of conservation and the prevalence of amino acid letters at each alignment position.
*@

@*~RSC_TXSHD_HELP_SECSTRU
 For PDB-files, helices are drawn <FONT color=#ff3333>red</FONT> and sheets <FONT color=#AAAA00>yellow</FONT>.
 The secondary structure information of one PDB-protein can be drawn over the alignment.
*@

@*~RSC_TXSHD_HELP_WRITE_DOT_TEX
 Writes TeXshade commands to display the predicted structure. Text lines starting with a percent sign are ignored.<BR><BR>
*@
@*~RSC_TXSHD_INFO_LOCATION
 Locations: top=above alignment  ttop=first above alignment  bottom=below alignment  bbottom=last below the alignment
*@
@*~RSC_TXSHD_WARN_NO_SECSTRU
 Tab secondary structure of TEXshade: No sequence has secondary structure information.
*@
@*SARRAYeq_SBALLON_TEXSHADE
 Delete selected files=TXSHD_but_DEL
 PostScript=TXSHD_but_PDF2PS
 Encapsulated PostScript=TXSHD_but_PS2EPS
 Scalable Vector Graphics=TXSHD_but_PDF2SVG
 Vector format for Windows=TXSHD_but_SVG2EMF
 Remove surrounding white space=TXSHD_but_PDF2PDF_CROP
 Inefficient because generated files are huge=TXSHD_but_PDF2SVG_JAVA
 You may not want to include the sequence<BR>which TeXshade retrieves the<BR>secondary structure information from.=TXSHD_ss_cbSkip
 PDF file name=TXSHD_tfName
 By giving a max and min value you can scale the plot<BR>Enter "auto" for entire range of values=TXSHD_g_tfMax
 You may substitute the<BR>names of the sequences<BR>by any latex expression=TXSHD_cbSeqNames
 protein1.swiss would be written as protein1=TXSHD_cbNoSfx
 Prevents that the PDF file gets locked under Windows. Required for AcrobatReader but not needed for Sumatra-PDF=TXSHD_cbCopyBeforeView
 Files can also be dragged to the desktop or into the file browser or into a document viewer.<BR>However be aware of file locking under Windows.=TXSHD_but_View
*@

// #define JAR_PDFBOX "pdfbox-app-2.0.8.jar"
// #define TEXSHADE_STY "texshade124.sty"
#define _txshdPredictInstV vNoClr(362)
#define _sel(id) isSlct(txshd(id))
/* (NUM1 1) */
#define TXSHD_INSTANCE_GRAPH 1
#define TXSHD_INSTANCE_SECSTRU 2
#define TXSHD_INSTANCE_PREDICT 3
/* --- */
#define _msg baNoClr(280)
#define baTmp() baClr(56)
/*X A5 A6 A7 A8 A9 B0 B1 B2 B3 B4 B5 B6 B7 B8 B9 C0 C1 C2 C3 C4 C5 C6 C7 C8 C9 USletter USlegal USexecutive*/
#define idEqTxshd(a) id==a
public final class DialogTEXshade extends javax.swing.JTabbedPane implements ChRunnable{
    private ChExec _exe;
    private static File _currentPDF;
    private final Object[]_txshd=new Object[TXSHD_ZZZ];
    private Object txshd(int id){
        Object c=_txshd[id];
        if(c==null){
            if(idEqTxshd(TXSHD_PCKG_MINIMAL)) c=isWin()?txshd(TXSHD_PCKG_PDF):cloneButPckgMinimal();
            if(idEqTxshd(TXSHD_PCKG_PDF)) c=isWin()?cloneButPckgAll():cloneButPckgPdfConversion();
            if(idEqTxshd(TXSHD_PCKG_pleaseInstall)) c=pnl("  ");
            if(idEqTxshd(TXSHD_pdf2svg_proxyObject)) c=mkInstance(0,cloadJavaClassWithJar(CLOAD_TRY_BOOT_CLASSLOADER|BUT_C1(Pdf2svg)));
            if(idEqTxshd(TXSHD_ss_helix1)||idEqTxshd(TXSHD_ss_helix2)||idEqTxshd(TXSHD_ss_sheet1)||idEqTxshd(TXSHD_ss_sheet2)) c=new ChTextField().cols(10);
            if(idEqTxshd(TXSHD_tfName)) c=new ChTextField("align").cols(20);
            if(idEqTxshd(TXSHD_g_tfMin)||idEqTxshd(TXSHD_g_tfMax)) c=new ChTextField("auto");
            if(idEqTxshd(TXSHD_frame)) c=new ChFrame("TEXshade ");
            if(idEqTxshd(TXSHD_panSrc)){
                c=pnl(VBHB,pnl(VBHB,BRDR_TITLED_EM+"Customize Source",
                               pnl(HB,
                                   buttn(CUSTOM_latexBegin),
                                   " ",buttn(CUSTOM_texshadeBegin), /*X .t("\\begin{texshade}texshade"), */
                                   " ",buttn(CUSTOM_texshadeEnd)),
                               " ",setBrdrC(BRDR_TITLED+"LaTeX code between \\begin{document} and \\begin{texshade}",txshd(TXSHD_taBefore)),
                               " ",setBrdrC(BRDR_TITLED+"LaTeX code between \\begin{texshade} and \\end{texshade}",txshd(TXSHD_taIn))),
                      setBrdrC(BRDR_TITLED+"Generated files",txshd(TXSHD_taSourceFiles)));
            }
            if(idEqTxshd(TXSHD_taBefore)||idEqTxshd(TXSHD_taIn)||idEqTxshd(TXSHD_taSourceFiles)) c=new ChTextArea("\n\n");
            if(idEqTxshd(TXSHD_panSeqName)) c=pnl(VBHB);
            //if(idEqTxshd(TXSHD_pChoiceRuler)) c=newProteinCombo(0);break;
            if(idEqTxshd(TXSHD_subfamilyProtList)) c=newProteinJlist(0);
            if(idEqTxshd(TXSHD_jListFF)){
                runCR1(RUN_NEW_DROPTARGET,_main,addActLi(this,c=new ChJList(JLIST_OPTIONS_FILES|JLIST_DEFAULT_RENDERER,_vFF)));
                pcp(KEY_DROP_ACCEPT_FILE_EXT,splitTkns(".pdf .svg"),pcp(KOPT_VIEW_FILE_ON_DOUBLE_CLICK,"",c));
            }
            if(idEqTxshd(TXSHD_tfSubfamilyName)) c=new ChTextField().cols(TF_NOT_MAXIMIZE|30);
            {
                String save=iConst(SARRAY_PRPRTY_ID,id),n;
                if((n=iConst(SARRAYeq_TXSHD_BUT_TITLE,id))!=null){
                    c=new ChButton(0,n);
                }else if((n=id==TXSHD_ss_sheetType?"--- box === --> '-> <-| <=> ,-, |=| helix":iConst(SARRAYeq_TXSHD_COMBO,id))!=null){
                    c=new ChJCombo(JCOMBO_SET_PROTOTYPE,splitTkns(n)).savePrprty(save==null?-1:id);
                }else if((n=iConst(SARRAYeq_TXSHD_CB,id))!=null){
                    c=(chrAt(0,n)=='^'?new ChButton(IF_WINDOWS(isWin()?BUTTN_CB_ON:)BUTTN_CB,n.substring(1),this):new ChButton(BUTTN_CB,n,this)).savePrprty(save==null?-1:id);
                }
                if((n=iConst(SARRAYeq_TXSHD_TF,id))!=null){
                    final int ct=!xisChrClass(DIGT,n,0)?0:n.indexOf('.')>0?TF_CONTENTTYPE_FLOAT:TF_CONTENTTYPE_UINT;
                    c=new ChTextField(n.replace('x',' ')).cols(maxi(sze(n),ct==TF_CONTENTTYPE_UINT?5:6)|ct).saveInFile(newFile(iFile(DIR_TEX_SAVE),save));
                }
                if((n=iConst(SARRAYeq_TXSHD_TF_IF_EMPTY,id))!=null) pcp(KEY_IF_EMPTY,n,c);
            }

            if(null!=iConst(SARRAYeq_TXSHD_SAVE_INT_FILE,id)){
                if(c!=null) tcTools(c).saveInFile(newFile(iFile(DIR_TEX_SAVE),iConst(SARRAYeq_TXSHD_SAVE_INT_FILE,id)));
                IF_MEIN_DEBUG(else baOut(RED_ERROR).aa(" TEXshade c=null id=",id).aln());;
            }
            if(c instanceof javax.swing.AbstractButton) addActLi(this,c);
            setTip(iConst(SARRAYeq_SBALLON_TEXSHADE,id),c);
            _txshd[id]=c;
        }
        return c;
    }
    private static ResidueAnnotation _oneAnno;
    private final DialogTEXshade[]_resGraph=new DialogTEXshade[4],_vapGraph=new DialogTEXshade[4],_secGraph=new DialogTEXshade[4];
/* <<<  <<< */
/* ---------------------------------------- */
/* >>> Constructor >>> */
    OVERRIDE_PUBLIC java.awt.Dimension getMinimumSize(){return dim(0,0);}
    private final java.util.Collection _vFF=new java.util.ArrayList();
    public DialogTEXshade(){
        _graphInterf=_instanceType=_location=0;
        _choiceP=null;
        txshd(TXSHD_frame);/*X Otherwise !EDT*/
        ROFt0(4){
            _vapGraph[t]=new DialogTEXshade(TXSHD_INSTANCE_GRAPH,t+1,INTRFC_ValueOfAlignPosition);
            _resGraph[t]=new DialogTEXshade(TXSHD_INSTANCE_GRAPH,t+1,INTRFC_ValueOfResidue);
            _secGraph[t]=new DialogTEXshade(TXSHD_INSTANCE_SECSTRU,t+1,-1);
        }
        //_delFF(true);
        {
            final Object
                details=pnl(CNSEW,txshd(TXSHD_tfGeometry),
                            pnl(txshd(TXSHD_BUT_SRC)),
                            pnl(buttn(BUTS_CUSTOMIZE_LaTeX)),
                            "]{geometry}","\\usepackage[",BRDR_TITLED+"Options"),
                north=pnl(pnl(VBHB,
                              dialogHead(this),
                              txshd(TXSHD_PCKG_pleaseInstall),
                              buttn(SBUT_WARN_MARCHING_ANTS),
                              " ",pnl(HBL,pnlTogglOpts(TOGGL_PNL_MoreOptions,details)),
                              details,
                              pnl(HBL,"Paper size=",txshdSaved(TXSHD_choiceSize)," ",txshd(TXSHD_cbLandscape)," ",txshd(TXSHD_cbNoMargin),"  Residues per line=",txshd(TXSHD_tfResPerLine)),
                              pnl(HBL,"Output file=",txshd(TXSHD_tfName)," ",txshd(TXSHD_but_TEX2PDF)),
                              " ",txshd(TXSHD_cbCopyBeforeView))),
                convert=pnl(GRIDLAYOUT(6,1),
                            "Typical Workflow: Split pages > Crop > SVG > EMF/GIF > Insert in MS-Word",
                            pnl(txshd(TXSHD_but_PDF2PDF_CROP)),
                            pnl(txshd(TXSHD_but_PDF2SVG),
                                //isWin()?null:pnl(txshd(TXSHD_but_PDF2SVG_INKSCAPE),
                                txshd(TXSHD_but_PDF2SVG_JAVA),"SVG for LibreOffice, HTML"),
                            pnl(txshd(TXSHD_but_SVG2EMF)," EMF for MS-Word"),
                            pnl(txshd(TXSHD_but_SVG2GIF),"  pixels/inch=",txshd(TXSHD_tfGifQuality),"  GIF raster graphics"),
                            pnl(txshd(TXSHD_but_PDF2PS),txshd(TXSHD_but_PDF_TO_PS),txshd(TXSHD_but_PS2EPS))),
                buttons=pnl(VB,pnl(txshd(TXSHD_but_View),txshd(TXSHD_but_SPLIT),txshd(TXSHD_but_DEL)),pnlTogglOpts(TOGGL_PNL_ConvertGraphics,convert),convert);
            adMainTab(pnl(CNSEW,pnl(CNSEW,scrllpn(0,txshd(TXSHD_jListFF)),null,null,buttons),north),this);
        }
        adTab(0,"Structure",
              pnl(pnl(VBHB,
                      rsc(RSC_TXSHD_INFO_LOCATION),
                      pnl(HB,"<H2>Secondary structure</H2>","#",buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_SECSTRU)),
                      " ",
                      _secGraph[0].secstruPnl(),"#JS",
                      _secGraph[1].secstruPnl(),"#JS",
                      _secGraph[2].secstruPnl(),"#JS",
                      _secGraph[3].secstruPnl())),this);
        adTab(0,"Sequence names",
              pnl(pnl(VBHB,
                      pnl(HB,"<H2>Substitute sequence name</H2>","#",buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_SUBSTITUTE_NAMES)),
                      txshdSaved(TXSHD_cbSeqNames),
                      txshdSaved(TXSHD_cbNoSfx))),
              this);

        adTab(0,"Plot",
              pnl(pnl(VBHB,
                      pnl(HB,"<H2>Plotting values of sequence positions</H2>","#",buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_BARCHART)),
                      rsc(RSC_TXSHD_INFO_LOCATION),
                      pnl(HBL,"Bargraphstretch=",new ChTextField(((ChTextField)txshd(TXSHD_tfBarstretch)).getDocument())),
                      " ",
                      _resGraph[0]._graphMainPnl(),"#JS",
                      _resGraph[1]._graphMainPnl(),"#JS",
                      _resGraph[2]._graphMainPnl(),"#JS",
                      _resGraph[3]._graphMainPnl())),this);

        adTab(0,"Plot",
              pnl(pnl(VBHB,
                      pnl(HB,"<H2>Plotting values of alignment positions (\"consensus\")</H2>","#",buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_BARCHART)),
                      rsc(RSC_TXSHD_INFO_LOCATION),
                      pnl(HBL,"Bargraphstretch=",txshd(TXSHD_tfBarstretch)),
                      " ",
                      _vapGraph[0]._graphMainPnl(),"#JS",
                      _vapGraph[1]._graphMainPnl(),"#JS",
                      _vapGraph[2]._graphMainPnl(),"#JS",
                      _vapGraph[3]._graphMainPnl())),this);
        adTab(0,"Appearance",pnl(pnl(VBHB,
                                     "<H2>Appearance of the Alignment</H2>",
                                     pnl(HBL,"Shading Mode",txshdSaved(TXSHD_choiceShading)),
                                     pnl(HBL,"Sequence name",txshdSaved(TXSHD_choiceShowNames)),
                                     " ",
                                     pnl(HBL,"Residue numbers",txshdSaved(TXSHD_choiceNumbering)),
                                     " ",
                                     pnl(HBL,"Vertical block space ",txshd(TXSHD_tfVbspace),"mm"),
                                     pnl(HBL,txshdSaved(TXSHD_cbFinger),txshdSaved(TXSHD_cbHideLegend)),
                                     pnl(HBL,"Consensus",txshdSaved(TXSHD_choiceConsensus),txshdSaved(TXSHD_choiceConsensusL),txshdSaved(TXSHD_cbNoConsens)),
                                     pnl(HBL,"Style for emphblock and emphregion: ",txshdSaved(TXSHD_choiceEmph)),
                                     txshdSaved(TXSHD_cbSeparation),
                                     txshd(TXSHD_cbUpperCase))),this);
        adTab(0,"Logo",remainSpcS(pnl(),pnl(VBHB,
                                      pnl(HB,"<H2>Simple Sequence Logo</H2>","#",buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_SEQ_LOGO)),
                                      pnl("Location=",txshdSaved(TXSHD_choiceSeqLogo)," ",txshd(TXSHD_cbHideSeqs)," ",txshdSaved(TXSHD_cbDoFreqCorrect)),
                                      " ","#JS",
                                      "<H2>Subfamily Logo</H2>",
                                      pnl("Location=",txshdSaved(TXSHD_choiceSubfamilyL),"  Name=",txshd(TXSHD_tfSubfamilyName)),
                                      "##",
                                      scrllpn(SCRLLPN_INHERIT_SIZE,txshd(TXSHD_subfamilyProtList)))),this);

        setSelIdx(0,this);
        runCR(_RUN_TEX_ENABLE,this);
        txshd(TXSHD_PCKG_PDF);
        txshd(TXSHD_PCKG_MINIMAL);
        thrdCR(RUN_TEX_PCKG_BASE|THRDCR_START,this);
        thrdCR(RUN_TEX_PCKG_RECOMMENDED|THRDCR_START,this);

    }
/* <<< Constructor <<< */
/* ---------------------------------------- */
/* >>> Src and MSF >>> */
    private void makeMsfAndSource(int colFrom,int colTo,Protein[]pp){
        clr(_msg);
        {
            final Object[]para=new Object[ALIWR_PARA_ZZZ];
            para[ALIWR_PARA_COL_RANGE]=new int[]{colFrom,colTo};
            wrte(iFile(F_TXSHD_MSF),strapInstance(ALIWR_MSF).getAliText(_sel(TXSHD_cbNoSfx)?ALIWR_FILE_SUFFIX:0,pp,para));
        }
        final BA tex=new BA(0).joinLns(custSettings(CUSTOM_latexBegin)).aln().replace(0,"{texshade}",baTmp().a('{').aWithoutLstCmpnt('.',nam(iFile(F_TXSHD_STY))).a('}'))
            .aa("\\usepackage[",lCase(txshd(TXSHD_choiceSize)),"paper");
        if(_sel(TXSHD_cbLandscape)) tex.a(",landscape");
        if(_sel(TXSHD_cbNoMargin))  tex.a(",left=1mm,right=1mm");
        tex.aa(',',toStrgTrim(txshd(TXSHD_tfGeometry))).del(',').aa("]{geometry}\n","\\begin{document}\n")
            .aln(txshd(TXSHD_taBefore))
            .joinLns(custSettings(CUSTOM_texshadeBegin))
            .aln(txshd(TXSHD_taIn));
        if(getSlctIdx(txshd(TXSHD_choiceShowNames))!=2) tex.aa("\n\\shownames{",txshd(TXSHD_choiceShowNames)).aln("}"); else tex.aln("\\hidenames");
        tex.aa("\\emphdefault{",txshd(TXSHD_choiceEmph)).aln("}");
        if(getSlctIdx(txshd(TXSHD_choiceNumbering))!=2) tex.aa("\n\\shownumbering{",txshd(TXSHD_choiceNumbering)).aln("}"); else tex.aln("\\hidenumbering");
        tex.aa("\\vblockspace{",txshd(TXSHD_tfVbspace)).aln("mm}")
            .aa("\\bargraphstretch{",txshd(TXSHD_tfBarstretch)).aln("}")
            .aln((_sel(TXSHD_cbHideLegend)?"\\hidelegend": "\\showlegend"));
        if(_sel(TXSHD_cbSeparation)) tex.aPlrl(pp.length,"\\separationline{%n}");
        if(_sel(TXSHD_cbNoConsens)) tex.aln("\\hideconsensus");
        if(getSlctIdx(txshd(TXSHD_choiceConsensusL))>0){
            tex.aa("\\defconsensus{{$\\bullet$}}{{$\\bullet$}}{{$\\bullet$}} \\showconsensus[",txshd(TXSHD_choiceConsensus),"]{",txshd(TXSHD_choiceConsensusL)).aln("}");
        }
        if(_sel(TXSHD_cbFinger)) tex.aPlrl(maxi(30,(colTo-colFrom+1)),"\\fingerprint{%n}\n");
        {
            final int n=xatoi(txshd(TXSHD_tfResPerLine));
            if(n>1) tex.aPlrl(n,"\\residuesperline*{%n}\n");
        }
        tex.aa(nameseq(pp),"\n\n% The setlength commands do not change the output, but may enhance speed\n");
        {
            boolean[]bbCrop=null;
            FORiP(0,pp.length){
                final Protein p=pp[iP];
                final int idx0=firstResIdx(p),aFrom=idx0+p.columnToIndex(CTRUE,colFrom);
                if(aFrom!=0) tex.aa("\\startnumber{",iP+1,"}{",aFrom+1).aln("}");
                if(!_sel(TXSHD_cbUpperCase)){
                    final byte[]seq=p.getResType();
                    boolean[]lc=null;
                    ROFi0(seq.length){
                        if(isChrClas(LOWR,seq,i)) (lc==null?lc=new boolean[i+1]: lc)[i]=true;
                    }
                    if(lc!=null) tex.aa("\\lowerregion{",iP+1,"}{",texshadeRange(lc,idx0)).aln("}");
                }
                for(ResidueAnnotation s:p.residueAnnotations()){
                    if(_oneAnno!=null) s=_oneAnno;
                    final boolean[]bb=s.getSelectedAminoacids();
                    final int lstTrue=lstTrue(bb),offset=s.getSelectedAminoacidsOffset();
                    if(lstTrue<0) continue;
                    {
                        bbCrop=redim(bbCrop,lstTrue+1,33|REDIM_CLEAR_ARRAY);
                        boolean selected=false;
                        final int I=mini(lstTrue+offset+1,p.countRes()+idx0,p.columnToIndex(CFALSE,colTo)+idx0+1);
                        FORi(maxi(offset,aFrom),I) if(bb[i-offset]) bbCrop[i-offset]=selected=true;
                        if(!selected) continue;
                    }
                    for(ResidueAnnotation.Entry e:s.entries()){
                        if(e.isEnabled() && IRESAN_TEXSHADE==e._ki) tex.a(resSelReplaceVariableBB(e.value(),bbCrop,offset,orS(s.getName(),"")
                                                                                                  .replaceAll(REGEX_NO_FILE_NAME," ").replace('_',' '),p,pp)).a(" % ").aln(p);
                    }
                    if(_oneAnno!=null) break;
                }
            }
        }
        tex.aa("\n\\threshold{",pp.length==1?333:maxi(0,intValueC(_sliderSimilarity))).aln("}");
        {
            final String shade=lCase(comboColorScheme(0));
            final int i=getSlctIdx(txshd(TXSHD_choiceShading));
            if(i==0 && strstr(STR_w,shade,"charge hydropathy chemical")>=0) tex.aa("\\shadingmode[",shade,"]{functional}\n");
            else if(i>0) tex.aa("\\shadingmode{",txshd(TXSHD_choiceShading)).aln("}");
        }
        if(_oneAnno==null){
            if(getSlctIdx(txshd(TXSHD_choiceSeqLogo))!=0 || getSlctIdx(txshd(TXSHD_choiceSubfamilyL))!=0){
                if(_sel(TXSHD_cbHideSeqs)) tex.aln("\\hideseqs");
                if(_sel(TXSHD_cbDoFreqCorrect)) tex.aln("\\dofrequencycorrection");
            }
            if(getSlctIdx(txshd(TXSHD_choiceSeqLogo))!=0) tex.aa("\\showsequencelogo{",txshd(TXSHD_choiceSeqLogo)).aln("} \\showlogoscale{leftright}");
            ROFt0(4){
                _resGraph[t]._graphMakeTex(tex,colFrom,colTo,pp);
                _vapGraph[t]._graphMakeTex(tex,colFrom,colTo,pp);
                _secGraph[t]._secstruMakeTex(tex,colFrom,colTo,pp);
            }
            FORj(0,sze(_txshdPredictInstV)){
                final DialogTEXshade d=(DialogTEXshade)iThElRmNull(j,_txshdPredictInstV);
                if(d!=null&&isSlct(d._toggle)) d._predictMakeTex(pp,j,tex);
            }
        }
        subfamily_makeTex(tex,pp);
        tex.aln().joinLns(custSettings(CUSTOM_texshadeEnd)).aln("\n\\end{document}");
        wrte(iFile(F_TXSHD_TEX),tex);
        runCR(_RUN_TEX_ENABLE,this);
    }
/* <<< Src and MSF <<< */
/* ---------------------------------------- */
/* >>> Threading >>> */
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(_RUN_TEX_ENABLE)
//              REFLECTION_PUBLIC_VOID _enable(){
                if(!isEDT()) thrdCR(_RUN_TEX_ENABLE|THRDCR_EDT_LATER,this);
                else{
                    setEnbld(null!=selItemJC(txshd(TXSHD_jListFF)),txshd(TXSHD_but_DEL));
                    setEnbld(sze(_vFF)>0,txshd(TXSHD_but_View));
                    FORi(0,TXSHD_but_ZZZ){
                        if(i!=TXSHD_but_DEL&&i!=TXSHD_but_TEX2PDF&&i!=TXSHD_but_View&&txshd(i)!=null) setEnbld(oneFileInList(i)!=null,txshd(i));
                    }
                    awtc(AWTC_REVALAND_REPAINT_MAYBE,txshd(TXSHD_jListFF));
                }
            break;
            CASE_ARGV(RUN_TEX_PCKG_RECOMMENDED)
                CASE_ARGV(RUN_TEX_PCKG_BASE)
                if(!pckgIsInstalled(id==RUN_TEX_PCKG_RECOMMENDED?PCKG_META_PDF:PCKG_META_BASE)){
                    final Object c=txshd(TXSHD_PCKG_pleaseInstall);
                    toContainrC(TOCONTAINR_FST,txshd(TXSHD_PCKG_MINIMAL),c);
                    if(id==RUN_TEX_PCKG_RECOMMENDED) toContainrC(TOCONTAINR_FST,txshd(TXSHD_PCKG_PDF),c);
                    setSmallButtonXc(-EM,pcp(RNDRER_KEY_TO_CLOSE,c,setBG(0xFF0000,c)));
                    amsDo(AMS_REVALIDATE,1111,c,null);
                }
            break;
            CASE_ARG(RUN_TEX_GET_PREDICTION,Object,parent){
                final Object pnl=pnl(CNSEW,
                                     _predictTA=new ChTextArea(5,80),
                                     pnl(buttn(BUT_C1(DialogTEXshade)).t("Open PDF Dialog"),buttn(BUTTN_CLASS_HELP_SMALL|RSC_TXSHD_HELP_WRITE_DOT_TEX)),
                                     null,null,BRDR_TITLED+"TeXshade -- generating PDF -- only the first selected sequence");
                setTxt(rsc(RSC_TXSHD_PREDICT_DEFAULT_TEX_CODE),_predictTA);
                pnl(parent,CNSEW,null,pnl(HBL,_toggle=new ChButton(BUTTN_CB,"Show in PDF export").cp(BUTTN_KEY_COLLAPSE,pnl)),pnl);
                BREAK;
            }
            CASE_ARGV(RUN_DISPOSE) dispos(_exe);return TRUEr;
            CASE_ARG(RUN_IS_OBJECT_ENABLED,Object,o){
                if(_instanceType==TXSHD_INSTANCE_GRAPH) return o==null?FALSEr: runCR1(RUN_IS_OBJECT_ENABLED,_graphVor,o);
                BREAK;
            }
            CASE_ARGV(RUN_TXSHD_PROCESS_FILE,int,bidParameter,File[],ff){
                final int bid=bidParameter;
                setIcn(IC_RUNNING,txshd(bid));
                for(File f:ff){
                    if(f==null)continue;
                    if(bid==TXSHD_but_SPLIT) adAllUniq((Object[])runCR1(RUN_PROXY_PDF_SPLIT_PAGES,txshd(TXSHD_pdf2svg_proxyObject),f),_vFF);
                    else if(bid==TXSHD_but_PDF2SVG_JAVA) adAllUniq((Object[])runCR1(RUN_PROXY_PDF2SVG,txshd(TXSHD_pdf2svg_proxyObject),f),_vFF);
                    else{
                        final File out=file(bid==TXSHD_but_SVG2EMF?addSfx(".emf",f): new BA(99).a(f).del(iConst(SARRAYeq_TXSHD_BID_TO_INFILESFX,bid)).a(iConst(SARRAYeq_TXSHD_BID_TO_OUTFILESFX,bid)));
                        if(bid!=TXSHD_but_View) fileDel(0,out);
                        final ChExec ex=new ChExec(EXEC_RESET_SEARCH_PATH|EXEC_AWT_CTRL|EXEC_STDERR|EXEC_STDOUT|EXEC_WRITE_INSTALLER);
                        if(bid==TXSHD_but_PDF2PDF_CROP){
                            ex.needPckg(PCKG_pdfcrop).needPckg(PCKG_perl).addCmdV(new Object[]{"pdfcrop",f,out});
                            if(isWin()){
                                ex.addEnv("HOME",iFile(F_PRPRTY_SYS_USER_HOME));
                                final File fPerl=findExe(0,"perl.exe");
                                if(fPerl!=null) ex.addEnv("PATH",new BA(999).a(prprty(ENV_PATH)).a1(';').a(fPerl.getParentFile()));
                                else ex.addHint(rsc(RSC_HINT_PERL_FOR_PDFCROP));
                            }
                            _runExe(bid,ex,null);
                        }
#if CPP_DEACTIVATED
@*SARRAY_TXSHD_CMD_SMARTCROP
                         me.jamespan.tech.smartcrop.shell.Main|crop|--input
*@
                        if(bid==TXSHD_but_CROP_JAVA_MK){
                            txshd(TXSHD_pdf2svg_proxyObject);/*X Loading pdfbox.jar */
                            _runExe(bid,ex.addCmdV(iFile(F_JAVA_EXE),
                                                   "-cp",
                                                   iPath2(PDFBOX_JAR,s(isWin()?';':':')).a(jarFileFromStrapUrl(F_SMART_CROP_CLI_WITHOUT_PDFBOX_JAR)),
                                                   arry(SARRAY_TXSHD_CMD_SMARTCROP),f,"--output",out),null);
                        }
                        if(bid==TXSHD_but_PDF2SVG_INKSCAPE && sze(out)==0) _runExe(bid,ex.addCmdV(splitTkns("inkscape -z -l"),out,f).needPckg(isPrprty(IS_LINUX)?"inkscape":iUrl(iURL_INKSCAPE)),null);
#endif //CPP_DEACTIVATED
                        if(bid==TXSHD_but_PDF2PS) _runExe(bid,ex.needPckg(PCKG_ghostscript).addCmdV(new Object[]{"pdf2ps",f,out}),null);
                        if(bid==TXSHD_but_PDF_TO_PS) _runExe(bid,ex.needPckg(PCKG_poppler).addCmdV(new Object[]{"pdftops",f,out}),null);
                        if(bid==TXSHD_but_PDF2SVG){
                            Object a0=null;
                            if(isWin() && null==findExe(0,"pdf2svg") && sze(a0=new BasicExecutable(BUT_C1(BEXEC_pdf2svg)).fileExecutable())==0) a0=null;
                            _runExe(bid,ex.needPckg(PCKG_pdf2svg).addCmdV(new Object[]{orO(a0,"pdf2svg"),f,out}),null);
                        }
                        if(bid==TXSHD_but_SVG2EMF) _runExe(bid,ex.setDir(iFile(DIR_TXSHD)).addCmdV(new Object[]{jarFileFromStrapUrl(F_SVG2EMF_JAR),f}),null);
                        if(bid==TXSHD_but_SVG2GIF) _runExe(bid,ex.setDir(iFile(DIR_TXSHD)).needPckg(PCKG_imagemagick).addCmdV(new Object[]{splitTkns("convert -density"),toStrgTrim(txshd(TXSHD_tfGifQuality)),f,out}),null);

                        if(bid==TXSHD_but_PS2EPS){
                            interactiveDownloadFiles(null,new java.net.URL[]{url(baTmp().aa(iUrl(iURL_STRAP_DATAFILES_SLASH),nam(iFile(F_PS2EPS_PERL)),".gz"))},new File[]{iFile(F_PS2EPS_PERL)});
                            _runExe(bid,ex.needPckg(PCKG_perl).addCmdV(new Object[]{iFile(F_PS2EPS_PERL),f,out}),null);
                        }
                        if(sze(out)>0) adUniq(out,_vFF);
                    }
                }
                runCR(_RUN_TEX_ENABLE,this);
                setIcn(null,txshd(bid));
                BREAK;
            }
            CASE_ARG(RUN_TXSHD_TEX,int,bid){
                final boolean[]stop={false};
                fileDel(0,iFile(F_TXSHD_PDF));
                _pdflatexFile(iFile(F_TXSHD_TEX),stop,bid,(awtActEvtModi()&SHIFT_MASK)!=0?0:EXEC_RUN_TWICE);
                if(sze(iFile(F_TXSHD_PDF))==0) thrdCR(RUN_TXSHD_ERROR|THRDCR_EDT_LATER,this);
                else{
                    cpy(iFile(F_TXSHD_PDF),_currentPDF=newFile(iFile(DIR_TXSHD),addPfx(orS(delSfx(".pdf",toStrgTrim(txshd(TXSHD_tfName))),"align"),".pdf")));
                    adUniq(_currentPDF,_vFF);
                }
                runCR(_RUN_TEX_ENABLE,this);
                setIcn(null,txshd(bid));
                BREAK;
            }
            CASE_ARG(RUN_TEX_ONE_RESAN,ResidueAnnotation,a){
                if(sp(_oneAnno=a)!=null){
                    makeMsfAndSource(0,MAX_INT,spp(_oneAnno));
                    thrdCR1(RUN_TXSHD_TEX|THRDCR_RUN,this,io(0));
                    _viewFile(_currentPDF);
                }
                _oneAnno=null;
                BREAK;
            }
            CASE_ARGV(RUN_TXSHD_ERROR){
                final BA sLog=readBytes(iFile(F_TXSHD_LOG));
                if(strstr(STR_IC,"capacity exceeded",sLog)>=0) shwErrorC("LaTeX ERROR",rsc(RSC_TXSHD_INFO_MEMORY));
                BREAK;
            }
#define q evtSrc(ev)
            CASE_ARG(RUN_M_actionPerformed,Object,ev){
                final int bid=idxOf(q,_txshd);
                if(_instanceType==TXSHD_INSTANCE_GRAPH){
                    if(q==_choiceP || q==_graphPP) _graphReplaceSeqs();
                    if(q==_graphChoiceClass) _graphReplaceInstance();
                    if(bid==TXSHD_g_butOtherSeq) shwTxtInW(FRAME_AT_CLICK,"Sequences",_graphPP==null?_graphPP=addActLi(this,newProteinJlist(0)):_graphPP);
                }else{
                    if(bid==TXSHD_jListFF) runCR(_RUN_TEX_ENABLE,this);
                    if(bid==TXSHD_cbSeqNames && isSlct(q)) showTexshadeNameseq();
                    if(bid==TXSHD_BUT_SRC||bid==TXSHD_but_TEX2PDF){
                        Protein[]pp=ppInRectangleForAlignment(1);
                        if(sze(pp)==0) baLog(LOG_MSG).a(RED_ERROR).aln("No sequence");
                        else{
                            final int[]r=rectRubberBand();
                            makeMsfAndSource(x(r),r!=null?x2(r): MAX_INT,pp);
                            setTxt(new BA(333).a("Generated Multiple Sequence file: \n ").aFile(iFile(F_TXSHD_MSF)).a("\n\n Genereated LaTeX-file:\n ").aFile(iFile(F_TXSHD_TEX)).aln(),txshd(TXSHD_taSourceFiles));
                            awtc(AWTC_SET_NOT_EDITABLE,undrlneRefs(0,txshd(TXSHD_taSourceFiles)));
                            if(bid==TXSHD_BUT_SRC) ChFrame.frame(0,"TEXshade ",txshd(TXSHD_panSrc)).shw(CLOSE_CtrlW_ESC);
                            else if(sze(iFile(F_TXSHD_TEX))>0 && sze(iFile(F_TXSHD_MSF))>0){
                                for(Object stop:oo(gcp(KEY_RUNNING_EXE,q))){
                                    if(stop instanceof boolean[]) ((boolean[])stop)[0]=true;
                                    else runCR(RUN_DISPOSE,stop);
                                }
                                setIcn(IC_RUNNING,q);
                                thrdCR1(RUN_TXSHD_TEX|THRDCR_START,this,io(bid));
                            }
                        }
                    }
/* if(bid==TXSHD_BUT_MEM){ */
/*     final File fOri=file(addSfx(".original",iFile(F_CYGWIN_TEXMF_CNF))); */
/*     if(sze(fOri)==0) cpy(iFile(F_CYGWIN_TEXMF_CNF),fOri); */
/*     { */
/*         final String[]ss=readLns(iFile(F_CYGWIN_TEXMF_CNF)); */
/*         if(ss==null) return null; */
/*         ROFi0(ss.length){ */
/*             final String s=ss[i].trim(); */
/*             if(chrAt(0,s)!='%'){ */
/*                 if(s.endsWith("00")) {ss[i]=addPfx(s,"00"); continue;} */
/*                 int idx00=s.indexOf("00 "); */
/*                 if(idx00>=0 || (idx00=s.indexOf("00\t"))>=0) ss[i]=s(baTmp().aFT(s,0,idx00+2).a("00").aFT(s,idx00+2,MAX_INT)); */
/*             } */
/*         } */
/*         wrte(iFile(F_CYGWIN_TEXMF_CNF),baTmp().joinLns(ss).aln("\n\n Modified by Strap")); */
/*     } */
/*     final ChExec ex=new ChExec(EXEC_AWT_CTRL).addCmdV(arry(SARRAY_TXSHD_CMD_FMTUTILS)); */
/*     runCR1(RUN_EXEC_SET_FRAME_FOR_OUTPUT,ex,txshd(TXSHD_frame)); */
/*     startThrd(ex); */
/*     dlgShowMsg(pnl(VBPNL,"fmtutil",pnl(VBPNL,pnl("I modified the file ",fOri," ==> ",iFile(F_CYGWIN_TEXMF_CNF)),"Please wait for the fmtutil to finish and then try again."))); */
/* } */
                    if(bid==TXSHD_but_View) _viewFile(oneFileInList(TXSHD_but_View));
                    if(0<bid&&bid<TXSHD_but_ZZZ){
                        File[]ff=selFiles(txshd(TXSHD_jListFF));
/* First take selected files. */
/* If none then take last file of required type. */
                        ROFi0(ff.length){
                            if(ff[i]!=null){
                                if(bid==TXSHD_but_DEL) rmElmntFromV(fileDel(0,ff[i]),_vFF);
                                if(!strEnds(iConst(SARRAYeq_TXSHD_BID_TO_INFILESFX,bid),ff[i])) ff[i]=null;
                            }
                        }
                        if(bid!=TXSHD_but_DEL){
                            if(fstNotNull(ff)!=null || fstNotNull(ff=new File[]{oneFileInList(bid)})!=null) thrdCR(RUN_TXSHD_PROCESS_FILE|THRDCR_START,this,io(bid),ff);
                        }
                        runCR(_RUN_TEX_ENABLE,this);
                    }
                }
                BREAK;
            }
        }
        return null;
    }
    private String nameseq(Protein[]pp){
        final BA sb=new BA(999);
        FORiP(0,pp.length){
            final Object newName=!_sel(TXSHD_cbSeqNames)?null: readBytes(baTmp().aa(DIRNAME_ANNOTATIONS,'/',pp[iP],".texName"));
            if(nxt(0,chrClas(-SPC),newName)>=0) sb.aa("\\nameseq{",iP+1,"}{",newName,"} % ").aln(pp[iP]);
        }
        return s(sb);
    }
    private int _addedPleaseInstall;
    private void _runExe(int button,ChExec ex,boolean[]stop){
        _awtSetEvt(txshd(button));
        pcp(KEY_RUNNING_EXE,new Object[]{stop,ex},txshd(button));
        runCR1(RUN_EXEC_SET_FRAME_FOR_OUTPUT,ex,txshd(TXSHD_frame));
        ex.run();
        if(ex.exitValue()!=0 && _addedPleaseInstall++==0) thrdCR(RUN_TEX_PCKG_RECOMMENDED|THRDCR_EDT_LATER,this);
    }
/* <<< nameseq <<< */
/* ---------------------------------------- */
/* >>> subfamilyLogo >>> */
    private BA subfamily_makeTex(BA sb,Protein[]ppDefault){
        if(getSlctIdx(txshd(TXSHD_choiceSubfamilyL))==0) return sb;
        Protein[]pp=spp(txshd(TXSHD_subfamilyProtList));
        if(ARRAY_EMPTY(pp)) pp=ppDefault;
        sb.a("\n\\setsubfamily{");
        for(Protein p:pp){
            final int idx=idxOf(p,ppDefault);
            if(idx>=0) sb.aa(idx+1,',');
        }
        return sb.del(',').aa("}","\n\\showsubfamilylogo{",txshd(TXSHD_choiceSubfamilyL),"}\n\\showlogoscale{leftright}\n\\namesubfamilylogo[others]{",txshd(TXSHD_tfSubfamilyName)).aln("}");
    }
/* --- NameSeq --- */
    private void showTexshadeNameseq(){
        Protein[]pp=selectedProteins();
        if(pp.length==0 && 0==(pp=strapVisibleProteins()).length) return;

        toContainrC(0,pnl(HBL,"<H2>Change displayed sequence names</H2>Warning: Unquoted underscores '_' lead to LaTeX-errors.<BR>"),awtc(AWTC_REMOVE_ALL,txshd(TXSHD_panSeqName)));
        for(Protein p:pp){
            Object pan=gcp(_TEXSHADE_KEY_PAN_NAMES,p);
            if(pan==null){
                final ChTextField tf=new ChTextField();
                tcTools(tf).saveInFile(newFile(iFile(DIR_ANNOTATIONS),addSfx(".texName",p)));
                setPrefSze(80*EM,ICON_HGT+2,pan=pnl(HB,nam(p)," ",tf));
                pcp(_TEXSHADE_KEY_PAN_NAMES,pan,p);
            }
            toContainrC(0,pan,txshd(TXSHD_panSeqName));
        }
        ChFrame.frame(FRAME_SCROLLPANE,"Substitute names",txshd(TXSHD_panSeqName)).shw();
    }
/* <<< subfamilyLogo <<< */
/* ---------------------------------------- */
/* >>> Utils >>> */
#if CPP_DEACTIVATED
    public static void ps2eps(File ps,File eps)throws IOException{
        if(sze(ps)==0) return;
        final ChInStream cis=new ChInStream(ps,9999);
        final BA line=new BA(9999);
        final OutputStream os=fOutStrm(0,eps);
        line.aln("%!PS-Adobe-2.0 EPSF-2.0").write(os);
        int count=0;
@*~RSC_TXSHD_WARN_NO_PS_ADOBE
         PS-File  does not start with %!PS-Adobe
*@
        while(cis.readLine(clr(line))){
            if(count++==0){
                if(!strStarts("%!PS-Adobe",line)) baOut(RED_WARNING).a(rsc(RSC_TXSHD_WARN_NO_PS_ADOBE)).aln(ps);
            }else line.aln().write(os);
        }
        closeStrm(os);
        closeStrm(cis);
    }
#endif //CPP_DEACTIVATED
@*SARRAY_TXSHD_CMD_PDFLATEX
     pdflatex|--interaction=nonstopmode
*@
    private void _pdflatexFile(File f,boolean[]stop,int bid,int opt){
        final ChExec ex=_exe=new ChExec(EXEC_RESET_SEARCH_PATH|EXEC_DEBUG|EXEC_AWT_CTRL|EXEC_STDOUT|EXEC_WRITE_INSTALLER|opt).needPckg(PCKG_latex_base).setDir(iFile(DIR_TXSHD));
        ex.out(EXEC_OUT_CREATE|EXEC_FIELD_ERR).a(_msg);
        ex.addCmdV(new Object[]{arry(SARRAY_TXSHD_CMD_PDFLATEX),nam(f)});
        if(!stop[0]) _runExe(bid,ex,stop);
    }
    //DIR_CYGWIN DIR_MINGW
    private File oneFileInList(int bid){
        if(bid==TXSHD_but_View) return(File)lstEl(_vFF);
        final String ext=iConst(SARRAYeq_TXSHD_BID_TO_INFILESFX,bid);
        if(ext==null) return null;
        ROFi0(sze(_vFF)){
            final Object f=xiThEl(i,_vFF);
            if(f instanceof File && strEnds(ext,f) && fileExsts(f)) return(File)f;
        }
        return null;
    }
    private void _viewFile(File f){
        if(_sel(TXSHD_cbCopyBeforeView) && strEnds(".pdf",f)){
            final File tmp=file(NEWFILE_TMPFILE_WITH_EXT,lstCmpnt('.',f));
            cpy(f,tmp);
            if(sze(tmp)==sze(f)) f=tmp;
            else baOut(RED_WARNING).a("TEXshade ").aFile(f).a(" copy=").aFile(tmp).aln();
        }
        viewFile(f);
    }

//    public static Object[]inCmdSetPath(Object...cmd){if(isWin()) cmd[0]=wrte(WRTE_IF_HC,newFile(iFile(DIR_BIN_MISC),addSfx(".bat",cmd[0])),new BA(333).a("set PATH=").join(';',exeSearchPath()).aln().a(cmd[0]).aln(" %*"));return cmd;}
@*RSC_HINT_PERL_FOR_PDFCROP
     @F pdfcrop requires PERL.
     PERL from Mingw and MSYS2 will be added to the search path automatically.
     All other PERL installations, must be in the search path.
     Rtools does not have PERL.
*@
/* <<< Utils <<< */
/* ---------------------------------------- */
/* >>> TexshadeGraph and TexshadeSecStructure >>> */
    private final int _location,_graphInterf,_instanceType;
    private final Object _choiceP;
    private Object _toggle;
    private DialogTEXshade(int type,int location,int interf){
        _location=location;
        _graphInterf=interf;
        if(TXSHD_INSTANCE_SECSTRU==(_instanceType=type)){
            ((ChJCombo)(_choiceP=newProteinCombo(IF_SECSTRU))).savePrprty(PRPRTY_TXSHD_SECSTRU_SEQUENCE_01234+_location);
        }else if(_graphInterf==INTRFC_ValueOfResidue){
            pcp(KEY_ENABLED,this,addActLi(this,_choiceP=newProteinCombo(0)));
        }else _choiceP=null;
    }
/* <<< TexshadeGraph <<< */
/* ---------------------------------------- */
/* >>> TexshadeGraph >>> */
    private Object _graphChoiceClass,_graphPP,_graphVor;
    private Object _graphMainPnl(){
        addActLi(this,_graphChoiceClass=classChoice(_graphInterf|CLASSCHOICE_SHIFT_SAVEPRPRTY(PRPRTY_TXSHD_graph_method_01234+_location)));
        final Object[]pp={
                          pnl(txshdSaved(TXSHD_txshd_g_color)," min=",txshdSaved(TXSHD_g_tfMin)," max=",txshdSaved(TXSHD_g_tfMax)),
                          pnl(HBL,_choiceP,_graphInterf==INTRFC_ValueOfResidue?null:txshd(TXSHD_g_butOtherSeq),getPnl(_graphChoiceClass))};
        _graphReplaceInstance();
        _graphReplaceSeqs();
        return pnl(VB,
                   pnl(HBL,
                       _toggle=new ChButton(CB_ON_OF(LOCATION_BOTTOM==_location && _graphInterf!=INTRFC_ValueOfResidue),null).savePrprty(PRPRTY_TXSHD_graph_enabled_01234+_location).cp(BUTTN_KEY_COLLAPSE,pp),
                       "Location: ",
                       iConst(SARRAYeq_TXSHD_LOCATION,_location),
                       pp[0]),
                   pp[1]);;
    }
    private void _graphReplaceInstance(){
        dispos(_graphVor);
        _graphVor=mkInstance(MKINSTANCE_SHOW_ERROR,_graphChoiceClass);
        _graphReplaceSeqs();
    }
    private void _graphReplaceSeqs(){
        setProt(sp(_choiceP),derefZ(_graphVor,ValueOfResidue.class));
        if(_graphPP!=null) runCR1(RUN_SET_SEQUENCES,derefZ(_graphVor,ValueOfAlignPosition.class),spp(_graphPP));
    }
    private BA _graphMakeTex(BA sb,int colFrom,int colTo,Protein[]pp){
        final BA errorPrefix=new BA(99).aa("% TexshadeGraph ",iConst(SARRAYeq_TXSHD_LOCATION,_location)," ",sclInterfaceName(_graphInterf));
        if(!isSlct(_toggle) || !isEnbld(_graphChoiceClass)) return sb;
        final String color=s(txshdSaved(TXSHD_txshd_g_color)),barOrColor=nxt(0,chrClas(UPPR),color,1,MAX_INT)>0?"color":"bar";
        double min=atof(getTxt(txshd(TXSHD_g_tfMin))),max=atof(getTxt(txshd(TXSHD_g_tfMax)));
        final ValueOfResidue vor=_graphInterf==INTRFC_ValueOfResidue?derefZ(_graphVor,ValueOfResidue.class):null;
        final double[]values;
        int valuesFrom=0,valuesTo=0;
        final BA sRange=baClr(57);
        String protNum=null;
        boolean[]takeValue=null;
        if(vor!=null){
            final Protein pVoR=sp(_choiceP);
            if(pVoR==null) return sb.aa(errorPrefix," p=null\n");
            final int idx0=firstResIdx(pVoR),iP=idxOf(pVoR,pp);
            if(iP<0) return sb;
            protNum=s(iP+1);
            setProt(pVoR,vor);
            values=vor.getValues();
            valuesFrom=maxi(0,pVoR.columnToIndex(CTRUE,colFrom));
            valuesTo=mini(sze(values),pVoR.columnToIndex(CFALSE,colTo-1)+1);
            sRange.a(idx0+valuesFrom+1).a("..").a(idx0+valuesTo);
            //for(int i=0;i<sze(values) && i<10;i++) puts(values[i]+" ");
        }else{
            final ValueOfAlignPosition vap=_graphInterf==INTRFC_ValueOfAlignPosition?derefZ(_graphVor,ValueOfAlignPosition.class):null;
            if(vap==null) return sb.aa(errorPrefix,"Could not initialize ").aln(_graphChoiceClass);
            final Protein[]ppVoAP=_graphPP!=null?spp(_graphPP):pp;
            if(ARRAY_EMPTY(ppVoAP)) return sb.aa(errorPrefix," ppVoAP=null\n");
            else{
                final byte[][]gappedSeq=new byte[ppVoAP.length][];
                ROFiP0(ppVoAP.length) gappedSeq[iP]=ppVoAP[iP].getGappedSequence(false);
                runCR1(RUN_SET_SEQUENCES,vap,ppVoAP);
                if((values=vap.getValues())!=null){
                    takeValue=new boolean[valuesTo=values.length];
                    int count=valuesFrom=0;
                    for(int c=colFrom;c<colTo && c<values.length;c++){
                        boolean isGap=true;
                        ROFiP0(ppVoAP.length) if(isChrClas(LETTR,gappedSeq[iP],c)) {isGap=false;break;}
                        if(!isGap) {count++; takeValue[c]=true;}
                    }
                    sRange.aa("1..",count);
                    protNum="consensus";
                }
            }
        }
        if(values==null) return sb.aa(errorPrefix," noValues\n");
        final BA sbData=new BA(999);
        final boolean minAuto=Double.isNaN(min),maxAuto=Double.isNaN(max);
        if(minAuto) min=Double.MAX_VALUE;
        if(maxAuto) max=Double.MIN_VALUE;
        for(int t=0;t<2;t++){/*X 1=write*/
            for(int i=valuesFrom;i<=valuesTo && i<values.length;i++){
                if(takeValue!=null && (i>=takeValue.length||!takeValue[i])) continue;
                if(t!=0){
                    final double v=(1000*(values[i]-min)/(max-min));
                    if(Double.isNaN(v)) sbData.aln("NaN");
                    else sbData.a((int)v).aln();
                }else{
                    if(minAuto && min>values[i]) min=values[i];
                    if(maxAuto && max<values[i]) max=values[i];
                }
            }
            if(min==max || Double.isNaN(min) || Double.isNaN(min)) return sb.aa(errorPrefix," min=",min," max=",max).aln();
        }
        return sb.aa("\\feature{",iConst(SARRAYeq_TXSHD_LOCATION,_location),"}{",protNum,"}{",sRange,"}{",barOrColor,"[0,1000]:",
                     nam(wrte(newFile(iFile(DIR_TXSHD),new BA(99).aa(sclInterfaceName(_graphInterf),"_",iConst(SARRAYeq_TXSHD_LOCATION,_location),".dat")),sbData)),
                     '[',color).aln("]}{}");
    }
/* <<< TexshadeGraph <<< */
/* ---------------------------------------- */
/* >>> TexshadeSecStructure >>> */
    Object secstruPnl(){
        final Object[]pp={
                          pnl(HBL,_choiceP," ",txshdSaved(TXSHD_ss_cbSkip)),
                          pnl(HBL,"\\feature{",iConst(SARRAYeq_TXSHD_LOCATION,_location),"}{ ... }{helix[RED]",txshdSaved(TXSHD_ss_helix1),"}{",txshdSaved(TXSHD_ss_helix2),"}"),
                          pnl(HBL,"\\feature{",iConst(SARRAYeq_TXSHD_LOCATION,_location),"}{ ... }{",txshdSaved(TXSHD_ss_sheetType),"[YELLOW]:",txshdSaved(TXSHD_ss_sheet1),"}{",txshdSaved(TXSHD_ss_sheet2),"}"),
                          _choiceP};
        return pnl(VBHB,
                   pnl(HBL,
                       _toggle=new ChButton(CB_ON_OF(LOCATION_TOP==_location),null).savePrprty(PRPRTY_TXSHD_secstru_enabled_01234+_location).cp(BUTTN_KEY_COLLAPSE,pp),
                       "Location: ",iConst(SARRAYeq_TXSHD_LOCATION,_location),pp[0]),pp[1],
                   pp[2]);
    }
    public void _secstruMakeTex(BA tex,int colFrom,int colTo,Protein[]pp){
        tex.aln("% secondary structure");
        Protein p=sp(_choiceP);
        if(isSlct(_toggle)){
            if(p==null||p.getResidueSecStrType()==null){
                for(Protein pSS:pp) if(pSS.getResidueSecStrType()!=null){setSelO(p=pSS,_choiceP);break;}
            }
            final int i=idxOf(p,pp);
            final byte[]ss=p==null?null:p.getResidueSecStrType();
            if(i<0)  _msg.a(RED_WARNING).aRplc(0,"@",s(p),rsc(RSC_TXSHD_WARN_NO_SECSTRU)).aln();
            else if(ARRAY_EMPTY(ss)) tex.aa("% TexshadeSecStructure: ",p," has no secondary structures\n");
            else{
                for(int subsetStart=p.subsetStart(),
                        iaTo=mini(ss.length-subsetStart,p.countRes(),p.columnToIndex(CFALSE,colTo-1)+1),
                        he=2;--he>=0;){
                    final boolean[]bb=new boolean[iaTo];
                    FORa(maxi(0,p.columnToIndex(CTRUE,colFrom)),iaTo)  bb[a]=(ss[a+subsetStart]|32)==(he==0?'h':'e');
                    if(fstTrue(bb)>=0){
                        tex.aa("\\feature{",iConst(SARRAYeq_TXSHD_LOCATION,_location),"}{",i+1,"}{",texshadeRange(bb,firstResIdx(p)),"}{");
                        if(he==0) tex.aa("helix[Red]:",txshd(TXSHD_ss_helix1),"}{",txshd(TXSHD_ss_helix2));
                        else tex.aa(txshdSaved(TXSHD_ss_sheetType),"[Yellow]:",txshd(TXSHD_ss_sheet1),"}{",txshd(TXSHD_ss_sheet2));
                        tex.a("}  % ").aln(p);
                    }
                }
                if(_sel(TXSHD_ss_cbSkip)) tex.aa("\\hideseq{",i+1,"} % ").aln(p);
            }
        }
    }
/* <<< TexshadeGraph <<< */
/* ---------------------------------------- */
/* >>> DialogPredictTexshade >>> */
    private Protein[]_predictPP;
    private String _predictName;
    private byte[][]_prediction;
    private Object _predictTA;
    public DialogTEXshade(byte prediction[][],Protein[]pp,String name){
        _graphInterf=_location=0;
        _choiceP=null;
        _instanceType=TXSHD_INSTANCE_PREDICT;
        _predictPP=pp;
        _predictName=name;
        _prediction=prediction;
        _txshdPredictInstV.add(wref(this));
    }
    private void _predictMakeTex(Protein[]pp,int iTab,BA sb){
        if(_prediction==null) return;
        final BA ba=toBA(_predictTA).a('\n');
        final byte[]T=ba.bytes();
        final boolean[]selA=new boolean[maxSze(_prediction)];
        sb.a("%  ").aln(_predictName);
        final int ee[]=ba.eol();
        FORiP(-1,_predictPP.length){
            if(iP>=0 && !cntainsEl(_predictPP[iP],pp)) continue;
            FORiL(0,ee.length){
                final int E=ee[iL],B=nxt(STR_E,chrClas(-SPC),T,iL==0?0:ee[iL-1],E);
                if(E-B<4 || T[B]=='%') continue;
                if(strstr(STR_w_R,"$PROTEIN_NO",T,B,E)>0){
                    final int spc=nxt(0,chrClas(SPC),T,B,E);
                    if(iP<0 || spc<0) continue;
                    ROFa0(selA.length) selA[a]= a<_prediction[iP].length && strchr(_prediction[iP][a],T,B,spc)>=0;
                    if(fstTrue(selA)>=0) sb.a(resSelReplaceVariableBB(ba.newString(spc,E+1),selA,firstResIdx(_predictPP[iP]),_predictName,_predictPP[iP],pp));
                }else  if(iP==0){
                    final String ins=ba.newString(B,E+1);/*X  INEFFICIENT */
                    if(iTab==0 || strstr(0,ins,sb)<0) sb.a(ins);
                }
            }
        }
    }
}
//inkscape --verb=FitCanvasToDrawing --verb=FileSave --verb=FileClose *.svg
#undef THIS_CLAS
