package charite.christo.strap;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
import charite.christo.*;
import java.util.*;
#define SUPPORT_INDIRECT 0
#define direct true
#define THIS_CLASS(a) BUT_C_##PredictionFromSequenceImpl##_##a
/** @author Christoph Gille */
@*H THIS_CLASS(TRANSMEMBRANEHELIX_HMMTOP)
   <BR>Publication: PUBMED:11590105
   <BR>Authors:  G.E. Tusnady
   <BR>Example: UNIPROT:P32302
*@
@*H THIS_CLASS(TRANSMEMBRANEHELIX_PHOBIUS)
   <BR>Publication:  PUBMED:15111065
   <BR>Author: Lukas Kall
   <BR>Example: UNIPROT:P32302
*@
@*H THIS_CLASS(TRANSMEMBRANEHELIX_DAS)
   Author: Miklos Cserzo
   <BR>Example: UNIPROT:P32302
*@
@*H THIS_CLASS(TRANSMEMBRANEHELIX_TOPPRED)
   <BR>Publication: PUBMED:7704669
   <BR>Example: UNIPROT:P32302
*@
@*RSC_MULTI_PRGPARA THIS_CLASS(TRANSMEMBRANEHELIX_TOPPRED)
  -c;Certain cut-off. (Default value: 1)
  -d;Critical distance between 2 transmembrane segments. (Default value: 2)
  -e;For use with Eucaryotes.
  -H;{CYTEXT-scale,GES-scale,GVH-scale,KD-scale} Hydrophobycitie values from <file>.
  -n;Core window length.  (Default value: 11)
  -p;Putative cut-off. (Default value: 0.6)
  -q;Wedge window length. (Default value: 5)
  -s;Critical loop length.  (Default value: 60)
ALIAS_PRGPARAS_FURTHER
*@
@*H THIS_CLASS(COILEDCOIL_R)
 Ported from Perl by Peter Robinson
 Example: UNIPROT:M57965
*@
@*H THIS_CLASS(SECONDARYSTRUCTURE_JNET)
   <BR><B>Author:</B> James Cuff and Geoff Barton
   <BR><B>Publication:</B> PUBMED:10861942
*@
/* The following modification was necessary for Windows: jnet.h "#define MAXSEQNUM 600" changed to "#define MAXSEQNUM 60"; */

@*SARRAYeq_PredictionFromSequence_CACHE_KEY
 _TMHELIX_HMMTOP_=TRANSMEMBRANEHELIX_HMMTOP
 _TMHELIX_DAS_=TRANSMEMBRANEHELIX_DAS
 _TMHELIX_PHOBIUS_=TRANSMEMBRANEHELIX_PHOBIUS
 _TMHELIX_COILEDCOIL_=COILEDCOIL_R
*@
// Hydrophobicity_TOPPRED. .SecondaryStructure_Jnet.class,

public class PredictionFromSequenceImpl implements PredictionFromSequence,ChRunnable{
    private final BA LOG=new BA(99);
    private byte[][]_prediction,_sequences;
    private Object _ctrl,_panWeb;
    private double[]_hydrophobicity;
    private final Object[]_shared=new Object[SHARED_FIELD_ZZZ];
String _urlResult;
 float[]_score={Float.NaN};
    private final int _it;
    private BasicExecutable _ex;
    REFLECTION_PUBLIC PredictionFromSequenceImpl(int id){
        _it=id;
    }
    CPP_RUN_ID_ARG(){
        switch(id){
            CASE_ARGV(RUN_GET_INSTANCE_TYPE) return io(_it);
            CASE_ARGV(RUN_DIAPREDICT_PNL_WEB){
                if(_panWeb==null && !isEDT()) thrdCR(RUN_DIAPREDICT_PNL_WEB|THRDCR_EDT_NOW,this);
                if(_panWeb==null) _panWeb=pnl(VB);
                return _panWeb;
            }
#if SUPPORT_INDIRECT
            CASE_ARG(RUN_DIAPREDICT_URL_RESULT_TO_CONTAINER,Object,urlResult){
                toContainrC(0,urlResult,runCR(RUN_DIAPREDICT_PNL_WEB,this));
                if(_ctrl!=null) toContainrC(TOCONTAINR_SOUTH,pnl(urlResult),_ctrl);
                LOG.a(ANSI_STYLE_DL+"urlResult="+ANSI_RESET).aln(urlResult);
                BREAK;
            }
#endif //SUPPORT_INDIRECT
            CASE_ARGV(RUN_DISPOSE){if(_ex!=null)_ex._disposed=true; return TRUEr;}
            CASE_ARGV(RUN_GET_SCORE) return _score;
            CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
                if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                if(_ex!=null) return runCR1(RUN_GET_CTRL_PNL,_ex,null);
                if(_ctrl==null)  _ctrl=pnl(CNSEW,scrllpn(0,LOG),runCR(RUN_DIAPREDICT_PNL_WEB,this));

                RETURN(_ctrl);
            }
            CASE_ARG(_RUN_GET_TOPPRED_HYDROPHOBICITY,byte[],s){
                _computeSeq(s);
                RETURN(_hydrophobicity);
            }
        }
        return returnPrgParas(id,arg,_shared,this);
    }
    OVERRIDE_PUBLIC_IF void setGappedSequences(byte[]ss[]) {_sequences=ss;_prediction=null;}
    OVERRIDE_PUBLIC_IF byte[][]getPrediction(){
        if(_prediction==null){
            _prediction=new byte[_sequences.length][];
            for(int i=0;i<_sequences.length && !(_ex!=null&&_ex._disposed);i++){
                zeroToSpc(_prediction[i]=_computeSeq(new BA(99).aFilter(LETTR,_sequences[i]).newBytes()));
            }
        }
        return _prediction;
    }
#if SUPPORT_INDIRECT
    public String findUrlInText(String txt){
        if(txt==null) return null;
        final int posFrom=strstr(STR_IC,"A href=",txt),posTo=txt.indexOf('>',posFrom+1);
        LOG.aa(ANSI_GREEN,"Found URL: ",posFrom,'-',posTo,'\n',ANSI_RESET);
        if(posFrom<0 || posTo<0) {LOG.a(RED_ERROR).aln("Could not find string \"a href=\""); return null;}
        String sUrl=rmQuotes('"',txt.substring(posFrom+7,posTo).trim());
        if(serverRoot()!=null && !looks(LIKE_EXTURL,sUrl)) sUrl=s(new BA(99).aa(serverRoot(),'/',sUrl));
        return sUrl;
    }
        public String serverRoot(){return null;}
#endif //SUPPORT_INDIRECT
#include "PredictionFromSequenceImpl_computeInc.java"
}
#undef THIS_CLASS
