package charite.christo.strap;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;

/** @author Christoph Gille */
public class ProteinsSorterMatrix implements ProteinsSorter{
    private Object _vop;
    private boolean[]_stop;
    public ProteinsSorter setCompareTwoProteins(Object vop){
        _vop=vop;
        return this;
    }
    public Protein[]sortProteins(Protein[]pp,boolean[]stop){
        final int N=pp.length;
        if(N<2) return pp;
        final float[][]m=matrix(pp);
        final Protein[]sorted=new Protein[N];
        for(int i=0,ii[]=sort(m,true);i<N;i++)sorted[i]=pp[ii[i]];
        return iThBool(0,_stop=stop)?null: sorted;
    }
    private static int[]sort(float[][]matrix,boolean distance){
        final int N=matrix.length,sorted[]=new int[N];
        final boolean[]taken=new boolean[N];
        taken[sorted[0]=representant(matrix,distance)]=true;
        FORi(1,N){
            double bestScore=0;
            int best=-1;
            ROFj0(N){
                if(taken[j]) continue;
                double sum=0;
                FORk(0,i){
                    final float jk=matrix[j][sorted[k]];
#if CPP_WITH_MEIN_DEBUG
                    if(j==sorted[k]) baOut(RED_ERROR).aln("j==sorted[k]");
                    final float kj=matrix[sorted[k]][j],diff=kj>jk?kj-jk:jk-kj;
                    if(diff>0.01f) baOut(RED_ERROR).a("symmetry ").aFloat(jk,3,2).a(' ').aFloat(kj,3,2).aln();
#endif //CPP_WITH_MEIN_DEBUG
                    sum+=(1+k*k)*jk;
                }
                if(best<0 || (distance?sum<bestScore: sum>bestScore)) {bestScore=sum; best=j;}
            }
            taken[sorted[i]=best]=true;
        }
        return sorted;
    }
    private float[][]matrix(Protein[]pp){
        final Object hasScore=_vop!=null?_vop: mkInstanceBid(BUT_C1(CompareByAlignmentScoreAsAligned));
        final float[][]m=new float[pp.length][pp.length];
        //Set debug=new HashSet();
        ROFi0(pp.length){
            ROFj0(i){
                if(iThBool(0,_stop)) break;
                m[i][j]=m[j][i]=(float)valueOfTwoProteins(isAssignblFrm(CompareTwoProteins.class,hasScore)?COMPARE_PP_TURN_INTO_DISTANCE_VALUE:0,hasScore,pp[i],pp[j],0,MAX_INT);
            }
        }
        return m;
    }
    private static int representant(float[][]m,boolean dist){
        double bestScore=0;
        int best=-1;
        ROFi0(m.length){
            double sum=0;
            ROFj0(m.length) if(i!=j) sum+=m[i][j];
            if(best<0 || (dist?sum<bestScore: sum>bestScore)) {best=i; bestScore=sum;}
        }
        return best;

    }

}
