package charite.christo.strap;
import charite.christo.*;
import static charite.christo.ChUtils.*;
import static charite.christo.strap.Strap.*;
#define _changed() run(RUN_CHANGED_ResidueSelectionImpl,null)
#define THIS_CLASS(a) BUT_C_##ResidueSelectionImpl##_##a
/** A skelleton of an Selection of Residues */
@*H
 <H2>Creating annotated residue selections</H2>
 Follow the two steps to select and annotate residues:
 <OL>
 <LI>Select the residues by dragging the mouse.</LI>
 <LI>Double-click the highlighted sequence. Or activate the menu item <i>HTMLDOC_BUTTON:M_SEL_EDIT</i>
 of the context menu (Right click).</LI>
 </OL>
 The annotated residue selection is displayed as a table as below.
 The name, sequence positions and annotation text can be edited.
 <BR>
 <i>HTMLDOC_JCOMPONENT:HTMLDOC_JC_ResidueAnnotation</i>
*@

// s8stdout a2_HomoSapiens.swiss 1nrg.pdb  *.swiss
// s8stdout 1nrg.pdb

@*SARRAYeq_NAMES_ResidueSelection
 Backbone=RESSEL_IMPL_BACKBONE
 Cursor=RESSEL_IMPL_CURSOR
 Mouse over=RESSEL_IMPL_MOUSE_OVER
 Selected=RESSEL_IMPL_SELECTED
 Dotplot=RESSEL_IMPL_DOTPLOT
 Closer than DISTANCE_CURSOR_MAX_VALUE=DISTANCE_CURSOR
 Align_one_to_many=RESSEL_IMPL_ALIGN_ONE_ALL
*@
#define sbTipDistance baNoClr(373)
#define tmp() baClr(65)
#define _shared _oo[RESSEL_IMPL_SHARED]
#define _p _oo[RESSEL_IMPL_PROTEIN]
#define _name _oo[RESSEL_IMPL_NAME]
#define _sliderL _oo[RESSEL_IMPL_SLIDER_LOWER]
#define _sliderU _oo[RESSEL_IMPL_SLIDER_UPPER]
#define _labMin _oo[RESSEL_IMPL_LAB_LOWER]
#define _labMax _oo[RESSEL_IMPL_LAB_UPPER]
#define _heteroTF _oo[RESSEL_IMPL_TF_HETERO]
#define _ctrl _oo[RESSEL_IMPL_CTRL]
public class ResidueSelectionImpl implements ResidueSelection,IF_GUI(SelectorOfNucleotides,)HasWRef{
    final int _opt;
    private int _offset,_where,_style;
    private boolean IF_GUI(_selectedNT[],)_selected[],_isBall;
     final Object[]_oo=new Object[RESSEL_IMPL_ZZZ];
    private Object _color UNLESS_GUI(=newColr(0xFFff00)),_lastColor,_image;
#define masterOrThis() this
#if CPP_WITH_GUI
#undef masterOrThis
#define masterOrThis()  (_master!=null?_master:this)
    private static void _heteroDist(float x,float y,float z,float[]xyz,float min2,float max2,int f,int t,boolean[]bb){
        FORi(f,t){
            final float xx=x-xyz[i*3],yy=y-xyz[i*3+1],zz=z-xyz[i*3+2],dd=xx*xx+yy*yy+zz*zz;
            bb[i]=dd<max2 && dd>min2;
        }
    }
    private int _offsetNT,_maxV,_minV,_mc,_mcAA,_mcNT;
    ResidueSelectionImpl _master;
#endif //CPP_WITH_GUI
    public ResidueSelectionImpl(int opt){
        final int it=opt&RESSEL_IMPL_IT_MASK;
        _opt=it==DISTANCE_HETERO||it==RESSEL_IMPL_ALIGN_ONE_ALL?opt|RESSEL_IMPL_OFFSET_IS_1ST_IDX:opt;

        _name=iConst(SARRAYeq_NAMES_ResidueSelection,it);
#if CPP_WITH_GUI
        if(it==DISTANCE_CURSOR||it==DISTANCE_HETERO){
            _image=img(IC_MEASURE);
            _maxV=DISTANCE_CURSOR_MAX_VALUE100;
        }
        _where=
            it==RESSEL_IMPL_BACKBONE?VIS123_STRUCTURE:
            it==RESSEL_IMPL_CURSOR?VIS123_SEQUENCE:
            it==RESSEL_IMPL_MOUSE_OVER?VIS123_SEQUENCE|VIS123_SB:
            VIS123_EVERYWHERE;
        setColorRGB(it==RESSEL_IMPL_BACKBONE?0xFFff00:
                       it==RESSEL_IMPL_CURSOR?0xFFffFF:
                       it==RESSEL_IMPL_SELECTED?0x5555ff:
                    0xFFff00,this);
        _style=
            it==RESSEL_IMPL_CURSOR?SSTYLE_CURSOR:
            it==RESSEL_IMPL_SELECTED?SSTYLE_DOTTED:
            it==DISTANCE_CURSOR||it==DISTANCE_HETERO||it==RESSEL_IMPL_DOTPLOT||it==RESSEL_IMPL_MOUSE_OVER?SSTYLE_CIRCLE:
            SSTYLE_BACKGROUND;
#endif //CPP_WITH_GUI
    }
/* ---------------------------------------- */
/* >>> Selected Residues >>> */
    OVERRIDE_PUBLIC boolean[]getSelectedAminoacids(){
        final Protein p=(Protein)_p;
        if(p==null)return NO_boolean;
#if CPP_WITH_GUI
        final int it=_opt&RESSEL_IMPL_IT_MASK;
        //if(it==RESSEL_IMPL_ALIGN_ONE_ALL) putln(DEBUG_NOW+" RESSEL_IMPL_ALIGN_ONE_ALL getSelectedAminoacids() "+_master);
        if(it!=0 && DIFF_MC(_mcAA,masterOrThis()._mc+(_master==_shared?0:modic(_shared))) || _selected==null){
            run(_RUN_RESSEL_IMPL_COMPUTE,null);
        }
#endif //CPP_WITH_GUI
        final boolean[]bb=_selected;
        return bb!=null?bb:NO_boolean;
    }
    OVERRIDE_PUBLIC int getSelectedAminoacidsOffset(){
        getSelectedAminoacids();
        return 0!=(_opt&RESSEL_IMPL_OFFSET_IS_1ST_IDX)?firstResIdx(sp(this)):_offset;
    }
#if CPP_WITH_GUI
    OVERRIDE_PUBLIC_IF int getSelectedNucleotidesOffset(){return _offsetNT;}
    OVERRIDE_PUBLIC_IF boolean[]getSelectedNucleotides(){
        final Protein p=(Protein)_p;
        if(p==null)return null;
        p.getResType();
        final byte[]nt=p.getNucleotides();
        if(nt==null || !p.isTranslated()) return null;
        if((_opt&RESSEL_IMPL_IT_MASK)==RESSEL_IMPL_HIGHLIGHT_PATTERN){
            if(DIFF_MC(_mcNT,p.mc((P_MC_RES_TYPE<<P_MC_SHIFT)|P_MC_1ST_RES_IDX)+_master._mc) || _selectedNT==null) run(_RUN_RESSEL_IMPL_COMPUTE_NT,nt);
        }
        return _selectedNT;
    }
#endif //CPP_WITH_GUI
    OVERRIDE_PUBLIC void setSelectedAminoacids(boolean[]bb,int offset){
        _offset=offset;
        _selected=bb;
        if(_p!=null && eqBoolArraysOffset(bb,offset,_selected,_offset)) strapIncMC(P_MC_RES_SELECTIONS,(Protein)_p);
    }
    OVERRIDE_PUBLIC String toString(){return s(runCR1(RUN_GET_RENDERER_TXT,this,NULL_AS_INT));}
    CPP_RUN_ID_ARG(){
        final Protein p=(Protein)_p;
        IF_GUI(final Object[]masterOO=_master==null?null:_master._oo);;
        final int it=_opt&RESSEL_IMPL_IT_MASK;
        if(it==DISTANCE_HETERO||it==DISTANCE_CURSOR){
#include "ResidueSelectionImpl_Distance_Inc.java"
        }
        switch(id){
#if CPP_WITH_GUI
#include "ResidueSelectionImpl_Compute_Inc.java"
#include "ResidueSelectionImpl_HighlightPattern_Inc.java"
#include "ResidueSelectionImpl_HighlightPatternMaster_Inc.java"
            CASE_ARGV(RUN_CHANGED_ResidueSelectionImpl){
                _mc++;
                clr(_selected);
                clr(_selectedNT);
                strapIncMC(P_MC_RES_SELECTIONS,p);
                strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
                break;
            }
            CASE_ARG(RUN_IS_OBJECT_ENABLED,Object,o){
                if((it==DISTANCE_CURSOR||it==DISTANCE_HETERO)&&o instanceof Protein){
                    if(((Protein)o).complies(it==DISTANCE_CURSOR?IF_CALPHA:IF_HETERO3D)) return TRUEr;
                }
                BREAK;
            }
            CASE_ARG(RUN_SET_SHARED_INSTANCE,Object,o) _master=derefZ(_shared=o,ResidueSelectionImpl.class);BREAK;
            CASE_ARGV(RUN_GET_SHARED_INSTANCE) return _master;
            CASE_ARGV(RUN_GET_RENDERER_OPTS) return p==null?RENDER_STRIKE_THROUGH_AS_OBJCT:null;
            CASE_ARG(RUN_GET_TIP_TEXT,Object,ev)
                CASE_ARG(RUN_GET_RENDERER_TXT,int,opt){
                if(it==RESSEL_IMPL_HIGHLIGHT_PATTERN || it==DISTANCE_HETERO||it==DISTANCE_CURSOR) return masterOrThis()._name;
                final BA sb=_baClrRenderer();
                if(p!=null && 0!=(opt&RENDER_FOR_JLIST)) sb.aa(p,'/');
                RETURN(sb.aa(nam(this),"  ").boolToText(getSelectedAminoacids(),getSelectedAminoacidsOffset()+1,",","-"));
            }
#endif //CPP_WITH_GUI
            CASE_ARGV(RUN_GET_INSTANCE_TYPE) return io(_opt&RESSEL_IMPL_IT_MASK);
            CASE_ARGV(RUN_GET_NAME){
                IF_GUI(if(it==RESSEL_IMPL_HIGHLIGHT_PATTERN){
                        return _master._name);;
                    }
                return _name;
            }
            CASE_ARG(RUN_SET_NAME,Object,n) _name=s(n);RETURN(TRUEr);
            CASE_ARG(RUN_SET_PROTEIN,Protein,neu){
                final Object old=p;
                if(old!=neu){
                    if((_p=neu)!=null) strapIncMC(P_MC_RES_SELECTIONS_V,neu);
                    if(old!=null) strapIncMC(P_MC_RES_SELECTIONS_V,(Protein)old);
                }
                RETURN(TRUEr);
            }
            CASE_ARGV(RUN_GET_PROTEIN) return p;
            CASE_ARG(RUN_SET_COLOR,Object,color) masterOrThis()._color=color; RETURN TRUEr;
            CASE_ARGV(RUN_GET_COLOR) return masterOrThis()._color;
            CASE_ARG(RUN_SET_IMAGE,Object,im){
                if(im==IC_BLANK) _isBall=true;
                else _image=im;
                BREAK;
            }
            CASE_ARG(RUN_GET_IMAGE,Object,supported){
                if(supported==PROPERTY_SUPPORTED) return PROPERTY_SUPPORTED;
                if(_isBall){
                    final Object c=runCR(RUN_GET_COLOR,this);
                    if(_lastColor!=c) {_image=null; _lastColor=c;}
                    if(_image==null) _image=imgColoredBall(c);
                }
                RETURN _image;
            }
        }
        return null;
    }
    public int getVisibleWhere(){return masterOrThis()._where;}
    public void setVisibleWhere(int w){masterOrThis()._where=w;}
    public int getStyle(){return masterOrThis()._style;}
    public void setStyle(int style){ masterOrThis()._style=style;}

    CPP_CODE_HasWRef();
}
