@*H THIS_CLASS(DISTANCE_CURSOR)
 In <i>HTMLDOC_DIALOG:BUT_C1(DialogSelectionOfResidues)</i> the method <i>HTMLDOC_COMBO_CLASS:BUT_C1(Distance3DToCursor)</i> is selected.
 <BR>
 The Euclidean distances between the cursor and  all C-alpha atom coordinates are permanently monitored
 when the cursor is moved.

 This way amino acids equivalent to the amino acid at the cursor position show up in all proteins.

 Before, the proteins should be superimposed.
 <BR>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogSelectionOfResidues)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogSuperimpose3D)</i>
*@
@*H THIS_CLASS(DISTANCE_HETERO)
 A white space separated list of hetero-groups is needed.

 Hetero-groups can be specified:
 <OL>
 <LI>The name E.G. FAD, FMN, HEM. </LI>
 <LI>The number as found in the pdb file. </LI>
 <LI>In case of DNA/RNA  a capital letter which designates the chain letter</LI>
 </OL>

 <BR><B>Limitations:</B> Currently only c-alpha atoms.
 <i>HTMLDOC_SEE_CLASS:BUT_C1(Distance3DToCursor)</i>
*@

@*~RSC_DISTANCE3DTOHETERO_EXPLAIN
 <BR>Either enter residue name like "FMN" or the residue number.<BR>
 Optionally append colon and chain-letter such as FMN:A or 250:A<BR>
 Specify DNA/RNA by a single capital letter denoting the chain or type "DNA" or "RNA".<BR>
*@

@*~RSC_DISTANCE3DTOHETERO_EXPLAIN_PEPTIDE_CHAINS
 <BR>Usually, the distance measurements are performed for hetero compounds and cAlpha positions of the same protein.<BR>
 But if the hetero compound is written in the form <PRE> protein/hetero</PRE>, distance is measured to cAlpha positions of all proteins.<BR>
 For example peptide chain F of PDB:1gd2 has a RNA with chain letter "A".
 The DNA chain is then written in the form 1gd2_F.pdb/A
*@

switch(id){
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        if(t==EVT_PROTEIN_3D_MOVED||
           t==EVT_ATOM_XYZ||
           it==DISTANCE_CURSOR && (t==EVT_CURSOR_RESIDUE||t==EVT_CURSOR_SEQUENCE)||
           it==DISTANCE_HETERO && t==EVT_HET_OR_NT_STRUCTURE_ADDED_OR_REMOVED){
            _changed();
        }
        RETURN TRUEr;
    }
    CASE_ARG(RUN_GET_SHARED_CTRL_PNL,Object,supported){
        if(supported==PROPERTY_SUPPORTED) return it==DISTANCE_CURSOR||it==DISTANCE_HETERO?PROPERTY_SUPPORTED:null;
        if(_ctrl==null){
            monospc(_labMax=labl(null));
            if(it==DISTANCE_CURSOR){
                runCR(_RUN_SET_LABEL_MIN_DISTANCE,this);
                runCR(_RUN_SET_LABEL_MAX_DISTANCE,this);
                _ctrl=pnl(VB,monospc(_sliderL=new ChJSlider(CHJSLIDER_DISTANCE_CURSOR_L,this)),monospc(_sliderU=new ChJSlider(CHJSLIDER_DISTANCE_CURSOR_U,this)),
                          pnl("Highlight residues closer than ",_labMax,"and more distant than",_labMin=monospc(labl(null))," to ","cursor"));
                _changed();
            }
            if(it==DISTANCE_HETERO){
                final Object explain=pnl(HBL,rsc(RSC_DISTANCE3DTOHETERO_EXPLAIN)),advanced=pnl(HBL,rsc(RSC_DISTANCE3DTOHETERO_EXPLAIN_PEPTIDE_CHAINS));
                _ctrl=pnl(VBHB,
                          pnlTogglOpts(TOGGL_PNL_Explain,explain),
                          explain,
                          pcp(KEY_IF_EMPTY,"Enter list of hetero group names or hetero residue numbers here",_heteroTF=addActLi(this,new ChTextField("").saveInFile("Distance3DToHetero_hetero"))),
                          pnl(CNSEW,_sliderU=new ChJSlider(CHJSLIDER_DISTANCE_HETERO,this)),
                          pnl(HBL,"Highlight residues closer than ",_labMax," to compound"),
                          " ",
                          pnlTogglOpts(TOGGL_PNL_Strap_ExplainMeasureAccrossProteins,advanced),
                          advanced);
                runCR(_RUN_SET_LABEL_MAX_DISTANCE,this);
                tcTools(_heteroTF).enableWordCompletion(strapProteinsV(0));
                _changed();
            }
        }
        RETURN(_ctrl);
    }
    CASE_ARGV(_RUN_SET_LABEL_MIN_DISTANCE)
        CASE_ARGV(_RUN_SET_LABEL_MAX_DISTANCE) setTxt(tmp().aFloat((id==_RUN_SET_LABEL_MIN_DISTANCE?_minV:_maxV)/100f,5,3).a(" \u00c5"),id==_RUN_SET_LABEL_MIN_DISTANCE?_labMin:_labMax);BREAK;
    CASE_ARG(RUN_M_actionPerformed,Object,ev)
        CASE_ARG(RUN_M_stateChanged,Object,ev){
        final Object q=evtSrc(ev);
        if(q==_sliderU){
            if((_maxV=intValueC(q))<_minV) { setIntValueC(_minV=_maxV,_sliderL); awtc(AWTC_OPT_REPAINT,_sliderL);}
            runCR(_RUN_SET_LABEL_MAX_DISTANCE,this);
            _name=s(tmp().aa("Closer than ",getTxt(_labMax)," to ",it==DISTANCE_CURSOR?"cursor":orS(sbTipDistance,"compound")));
        }
        if(q==_sliderL){
            if((_minV=intValueC(q))>_maxV){ setIntValueC(_maxV=_minV,_sliderU); awtc(AWTC_OPT_REPAINT,_sliderU);}
            runCR(_RUN_SET_LABEL_MIN_DISTANCE,this);
        }
        //putln(DEBUG_NOW+"_changed ");
        _changed();
        BREAK;
    }
 }
