#define DIA_ALIGN_SEQS_SELECTED 0
#define DIA_ALIGN_SEQS_RUBBER_BAND 1
#define DIA_ALIGN_SEQS_TEXT_LIST 2
@*H THIS_CLASS(DIA_ALIGN)
 The Dialog is used to align a
 number of selected sequences (see WIKI:Sequence_alignment).

 The user selects an alignment method <i>HTMLDOC_COMBO_CLASS:BUT_C1(ClustalW)</i>.

 By pressing the button <i>HTMLDOC_BUTTON:BUTS_GO</i>, the alignment
 computation is started. It takes some seconds to minutes, before the
 computation the result is shown in a preview panel.

 To accept the alignment in the preview and to infer the alignment into
 the working alignment panel,
 the button <i>HTMLDOC_BUTTON:SBUTS_TAB_ALIGN_Apply</i> needs to be pressed.

 <B>3D-alignment</B> programs consider the 3D-structure.
 If not all proteins have 3D-coordinates, then the Strap uses a combination of
 3D- and sequence alignment.

 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogAlignOneToAll)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogInferAlignment)</i>
*@
@*SARRAYeq_DialogAlign_SEQS
 Selected in the list=DIA_ALIGN_SEQS_SELECTED Rubber band selection=DIA_ALIGN_SEQS_RUBBER_BAND Text list of sequence names=DIA_ALIGN_SEQS_TEXT_LIST
*@
@*~RSC_ALIGNER_INFO_RECTANGLE
 The residues within the rubber band are taken.<BR>The rubber band is a red-white "Marching ants" rectangle in the alignment pane.<BR>It looks like:
*@
@*~RSC_ALIGNER_INFO_THREE_MODES
 CPP_UNSTRINGIZE(BRDR_TITLED) The sequences to be aligned can be specified in three ways:
*@
@*~RSC_ALIGNER_WARN_MARC_RECTANGLE
 Error: Please mark a rectangular area in the alignment with the mouse.
*@
@*~RSC_ALIGNER_WARN_NOT_SUPPORT_PROFILE
 The alignment method does not support profiles.<BR>Only the following methods can work with alignment profiles:<UL>
*@
@*~RSC_ALIGNER_WARN_NO_RESSEL
 Error: No reside selection specified.<BR><BR>
*@
@*RSC_ALIGNER_INFO_ENTER_SEQS
                         Enter a list of sequences or sequences plus residue ranges.
*@

/*(NUM1 3) */
#define DIA_ALIGN_PROFILES_ZZZ 3
#define _currentPnl _bb[4]
#define _alignRadio _bb[5]
/*(NUM1 0)*/
#define _diaAlignPnls _ooo[0]
#define _diaAlignProfile _ooo[1]
/* --- */

switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _diaAlignProfile=new ChTextArea[DIA_ALIGN_PROFILES_ZZZ];
        _jlistSequences=newProteinJlist(NEWPROTEINJLIST_SELECT_ALL);
        final Object
            msgExplain=pnl(VBHB,
                           rsc(RSC_HELP_DIAALIGN_EXPLAIN_SEQLIST),
                           buttn(BUT_C1(DialogSelectionOfResidues)),
                           buttn(BUT_C1(DialogBlast)),
                           buttn(BUT_C1(DialogAlignOneToAll))),
            msgList=pnl(VBHB,
                        pnl(HBL,rsc(RSC_ALIGNER_INFO_ENTER_SEQS)," ",pnlTogglOpts(TOGGL_PNL_Explain,msgExplain)),
                        msgExplain),
            butInsert=setTip(io(RSC_HELP_EXPLAIN_SELECT_RESSEL),_bb[SBUTS_DIA_ALIGN_Insert_ressel]);
        runCR1(RUN_NEW_DROPTARGET,_main,_jTextArea=new ChTextArea(""));
        _diaAlignPnls=new Object[]{
            scrllpn(SCRLLPN_INHERIT_SIZE,pcp(KEY_ENABLED,_choiceClass=addActLi(this,classChoice(INTRFC_SequenceAligner|CLASSCHOICE_SHIFT_SAVEPRPRTY(PRPRTY_Align_method))),_jlistSequences)),
            pnl(VBHB,rsc(RSC_ALIGNER_INFO_RECTANGLE)),
            pnl(CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,_jTextArea),msgList,pnl(butInsert," ",_bb[SBUTS_DIA_ALIGN_Insert_rubberband]))
        };
        undrlneRefs(ULREFS_NOT_CLICKABLE,tcTools(addActLi(this,_jTextArea)).saveInFile("DialogAlign_namesResSel"));
        highlightSeqsInTA(HL_TA_SEQS|HL_TA_RESAN,_jTextArea);

        final Object
            profile=pnl(HBL,"Use some pre-aligned sequences as a profile."),
            details=pnl(VBHB,BRDR_ETCHED_EM,
                        cloneButPckgMinimal(),
                            getPnl(_choiceClass),
                            buttn(TOG_CACHE),
                            buttn(TOG_ALI_NOT_COMMUT),
                            profile,
                            pnl(HBL,"Currently only for T-coffee:",_bb[STOGS_DIA_ALIGN_Secstru]));
        FORi(0,DIA_ALIGN_PROFILES_ZZZ)adC(_bb[i]=TOGGL(s(i+1),this),profile);
        pnl(this,CNSEW,null,null,null,null,pnl(VBPNL,
                                               pnl(HBL," ",pnl(HB,rsc(RSC_ALIGNER_INFO_THREE_MODES),_alignRadio=addActLi(this,radioGrp(SARRAYeq_DialogAlign_SEQS)))," "),
                                               pnl(HBL,pnlTogglOpts(details),"#",newBut(BUTS_GO,this),"#"),
                                               details));
        runCR(_RUN_DIA_ALIGN_setCenter,this);
        setEnbld(wdth(rectRubberBand(null))>0,_bb[SBUTS_DIA_ALIGN_Insert_rubberband]);
        addMarchingAnt(ANTS_SEARCH,wref(_diaAlignPnls[1]),new int[]{10*EM,2*EX,5*EM,EX},C(0xffFFff),C(0xFF0000));
        break;
    }
    CASE_ARGV(RUN_DIA_ALIGN_REGION){
        radioGrpSet(1,_alignRadio);
        runCR(_RUN_DIA_ALIGN_setCenter,this);
        break;
    }
    CASE_ARG(RUN_SELECTION_DialogAlign,Object,txt){
        radioGrpSet(2,_alignRadio);
        setTxt(txt,_jTextArea);
        runCR(_RUN_DIA_ALIGN_setCenter,this);
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_ALIGN_setCenter){
        final Object c=_diaAlignPnls[maxi(0,radioGrpIdx(_alignRadio))];
        if(_currentPnl!=c){
            awtc(AWTC_REMOVE_FROM_PARENT,_currentPnl);
            adConstraintC(_currentPnl=c,this,BorderLayout_CENTER);
        }
        break;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        if(t==EVT_RESIDUE_SELECTION || t==EVT_RESIDUE_SELECTION_COLOR || t==EVT_AA_SHADING_CHANGED){
            awtc(AWTC_OPT_REPAINT,_tabbed);
        }
        if(t==EVT_RUBBER_BAND) setEnbld(wdth(rectRubberBand(null))>0,_bb[SBUTS_DIA_ALIGN_Insert_rubberband]);

        RETURN TRUEr;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==SDIALOGS_CHOICE_CLASS) awtc(AWTC_OPT_REPAINT,_jlistSequences);
        ROFi0(DIA_ALIGN_PROFILES_ZZZ){
            if(bid==i && isSlct(evtSrc(ev))){
                if(_diaAlignProfile[i]==null){
                    final Object
                        ta=_diaAlignProfile[i]=new ChTextArea(readBytes(iPath2(F_PROFILE_,io(i)))),
                        msg=pnl(HBL,rsc(RSC_HELP_DIAALIGN_EXPLAIN_PROFILE)),
                        c=pnl(CNSEW,scrllpn(0,ta),pnl(VBHB,pnlTogglOpts(TOGGL_PNL_Explain,msg),msg));
                    tcTools(pcp(_KEY_MSG,c,addActLi(this,ta))).saveInFile("DialogAlign_profile"+i);
                }
                ChFrame.frame(CLOSE_CtrlW,getTxt(evtSrc(ev)),gcp(_KEY_MSG,_diaAlignProfile[i])).shw();
            }
        }
        Object append=null;
        switch(bid){
        case SBUTS_DIA_ALIGN_Insert_ressel:{
            final BA sb=resSelListFromTo(selectedResidueSelections(SOBJECT_RESSEL_AND_RESAN),0,new BA(999));
            if(sze(sb)>0) append=sb;
            else new BA(333).aa(rsc(RSC_ALIGNER_WARN_NO_RESSEL),rsc(RSC_HELP_EXPLAIN_SELECT_RESSEL)).special(BA_ERROR);
            break;
        }
        case SBUTS_DIA_ALIGN_Insert_rubberband:{
            final int[]rect=rectRubberBand(null);
            if(rect!=null){
                final BA sb=new BA(999);
                for(Protein p:ppInRectangle(null,null)){
                    sb.aWithoutLstCmpnt('!',p.getName()).aa('/',firstResIdx(p)+p.columnToIndex(CTRUE,rect[RECTx])+1,'-',firstResIdx(p)+p.columnToIndex(CFALSE,rect[RECTx]+rect[RECTw]-1)+1).aln();
                }
                append=sb;
            }
            break;
        }
        case BUTS_GO:{
            final Protein[]pp,ppLocal;
            int startIdx=0;
            switch(radioGrpIdx(_alignRadio)){
            case DIA_ALIGN_SEQS_RUBBER_BAND:{
                final int[]rect=rectRubberBand(null);
                if(sze((ppLocal=(pp=ppInRectangle(rect,null)).clone()))>0){
                    ROFiP0(ppLocal.length){
                        if(pp[iP]!=null) ppLocal[iP]=pp[iP].newProteinSubset(new int[]{rect[RECTx],x2(rect)});
                        startIdx=rect[RECTx];

                    }
                }else{
                    rsc(RSC_ALIGNER_WARN_MARC_RECTANGLE).special(BA_ERROR);
                    return null;
                }
                break;
            }
            case DIA_ALIGN_SEQS_TEXT_LIST:{
                final Object[]pp_ss=objectsWithRegex(OBJRX_RESSEL_ANONYM,toBA(_jTextArea),strapProteins());/*X,'A'*/
                final ResidueSelection[]ss=derefArry(pp_ss,ResidueSelection.class);
                final Collection vP=new ArrayList(pp_ss.length);
                for(ResidueSelection s:ss) adUniq(sp(s),vP);
                adAllUniq(derefArry(pp_ss,Protein.class),vP);
                ROFiP0((ppLocal=(pp=spp(vP)).clone()).length){
                    if(pp[iP]!=null&&null==(ppLocal[iP]=pp[iP].newProteinSubset(ss))) ppLocal[iP]=pp[iP];
                }
                break;
            }
            default:
                pp=ppLocal=ppSelectedMinNum(2,_jlistSequences);
                break;
            }
            if(pleaseSelect(CHAINTYPE_PEP|(2<<PLEASE_SELECT_N_SHIFT),pp).length<2) return null;
            final SequenceAligner a=sclInstanceSA(MKINSTANCE_SHOW_ERROR,pp,_choiceClass);
            if(a!=null){
                addOpts(isSlct(_bb[STOGS_DIA_ALIGN_Secstru])?ALIGNER_FLAGS_NOT_TO_SECURITY_LIST|ALIGNER_FLAGS_USE_SECONDARY_STRUCTURE:ALIGNER_FLAGS_NOT_TO_SECURITY_LIST,a);
                runCR1(RUN_SET_SEQUENCES,a,ppLocal);
                BA sbIgnore=null,sbError=null;
                final Color COLOR_IGNORE=argbToColor(0x44FF0000),COLOR_OK=argbToColor(0x4400ff00);
                for(int count=0,i=0;i<DIA_ALIGN_PROFILES_ZZZ;i++){
                    if(!isSlct(_bb[i])) continue;
                    final int maxProfile=xatoi(runCR1(RUN_ALIGN_ADD_PROFILE,a,null));
                    if(maxProfile==0){
                        final BA s=new BA(999).a(rsc(RSC_ALIGNER_WARN_NOT_SUPPORT_PROFILE));
                        for(int c:sclImplementationsForInterface(INTRFC_SequenceAlignerTakesProfile)) s.aa("<LI>",iConst(SARRAY_BID_TO_ALIAS,c),"</LI>");
                        s.a("</UL>").special(BA_ERROR);
                        break;
                    }
                    final BA ba=toBA(_diaAlignProfile[i]);
                    wrte(file(iPath2(F_PROFILE_,io(i))),ba);
                    final Collection<byte[]>vGapped=new ArrayList();
                    final byte[]T=ba.bytes();
                    for(int ee[]=ba.eol(),blockBegin=0,iL=0;iL<ee.length;iL++){
                        final int b=BOL0(iL,ee),e=eolTrim(T,b,ee[iL]);
                        int countLetters=0;
                        Color color=null;
                        int start=b;
                        if(e-b>5 && strEquAt(0,"pdb",T,b)){/*X  Skip sequence name */
                            final int spc=nxt(0,chrClas(SPC),T,b,e);
                            if(spc>0) start=nxt(0,chrClas(-SPC),T,spc,e);
                        }
                        for(int t=start;t<e;t++){
                            final byte c=T[t];
                            if(is(LETTR,c)) countLetters++;
                            else if(c!=' ' && c!='.' && c!='-'){
                                countLetters=-1;
                                if(sbIgnore==null) sbIgnore=new BA(99).a("The following lines are ignored: "); else sbIgnore.a(", ");
                                color=COLOR_IGNORE;
                                sbIgnore.a(iL);
                                break;
                            }
                        }
                        if(countLetters>0){
                            final byte[]seq=new byte[e-start];
                            FORt(start,e) seq[t-start]=isChrClas(LETTR,T,t)?T[t]:(byte)'-';
                            if(sze(vGapped)==0) blockBegin=start;
                            vGapped.add(seq);
                        }
                        if(countLetters==0 || iL==ee.length-1){
                            final byte[][]alignment=toArry(vGapped,byte[].class);
                            if(alignment.length==1)  (sbError==null?sbError=new BA(99):sbError).aPlrl(iL,"Error line %n profile has only one sequence.\n\n");
                            if(alignment.length>1){
                                if(++count>maxProfile) baLog(LOG_MSG).aa(RED_ERROR,shrtClasNamOrAlias(a)).aPlrl(maxProfile," takes not more than %n profiles.").send();
                                else{
                                    runCR1(RUN_ALIGN_ADD_PROFILE,a,alignment);
                                    color=COLOR_OK;
                                }
                            }
                            clr(vGapped);
                        }
                        if(color!=null) tcAddColoredBg(color==COLOR_OK?blockBegin: b,e,color,_diaAlignProfile[i]);
                    }
                }
                if(sbIgnore!=null) (sbError==null?sbError=new BA(99): sbError).aa('\n',sbIgnore);
                if(sbError!=null) sbError.special(BA_ERROR);
                final SDialogs tab=new SDialogs(TAB_ALIGN);
                tab._aligner=a;
                tab._pp=ppLocal;
                tab._seqs=pp;
                tab._ii[0]=startIdx;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(CLOSE_CtrlW|CLOSE_CHILDS,plrl(++_resultNum,"Preview %n"),tab,_tabbed);
            }
        }
        }
        if(append!=null) setTxt("\n"+append,_jTextArea);
        runCR(_RUN_DIA_ALIGN_setCenter,this);
        BREAK;
    }
 }
#undef _currentPnl
#undef _alignRadio
