@*H THIS_CLASS(DIA_ALIGN_ONE_ALL)
 With this dialog a reference protein can be aligned to many other
 proteins producing pair-alignments for each protein.

 On pressing <i>HTMLDOC_BUTTON:BUTS_GO</i>  the  sequence alignments appear in the preview.

 <BR><BR><B>Inferred into the working alignment</B>
 Sequence alignments can be applied to the working sequence alignment.
 Only the gaps of the reference protein are changed in the working alignment.
 The other proteins are not changed.

 <BR><BR><B>Highlighting of the match:</B>
 Table rows can be selected using the <i>HTMLDOC_ICON:IC_SHOW</i> toggles.
 The matches of selected rows are highlighted in the alignment using residue selection objects.

 <BR><BR><B>Limitations:</B>
 The induction of gaps from the calculated sequence alignment into the working
 sequence  alignment may fail because only the residue positions of the
 reference protein but not of the other sequences are changed by
 this procedure.

 Therefore it might not find sufficient white space in the multiple sequence
 alignment.

 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogAlign)</i>
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogSuperimpose3D)</i>
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object
            details=pnl(VBHB,buttn(TOG_ALI_NOT_COMMUT),buttn(TOG_CACHE)),
            westNorth=pnl(VBHB,
                          pnl(HBL,"Reference sequence:",_choiceSequence=newProteinCombo(0)),
                          pnl(HBL,"Method:",getPnl(_choiceClass=classChoice(INTRFC_SequenceAligner|CLASSCHOICE_SHIFT_SAVEPRPRTY(PRPRTY_AlignOneToAll_method)))),
                          pnl(HBL,pnlTogglOpts(details),"#",newBut(BUTS_GO,this),"#"),
                          details);
        setLayout(new GridLayout(1,2));
        add(pnl(CNSEW,null,westNorth,null,null,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH)));
        add(scrllpn(SCRLLPN_INHERIT_SIZE,_jlistSequences=newProteinJlist(NEWPROTEINJLIST_SELECT_ALL)));
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            final Protein[]pp=proteinJlistSelectedOrAll(_jlistSequences);
            if(pleaseSelect(CHAINTYPE_PEP,pp).length>0){
                final SDialogs tab=new SDialogs(TAB_ALIGN_ONE_ALL);
                tab._pp=pp;
                tab._p=sp(_choiceSequence);
                tab._choiceClass=_choiceClass;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(DISPOSE_CtrlW,_choiceSequence+" "+shrtClasNamOrAlias(_choiceClass),tab,_tabbed);
            }
        }
        BREAK;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
                final int t=evtType[0];
                if(t==EVT_RESIDUE_SELECTION || t==EVT_RESIDUE_SELECTION_COLOR || t==EVT_AA_SHADING_CHANGED) awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_200,this);
        return TRUEr;
    }
 }
