/*(NUM1 1)*/
#define CHOICE_DB_NUC 1
#define CHOICE_DB_AMINO 2
#define BB_choiceTypeOfSequence 3
#define _tfFrom _bb[4]
#define _tfTo _bb[5]
#define _radioDB _bb[6]
/* --- */
/*(NUM1 0)*/
#define AA_OR_NT_GUESS 0
#define WITH_INTRON 1
#define NO_INTRON 2

@*H THIS_CLASS(DIA_BLAST)

Strap allows to search public and private sequence databases to
identify sequences that are similar to a query sequences.

Depending on the type of sequences, there are four search methods:
<OL>
<LI>The query is an amino acid (aa) sequence and the database contains nucleotide (nt) sequences.</LI>
<LI>  ...   nt   ...  nt. ...  </LI>
<LI>  ...   aa   ...  aa  ...  </LI>
<LI>  ...   nt   ...  aa  ...  </LI>
</OL>

By default the computation is performed on the EBI Blast server.

Strap as a front end provides advanced features compared to the web user interfaces of public services:

<UL>

<LI>Many jobs can be run one after another.</LI>

<LI>The Blast result is saved in the cache. If the same query is used a
second time the cached result appears without delay.
</LI>

<LI>
Blast alert:

The sequence databases are permanently growing.

With the cache disabled Strap conducts a new Blast
and compares the new result with the previous result stored in the cache.

It reports if there are new hits since last run and  highlights all new hits.
</LI>

<LI>Several patterns can be highlighted.
Strap identifies patterns even if they are disrupted by a gap.
</LI>

<LI>Sequences from the hit-list can be loaded by mouse click.</LI>
</UL>

<i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogSimilarStructure)</i>
<i>HTMLDOC_INCLUDE_DOC2:BUT_C1(SequenceBlaster)</i>
*@
@*SARRAYeq_DialogBlast_comboNT
 Aminos or nucleotides: detect automatically=AA_OR_NT_GUESS Query is nucl sequ with introns=WITH_INTRON Query is the coding nucleotide sequence=NO_INTRON
*@
@*SARRAY_DialogBlast_DB
 Proteins with 3D-structure|All sequences|Non-redundant set of sequences
*@
#define VARS_DIA_BLAST  private Collection[]_blastDB
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _blastDB=new Collection[]{new ArrayList(999),new ArrayList(22000)};

        _bb[CHOICE_DB_NUC]=new ChJCombo(0,_blastDB[0]);
        _bb[CHOICE_DB_AMINO]=new ChJCombo(0,_blastDB[1]);
        final Object
#if CPP_DEACTIVATED
            pAllDB=pnl(VBHB,BRDR_ETCHED,
                       pnl(CNSEW,_blastLabDB=labl(null),null,null,null,_bb[SBUTS_DIA_BLAST_Download_Full_DB]),
                       "Facilitate browsing long lists of databases by hiding entries."
                       pnl(HB,"   Hide those that contain one of the strings: ",_blastSkip),
                       pnl(HB,"   But do not hide those, that contain: ",_blastSkipNot)),
#endif //CPP_DEACTIVATED
            simple=pnl(VBHB,"Searching for similar sequences in:",pnl(HBL," "," ",pnl(VB,_radioDB=addActLi(this,radioGrp(SARRAY_DialogBlast_DB))))," ",buttn(TOG_CACHE)," "),
            pRange=pnl(HBL,_bb[LABEL_DIA_BLAST_Fst],_tfFrom=new ChTextField("1").cols(6),_bb[LABEL_DIA_BLAST_Lst],_tfTo=new ChTextField(s(9999)).cols(6)),
            pSettings=pnl(VBHB,
                          pRange,
                          " ",
                          pnl(HBL,"Database:  ",pcp(BUTTN_KEY_COLLAPSE,_bb[CHOICE_DB_AMINO],pcp(BUTTN_KEY_COLLAPSE_HIDE,_bb[CHOICE_DB_NUC],_bb[STOGS_DIA_BLAST_Amino]))),
                          IF_DEACTIVATED(pnlTogglOpts("Load full list of available databases",pAllDB),pnl(HB," ",pAllDB," "),)
                          _bb[CHOICE_DB_AMINO],
                          _bb[CHOICE_DB_NUC],
                          " ",
                          "Blast service:",
                          pnl(HBL," ",_choiceClass=addActLi(this,setSelIdx(SEQ_BLASTER_WEB_EBI,new ChJCombo(arry(SARRAYeq_BLAST_CMD))))," ",buttn(BUTTN_CLASS_HELP_SMALL|BUT_C1(SequenceBlaster))),
                          pnl(HBL," ",_bb[BB_choiceTypeOfSequence]=addActLi(this,new ChJCombo(arry(SARRAYeq_DialogBlast_comboNT)))));
        add(pnl(CNSEW,null,
                pnl(VBPNL,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH),
                    pSettings,
                    simple,
                    pnl(HBL,"Options ",((ChButton)_bb[STOGS_DIA_BLAST_Detail]).cp(BUTTN_KEY_COLLAPSE,new Object[]{pSettings,pRange}).cp(BUTTN_KEY_COLLAPSE_HIDE,simple),"#",pnl(_bb[SBUTS_DIA_BLAST_Go])))));
        runCR(_RUN_DIA_BLAST_updateDB,this);
        break;
    }
    CASE_ARGV(_RUN_DIA_BLAST_updateDB){
        //private void _blastUpdateDB(int dbOpts){
        //runCR(_RUN_DIA_BLAST_updateDB,this)
        ROFt0(2){/*X isAmino */
            clr(_blastDB[t]);
            IF_DEACTIVATED(skipDatabases(b,_blastSkip,_blastSkipNot));;
            final String[]dd=new SequenceBlaster(0,getSlctIdx(_choiceClass),null,null,null).getAvailableDatabases(t==1?0:BLAST_NUCLEOTIDE_DB);
            if(!ARRAY_EMPTY(dd)){
                adAll(dd,_blastDB[t]);
                setSelIdx(maxi(0,idxOfStrg(0,s(_bb[t+CHOICE_DB_NUC]),dd)),_bb[t+CHOICE_DB_NUC]);
                IF_MEIN_DEBUG(assert CHOICE_DB_NUC+1==CHOICE_DB_AMINO);;
            }
        }
        final String s=getSlctIdx(_bb[BB_choiceTypeOfSequence])==0?" residue ":" nucleotide ";
        setTxt(addPfx("First ",s),_bb[LABEL_DIA_BLAST_Fst]);
        setTxt(addPfx(" Last ",s),_bb[LABEL_DIA_BLAST_Lst]);
        awtc(AWTC_OPT_REPAINT,_jlistSequences);
        break;
    }
    //REFLECTION_PUBLIC_STATIC_VOID _blastSetAvailableDB(SequenceBlaster b,Collection[]v,Object[]bb){IF_DEACTIVATED(,Object tfSkip,Object tfSkipNot,Runnable finaly)
    CASE_ARG(_RUN_DIA_BLAST_setAvailableDB,SequenceBlaster,b){
        ROFt0(2){
            IF_DEACTIVATED(skipDatabases(b,tfSkip,tfSkipNot));;
            final String[]ss=b.getAvailableDatabases((t!=0?0:BLAST_NUCLEOTIDE_DB)|BLAST_DATABASES_FULL_LIST);
            if(!ARRAY_EMPTY(ss) && iThEl(t,_blastDB)!=null){
                final String sel=lstTkn(s(_bb[t+CHOICE_DB_NUC])),dd[]=ss;/*X new SortBlastDatabases(ss,arry(SARRAY_BLAST_PREF_DB)).sorted(); */
                adAll(dd,clr(_blastDB[t]));
                int idx=-1;
                ROFi0(sze(dd)) if(strEnds(STR_w|STR_IC,sel,dd[i])) idx=i;
                if(idx>=0) setSelIdx(idx,_bb[t+CHOICE_DB_NUC]);
                else awtc(AWTC_REVALAND_REPAINT_MAYBE,_bb[t+CHOICE_DB_NUC]);
            }
        }
        IF_DEACTIVATED(runR(finaly));;
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,o){
        if(bid==SDIALOGS_CHOICE_CLASS){
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_BLAST_Download_Full_DB]);
            IF_DEACTIVATED(setTxt(null,_blastLabDB));;
            runCR(_RUN_DIA_BLAST_updateDB,this);
        }
        if(bid==SBUTS_DIA_BLAST_Download_Full_DB){
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_BLAST_Download_Full_DB]);
            thrdCR1(_RUN_DIA_BLAST_setAvailableDB|THRDCR_START,this,new SequenceBlaster(0,getSlctIdx(_choiceClass),null,null,null));
            //IF_DEACTIVATED(_blastSkip,_blastSkipNot,thrdCR(_RUN_DIA_BLAST_AFTER_DB,this))));
            IF_DEACTIVATED(awtc(AWTC_REVALAND_REPAINT_MAYBE,setFG(0,setTxt("Loading ...",_blastLabDB))));;
        }
        if(bid==BUTS_GO){
            FORi(0,sze(_queue)){
                final Runnable r=_queue[i];
                if(r!=null && gcp(KOPT_DISPOSED,this)==null){
                    final int time=timeOn();
                    r.run();
                    if(timeOn()-time>4444) speak(RETURN_THREAD,"Blast finished");
                }
            }
        }
        final int nP=spp(_jlistSequences).length;
        if(nP>0) baLog(LOG_MSG).send();
#if CPP_DEACTIVATED
        if(bid==BB_choiceTypeOfSequence || bid==SDIALOGS_CHOICE_CLASS || (id==RUN_M_focusLost||bid==ACTION_ENTER) && (bid==BB_blastSkip||bid==BB_blastSkipNot)){
            final Object renderer=_jlistSequences.getCellRenderer();
            if(renderer instanceof Strap) ((Strap)renderer)._idata[IDATA_LSTMDL_FILTER]=getSlctIdx(_bb[BB_choiceTypeOfSequence])==WITH_INTRON?IF_NT_or_ACTGN: getSlctIdx(_bb[BB_choiceTypeOfSequence])==NO_INTRON?IF_NT:0;
            awtc(AWTC_OPT_REPAINT,_jlistSequences);
            runCR(_RUN_DIA_BLAST_updateDB,this);
        }
#endif //CPP_DEACTIVATED
        if(bid==SBUTS_DIA_BLAST_Go){
            final Protein[]pp=spp(_jlistSequences);
            if(nP==0) new BA(99).a(RED_ERROR).aln(rsc(RSC_MSG_NoSeqSel)).special(BA_ERROR);
            else{
                int count=0;
                _queue=new Runnable[pp.length];
                final int mode=getSlctIdx(_bb[BB_choiceTypeOfSequence]);
                final Collection vNotACTG=new ArrayList();
                for(Protein p:pp){
                    byte[]seq=p.getResType();
                    int optQ=BLAST_NUCLEOTIDE_QUERY;
                    if(mode==AA_OR_NT_GUESS){
                        if(!p.onlyActgn()) optQ=0;
                        else if(p.countRes()<50){
                            vNotACTG.add(p);
                            optQ=0;
                        }
                    }else if(mode==WITH_INTRON){
                        if(null!=p.triplets()) seq=p.triplets();
                        else if(!p.onlyActgn()){
                            vNotACTG.add(p);
                            optQ=0;
                        }
                        seq=p.triplets()!=null?p.triplets(): p.onlyActgn()?seq:null;
                    }else{/*X NO_INTRON*/
                        if(p.getNucleotides()!=null) seq=p.getNucleotides();
                        else if(!p.onlyActgn()){
                            vNotACTG.add(p);
                            optQ=0;
                        }
                    }
                    if(sze(seq)==0) continue;
                    final boolean isAminoDB=!isSlct(_bb[STOGS_DIA_BLAST_Detail])||isSlct(_bb[STOGS_DIA_BLAST_Amino]);
                    final String
                        query=substrg(seq,xatoi(_tfFrom)-firstResIdx(p)-1,mini(strLen(seq),xatoi(_tfTo)-firstResIdx(p))),
                        db=isSlct(_bb[STOGS_DIA_BLAST_Detail])?s(_bb[isAminoDB?CHOICE_DB_AMINO:CHOICE_DB_NUC]):
                        radioGrpIdx(_radioDB)==0?"pdb": radioGrpIdx(_radioDB)==1?"uniprotkb": "uniref90";
                    final SDialogs tab=new SDialogs(TAB_BLAST);
                    tab._bb[TAB_BLAST_blaster]=new SequenceBlaster(optQ|(isAminoDB?0:BLAST_NUCLEOTIDE_DB),getSlctIdx(_choiceClass),query,db,s(p));
                    tab._bb[TAB_BLAST_query]=query;
                    tab._bb[TAB_BLAST_db]=db;
                    //tab._bb[TAB_BLAST_name]=iConst(SARRAYeq_BLAST_CMD,blaster._type);
                    tab._p=p;
                    runCR(RUN_INIT_DIALOG,tab);
                    _queue[count++]=thrdCR(_RUN_DIABLAST_COMPUTE,tab);
                    adTab(DISPOSE_CtrlW,s(new BA(99).aWithoutLstCmpnt('.',p).a(" ...")),tab,_tabbed);
                }
                if(sze(vNotACTG)>0) new BA(99).a(RED_ERROR).aln("Sequence contains letters other than A C T G U or N. ").joinSpc(vNotACTG).special(BA_ERROR);
                thrdCR(_RUN_DIABLAST_COMPUTE|THRDCR_START,this);
            }
        }
        if(bid==SDIALOGS_JLIST_SEQUENCES){
            setEnbld(nP==1,_tfFrom);
            setEnbld(nP==1,_tfTo);
        }
        BREAK;
    }
 }
#if CPP_DEACTIVATED
private static void skipDatabases(SequenceBlaster b,Object tfSkip,Object tfSkipNot){
    final SequenceBlaster ab=derefZ(b,SequenceBlaster.class);
    if(ab!=null) ab.skipDatabases(splitTkns(s(tfSkip)),splitTkns(s(tfSkipNot)));
}
#endif //CPP_DEACTIVATED
#if CPP_DEACTIVATED
class SortBlastDatabases implements Comparator{
    private final String[]_ddDefault,_dd;
    public SortBlastDatabases(String[]ddOrig,String[]ddDefault){
        ROFi0((_ddDefault=new String[sze(ddDefault)]).length) _ddDefault[i]=lstTkn(ddDefault[i]);
        Arrays.sort(_dd=ddOrig.clone(),this);
    }
    public String[]sorted(){return _dd;}
    public int compare(Object o1,Object o2){
        final String s1=(String)o1,s2=(String)o2;
        if(s1==null) return s2==null?0:1;
        if(s2==null) return -1;
        final int isDefault1=isDefault(s1),isDefault2=isDefault(s2);
        if(isDefault1!=isDefault2) return isDefault1>isDefault2?-1:1;
        return s1.compareTo(s2);
    }
    private int isDefault(String s){
        ROFi0(_ddDefault.length) if(strEnds(STR_IC|STR_w,_ddDefault[i],s)) return _ddDefault.length-i;
        return -1;
    }
#endif //CPP_DEACTIVATED
#undef AA_OR_NT_GUESS
#undef NO_INTRON
#undef WITH_INTRON
#undef CHOICE_DB_NUC
#undef CHOICE_DB_AMINO
#undef BB_choiceTypeOfSequence
#undef _tfFrom
#undef _tfTo
#undef _radioDB
