/*(NUM1 1)*/
#define _tfFrom _bb[1]
#define _tfTo _bb[2]
#define BB_choiceViewType 3
#define _choiceSeqsPanBoth _bb[4]

@*H THIS_CLASS(DIA_COMPARE_SEQUENCES)

This dialog allows the pairwise comparison of a set of proteins.
Numeric (float) values are computed for pairs of proteins using the method selected by the user.

As an example  "sequence dissimilarity" yields the proportion of amino acids that are different
in both sequences.

<BR>
These values can be visualized as:
<UL>
<LI>A table with each row and column representing a protein.</LI>

<LI>A graph of proteins. The  proteins are the graph nodes.
The length of the  graph edges which connect  the  protein nodes   represent the  distance.</LI>

</UL>

<i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogBarChart)</i>
*@
#define AS_GRAPH 0
#define AS_TABLE 1
#define AS_LIST_OF_PAIRS 2
@*SARRAY_DialogCompareProteins_CHOICE
 Graph|Table (n x m matrix)|List of sequence pairs
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _choiceSeqsPanBoth=pnl(GRIDLAYOUT(1,2));
        pcp(KEY_ENABLED,_choiceClass=classChoice(INTRFC_CompareTwoProteins|CLASSCHOICE_SHIFT_SAVEPRPRTY(PRPRTY_CompareProteins_method)),
            _jlistSequences=newProteinJlist(NEWPROTEINJLIST_SELECT_ALL));

        final Object
            details=pnl(VBHB,
                        pnl(FLOWLEFT,"Alignment range  from: ",_tfFrom=new ChTextField("1").cols(6),"  to: ",_tfTo=new ChTextField(s(999999)).cols(6),"(inclusive) "),
                        buttn(TOG_CACHE),
                        buttn(TOG_ALI_NOT_COMMUT));
        pnl(this,CNSEW,null,pnl(HBL,"View as ",_bb[BB_choiceViewType]=addActLi(this,new ChJCombo(arry(SARRAY_DialogCompareProteins_CHOICE)).savePrprty(PRPRTY_CompareProteins_mode))),
            pnl(VB,
                getPnl(_choiceClass),
                pnl(HBL,pnlTogglOpts(details),"#",newBut(BUTS_GO,this),"#"),
                details));
        runCR(_RUN_DIA_COMPARE_SEQUENCES_CHOICE_Layout,this);
        break;
    }
    CASE_ARGV(_RUN_DIA_COMPARE_SEQUENCES_CHOICE_Layout){
        remove(scrllpn(SCRLLPN_OPTS_PROTEINS,_jlistSequences));
        awtc(AWTC_REMOVE_FROM_PARENT,_choiceSeqsPanBoth);
        awtc(AWTC_REMOVE_ALL,_choiceSeqsPanBoth);
        final int i=getSlctIdx(_bb[BB_choiceViewType]);
        if(i==0)add(scrllpn(SCRLLPN_OPTS_PROTEINS,_jlistSequences),BorderLayout_CENTER);
        if(i==1){
            adC(scrllpn(0,_jlistSequences),_choiceSeqsPanBoth);
            adC(scrllpn(SCRLLPN_OPTS_PROTEINS,pcp(KEY_ENABLED,addActLi(this,_choiceClass),_bb[SDIALOGS_JLIST_SEQUENCES_2]=newProteinJlist(NEWPROTEINJLIST_SELECT_ALL))),_choiceSeqsPanBoth);
        }
        if(i!=0) add((Component)_choiceSeqsPanBoth,BorderLayout_CENTER);
        awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,this);
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        baLog(LOG_MSG).send();
        if(bid==BB_choiceViewType) {awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_choiceClass); runCR(_RUN_DIA_COMPARE_SEQUENCES_CHOICE_Layout,this);}
        if(bid==SDIALOGS_CHOICE_CLASS) {awtc(AWTC_OPT_REPAINT,_jlistSequences); awtc(AWTC_OPT_REPAINT,_bb[SDIALOGS_JLIST_SEQUENCES_2]);}
        if(bid==BUTS_GO){
            Protein[]ppRow=ppSelectedMinNum(-1,_jlistSequences),ppCol=null;
            final int from=maxi(0,xatoi(_tfFrom)-1),to=xatoi(_tfTo);
            final Object sharedInst=instanceOfSelectedClass(MKINSTANCE_SHOW_ERROR,_choiceClass);
            pcp(_KEY_MAP_INSTANCE,null,_choiceClass);/*X Order of lines! Apply current Settings only to this result tab */
            closC(CLOSE_DISPOSE,ChFrame.frame(0,"",sharedCtrlPnl(sharedInst)));
            final int i=getSlctIdx(_bb[BB_choiceViewType]);
            if(i== AS_LIST_OF_PAIRS){
                final SDialogs tab=new SDialogs(TAB_COMPARE_SEQUENCES_PAIR);
                tab._bb[TAB_COMPARE_SEQUENCES_PAIR_class]=selItemJC(_choiceClass);
                tab._sharedInstance=sharedInst;
                tab._ii[TAB_COMPARE_SEQUENCES_PAIR_from]=from;
                tab._ii[TAB_COMPARE_SEQUENCES_PAIR_to]=to;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(DISPOSE_CtrlW,"Pairs",tab,_tabbed);
            }else if(i==AS_TABLE||pleaseSelect(CHAINTYPE_PEP|(3<<PLEASE_SELECT_N_SHIFT),ppRow).length>2){
                if(i==AS_TABLE){
                    if((ppCol=spp(_bb[SDIALOGS_JLIST_SEQUENCES_2])).length==0) ppCol=ppRow.length<2?strapProteins():ppRow;
                    if(eqArry(0,ppCol,ppRow)) ppCol=ppRow;
                }
                //adTab(DISPOSE_CtrlW,iConst(SARRAY_DialogCompareProteins_CHOICE,i),new TabCompareSequences(selItemJC(_choiceClass),sharedInst,ppRow,null,from,to),_tabbed);
                //TabCompareSequences(Object clas,Object sharedInst,Protein[]ppRow,Protein ppCol[],int fromColumn,int toColumn){
                final SDialogs tab=new SDialogs(TAB_COMPARE_SEQUENCES);
                tab._choiceClass=_choiceClass;
                tab._sharedInstance=sharedInst;
                tab._pp=ppRow;
                tab._pp2=ppCol;
                tab._ii[TAB_COMPARE_SEQUENCES_fromCol]=from;
                tab._ii[TAB_COMPARE_SEQUENCES_toCol]=to;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(DISPOSE_CtrlW,iConst(SARRAY_DialogCompareProteins_CHOICE,i),tab,_tabbed);
            }
            BREAK;
        }
    }
 }
#undef _tfFrom
#undef _tfTo
#undef BB_choiceViewType
#undef _choiceSeqsPanBoth
#undef AS_GRAPH
#undef AS_TABLE
#undef AS_LIST_OF_PAIRS
