@*H THIS_CLASS(DIA_DIFFRES)
Based on the current sequence alignment two aligned sequences are
compared residue by residue and all different residues are reported.
The result can be used in different ways:
<OL>
  <LI>
    Homology modeling: Some 3D viewers such as the Swiss-viewer
    (http://www.expasy.org/spdbv/  can substitute residues in a
    3D-structure.
    With this dialog the commands to replace
    the residues of the 3D-structure by the residues of a raw
    sequence can be generated.
    Alignment gaps are not considered.
    <BR>
    <B>Customization:</B> These commands can be modified  using the customize dialog.
    The contents of the n-th column is referred to by backslash n.
  </LI>
  <LI>
    Differing positions may be used to generate residue annotations.
  </LI>
</OL>

<i>HTMLDOC_SEE_CLASS:BUT_C1(ResidueAnnotation)</i>
*@


@*SARRAYeq_DIA_DIFFRES_strings
Select target sequence (Usually from a structure  pdb or mmCIF file)=1
Select source sequence (e.g. a sequence file)=2
Select two different sequences=3
*@
/*(NUM1 1)*/
#define DIA_DIFFRES_CHOICE_SEQ_WITH_XYZ 1
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        return pnl(VBPNL,
                   iConst(SARRAYeq_DIA_DIFFRES_strings,1),
                   _bb[DIA_DIFFRES_CHOICE_SEQ_WITH_XYZ]=newProteinCombo(0),
                   " ",
                   iConst(SARRAYeq_DIA_DIFFRES_strings,2),setSelIdx(1,_choiceSequence=newProteinCombo(0)),
                   newBut(BUTS_GO,this));
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            final Protein p=sp(_choiceSequence),p3D=sp(_bb[DIA_DIFFRES_CHOICE_SEQ_WITH_XYZ]);
            if(p==null || p3D==null || p==p3D) baLog(LOG_MSG).a(RED_ERROR).aln(iConst(SARRAYeq_DIA_DIFFRES_strings,3));
            else{
                final SDialogs tab=new SDialogs(TAB_DIFFRES);
                tab._p=p;
                tab._p2=p3D;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(DISPOSE_CtrlW,plrl(++_resultNum,"%n    "),tab,_tabbed);
            }
        }
        BREAK;
    }
 }
