@*H THIS_CLASS(DIA_DNA)
 This Dialog allows to translate coding nucleotide sequences into amino acid sequences.
 Three nucleotides are called a triplet and are translated into one amino acid (WIKI:Genetic_code).

 The user selects either the forward or the reverse complement strand  and can select translated (i.e. WIKI:Exons) and untranslated
 (i.e. WIKI:Introns,  WIKI:Untranslated_region UTRs) sequence regions.
 The coding nucleotides (Exons) are  bright (WIKI:Coding_sequence), while
 non-coding nucleotides are darker.

 The horizontal scroll-bar outlines the intron-exon structure of DNA.

 <BR><BR>

 <B>Change coding/non-coding:</B> By pressing the Insert-key or
 Space-bar, nucleotides are turned into coding nucleotides which are
 drawn bright white.  Conversely, Backspace and Delete turns translation
 int amino acids off and creates or prolongs introns and UTRs. Those
 nucleotides are drawn gray.

 <BR><BR>
 <B>Navigation:</B>
 The keys &larr;, &rarr;, Home, End, PgUp, PgDown and the mouse allow navigation within the DNA sequence.
 The Shift-key in conjunction with these keys creates a block selection.

 <B>Alt+&rarr;</B> and <B>Alt+&larr;</B> jumps to the next interesting sequence
 position. These positions are intron/exon boundaries and selected
 nucleotides or selected amino acids.  Typing letter <B>c</B> jumps to
 the nucleotide position corresponding to the alignment-cursor.
 Typing a number followed by letter N, E  or A goes to the
 i-th nucleotide, exon or amino acid, respectively.

 <BR><BR><B>Num-prefix</B> Some key-stroke can be applied n times.  For
 example typing a number followed by Insert will turn the next n
 nucleotides into coding nucleotides.

 <BR><BR><B>Zoom:</B>
 Ctrl+<B>+</B> and Ctrl+<B>-</B> or Ctrl+Wheel

 <BR><BR><B>Saving/restoring cursor and scroll position:</B> To store the current position,  type a
 number followed by upper letter <B>S</B>. For
 reverting to a saved position type the number followed by
 lower letter<B>s</B>.
 <BR><BR><B>Mouse actions:</B>
 Left-click an amino acid moves the alignment cursor to the clicked residue.
 <i>HTMLDOC_SEE_DIALOG:BUT_C1(DialogGenbank)</i>
*@
/* (NUM1 0) */
#define CHOICE_TRANSLATE_F 0
#define CHOICE_TRANSLATE_RC 1
#define CHOICE_DISPOSE 2
#define CHOICE_GB 3
/* --- */
@*SARRAYeq_EditDna_CHOICE
 Translate forward=CHOICE_TRANSLATE_F
 Translate rev compl=CHOICE_TRANSLATE_RC
 By sequence file=CHOICE_GB
 Dispose=CHOICE_DISPOSE
*@
@*~RSC_EditDna_Msg
 <B>Options</B>
 <OL>
 <LI>Translate nucleotide sequence in forward orientation.</LI>
 <LI>Translate nucleotide sequence in reverse complement orientation.</LI>
 <LI>Dispose existing translation</LI>
 <LI>Use CDS (Coding sequence) attribut in sequence file</LI>
 </OL>
*@
/* (NUM1 1) */
#define _pnlFocus _bb[1]
#define _pnlEditors _bb[2]
/* --- */
#define _tables _mapProtObj
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _tables=new WeakHashMap();
        pnl(this,CNSEW,_pnlEditors=pnl(VB,"##",pnl()),
            pnl(HB,_bb[SBUTS_DIA_DNA_table],_bb[SBUTS_DIA_DNA_orientation],"#",smallHelpBut(this)),
            pnl(REMAINING_VSPC1));
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        final Protein p=sp(orO(deref(_pnlFocus),iThEl(0,childsR(_pnlEditors,SDialogs.class))));
        if(p!=null){
            if(bid==SBUTS_DIA_DNA_orientation){
                final int c;
                {
                    String[]ss=arry(SARRAYeq_EditDna_CHOICE);
                    if(p.countCDS()==0) (ss=ss.clone())[CHOICE_GB]=null;
                    c=dlgOption(pnl(rsc(RSC_EditDna_Msg)),rmNullS(ss));
                }
                switch(c){
                case CHOICE_DISPOSE:p.setExons(null,false);break;
                case CHOICE_GB:runCR1(RUN_COMPUTE,addDialogSetClassAndSequences(BUT_C1(DialogGenbank),null,spp(p)),null);break;
                case CHOICE_TRANSLATE_F:
                case CHOICE_TRANSLATE_RC:
                    p.setExons(new int[][]{},c==CHOICE_TRANSLATE_RC);
                    runCR1(RUN_DIA_DNA_ADD_SEQUENCE_UNLESS_ALREADY,this,p);
                    break;
                }
                strapEvtDispatch(EVT_NUCL_TRANSLATION);
            }
            if(bid==SBUTS_DIA_DNA_table){
                SDialogs tab=(SDialogs)deref(_tables.get(p));
                if(tab==null){
                    _tables.put(p,wref(tab=new SDialogs(DIA_DNA_TABLE_EXONS)));
                    tab._p=p;
                    runCR(RUN_INIT_DIALOG,tab);
                }
                ChFrame.frame(0,addPfx(butTxt(bid),_p),tab).shw();
            }
        }
        BREAK;
    }
    CASE_ARG(RUN_DIA_DNA_SET_FOCUSED,Object,e){
        _pnlFocus=wref(e);
        BREAK;
    }
    CASE_ARG(RUN_DIA_DNA_ADD_SEQUENCE_UNLESS_ALREADY,Protein,sequence)
        CASE_ARG(RUN_DIA_DNA_ADD_SEQUENCE,Protein,sequence){
        final Protein p=sequence;
        if(p!=null){
            SDialogs e=null;
            if(id==RUN_DIA_DNA_ADD_SEQUENCE_UNLESS_ALREADY) for(Object ed:childsR(_pnlEditors,SDialogs.class)) if(sp(ed)==p) e=(SDialogs)ed;
            if(e==null){
                if(!p.isTranslated()){
                    p.setExons(new int[][]{{0},{p.countRes()}},false);
                    strapEvtDispatch(EVT_NUCL_TRANSLATION);
                }
                 e=new SDialogs(DIA_DNA_PANEL);
                e._p=p;
                runCR(RUN_INIT_DIALOG,e);
                adC(e,_pnlEditors);
            }
            _pnlFocus=wref(e);
            awtc(AWTC_OPT_REVALIDATE|AWTC_OPT_REPAINT,_pnlEditors);
        }
        break;
    }
 }

#undef CHOICE_TRANSLATE_F
#undef CHOICE_TRANSLATE_RC
#undef CHOICE_DISPOSE
#undef CHOICE_GB
#undef _tables
#undef _pnlFocus
#undef _pnlEditors
