#define FILTER_COSINUS 0
#define FILTER_TRIANGULAR 1
#define FILTER_CONSTANT 2
/* (NUM1 0) */
#define NT_BT 0
#define NT_FULL 1
#define NT_CDS 2
#define NT_THIS 3
/* --- */
#define WEIGHTS_AVERAGE_VALUE 1024
#define MAX_WERT_SQRT 100
#define MAX_WERT MAX_WERT_SQRT*MAX_WERT_SQRT
#define RADIUS 16
#define THICKNES 4
/* --- */
#define XY_X 0
#define XY_Y 1
#define XY 2
/* (NUM1 1) */
#define BB_butColor 1
#define BB_area 2
#define BB_comboUsage 3
#define BB_comboFilter 5
#define BB_sliderWidth 4
#define BB_sliderBrightness 8
#define BB_sliderThreshold 9
#define _panArrow _bb[6]
#define _labPosition _bb[7]
#define _imageBall _bb[10]
#define _refValues _bb[11]
#define _rectCursor _bb[14]
#define _drawMsg _bb[15]
#define SEQ_PARENT_X 16
#define SEQ_PARENT_Y 17
#define CHOICE_PROT_X 18
#define CHOICE_PROT_Y 19
#define CHOICE_NT_X 20
#define CHOICE_NT_Y 21
#define SEQPANEL_X 22
#define SEQPANEL_Y 23
#define RESSEL_X 24
#define RESSEL_Y 25
#define SBUTS_DOTPLOT_LEFT_X 26
#define SBUTS_DOTPLOT_LEFT_Y 27
#define SBUTS_DOTPLOT_RGHT_X 28
#define SBUTS_DOTPLOT_RGHT_Y 29
#define _codonUsage _bb[30]
#define _color _bb[31]
#define _bl2seq _bb[33]
/* (NUM1 0) */
#define _charW _ii[0]
#define _charH _ii[1]
#define _aliPosX _ii[II_aliPosX]
#define _aliPosY _ii[II_aliPosY]
#define _plotW _ii[2]
#define _plotH _ii[3]
#define _valuesW _ii[4]
#define _valuesH _ii[5]
#define _mcResSel _ii[6]
#define _nSelected _ii[7]
#define _prevPos _ii[8]

#define II_aliPosX 10
#define II_aliPosY 11
#define II_seqLen_X 12
#define II_seqLen_Y 13

#define II_ZZZ 14
/* --- */
/* (NUM1 0) */
#define _selected _iii[0]
/* --- */
#define ressel(xy) _bb[RESSEL_X+xy]
#define seqLen(xy) _ii[II_seqLen_X+xy]
#define _choiceProt(xy) _bb[CHOICE_PROT_X+xy]
#define _choiceNT(xy) _bb[CHOICE_NT_X+xy]
#define protein(xy)  sp(_choiceProt(xy))
#define alignmentPos(xy)  _ii[II_aliPosX+xy]
#define tmp() baClr(368)
#define seqPanel(xy) _bb[SEQPANEL_X+xy]
#define seqPanelParent(xy) _bb[SEQ_PARENT_X+xy]
#define getOffset()   wdth(getSP(seqPanel(xy)).getViewport())/2
#if DIALOG_CODE==0
@*H THIS_CLASS(DIA_DOTPLOT)

A dot-plot is a correlogram of two sequence WIKI:Dot_plot_(bioinformatics).

Each dot in the pane represents a pair of residues from either
protein.  The brightness of the dot is mainly determined by the
similarity of both amino acids according to the blosum62 matrix.  A
number of positions up and downstream are taken into account
with declining weight.

<BR><BR><B>Periodicity</B> Sequence periodicity becomes evident by more than one white oblique trace. See PDB:1g61 for an example.

<BR><BR>White background for printing: <i>HTMLDOC_BUTTON:TOG_WHITE_BG!</i>

<BR><BR><B>Related links:</B> PUBMED:15724278
*@
/* (NUM1 0) */
@*SARRAYeq_DOTPLOT_NUCL_MODE
 Backtranslate=NT_BT
 All nucleotides=NT_FULL
 Coding nucleotides=NT_CDS
 Treat this sequence as nucleotide sequence=NT_THIS
*@
@*SARRAYeq_DOTPLOT_Horizontal_Vertical
 Horizontal=XY_X
 Vertical=XY_Y
*@
@*SARRAYeq_DOTPLOT_FILTER
 Cosinus=FILTER_COSINUS
 Triangular=FILTER_TRIANGULAR
 Constant=FILTER_CONSTANT
*@
private static int[][]_cosinus;
private byte[]_dotplotSeq(int xy){
    final Protein p=protein(xy);
    if(p==null) return NO_byte;
    byte[]seq=p.getResType();
    final int nt=getSlctIdx(_choiceNT(xy));
    if(!isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt]) || nt==NT_THIS) return seq;
    if(nt==NT_FULL){
        seq=p.getNucleotides();
    }else if(nt==NT_CDS){
        seq=p.triplets();
    }else{
        if(_codonUsage==null) _codonUsage=backtransCodonUsage(getSlctIdx(_bb[BB_comboUsage]));
        seq=backtranslate(seq,seq.length,(Codonusage)_codonUsage,false);
    }
    return seq==null?NO_byte: seq;
}
private char _dotplotSeqType(int xy){
    return!isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt])?'a': xy==XY_X && isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_complement])?'N': 'n';
}
private void _dotplotSetPosition(int xy,int pos){
    final byte[]seqx=_dotplotSeq(XY_X),seqy=_dotplotSeq(XY_Y);
    if(seqx.length*seqy.length>0){
        final JComponent a=(JComponent)_bb[BB_area];
        if(xy==XY_X){
            final int old=_plotW*_aliPosX/seqx.length,xNew=_plotW*(_aliPosX=pos)/seqx.length;
            a.paintImmediately(old,0,1,_plotH);
            a.paintImmediately(xNew,0,1,_plotH);
        }else{
            final int old=_plotH*_aliPosY/seqy.length,yNew=_plotH*(_aliPosY=pos)/seqy.length;
            a.paintImmediately(0,yNew,_plotW,1);
            a.paintImmediately(0,old,_plotW,1);
        }
        setTxt(tmp()
               .aBYTES(' ','x','=').aa(_aliPosX,' ',chrAt(_aliPosX,seqx))
               .aBYTES(' ','y','=').aa(_aliPosY,' ',chrAt(_aliPosY,seqy)),_labPosition);
        awtc(AWTC_OPT_REPAINT,_labPosition);
    }
}
/* <<< Alignment <<< */
/* ---------------------------------------- */
/* >>> ResidueSelection >>> */
private static void addPoint(int x,int y,double score,int[][]vHits){
    if(vHits.length<=y) return;
    final int newEntry=x| ((int)(10*score)<<16) | (1<<31);
    int[]hy=vHits[y];
    if(hy==null)hy=vHits[y]=new int[3];
/* --- Point already set? Replace if score is higher. --- */
    ROFi0(hy.length) if(hy[i]!=0 && (hy[i]&0xffFF)==x) hy[i]=maxi(newEntry,hy[i]);
    int idx=0;
    while(idx<hy.length && hy[idx]!=0) idx++;
    if(hy.length<=idx) vHits[y]=hy=chSze(hy,idx+3);
    hy[idx]=newEntry;
}
public void dotplotAddPoints(byte[]tX,int seqx,boolean revX,int fromX,
                             byte[]tY,int seqy,boolean revY,int fromY,
                             double score,int[][]vHits){
    final boolean[]lettr=chrClas(LETTR),eol=chrClas(EOL);
    final char typX=_dotplotSeqType(XY_X);
    final char typY=_dotplotSeqType(XY_Y);
    final boolean ntAutoX=typX=='a' && nxt(0,chrClas(-ACTGUN),_dotplotSeq(XY_X))<0;
    final boolean ntAutoY=typY=='a' && nxt(0,chrClas(-ACTGUN),_dotplotSeq(XY_Y))<0;
    final int stepX=(revX?-1:1) * ((typX|32)=='n'|| (ntAutoX&&!ntAutoY)?3:1);
    final int stepY=(revY?-1:1) * ((typY|32)=='n'?3:1);
    for(int x=fromX,y= (ntAutoY&&!ntAutoX)?fromY/3:fromY;seqx<tX.length && seqy<tY.length; seqx++,seqy++){
        final boolean lx=isChrClas(lettr,tX,seqx);
        final boolean ly=isChrClas(lettr,tY,seqy);
        if(lx&&ly)  addPoint(x,y,score,vHits);
        else if(isChrClas(eol,tX,seqx)||isChrClas(eol,tY,seqy)) break;
        if(lx) x+=stepX;
        if(ly) y+=stepY;
    }
}
/* <<< ResidueSelection <<< */
/* ---------------------------------------- */
/* >>> getValues >>> */
private short[][]getValues(int w,int h){
    int min=Short_MAX_VALUE,max=Short_MIN_VALUE;
    short[][]values=(short[][])deref(_refValues);
    final byte[]seqx=_dotplotSeq(XY_X),seqy=_dotplotSeq(XY_Y);
    if(sze(values)!=w||w<1||values[0].length!=h) values=new short[w][h];
    final int[][]b2s=(int[][])_bl2seq;
    if(b2s!=null){
        if(b2s.length==0) return null;
        for(int iy=b2s.length;--iy>0;){
            final int[]line=b2s[iy];
            if(line!=null){
                for(int d:line){
                    if(d!=0){
                        final int
                            ix=d&0xffff,
                            score=(d>>>16) &0xfff,
                            x=ix*w/seqx.length,
                            y=iy*h/seqy.length,
                            v=score;
                        if(x>=0 && y>=0 && x<w && y<h && values[x][y]<v)  values[x][y]= (short)(v>Short_MAX_VALUE?Short_MAX_VALUE:v);
                    }
                }
            }
        }
        ROFx0(w){
            ROFy0(h){
                int v=values[x][y];
                if(v<min) v=min;
                if(v>max) v=max;
            }
        }
    }else{
        final int
            tX=_dotplotSeqType(XY_X),
            tY=_dotplotSeqType(XY_Y),
            weights[]=_cosinus[mini(COSINUS_SIZE-1,maxi(1,parentC(_bb[BB_sliderWidth])==null?1:intValueC(_bb[BB_sliderWidth])))],
            w2=weights.length/2,
            filter=getSlctIdx(_bb[BB_comboFilter]);
        final boolean isNT=(tX|32)=='n' && (tY|32)=='n',rc=isNT && tX=='N';
        final byte[][]distance=similarityMatrix(rc?SIMILARITY_MATRIX_COMPL:isNT?SIMILARITY_MATRIX_NUC:SIMILARITY_MATRIX_BLOSUM62);
        ROFx0(w){
            final int ix=seqx.length*x/w;
            final short[]vv=values[x];
            Arrays.fill(vv,(short)Short_MIN_VALUE);
            ROFy0(h){
                final int iy=(int)(seqy.length*(double)y/h);
                int sum=0;
                FORi(-weights.length+1,weights.length){
                    final int lx=ix+i,ly=rc?iy-i: iy+i,d=(lx>=0 && ly>=0 && lx<seqx.length && ly<seqy.length)? distance[seqx[lx]][seqy[ly]]:0,abs=i<0?-i:i;
                    sum+=(filter==0?weights[abs]:
                          filter==1?100000*(weights.length-abs):
                          100000/2)*d;
                }
                final short v=sum>Short_MAX_VALUE?Short_MAX_VALUE: sum<Short_MIN_VALUE?Short_MIN_VALUE: (short)sum;
                vv[y]=v;
                if(x>w2 && y>w2 && x<w-w2 && y<h-w2){
                    if(v<min) min=v;
                    if(v>max) max=v;
                }
            }
        }
    }
    if(max>min){
        ROFx0(w){
            final short[]vvX=values[x];
            ROFy0(h){
                final float v=(MAX_WERT*(vvX[y]-(float)min)/(max-min));
                vvX[y]=(short)v;
                IF_MEIN_DEBUG(if((v<-.01 || v>1+MAX_WERT)) putln("Warning DialogDotPlot MAX_WERT="+MAX_WERT));;
            }
        }
    }
    return values;
}
/* <<< getValues <<< */
/* ---------------------------------------- */
/* >>> Coordinates >>> */
private static float amino2x(int pos,boolean nt,int type,byte[]seq,Protein p){
    final float L=seq.length;
    return L==0?-1:
        !nt || type==NT_THIS?pos/L:
        type==NT_CDS || type==NT_BT?pos/L*3:
        type==NT_FULL?p.aa2ntZ(pos,0)/L:
        -1;
}
static int x2amino(float x,boolean nt,int type,byte[]seq,Protein p){
    final float L=seq.length;
    return L==0?-1:
        !nt || type==NT_THIS?(int)(L*x):
        type==NT_CDS || type==NT_BT?(int)(L*x/3):
        type==NT_FULL?p.nt2aaZ((int)(x*L)):
        -1;
}
/* <<< Coordinates <<< */
/* ---------------------------------------- */
/* >>> run >>> */
#endif //DIALOG_CODE==0
#if DIALOG_CODE==1
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final int opt=xatoi(iThEl(0,DOTPLOT_PARA));
        final Protein px=iThProt(1,DOTPLOT_PARA),py=iThProt(2,DOTPLOT_PARA);
        DOTPLOT_PARA=null;
        _opt=opt|DOTPLOT_NOT_SEQUENCE_PANEL;
        if(_cosinus==null){
            _cosinus=new int[COSINUS_SIZE][];
            ROFk0(COSINUS_SIZE){
                _cosinus[k]=new int[k+1];
                for(int i=0;i<=k;i++)_cosinus[k][i]=(int)(100000*(1+Math.cos(i*Math.PI/k)));
                final int[]ww=_cosinus[k];/*X Normalize */
                double mean=0,min=MAX_INT;
                for(int w:ww){
                    if(w<min) min=w;
                    mean+=w;
                }
                mean/=ww.length;
                for(int i=ww.length; mean>0 && --i>=0;) ww[i]=(int)(WEIGHTS_AVERAGE_VALUE*(ww[i]-min)/mean);
            }
        }
        final Object[]panProt1=new Object[XY],panProt2=new Object[XY];
        _dgs=strapInstance(STRAPGUI_DRAW_GAPPED);
        ROFxy0(XY){
            final Protein p=xy==XY_X?px:py;
            final Object sp=scrllpn(SCRLLPN_NO_VSB|SCRLLPN_NO_HSB,
                                    specifcLstnr(MOMOLI_DRAG_SCROLLS_HV,
                                                 pcp(RUN_PROVIDE_PREF_SIZE,this,
                                                     pcp(KOPT_TRACKS_VIEWPORT_HEIGHT,"",
                                                         addLi(this,LSTNR_MO|LSTNR_WHEEL,
                                                               addSrvc(RUN_SERVICE_PAINTHOOK,this,
                                                                            seqPanel(xy)=pnl()))))));
            seqPanelParent(xy)=pnl(CNSEW,sp,null,null,
                                   newButtn((SBUTS_DOTPLOT_RGHT_X|BUTTN_MAC_TYPE_ICON)+xy,">",this),
                                   newButtn((SBUTS_DOTPLOT_LEFT_X|BUTTN_MAC_TYPE_ICON)+xy,"<",this));

            _choiceNT(xy)=addActLi(this,new ChJCombo(arry(SARRAYeq_DOTPLOT_NUCL_MODE)));
            setEnbld(p==null,setTip(iConst(SARRAYeq_DOTPLOT_Horizontal_Vertical,xy),addActLi(this,setSelO(p,_choiceProt(xy)=newProteinCombo(0)))));
            runCR1(RUN_SET_ICON_IMAGE,ressel(xy)=new ResidueSelectionImpl(RESSEL_IMPL_DOTPLOT),img(iicon(IC_BLANK)));
            final Object combo=p==null?_choiceProt(xy):newSeqLabel(0,p);
            panProt1[xy]=0!=(opt&DOTPLOT_NUCLEOTIDES) || xy==XY_Y?combo: pnl(combo,_bb[STOGS_DIA_DOTPLOT_Selection_nt]);
            panProt2[xy]=0!=(opt&DOTPLOT_NUCLEOTIDES)?null: pnl(_choiceNT(xy),xy==XY_Y?null:_bb[STOGS_DIA_DOTPLOT_Selection_complement]);
        }

        if(0==(DOTPLOT_BL2SEQ&opt)){
            IF_PRINT_IMG(pcp(KEY_IMAGE_FILE_NAME,s(tmp().aa(pX,'+',pY,"-bl2seq.png")),this));;
            _bb[BB_sliderWidth]=new ChJSlider(CHJSLIDER_DIA_DOTPLOT_lowPassWidth,this);
        }else{
            _bl2seq=new int[0][];
        }
        pcp(BUTTN_KEY_COLLAPSE,panProt2,_bb[STOGS_DIA_DOTPLOT_Selection_nt]);
        final Object north=pnl(VB,
                               0!=(opt&(DOTPLOT_CB_HITS|DOTPLOT_BL2SEQ))?null:dialogHead(this),
                               0!=(opt&(DOTPLOT_CB_HITS|DOTPLOT_BL2SEQ))?null:pnl(VB,pnl(GRIDLAYOUT(1,2),panProt1),pnl(GRIDLAYOUT(1,2),panProt2)),
                               pnl(GRIDLAYOUT(3,1),addSrvc(RUN_SERVICE_PAINTHOOK,this,_panArrow=pnl()),seqPanelParent(XY_X),seqPanelParent(XY_Y))),
            west=pnl(CNSEW,null,
                     pnl(VBHB,
                         0!=(DOTPLOT_BL2SEQ&opt)?null:pnl(VBHB,
                                                          _bb[BB_sliderWidth],
                                                          pnl(HBL,"Width of low pass filter"),
                                                          pnl("Weights:",_bb[BB_comboFilter]=addActLi(this,new ChJCombo(arry(SARRAYeq_DOTPLOT_FILTER)))),
                                                          " ",_bb[BB_sliderBrightness]=new ChJSlider(CHJSLIDER_DIA_DOTPLOT_Brightness,this),"Brightness",
                                                          " ",_bb[BB_sliderThreshold]=new ChJSlider(0,MAX_WERT_SQRT,MAX_WERT_SQRT/2,this),"Threshhold"),
                         pnl(HBL,"Marks: ",_bb[SBUTS_DIA_DOTPLOT_Selection_add],_bb[SBUTS_DIA_DOTPLOT_Selection_clear],_bb[BB_butColor]=ChButton.doColor(0,RGBA_PINK,this).t("").rover(IC_COLOR)),
                         _bb[STOGS_DIA_DOTPLOT_Selection_trace],
                         _labPosition=pnl(),
                         0==(opt&DOTPLOT_BL2SEQ)?null:pnl(ChButton.doView(_log).t("Log"),newCtrlBut(this)),
                         "##"));
        //pnl(this,CNSEW,_bb[BB_area]=pcp(KOPT_NO_DRAG_PARWINDOW,"",addSrvc(RUN_SERVICE_PAINTHOOK,this,pnl())),
        pnl(this,CNSEW,_bb[BB_area]=addSrvc(RUN_SERVICE_PAINTHOOK,this,pnl()),
            north,
            null,null,
            west);
        awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_800,addLi(this,LSTNR_MOMO|LSTNR_MO|LSTNR_WHEEL,_bb[BB_area]));
        if(0!=(DOTPLOT_BL2SEQ&opt)) thrdCR(_RUN_DIABLAST_BL2SEQ_BG|THRDCR_START,this);
        awtc(AWTC_SET_DISABLED,_bb[BB_butColor]);
        runCR1(_RUN_DOTPLOT_SET_FONT,this,io(24));
        _aliPosX=_aliPosY=10;
        setPrefSze(Short_MAX_VALUE,_charH+1,this);
        _color=C(RGBA_PINK);
        _selected=new int[100];
        BREAK;
    }
    CASE_ARG(_RUN_DOTPLOT_SET_BL2SEQ_DATA,int[][],data){
        _ctrl=null;
        _refValues=null;
        _bl2seq=data;
        awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        BREAK;
    }
    CASE_ARGV(_RUN_DOTPLOT_RECTANGLE_CURSOR){
        final Protein px=protein(XY_X),py=protein(XY_Y);
        if(px==null || py==null || _dotplotSeq(XY_X).length*_dotplotSeq(XY_Y).length==0 || strapCursor(GET_CURSOR_COLUMN)<0) return null;
        int ax=px.columnToIndex(0,strapCursor(GET_CURSOR_COLUMN)),ay=py.columnToIndex(0,strapCursor(GET_CURSOR_COLUMN));
        if(ax<0) ax=-99;
        if(ay<0) ay=-99;
#define x amino2x(ax,isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt]),getSlctIdx(_choiceNT(XY_X)),_dotplotSeq(XY_X),px)
#define y amino2x(ay,isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt]),getSlctIdx(_choiceNT(XY_Y)),_dotplotSeq(XY_Y),py)
        return new Rectangle((int)(_plotW*x),(int)(_plotH*y)-RADIUS/2,RADIUS,RADIUS);
#undef x
#undef y
    }
    CASE_ARGV(_RUN_DOTPLOT_CLR_SELECTION){
        ROFxy0(XY){
            final ResidueSelection s=(ResidueSelection)ressel(xy);
            s.setSelectedAminoacids(null,firstResIdx(protein(xy)));
            rmFromParentProt(s);
        }
        _nSelected=0;
        awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
        BREAK;
    }
    CASE_ARG(_RUN_DOTPLOT_HIGHLIGHT,Graphics,g){
        for(int i=0;i<_nSelected;i+=2){
            final int ix=_selected[i],iy=_selected[i+1];
            if((_imageBall!=null || (_imageBall=imgColoredBall(_color))!=null)&& _dotplotSeq(XY_X).length*_dotplotSeq(XY_Y).length!=0){
                final int radius=wdth(_imageBall);
                imgDrawImage(g,(Image)_imageBall,
                             _plotW*ix/_dotplotSeq(XY_X).length-radius/2,
                             _plotH*iy/_dotplotSeq(XY_Y).length-radius/2,
                             radius,radius,getAlphaComposite(70),this);
            }
        }
        BREAK;
    }
    CASE_ARG(_RUN_DOTPLOT_INC_FONT,int,s)
        CASE_ARG(_RUN_DOTPLOT_SET_FONT,int,s){
        int size=s+(id==_RUN_DOTPLOT_SET_FONT?0:_fontSize);
        if(size<4) size=4;
        ROFxy0(XY){
            final int cb[]=chrBnds(monospc(pcp(KEY_FONT_SIZE,io(size),seqPanel(xy))));
            _charH=cb[RECTh];
            _charW=cb[RECTw];
        }
        BREAK;
    }
    CASE_ARGV(_RUN_DOTPLOT_RESET_IMG){
        _refValues=null;
        awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        awtc(AWTC_OPT_REPAINT,seqPanel(XY_X));
        awtc(AWTC_OPT_REPAINT,seqPanel(XY_Y));
        IF_PRINT_IMG(pcp(KEY_IMAGE_FILE_NAME,s(tmp().aa("Dotplot",'-',protein(XY_X),'-',protein(XY_Y))),this));;
        break;
    }
    CASE_ARGV(RUN_DISPOSE){
        rmFromParentProt(ressel(XY_X));
        rmFromParentProt(ressel(XY_Y));
        return TRUEr;
    }
    CASE_ARG(_RUN_DOTPLOT_SEQ_MOVE_X,Object,intAmount){
        _dotplotSetPosition(XY_X,alignmentPos(XY_X)+xatoi(intAmount));
        runCR(_RUN_DOTPLOT_SEQ_UPDATE_X,this);
        BREAK;
    }
    CASE_ARG(_RUN_DOTPLOT_SEQ_MOVE_Y,Object,intAmount){
        _dotplotSetPosition(XY_Y,alignmentPos(XY_Y)+xatoi(intAmount));
        runCR(_RUN_DOTPLOT_SEQ_UPDATE_Y,this);
        BREAK;
    }
    CASE_ARGV(_RUN_DOTPLOT_SEQ_UPDATE_X)
        CASE_ARGV(_RUN_DOTPLOT_SEQ_UPDATE_Y){
        final int xy=id==_RUN_DOTPLOT_SEQ_UPDATE_X?XY_X:XY_Y,pos=alignmentPos(xy)*_charW;
        if(pos>=0) setIntValueC(pos,getSB(SB_HORIZONTAL,seqPanel(xy)));
        break;
    }
    CASE_ARG(RUN_GET_CTRL_PNL,Object,supported){
        if(supported==PROPERTY_SUPPORTED) return _bl2seq==null?null:PROPERTY_SUPPORTED;
        if(_ctrl==null){
            _ctrl=pnl(CNSEW,scrllpn(0,_log),
                      0!=(_opt&DOTPLOT_NUCLEOTIDES)?null: pnl(VB,pnl("In case of translation of aminos to triplets use the codon table: ",_bb[BB_comboUsage]=addActLi(this,new ChJCombo(arry(SARRAYeq_CODON_USAGE_ORGANISMS)))))
                      );
        }
        RETURN(_ctrl);
    }
    CASE_ARGV(_RUN_DIABLAST_BL2SEQ_BG){
        final byte[]sx=_dotplotSeq(XY_X),sy=_dotplotSeq(XY_Y);
        _log.aBYTES('x',':',' ').aln(sx).aln().aBYTES('y',':',' ').aln(sy).aln();
        if(sx!=null&&sy!=null){
            final int prg=bl2seqPrg(sx,sy,_log),vHits[][]=new int[sy.length][];
            final BA result=bl2seqCompute(BL2SEQ_ALIGNMENT|prg,sx,sy,_log);
            if(result!=null){
                if(strstr(0,"No hits found",result)>=0) _drawMsg="No hits found";
                else{
                    final byte[]T=result.bytes();
                    double score=0;
                    for(int ee[]=result.eol(),fromX=-1,fromY=-1,toX=-1,toY=-1,seqX=-1,seqY=-1,iL=0;iL<ee.length;iL++){
                        final int b=BOL0(iL,ee),e=ee[iL];
                        if(e-b<12) continue;
                        //if(Q(1,'S') && Q(2,'c') && Q(3,'o')  && Q(4,'r') && Q(5,'e')) score=atof(T,b+8,e);//final boolean isX=Q(0,'Q') && Q(1,'u') && Q(2,'e') && Q(3,'r') && Q(4,'y'),isY=Q(0,'S') && Q(1,'b') && Q(2,'j') && Q(3,'c') && Q(4,'t');
                        if(bytsEquls(BYTES('S','c','o','r'),T,b+1) && T[b+5]=='e') score=atof(T,b+8,e);
                        else if(bytsEquls(BYTES('Q','u','e','r'),T,b) && T[b+4]=='y' || bytsEquls(BYTES('S','b','j','c'),T,b) && T[b+4]=='t'){
                            int to=-1;
                            for(int i=b+12;i<e;i++)if(to==-1 && isChrClas(DIGT,T,i)) to=atoi(T,i,e);
                            final int from=atoi(T,b+6,e)-1,seq=nxt(STR_E,chrClas(LETTR),T,b+6,e);
                            if(T[b]=='Q') {
                                fromX=from;
                                toX=to;
                                seqX=seq;
                            }else{
                                fromY=from; toY=to; seqY=seq;
                                if(fromX>=0 && toX>=0 && fromY>=0 && toY>=0)dotplotAddPoints(T,seqX,fromX>toX,fromX,
                                                                                      T,seqY,fromY>toY,fromY,score,vHits);
                            }
                        }
                    }
                    runCR1(_RUN_DOTPLOT_SET_BL2SEQ_DATA,this,vHits);
                }
            }
            _log.send();
        }
        break;
    }/*X _RUN_DIABLAST_BL2SEQ_BG */
    CASE_ARG(RUN_PROVIDE_PREF_SIZE,Object,component){
        ROFxy0(2) if(component==seqPanel(xy)) return dim(_dotplotSeq(xy).length*_charW+getOffset()*2,_charH+2);
        BREAK;
    }
    CASE_ARG(RUN_PAINT_HOOK_AFTER,Object,component){
        final Graphics g=_paintHookG;
        final int W=wdth(component),H=hght(component);
        ROFxy0(2){
            if(component==seqPanel(xy)){
                final Protein p=protein(xy);
                if(p!=null){
                    setColorRGB(isCbSlct(TOG_WHITE_BG)?0xFFffFF:0,g);
                    g.fillRect(0,0,Short_MAX_VALUE,_charH+9);
                    {
                        final byte[]sequence=_dotplotSeq(xy);
                        if(seqLen(xy)!=(seqLen(xy)=sequence.length)) awtc(AWTC_QUEUE_REVALIDATE|AWTC_AFTER_100,this);
                        final char t=_dotplotSeqType(xy);
                        //(t=='n'?DRAWSEQ_AA2NT:t=='N'?dgs.NUCLEOTIDES:0);
                        _dgs.drawSeq((rescolorI()==RESCOLOR_SECSTRU?DRAWSEQ_SECSTRU:0),
                                                       g,
                                                       setXY(getOffset(),0,_origin),
                                                       0,sequence,0,MAX_INT,
                                                       t=='a'?p:null,
                                                       rescolors(isCbSlct(TOG_WHITE_BG)?RESCOLOR_NO_SECSTRU_WHITE_BG:RESCOLOR_NO_SECSTRU));
                    }
                    if(DIFF_MC(_prevPos,intValueC(getSB(SB_HORIZONTAL,seqPanel(xy))))) _dotplotSetPosition(xy,_prevPos/_charW);
                }
            }
        }
        if(component==_bb[BB_area] && W*H!=0){
            _plotH=H;
            final int clip[],minX,minY,maxX,maxY;
            if(_plotW!=W || _plotH!=H){
                minX=minY=0;
                _plotW=maxX=W;
                _plotH=maxY=H;
                clip=null;
            }else{
                clip=clipBnds(g,W,H);
                minX=maxi(0,x(clip));
                minY=maxi(0,y(clip));
                maxX=mini(W,x2(clip)+1);
                maxY=mini(H,y2(clip)+1);
            }
            if(W<3 || H<3) return null;
            g.setFont(mkFont(16,Font_BOLD));
            final Protein px=protein(XY_X),py=protein(XY_Y);
            final byte[]seqx=_dotplotSeq(XY_X),seqy=_dotplotSeq(XY_Y);
            String msg=(String)_drawMsg;
            if(seqx.length*seqy.length==0) msg="Require two sequences!";
            else{
                int brightness=intValueC(_bb[BB_sliderBrightness]),threshhold=intValueC(_bb[BB_sliderThreshold]);
                threshhold*=threshhold;
                short[][]values=(short[][])deref(_refValues);
                {
                    final int
                        vW=mini(seqx.length,W),
                        vH=mini(seqy.length,H);
                    if(values==null||
                       _valuesH!=vH||
                       _valuesW!=vW){
                        _refValues=newSoftRef(values=getValues(_valuesW=vW,_valuesH=vH));
                    }
                }
                final int vWidth=sze(values),vHeight=vWidth>0?values[0].length:0;
                if(vWidth*vHeight==0) return null;
#define autoScale _bl2seq!=null
                int autoScaleMa=MIN_INT,autoScaleMi=MAX_INT;
                if(autoScale){
                    ROFx0(vWidth){
                        ROFy0(sze(values[x])){
                            final int v=values[x][y];
                            if(v<autoScaleMi) autoScaleMi=v;
                            if(v>autoScaleMa) autoScaleMa=v;
                        }
                    }
                }
                if(vHeight>0 && autoScaleMa!=autoScaleMi && MAX_WERT!=threshhold){
                    final boolean isWhiteBG=isCbSlct(TOG_WHITE_BG);
                    final BufferedImage image=sharedImageVerticalGray(vHeight);
                    for(int
                            rgb[]=sharedRGB(vHeight),
                            vMinY=maxi(0,minY*vHeight/H-1),
                            vMaxY=mini(vHeight,maxY*vHeight/H+1),
                            vMaxX=mini(vWidth,maxX*vWidth/W+1),
                            x=maxi(0,minX*vWidth/W-1);x<vMaxX;x++){
                        final short[]valuesX=values[x];
                        Arrays.fill(rgb,vMinY,vMaxY,0);
                        FORy(vMinY,vMaxY){
                            final int v0=(int)valuesX[y];
                            if(v0>threshhold || autoScale){
                                int v=autoScale?(int)(256L*(v0-autoScaleMi)/(autoScaleMa-autoScaleMi)): (v0-threshhold)*brightness/(MAX_WERT-threshhold);
                                if(v>255) v=255; else if(v<0) v=0;
                                if(isWhiteBG) v=255-v;
                                rgb[y]=(v<<16)|(v<<8) |  v;
                            }else if(isWhiteBG) rgb[y]=0xFFffFF;
                        }
                        image.setRGB(0,0,1,vMaxY-vMinY,rgb,vMinY,1);
                        g.drawImage(image,
                                    x*W/vWidth,
                                    vMinY*H/vHeight,
                                    (1+x)*W/vWidth,
                                    vMaxY*H/vHeight,
                                    0,0,1,vMaxY-vMinY,this);
                    }
                }else if(_drawMsg==null){
                    msg=0!=(_opt&DOTPLOT_CB_HITS)?" Activate check-boxes of hits ": " Calculating ...";
                }
            }
            if(msg!=null){/*X  Msg */
                g.fillRect(0,0,W,H);
                setColorRGB(RGBA_PINK,g);
                g.drawString(msg,20,20);
            }
            if(isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_trace])){/*X  Trace */
                setColorRGB(0x66FF64ff,g);
                final boolean isNT=isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt]);
                for(int lineWidth=W/50+1,
                        typeX=getSlctIdx(_choiceNT(XY_X)),
                        typeY=getSlctIdx(_choiceNT(XY_Y)),
                        lastX=-1,lastY=-1,
                        x=minX;x<maxX;x++){
                    final int col=px.getResColumnAt(x2amino(x/(float)W,isNT,typeX,seqx,px)),ay=py.columnToIndex(CTRUE,col);
                    if(py.getResColumnAt(ay)==col){
                        g.fillRect(lastX,lastY-lineWidth/2,x-lastX,lineWidth);
                        lastX=x;
                        lastY=(int)(amino2x(ay,isNT,typeY,seqy,py)*H);
                    }
                }
            }
            runCR1(_RUN_DOTPLOT_HIGHLIGHT,this,g);
            final Object r=runCR(_RUN_DOTPLOT_RECTANGLE_CURSOR,this);
            if(r!=null) imgDrawCursor(g,x(r),y(r),wdth(r),hght(r),this);
            _rectCursor=r;
            if(_aliPosX>=0 && _aliPosY>0 && seqx.length>0 && seqy.length>0){
                setColorRGB(0xFF0000,g);
                final int x=W*_aliPosX/seqx.length,y=H*_aliPosY/seqy.length;
                g.drawLine(0,y,W,y);
                g.drawLine(x,0,x,H);
            }
            ROFt0(XY){
                if((t!=0?minX:minY)>THICKNES) continue;
                final Protein p=t!=0?py:px;
                final byte[]ss=p.getResidueSecStrType();
                if(ss!=null){
                    final int nR=p.countRes(),rgb[]=sharedRGB(nR);
                    final BufferedImage im=t!=0?sharedImageVertical(nR):sharedImageHorizontal(nR);
                    {
                        final int start=p.subsetStart();
                        ROFi0(nR) rgb[i]=i+start<ss.length?rescolorRGBA(RESCOLOR_SECSTRU)[ss[i+start]]:0;
                    }
                    if(t!=0){
                        im.setRGB(0,0,1,nR,rgb,0,1);
                        g.drawImage(im,0,0,THICKNES-1,H,0,0,1,nR,this);
                    }else{
                        im.setRGB(0,0,nR,1,rgb,0,nR);
                        g.drawImage(im,0,0,W,THICKNES-1,0,0,nR,1,this);
                    }
                }
            }
        }else if(component==_panArrow){
            setColorRGB(0xFF0000,g);
            g.drawLine(W/2,0,W/2,H);
            g.drawLine(W/2-EM/2,H-EM,W/2,H);
            g.drawLine(W/2+EM/2,H-EM,W/2,H);
        }
        BREAK;
    }/*X RUN_PAINT_HOOK_AFTER*/
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        boolean repaintSeq=false;
        if((t==EVT_BACKGROUND_CHANGED || t==EVT_ALIGNMENT) && isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_trace])) awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        if(t==EVT_BACKGROUND_CHANGED || t== EVT_ALIGNMENT || t==EVT_CURSOR_RESIDUE || t==EVT_CURSOR_SEQUENCE){
            repaintRectC(_bb[BB_area],IF_CHECK_CODE((Rectangle))_rectCursor);
            repaintRectC(_bb[BB_area],IF_CHECK_CODE((Rectangle))(_rectCursor=runCR(_RUN_DOTPLOT_RECTANGLE_CURSOR,this)));
            repaintSeq=true;
        }
        if(t==EVT_RESIDUE_SELECTION || t==EVT_RESIDUE_SELECTION_COLOR){
            final Protein px=protein(XY_X),py=protein(XY_Y);
            if(px!=null && py!=null && DIFF_MC(_mcResSel,px.mc(P_MC_RES_SELECTIONS)+py.mc(P_MC_RES_SELECTIONS)+modic(_choiceProt(XY_X))+modic(_choiceProt(XY_Y))))  repaintSeq=true;
        }
        if(EVT_RESIDUES_AAA<t && t<EVT_RESTYPE_ZZZ) runCR(_RUN_DOTPLOT_RESET_IMG,this);
        if(t==EVT_AA_SHADING_CHANGED || repaintSeq) {
            awtc(AWTC_OPT_REPAINT,seqPanel(XY_X));
            awtc(AWTC_OPT_REPAINT,seqPanel(XY_Y));
        }
        RETURN TRUEr;
    }
    CASE_ARG(RUN_M_mousePressed,Object,ev)
        CASE_ARG(RUN_M_mouseDragged,Object,ev){
        if(bid==BB_area){
            final int h=_plotH,w=_plotW;
            if(w*h!=0 && protein(XY_X)!=null && protein(XY_Y)!=null){
                _dotplotSetPosition(XY_X,x(ev)*_dotplotSeq(XY_X).length/w);
                _dotplotSetPosition(XY_Y,y(ev)*_dotplotSeq(XY_Y).length/h);
                runCR(_RUN_DOTPLOT_SEQ_UPDATE_X,this);
                runCR(_RUN_DOTPLOT_SEQ_UPDATE_Y,this);
                awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_DOTPLOT_Selection_add]);
            }
        }
        BREAK;
    }
    CASE_ARG(RUN_M_mouseReleased,Object,ev){
        awtc(AWTC_OPT_REPAINT,seqPanel(XY_X));
        awtc(AWTC_OPT_REPAINT,seqPanel(XY_Y));
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev)
        CASE_ARG(RUN_M_stateChanged,Object,ev){
        if(bid==SBUTS_DOTPLOT_LEFT_X) runCR1(_RUN_DOTPLOT_SEQ_MOVE_X,this,io(-1));
        if(bid==SBUTS_DOTPLOT_RGHT_X) runCR1(_RUN_DOTPLOT_SEQ_MOVE_X,this,io(1));
        if(bid==SBUTS_DOTPLOT_LEFT_Y) runCR1(_RUN_DOTPLOT_SEQ_MOVE_Y,this,io(-1));
        if(bid==SBUTS_DOTPLOT_RGHT_Y) runCR1(_RUN_DOTPLOT_SEQ_MOVE_Y,this,io(1));
        if(bid==BB_butColor){
            setColrO(_color=getColr(_bb[BB_butColor]),ressel(XY_X));
            setColrO(_color,ressel(XY_Y));
            _imageBall=null;
            runCR1(_RUN_DOTPLOT_HIGHLIGHT,this,awtGraphics(_bb[BB_area]));
            strapEvtDispatch(EVT_RESIDUE_SELECTION_COLOR|SEVTMS*111);
            awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        }
        if(bid==BB_comboUsage){
            runCR(_RUN_DOTPLOT_RESET_IMG,this);
            if(bid==BB_comboUsage) _codonUsage=null;
        }
        if(bid==STOGS_DIA_DOTPLOT_Selection_nt){
            awtc(AWTC_OPT_REVALIDATE,seqPanel(XY_X));
            awtc(AWTC_OPT_REVALIDATE,seqPanel(XY_Y));
            runCR(_RUN_DOTPLOT_RESET_IMG,this);
        }
        if(bid==CHOICE_PROT_X||bid==CHOICE_PROT_Y||bid==CHOICE_NT_X || bid==CHOICE_NT_Y || bid==STOGS_DIA_DOTPLOT_Selection_nt || bid==STOGS_DIA_DOTPLOT_Selection_complement){
            runCR(_RUN_DOTPLOT_CLR_SELECTION,this);
            runCR(_RUN_DOTPLOT_RESET_IMG,this);
        }
        if(bid==STOGS_DIA_DOTPLOT_Selection_trace) awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        if(bid==SBUTS_DIA_DOTPLOT_Selection_clear){
            runCR(_RUN_DOTPLOT_CLR_SELECTION,this);
            awtc(AWTC_SET_DISABLED,_bb[SBUTS_DIA_DOTPLOT_Selection_clear]);
            awtc(AWTC_SET_DISABLED,_bb[BB_butColor]);
        }
        if(bid==SBUTS_DIA_DOTPLOT_Selection_add){
            if(_nSelected+2<_selected.length){
                _selected[_nSelected++]=_aliPosX;
                _selected[_nSelected++]=_aliPosY;
            }
#define isNT isSlct(_bb[STOGS_DIA_DOTPLOT_Selection_nt])
            FORxy(0,XY){
                final ResidueSelection s=(ResidueSelection)ressel(xy);
                final byte[]seq=_dotplotSeq(XY_X);
                if(seq.length>0){
                    resSelSetAminoSelected(SELECTION_ADD,x2amino(alignmentPos(xy)/((float)seq.length),isNT,getSlctIdx(_choiceNT(xy)),seq,protein(xy)),ALIAS_POSITION_PLUS_1,s);
                    addToProt(s,protein(xy));
                    setColrO(_color,s);
                }
            }
#undef isNT
            runCR(_RUN_DOTPLOT_SEQ_UPDATE_X,this);
            runCR(_RUN_DOTPLOT_SEQ_UPDATE_Y,this);
            strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
            awtc(AWTC_SET_ENABLED,_bb[BB_butColor]);
            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_DOTPLOT_Selection_clear]);
            awtc(AWTC_OPT_REPAINT,_bb[BB_area]);
        }
        if(bid==BB_sliderWidth || bid==BB_comboFilter) runCR(_RUN_DOTPLOT_RESET_IMG,this);
        if(bid==BB_sliderThreshold||bid==BB_sliderBrightness||bid==BB_sliderThreshold) awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_100,_bb[BB_area]);
        BREAK;
    }
 }
#define ev arg
{
    final int wheel=evtWheel(ev);
    if(wheel!=0){
        if(bid==BB_area){
            UNLESS_CHECK_CODE(runCR1(0!=(modi&SHIFT_MASK)?_RUN_DOTPLOT_SEQ_MOVE_X:_RUN_DOTPLOT_SEQ_MOVE_Y,this,io(5*wheel)));;
            awtc(AWTC_QUEUE_REPAINT|AWTC_AFTER_200,_bb[BB_area]);
        }else{
            if(0!=(modi&CTRL_MASK)) runCR1(_RUN_DOTPLOT_INC_FONT,this,io(wheel));
            else setIntValueC(intValueC(getSB(SB_HORIZONTAL,evtSrc(ev)))+wheel*EM,getSB(SB_HORIZONTAL,evtSrc(ev)));
                              }
    }
}
#undef ev
#endif //DIALOG_CODE==1

#undef FILTER_COSINUS
#undef FILTER_TRIANGULAR
#undef FILTER_CONSTANT
#undef NT_BT
#undef NT_FULL
#undef NT_CDS
#undef NT_THIS
#undef WEIGHTS_AVERAGE_VALUE
#undef MAX_WERT_SQRT
#undef MAX_WERT
#undef RADIUS
#undef THICKNES
#undef XY_X
#undef XY_Y
#undef XY
#undef _panArrow
#undef _labPosition
#undef BB_sliderBrightness
#undef BB_sliderThreshold
#undef _imageBall
#undef _refValues
#undef _rectCursor
#undef _drawMsg
#undef SEQ_PARENT_X
#undef SEQ_PARENT_Y
#undef CHOICE_PROT_X
#undef CHOICE_PROT_Y
#undef CHOICE_NT_X
#undef CHOICE_NT_Y
#undef SEQPANEL_X
#undef SEQPANEL_Y
#undef RESSEL_X
#undef RESSEL_Y
#undef SBUTS_DOTPLOT_LEFT_X
#undef SBUTS_DOTPLOT_LEFT_Y
#undef SBUTS_DOTPLOT_RGHT_X
#undef SBUTS_DOTPLOT_RGHT_Y
#undef _codonUsage
#undef _color
#undef _bl2seq
#undef _charW
#undef _charH
#undef _aliPosX
#undef _aliPosY
#undef _plotW
#undef _plotH
#undef _valuesW
#undef _valuesH
#undef _mcResSel
#undef _nSelected
#undef _prevPos
#undef II_aliPosX
#undef II_aliPosY
#undef II_seqLen_X
#undef II_seqLen_Y
#undef II_ZZZ
#undef _selected
#undef x
#undef y
#undef autoScale
#undef tmp
#undef BB_butColor
#undef BB_area
#undef BB_comboUsage
#undef BB_sliderWidth
#undef BB_comboFilter
