/* (NUM1 1) */
#define _jlistWritten _bb[2]
@*H THIS_CLASS(DIA_EXPORT_SEQUENCES)
 <h3>Using the export dialog (file-menu)</h3>
 Single sequence files can be exported in various output formats.

 <h3>Dragging sequences with the mouse</h3>

 Proteins can be dragged from the alignment to the desktop or the file browser.

 Sequences can be grabbed with the mouse at their sequence label as found in the row header of
 the alignment.

 Proteins can be dropped in other Desktop applications that support  WIKI:Drag_and_drop.
 They may also be dropped into another Strap instance.

 <BR><BR>
 The original file that the sequence was loaded from, is directly transferred even if the 3D orientation
 has been changed in Strap or the N-terminus or C-terminus have been cleaved off.
 This behavior can be changed with an option pane. The button to open this option pane appears in the Strap tool pane when the sequences are dragged.
*@
@*~RSC_DialogExportProteins_BALLOON1
 For the selected sequences, output files are written.
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object west=pnl(VBHB,pcpKey(KOPT_TRACKS_VIEWPORT_WIDTH),
                              getPnl(_choiceClass=classChoice(INTRFC_ProteinWriter)),
                              buttn(STOG_DIA_EXPORT_SEQUENCES_Rubber_Band),
                              pnl(setTip(io(RSC_DialogExportProteins_BALLOON1),newBut(BUTS_GO,this))),
                              new BA(99).aa("Target directory: ",iFile(DIR_STRAPOUT),"<BR>Hint: Also consider Drag-and-Drop ",buttn(BUTS_MOVIE_Export_Proteins)));
        return pnl(GRIDLAYOUT(1,2),scrllpn(SCRLLPN_INHERIT_SIZE,_jlistSequences=newProteinJlist(0)),west);
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==STOG_DIA_EXPORT_SEQUENCES_Rubber_Band) setEnbld(!isCbSlct(STOG_DIA_EXPORT_SEQUENCES_Rubber_Band),_jlistSequences);
        if(bid==BUTS_GO){
            baLog(LOG_MSG).send();
            int fromCol=0,toCol=MAX_INT;
            Protein[]pp=null;
            if(isCbSlct(STOG_DIA_EXPORT_SEQUENCES_Rubber_Band)){
                if(sze(pp=ppInRectangle(null,null))==0) error("No sequence marked by rubber band");
                else{
                    fromCol=x(rectRubberBand(null));
                    toCol=x2(rectRubberBand(null));
                }
            }else{
                pp=proteinJlistSelectedOrAll(_jlistSequences);
            }
            if(_jlistWritten==null){
                pcp(DIA_MATCH_KEY_SAVE,"Proteins",_jlistWritten=new ChJList(JLIST_OPTIONS_FILES|JLIST_DEFAULT_RENDERER,_v=new ArrayList()));
                pcp(KEY_PANEL,pnl(CNSEW,scrllpn(0,_jlistWritten),null,rsc(RSC_HINT_CONTEXT_AND_DND)),_jlistWritten);
            }
            final Collection vTxt=new ArrayList(999);
            int count=0;
            FORi(0,sze(pp)){
                final Protein p=pp[i];
                int[]range=null;
                if(isCbSlct(STOG_DIA_EXPORT_SEQUENCES_Rubber_Band)){
                    range=new int[]{p.columnToIndex(CTRUE,fromCol),p.columnToIndex(CFALSE,toCol)};
                    if(range[0]>=range[1]) continue;
                }
                final ProteinWriter pw=(ProteinWriter)mkInstance(iCLASS_ProteinWriter,_choiceClass);
                if(pw==null) break;
                pw.getProteinText(SEQW_HETEROS|SEQW_SEQRES|SEQW_HELIX_SHEET,p,new Matrix3D[]{p.getRotationAndTranslation()},range,clr(vTxt));

                adUniq(wrte(file(iPath2(DIR_STRAPOUT,p).a(iConst(SARRAYeq_STRAP_FILE_EXT,bidForClass(pw))).replaceChar(':','_')),vTxt),_v);
                count++;

                amsDo(AMS_CONTENT_CHANGED,111,_jlistWritten,null);
            }
            if(count>0){
                shwTxtInW(FRAME_AT_CLICK,"Exported sequence files",_jlistWritten);
                adUniq(iFile(DIR_STRAPOUT),_v);
            }
            baLog(LOG_MSG).aPlrl(count,"@1 Written %N file%S");
        }
        BREAK;
    }
 }
#undef _jlistWritten
