#define DIA_FETCH_PDB_CHOICE_PDB_SITE 1
@*H THIS_CLASS(DIA_FETCH_PDB)
 This dialog aims at loading many PDB-files from file servers.

 The user enters a text containing
 pdb-codes such as <I>1prp</I>, <I>pdb1ryp</I> or <I>1SBC.</I>

 The optional chain identifier must be preceded by colon or underscore.
*@
@*~RSC_DIALOGFETCHPDB_EXAMPLE
 Words consisting of four letters or digits are assumed to be PDB identifiers.
 They can be typed in different ways:
 - 1sbc 1sbt  or
 - or pdb1sbc pdb1sbt
 - or with chain pdb1sbc_A or pdb1sbc:A  or  1ryp:L
 They are download with the "GO" button.
*@
@*~RSC_DIALOGFETCHPDB_EMPTY
Enter a text containing PDB IDs
*@
/* Used to be "http://www.rcsb.org/pdb/files/1sbt.cif.gz"; */
/* Now "http://files.rcsb.org/download/1SBT.pdb.gz"; */
/* Used to be http://www.rcsb.org/pdb/files/fasta.txt?structureIdList=1SBT */
/* Now http://www.rcsb.org/pdb/download/downloadFastaFiles.do?compressionType=uncompressed&structureIdList=1SBT */

#define _fetchPdbFT _iii[0]
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        tcTools(pcp(KEY_IF_EMPTY,rsc(RSC_DIALOGFETCHPDB_EMPTY),addSrvc(RUN_TEXT_CHANGED,this,_jTextArea=new ChTextArea(4,4))))
            .saveInFile("DialogFetchPdb")
            .enableUndo(true).enableWordCompletion(iFile(DIR_WORKING));
        runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_highlight,this);
        final Object alsoSee=pnl(buttn(BUT_C1(DialogFetchSRS)),buttn(BUTS_MOVIE_Load_Proteins)," ",buttn(BUTS_MOVIE_Load_Proteins_web_pdb));
        pnl(this,CNSEW,
            scrllpn(0,_jTextArea),
            null,
            pnl(VBHB,
                _bb[DIA_FETCH_PDB_CHOICE_PDB_SITE]=((ChJCombo)customizeNewComboForID(CUSTOM_pdbFiles)).savePrprty(PRPRTY_FetchPdbSite),
                pnl(newBut(BUTS_GO,this)," ",newBut(SBUTS_DIALOGS_NEWBIES_EXAMPLE,this)),pnlTogglOpts(TOGGL_PNL_AlsoSee,alsoSee),
                alsoSee
));
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==BUTS_GO){
            runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_highlight,this);
            final BA ba=tcTools(_jTextArea).byteArray();
            {
                final int b=((JTextComponent)_jTextArea).getSelectionStart(),e=((JTextComponent)_jTextArea).getSelectionEnd();
                runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_ids,this,ba,io(b<e?b:0),io(b<e?e:MAX_INT));
            }
            //fromTo[]=_fetchPdbIds(ba,b<e?b:0,b<e?e:MAX_INT),
            final int N=_fetchPdbFT.length/2;
            if(N==0) baLog(LOG_MSG).a(RED_ERROR).aln(ANSI_W_ON_R+"No PDB codes found in the text!");
            else{
                baLog(LOG_MSG).send();

                final String pdbBase=s(_bb[DIA_FETCH_PDB_CHOICE_PDB_SITE]),urls[]=new String[N],fileNames[]=new String[N],chains[]=new String[N];
                final byte[]T=ba.bytes();
                final BA id4=new BA(6);
                ROFi0(N){
                    final int f=_fetchPdbFT[2*i],t=_fetchPdbFT[2*i+1];
                    if(t-f==LENGTH_PDBIDS && t<=T.length){
                        clr(id4).aFT(T,f,t);
                        urls[i]=pdbToUrlMask(s(id4),pdbBase);
                        if(t+2<=ba.end() &&  (T[t]==':' || T[t]=='_' || T[t]=='|'))  chains[i]=pdbChainAt(T,t+1,ba.end());
                        fileNames[i]=s(id4.a(".cif"));
                    }
                }
                final SDialogs tab=new SDialogs(TAB_FETCH_PDB);
                tab._bb[TAB_FETCH_PDB_urls]=urls;
                tab._bb[TAB_FETCH_PDB_chains]=chains;
                tab._bb[TAB_FETCH_PDB_fileNames]=fileNames;
                runCR(RUN_INIT_DIALOG,tab);
                adTab(DISPOSE_CtrlW,"Fetched ",tab,_tabbed);
            }
        }
        if(bid==SBUTS_DIALOGS_NEWBIES_EXAMPLE) setTxt(new BA(99).aa(rsc(RSC_DIALOGFETCHPDB_EXAMPLE),_jTextArea),_jTextArea);
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_FETCH_PDB_CHOICE_PDB_highlight){
        tcRemoveHighlight(_textMatches,_jTextArea);
        runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_ids,this,tcTools(_jTextArea).byteArray(),io(0),io(MAX_INT));
        tcAddHighlight(_textMatches=new TextMatches(0,_fetchPdbFT,MAX_INT,argbToColor(0x80FF4400)),_jTextArea);
        break;
    }
    CASE_ARGV(_RUN_DIA_FETCH_PDB_CHOICE_PDB_ids,BA,ba,int,selBeg,int,e){
        final byte[]T=ba.bytes();
        int count=0;
        final int E=mini(ba.end(),e);
        FORi(selBeg,E-3){
            if(isChrClas(LETTR_DIGT_US,T,i-1)?
                ('b'!= (T[i-1]|32) || !strEquAt(STR_w_L,"pdb",T,i-3)&& !strEquAt(STR_w_L,"PDB",T,i-3)): !isChrClas(DIGT,T,i)) continue;
            if(!(i+4<E&&isChrClas(LETTR_DIGT,T,i+4)) && (0>nxt(chrClas(-LOWR_DIGT),T,i,i+4) || 0>nxt(chrClas(-UPPR_DIGT),T,i,i+4))){
                if(sze(_fetchPdbFT)<=count+1) _fetchPdbFT=chSze(_fetchPdbFT,count+99);
                _fetchPdbFT[count++]=i;
                _fetchPdbFT[count++]=i+4;
            }
        }
        if(sze(_fetchPdbFT)>count) _fetchPdbFT=chSze(_fetchPdbFT,count);
        RETURN(_fetchPdbFT);
    }
    CASE_ARG(RUN_TEXT_CHANGED,Object,o){
        runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_highlight,this);
        RETURN(TRUEr);
    }
 }

//private int[]_fetchPdbIds(BA ba,int,selBeg,int,selEnd)
//runCR(_RUN_DIA_FETCH_PDB_CHOICE_PDB_ids,this,

#undef _fetchPdbFT
