/* (NUM 0) 14128 */
#define HSLV_ECOLI 0
#define P68871 1
#define M57965 2
#define GI_20259105 3
#define NM_002726 4
#define UPI0000672BF8 5
#define TYPES_ZZZ 6
/* --- */
#define LBUT_FETCH_SEQS_HL 1
/* (NUM1 1) */
#define _fetchSeqs_pnlLoad _bb[1]
#define _fetchSeqsWords _bb[2]

@*H THIS_CLASS(DIA_FETCH_SEQ)
 Sequence files can be loaded from public servers.

 A text containing sequence IDs is pasted into the text area.

 Certain types of IDs are identified and highlighted within the text
 on pressing the respective highlight button.

 Subsequently, they can be fetched from the respective server.
*@
@*SARRAYeq_DialogFetchSRS_TYPES_SS
 Like "HSLV_ECOLI" (SwissProt)=HSLV_ECOLI
 Like "P68871" (letter + letters/digits)=P68871
 Like "M57965" (letter + digits)=M57965
 Like "gi|20259105" (NCBI)=GI_20259105
 Like "NM_002726" (NCBI)=NM_002726
 Like "UPI0000672BF8" (Uniparc)=UPI0000672BF8
*@
@*~RSC_DIALOGFETCHSRS_EXAMPLE
 HSLV_ECOLI or HSLV_BACSU or P68871 can be loaded from UniProt
 M57965 can be loaded from Embl.
 UPI0000672BF8 ore UPI0000685C48 are loaded from UniParc
 NM_002726 or gi|20259105 can be loaded from NCBI
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        final Object pnlHL=pnl(new GridLayout(TYPES_ZZZ,1));
        FORi(0,TYPES_ZZZ) adC(awtc(AWTC_SET_HORIZONTAL_ALIGNMENT_SWC_LEFT,newButtn(0,iConst(SARRAYeq_DialogFetchSRS_TYPES_SS,i),this)),pnlHL);
        tcTools(addActLi(this,pcp(KEY_IF_EMPTY,"First step: Enter here a text with sequence IDs \n",_jTextArea=new ChTextArea(4,4)))).enableWordCompletion(iFile(DIR_WORKING)).enableUndo(true);
        final Object alsoSee=pnl(VBHB,buttn(BUT_C1(DialogFetchPdb)),buttn(BUTS_MOVIE_Load_Proteins)," ",buttn(BUTS_MOVIE_Load_Proteins_web_pdb));
        pnl(this,CNSEW,pnl(CNSEW,scrllpn(0,_jTextArea),null,null,pnl(CNSEW,pnl(pnlHL),"2nd step: Highlight all IDs in the text")),
            pnl(VBPNL,pnl(HBL,"First step: Enter text containing sequence IDs ",newBut(SBUTS_DIALOGS_NEWBIES_EXAMPLE,this))),
            pnl(VBHB,"Last step: Click the respective file server:",
                pnl(_fetchSeqs_pnlLoad=pnl()),
                pnlTogglOpts(TOGGL_PNL_AlsoSee,alsoSee),
                alsoSee));
        runCR(_RUN_DIA_FETCH_SEQ_Layout,this);
        break;
    }
    CASE_ARGV(_RUN_DIA_FETCH_SEQ_Layout){
        awtc(AWTC_REMOVE_ALL,_fetchSeqs_pnlLoad);
        final String[]dbs=custSettings(CUSTOM_fetchProteinFile);
        ((Container)_fetchSeqs_pnlLoad).setLayout(new GridLayout(1,dbs.length));
        for(String db:dbs) adC(pcp(_KEY_WORD,db,newButtn(LBUT_FETCH_SEQS_HL,delChrSfx(':',db),this)),_fetchSeqs_pnlLoad);
        break;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(evtSrc(ev) instanceof Customize) {
            runCR(_RUN_DIA_FETCH_SEQ_Layout,this);
            awtc(AWTC_OPT_REVALIDATE,this);
        }
        if(bid==SBUTS_DIALOGS_NEWBIES_EXAMPLE) setTxt(addPfx(s(rsc(RSC_DIALOGFETCHSRS_EXAMPLE)),_jTextArea),_jTextArea);
        boolean clrErr=false;
        ROFt0(TYPES_ZZZ){
            if(strEnds(iConst(SARRAYeq_DialogFetchSRS_TYPES_SS,t),evtCmd(ev))){
                tcTools(_jTextArea).setChanged();
                final BA ba=tcTools(_jTextArea).byteArray();
                tcRemoveHighlight(_textMatches,_jTextArea);
                final byte[]T=ba.bytes();
                int E=((JTextComponent)_jTextArea).getSelectionEnd(),B=((JTextComponent)_jTextArea).getSelectionStart();
                if(B<0||B>=E-1) {B=0;E=ba.end();}
                //private static int[]_fetchSeqsFindIds(int t,byte[]T,int B,int E)
                int[]fromTo=null;
                for(;;){
                    int count=0;
                    FORi(B,E-2){
                        if(isChrClas(LETTR_DIGT_US,T,i-1)) continue;
                        int end=0;
                        final boolean U=isChrClas(UPPR,T,i);
                        switch(t){
                        case NM_002726:
                        case HSLV_ECOLI:
                            final int cc=U?-UPPR_DIGT: isChrClas(LOWR,T,i)?-LOWR_DIGT:0;
                            if(cc!=0){
                                final int us=nxt(0,chrClas(cc),T,i,E);
                                if(us>i+2 && T[us]=='_'){
                                    final int e=nxt(STR_E,chrClas(cc),T,us+1,E);
                                    if(e>us+2) end=e;
                                }
                            }
                            break;
                        case P68871:
                            if(U){
                                final int e=nxt(STR_E,chrClas(-UPPR_DIGT),T,i,E);
                                if(e>5+i && countChrClas(chrClas(DIGT),T,i+1,e)>0) end=e;
                            }
                            break;
                        case GI_20259105:
                            if(i>=3 && (T[i-3]|32)=='g' && (T[i-2]|32)=='i'  && (T[i-1]=='|' || T[i-1]==':')){
                                final int e=nxt(STR_E,chrClas(-DIGT),T,i+1,E);
                                if(e>i+1) end=e;
                            }
                            break;
                        case M57965:
                            if(U){
                                final int e=nxt(STR_E,chrClas(-DIGT),T,i+1,E);
                                if(e>4+1+i) end=e;
                            }
                            break;
                        case
                            UPI0000672BF8:
                            if(T[i]=='U' && T[i+1]=='P' && T[i+2]=='I' && i+13==nxt(STR_E,chrClas(-LETTR_DIGT),T,i+3,E)) end=i+13;
                            break;
                        }
                        if(end>0 && !(end<E&&isChrClas(LETTR_DIGT_US,T,end))){
                            if(fromTo!=null){
                                fromTo[2*count]=i;
                                fromTo[2*count+1]=end;
                            }
                            count++;
                        }
                    }
                    if(fromTo==null) fromTo=new int[2*count]; else break;
                }
                tcAddHighlight(_textMatches=new TextMatches(0,fromTo,MAX_INT,argbToColor(0x80FF4400)),_jTextArea);
                final String[]ww=new String[sze(fromTo)/2];
                _fetchSeqsWords=ww;
                FORi(0,ww.length)ww[i]=ba.getString(MAP_BA_STRING_TRIM,fromTo[2*i],fromTo[2*i+1]);
                repaint();
                clrErr=true;
            }
        }
        if(bid==SDIALOGS_JTEXTAREA){tcRemoveHighlight(_textMatches,_jTextArea); _fetchSeqsWords=null; _textMatches=null; clrErr=true;}
        if(bid==LBUT_FETCH_SEQS_HL){
            if(tcTools(_jTextArea).byteArray().onlyWhiteSpace()) baLog(LOG_MSG).a(RED_ERROR).aln("Type/paste a text containing sequence IDs");
            else{
                final String DB=gcps(_KEY_WORD,_bb[LBUT_FETCH_SEQS_HL]),ww[]=(String[])_fetchSeqsWords;
                if(ww==null) baLog(LOG_MSG).a(RED_ERROR).aln("Highlight the IDs by pressing one of the 'highlight..'-buttons");
                else if(ww.length>0){
                    final String[]urls=new String[ww.length];
                    FORi(0,ww.length)urls[i]=addPfx(DB,ww[i]);
                    final SDialogs tab=new SDialogs(TAB_FETCH_PDB);
                    tab._bb[TAB_FETCH_PDB_urls]=urls;
                    tab._bb[TAB_FETCH_PDB_fileNames]=ww;
                    runCR(RUN_INIT_DIALOG,tab);
                    adTab(DISPOSE_CtrlW,delChrSfx(':',DB),tab,_tabbed);
                }
            }
        }
        if(clrErr) baLog(LOG_MSG).aln(null);
        BREAK;
    }
 }
