@*H THIS_CLASS(DIA_GENBANK)
 The Genbank file format and Embl file format are used for annotated nucleotide sequences.
 Format specifications:
 <UL>
 <LI>http://www.ncbi.nlm.nih.gov/Sitemap/samplerecord.html</LI>
 <LI>ftp://ftp.ncbi.nih.gov/genbank/gbrel.txt</LI>
 <LI>http://www.ebi.ac.uk/embl/Documentation/User_manual/usrman.html</LI>
 </UL>
 After loading a Genbank or Embl file into Strap, the nucleotide sequence is shown.
 Only after translation into amino acids, the amino acid sequence is shown.
 The translation is directed by the CDS-expression within the file.
 Example:
 <PRE class="data" style="float: right;">
 CDS     5. .799
 /gene="Psmb5"
 /product="proteasome subunit X"
 </PRE>
 If a file contains several CDS then the user can choose one of them.
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        return pnl(VBPNL,"Select sequences in Genbank or EMBL format",newBut(BUTS_GO,this));
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==BUTS_GO){
            _seqs=selectedProteins();
            runCR1(RUN_COMPUTE,this,null);
            if(_seqs.length==0) pleaseSelect(CHAINTYPE_PEP,null);
        }
        BREAK;
    }
    CASE_ARG(RUN_COMPUTE,Object,unused){
        if(sze(_seqs=proteinsThatComply(IF_HAS_CDS_DATA,spp(_seqs)))==0) RETURN FALSEr;
        final SDialogs tab=new SDialogs(TAB_GENBANK);
        tab._seqs=_seqs;
        runCR(RUN_INIT_DIALOG,tab);
        adTab(DISPOSE_CtrlW,plrl(++_resultNum,"%n    "),tab,_tabbed);
        break;
    }
 }
#if 0
/*
  Problem:
  AL935121
  FT   CDS             complement(join(104984..105040,105385..105531,
  FT                   AL772299.10:2661..2732,AL772299.10:3575..3646,
  FT                   AL772299.10:4101..4220,AL772299.10:5400..5462,
  FT                   AL772299.10:5872..6063,AL772299.10:9023..9139,
  FT                   AL772299.10:10369..10503,AL772299.10:12643..12788,
*/
#endif //0
