/* (NUM1 0) */
#define COL_VISIBLE_ALI 0
#define COL_VISIBLE_3D 1
#define COL_VISIBLE_SB 2
#define COL_VISIBLE_NT 3
#define COL_PATTERN 4
#define COL_COLOR 5
#define COL_NAVI 6
#define COL_ZZZ 7
/* --- */
#define PP()  (isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Only_in_selected])?selectedProteins():strapVisibleProteins())
/*(NUM1 1)*/
#define DIA_HIGHLIGHT_PATTERN_BUT_NXT_PREV 1
#define DIA_HIGHLIGHT_PATTERN_ERROR_STRG 2
#define DIA_HIGHLIGHT_PATTERN_NAVIGATION 3
@*H THIS_CLASS(DIA_HIGHLIGHT_PATTERN)
 This dialog is used to underline all occurrences of sequence patterns.
 <BR>
 <BR>
 The search patterns are entered into the table.
 Several search patterns can be entered in one single table row and must be separated
 by white space.

 All matches are underlined. The highlights have a context menu.
 <BR>
 <BR>
 The search string may be a simple string of letters or a complex WIKI:Regular_expression. Syntax:

 <UL>
 <LI>"FSP" is a simple search string identifying all occurrences of "FSP" in the amino acid sequence.</LI>
 <LI>A dot matches any letter. For example "F.P" would match F followed by any letter followed by P.</LI>
 <LI>Vertical bars separate alternatives. "IFSP|TFSP" is equivalent to "[IT]FSP" or "(IF|TF)SP" or "IFSP&nbsp;&nbsp;&nbsp;TFSP".</LI>
 <LI>"(.....)\1" selects all penta repeats. A backslash-number is a reference to a parenthesized group.</LI>
 <LI>Square brackets enclose groups of letters at one single sequence position. "[FYW][FYW]" selects adjacent aromatic amino acids.</LI>
 <LI>"[ke]{3,99}"highlights all occurrences of 3 to 99 continuous positions containing either Lys or Glu.</LI>
 </UL>
 <i>HTMLDOC_SEE_CLASS:BUT_C1(ResidueSelection)</i>
*@
@*SARRAYeq_DIA_HLTPATTERN_HEADERS
 CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Alignment Pane=COL_VISIBLE_ALI
 CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)3D Backbone=COL_VISIBLE_3D
 CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Scroll-bar=COL_VISIBLE_SB
 CPP_UNSTRINGIZE(BUTTN_PFX_VERTICAL)Nucleotide sequence=COL_VISIBLE_NT
 Type a search pattern.  Separate patterns by white space.=COL_PATTERN
 Navigation=COL_NAVI
*@
@*SARRAYeq_DIA_HLTPATTERN_HEADER_TIPS
 Visible in alignment panel=COL_VISIBLE_ALI
 Visible in 3D-Backbone=COL_VISIBLE_3D
 Visible in horizontal scrollbar=COL_VISIBLE_SB
 Act on nucleotide sequence=COL_VISIBLE_NT
 Small sequence of amino acids in (One-letter-code) to be searched for. A dot matches any amino acid.=COL_PATTERN
 Change color of hits=COL_COLOR
 Jump to first, previous, next and last hit=COL_NAVI
*@
@*~RSC_DIALOG_PATTERN_nucleotides
 Search in nucleotides if check-box in 4th column is activated:
*@
@*RSC_DIALOG_PATTERN_ERROR_NUCL
 Error selecting "nt": No nucleotide sequence present.
*@
#define _hlPattern_iTh(i) (ResidueSelectionImpl)iThEl(i,_v)
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        _bb[DIA_HIGHLIGHT_PATTERN_NAVIGATION]=navigationPreviousNext(DIA_HIGHLIGHT_PATTERN_BUT_NXT_PREV|NAVIGATION_PREV_NEXT_WITH_EDITOR_COMPONENT,this,"Go to * match");
        (_v=new ArrayList()).add(runCR1(_RUN_DIA_HIGHLIGHT_newHighlight,this,""));
        _bb[SDIALOGS_RESSEL]=_v;
        addShutdownHook1(thrdCR(_RUN_DIA_HIGHLIGHT_PATTERN_SHUTDOWNHOOK,this));
        boolean nt=false;
        {
            final String[]txt=readLns(iFile(F_DIA_HIGHLIGHT_PATTERN));
            FORi(0,sze(txt)){
                final ResidueSelectionImpl s=(ResidueSelectionImpl)runCR1(_RUN_DIA_HIGHLIGHT_newHighlight,this,txt[i]);
                _v.add(s);
                nt=nt||s._oo[HLPAT_isNT]!=null;
                runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
            }
        }
        (_jt=new ChJTable(JLIST_EXX_ROW_HEIGHT|JLIST_DEFAULT_RENDERER|JLIST_NO_REORDER,new ChTableModel(0,arry(SARRAYeq_DIA_HLTPATTERN_HEADERS),this)).headerTip(arry(SARRAYeq_DIA_HLTPATTERN_HEADER_TIPS))).setRowSelectionAllowed(false);
        addSrvc(RUN_TEXT_CHANGED,this,_jt.getChRenderer().getRndrerTextfield());
        _jt.getTableHeader().setDefaultRenderer(chRenderer());
        _jt.setCellSelectionEnabled(false);
        final Object
            sp=scrllpn(SCRLLPN_INHERIT_SIZE,rtt(_jt)),
            options=pnl(rsc(RSC_DIALOG_PATTERN_nucleotides),_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Fwd],_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Rev_Compl],"  ",_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Only_in_selected],"  ",runCR(_RUN_DIA_MAKE_CHOICE_STYLE,this)),
            _pMain=pnl(CNSEW,sp,
                       pnl(VBHB,
                           pnl(HBL,"Details ",_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Details]),options,monospc(_bb[BUTS_DIA_HIGHLIGHT_PATTERN_Label]),"##"));
        setSlct(nt,pcp(BUTTN_KEY_COLLAPSE,options,_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Details]));
        runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
        pcp(KEY_CLOSE_OPT,io(CLOSE_DISPOSE),this);
        setMinSze(4*EX,4*EX,setBrdrC(null,sp));
        runCR(_RUN_DIA_HIGHLIGHT_PATTERN_SET_WIDTH,this);
        return _pMain;
    }
    CASE_ARGV(RUN_TABLE_getRowCount) ROW_COL[0]=sze(_v);break;
    CASE_ARGV(RUN_TABLE_getValueAt){
        final ResidueSelectionImpl s=_hlPattern_iTh(ROW_COL[0]);
        if(s==null) return "Error";
        int w=0;
        switch(ROW_COL[1]){
        case COL_VISIBLE_ALI:w=VIS123_SEQUENCE;break;
        case COL_VISIBLE_3D:w=VIS123_STRUCTURE;break;
        case COL_VISIBLE_SB:w=VIS123_SB;break;
        case COL_VISIBLE_NT:return bo(s._oo[HLPAT_isNT]!=null);
        case COL_PATTERN:return s._oo[HLPAT_text];
        case COL_COLOR:
            if(s._oo[HLPAT_butColor]==null) s._oo[HLPAT_butColor]=ChButton.doColor(0,RGBA_MAGENTA,s);
            return s._oo[HLPAT_butColor];
        case COL_NAVI:return _bb[DIA_HIGHLIGHT_PATTERN_NAVIGATION];
        }
        return bo(0!=(s.getVisibleWhere()&w));
    }
    CASE_ARGV(RUN_TABLE_isCellEditable) return ROW_COL[0]>=0?TRUEr:FALSEr;
    CASE_ARG(RUN_TABLE_setValueAt,Object,o){
        final int col=ROW_COL[1];
        final ResidueSelectionImpl s=_hlPattern_iTh(ROW_COL[0]);
        if(s!=null&&o!=null){
            int mask=0;
            boolean changed=false;
            switch(col){
            case COL_VISIBLE_ALI:mask=VIS123_SEQUENCE;break;
            case COL_VISIBLE_3D:mask=VIS123_STRUCTURE;break;
            case COL_VISIBLE_SB:
                mask=VIS123_SB;
                if(isTrue(o)) runCR(RUN_ALIPANEL_OUTLINE_SB_OFF,aliPanel());
                break;
            case COL_VISIBLE_NT:
                changed=runCR1(_RUN_HIGHLIGHTPATTERN_MASTER_SET_TAKE_NUCLEOTIDES,s,isTrue(o)?TRUEr:null)!=null;
                runCR1(_RUN_DIA_HIGHLIGHT_PATTERN_SET_ERROR,this,s._oo[HLPAT_isNT]!=null && null==fstComplies(PP(),IF_NT)?rsc(RSC_DIALOG_PATTERN_ERROR_NUCL): "");
                break;
            case COL_PATTERN:
                changed|=runCR1(RUN_SET_TEXT,s,o)!=null;
                runCR(_RUN_DIA_HIGHLIGHT_PATTERN_NEW_ROW,this);
                awtc(AWTC_OPT_REPAINT,_jt);
                break;
            default:
            }
            if(mask!=0){
                final int v0=s.getVisibleWhere(),v=o==bo(true)?(v0|mask):(v0&~mask);
                if(v!=v0){
                    changed=true;
                    s.setVisibleWhere(v);
                }
            }
            if(changed){
                runCR1(_RUN_HIGHLIGHTPATTERN_MASTER_ADD_TO_SEQUENCES,s,PP());
                runCR(_RUN_DIA_HIGHLIGHT_PATTERN_NEW_ROW,this);
                strapIncMC(P_MC_RES_SELECTIONS,sp(s));
                strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*99);
                awtc(AWTC_OPT_REPAINT,_jt);
            }
        }
        RETURN(null);
    }
    CASE_ARGV(RUN_DISPOSE){
        runCR(_RUN_DIA_HIGHLIGHT_PATTERN_REMOVE_ALL,this);
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
        runCR(_RUN_DIA_HIGHLIGHT_PATTERN_CLEAR_ANTS,this);
        return TRUEr;
    }
    CASE_ARG(RUN_TEXT_CHANGED,Object,o){
        if(o==_jt.getChRenderer().getRndrerTextfield() && runCR1(RUN_SET_TEXT,_hlPattern_iTh(_jt.getChRenderer().editedRowCol(0)),o)!=null) runCR(_RUN_DIA_HIGHLIGHT_PATTERN_CHANGED,this);
        BREAK;
    }
    CASE_ARGV(RUN_DIA_HIGHLIGHT_PATTERN_GET_fwdOrRev) return io((_mc<<16)|(isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Rev_Compl])?HIGHLIGHT_PATTERN_REVCOMP:0)|(isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Fwd])?HIGHLIGHT_PATTERN_FORWARD:0));
    CASE_ARG(_RUN_DIA_HIGHLIGHT_PATTERN_SET_ERROR,Object,msg){
        if((msg=s(msg))!=_bb[DIA_HIGHLIGHT_PATTERN_ERROR_STRG]){
            setTxt(msg,setFG(0xFF0000,_bb[BUTS_DIA_HIGHLIGHT_PATTERN_Label]));
            if((sze(msg)==0) != (sze(_bb[DIA_HIGHLIGHT_PATTERN_ERROR_STRG])==0))  awtc(AWTC_OPT_REVALIDATE,_bb[BUTS_DIA_HIGHLIGHT_PATTERN_Label]);
            _bb[DIA_HIGHLIGHT_PATTERN_ERROR_STRG]=msg;
        }
        BREAK;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_CHANGED){
        runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
        strapIncMC(P_MC_RES_SELECTIONS,null);
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
        break;
    }
    CASE_ARG(_RUN_DIA_HIGHLIGHT_newHighlight,Object,lineAsString){
        final ResidueSelectionImpl s=new ResidueSelectionImpl(RESSEL_IMPL_HIGHLIGHT_PATTERN_MASTER);
        s._oo[HLPAT_dialog]=this;
        int where=-1;
        final String[]ss=splitTkns('\t',lineAsString);
        if(sze(ss)>3){
            runCR1(RUN_SET_TEXT,s,ss[0]);
            runCR1(RUN_SET_COLOR,s,str2color(ss[1],0));
            where=xatoi(ss[2]);
            runCR1(_RUN_HIGHLIGHTPATTERN_MASTER_SET_TAKE_NUCLEOTIDES,s,isTrue(ss[3])?TRUEr:null);
        }
        if(where!=-1) s.setVisibleWhere(where|VIS123_LIST_NOT_EMPTY);
        s.setStyle(SSTYLE_BACKGROUND);
        RETURN s;
    }

    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_REMOVE_ALL){
        for(Protein p:strapProteins())
            for(ResidueSelection s:p.resSel(SOBJECT_RESSEL))
                if(xatoi(runCR(RUN_GET_INSTANCE_TYPE,s))==RESSEL_IMPL_HIGHLIGHT_PATTERN) rmFromProt(s,p);
        break;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_SET_WIDTH){
        final boolean details=isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Details]);
        int headerH=EX;
        ROFc0(COL_ZZZ){
            final int w=c<COL_PATTERN?(details?ICON_HGT:0):
                c==COL_COLOR?ICON_HGT:
                c==COL_NAVI?prefW(_bb[DIA_HIGHLIGHT_PATTERN_NAVIGATION]):
                -1;
            if(w>=0) ROFj0(2) _jt.setColWidth(w,c);
            if(details) headerH=maxi(headerH,prefH(labl(iConst(SARRAYeq_DIA_HLTPATTERN_HEADERS,c))));
        }
        _jt.getColumnModel().setColumnMargin(details?1:0);
        setPrefSze(1,headerH+EX,_jt.getTableHeader());
        break;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_NEW_ROW){
        ROFi0(sze(_v)){
            final ResidueSelectionImpl s=_hlPattern_iTh(i);
            if(s!=null&&sze(s._oo[HLPAT_text])==0) return null;
        }
        _v.add(runCR1(_RUN_DIA_HIGHLIGHT_newHighlight,this,""));
        awtc(AWTC_OPT_REVALIDATE,_jt);
        break;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN){
        runCR1(_RUN_HIGHLIGHTPATTERN_MASTER_ADD_TO_SEQUENCES,_v,PP());
        strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*111);
        break;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_SHUTDOWNHOOK){
        final BA sb=new BA(999);
        ROFi0(sze(_v)){
            final ResidueSelectionImpl s=_hlPattern_iTh(i);
            if(s!=null && sze(s._oo[HLPAT_text])>0) sb.aa(s._oo[HLPAT_text],'\t','#').aFT(runCR(RUN_GET_COLOR,s),0,8).aa('\t',s.getVisibleWhere(),'\t',s._oo[HLPAT_isNT]!=null).aln();
        }
        wrte(iFile(F_DIA_HIGHLIGHT_PATTERN),sb);
        break;
    }
    CASE_ARGV(_RUN_DIA_HIGHLIGHT_PATTERN_CLEAR_ANTS){
        addMarchingAnt(ANTS_SEARCH,runCR(RUN_ALIPANEL_GET_PANE,aliPanel()),null,null,null);
        break;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        if(t==EVT_SEQUENCE_ADDED || t==EVT_SEQUENCE_REMOVED) runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
        else if(EVT_RESIDUES_AAA<t && t<EVT_RESTYPE_ZZZ) strapEvtDispatch(EVT_RESIDUE_SELECTION|SEVTMS*333);
        else if((t&SEVT_MASK_SEQ_SELECTED)==SEVT_MASK_SEQ_SELECTED && isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Only_in_selected])){
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_REMOVE_ALL,this);
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_CLEAR_ANTS,this);
        }
        return TRUEr;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==STOGS_DIA_HIGHLIGHT_PATTERN_Details){
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_SET_WIDTH,this);
            revalidate();
        }
        {
            final ResidueSelectionImpl s=_hlPattern_iTh(_jt.getChRenderer().editedRowCol(0));
            if(s!=null && DIA_HIGHLIGHT_PATTERN_BUT_NXT_PREV<=bid && bid<DIA_HIGHLIGHT_PATTERN_BUT_NXT_PREV+4){
                final Collection v=new ArrayList();
                for(Protein p:strapProteins()) adNotNull(runCR1(RUN_HIGHLIGHTPATTERN_MASTER_resselForSeq,s,p),v);
                resselNxtprevGo(bid-DIA_HIGHLIGHT_PATTERN_BUT_NXT_PREV,toArry(v,ResidueSelection.NONE));/*X s._nextAndPrev.go*/
            }
        }
        if(bid==STOGS_DIA_HIGHLIGHT_PATTERN_Fwd || bid==STOGS_DIA_HIGHLIGHT_PATTERN_Rev_Compl){
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_CHANGED,this);
            if(!isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Fwd])&&!isSlct(_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Rev_Compl])) setSlct(true,_bb[STOGS_DIA_HIGHLIGHT_PATTERN_Fwd]);
            runCR(RUN_CHANGED_ResidueSelectionImpl,_v);
            _mc++;
        }
        if(bid==STOGS_DIA_HIGHLIGHT_PATTERN_Only_in_selected){
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_REMOVE_ALL,this);
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_HIGLIGHT_TO_PROTEIN,this);
            runCR(_RUN_DIA_HIGHLIGHT_PATTERN_CLEAR_ANTS,this);
        }

    }
    BREAK;
 }

#undef PP
#undef COL_VISIBLE_ALI
#undef COL_VISIBLE_3D
#undef COL_VISIBLE_SB
#undef COL_VISIBLE_NT
#undef COL_PATTERN
#undef COL_COLOR
#undef COL_NAVI
#undef COL_ZZZ
