#define _fileChooser _bb[2]
@*H THIS_CLASS(DIA_IMPORT_MFA)
 Multiple sequence files (<I>WIKI:FASTA_format</I>, MSF, NexusFormat, WIKI:Stockholm_format) can be directly dragged into the
 alignment panel,

 however, the import dialog provides more control for the import of these files.

 The alignment text needs to be pasted into the text-area.
 When <i>HTMLDOC_BUTTON:BUTS_GO</i> is pressed, the resulting sequences are shown as a table.

 <BR><BR><B>Setting the sequence names</B>:

 The table column <I>Sequence name</I> must contain the names for the new sequences.

 The fasta header may consist of several fields separated by a vertical bar and the first or
 secondary field can be used as sequence name.
 Alternatively, WIKI:Regular_expression can be used to extract parts of the header text.
*@
@*RSC_DialogMFA_EXPLAIN_HEADER
 Short explanation:
 The headers in fasta files often consist of fields that are separated by vertical bar.
 The example shows, how these fields are captured in parenthesis and referenced by dollar-sign-number.
*@
@*RSC_DialogMFA_EXPLAIN_HEADER_FIELD
 For example press the button "3" to use the 3rd field of the fasta header as the sequence name.
*@
@*RSC_DialogMFA_EXPLAIN_HEADER_REGEX
 The fasta header can be used to form sequence names. See WIKI:Regular_expression.
*@

@*SARRAY_ImportMFA_Skip_OR_OVERWRITE
 Skip|Overwrite sequence
*@
@*SARRAY_ImportMFA_TABLE_HEADER
 Header|Sequence name|Sequence|
*@
@*~RSC_DIA_MFA_NEWBIES_EXAMPLE
 >homo_sapiens
 MY-MISS--ISAH-IPPIE
 >mus_musculus
 I--MISS-MISSISSIPPI
*@
@*~RSC_DIA_MFA_PLEASE_ENTER
 Enter alignment in multiple fasta format
*@
@*~RSC_DIA_MFA_FFILTER
 -iz .fasta .fa .mfa # Fasta format
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){
        tcTools(pcp(KEY_IF_EMPTY,rsc(RSC_DIA_MFA_PLEASE_ENTER),_jTextArea=new ChTextArea(3,3))).enableUndo(true).enableWordCompletion(iFile(DIR_WORKING));
        pnl(this,CNSEW,scrllpn(0,_jTextArea),
            null,
            pnl(_bb[SBUTS_DIA_IMPORT_MFA_FromFile],newBut(SBUTS_DIALOGS_NEWBIES_EXAMPLE,this),"  ",newBut(BUTS_GO,this)));
        break;
    }
    CASE_ARG(RUN_FileChooser_APPROVE_SELECTION,Object,fileChooser){
        setTxt(readBytes(runCR(RUN_FCHOOSER_selectedFile,_fileChooser)),_jTextArea);
        BREAK;
    }
    CASE_ARG(RUN_M_actionPerformed,Object,ev){

        if(bid==SBUTS_DIALOGS_NEWBIES_EXAMPLE) setTxt(rsc(RSC_DIA_MFA_NEWBIES_EXAMPLE),_jTextArea);
        if(bid==SBUTS_DIA_IMPORT_MFA_FromFile){
            if(_fileChooser==null) runCR1(RUN_FCHOOSER_addFilter,addActLi(this,_fileChooser=newFileChooser(PRPRTY_ImportFasta|FCHOOSER_CLOSE)),rsc(RSC_DIA_MFA_FFILTER));
            ChFrame.frame(0,"Import_Fasta",_fileChooser).shw(FRAME_AT_CLICK);
        }
        if(bid==BUTS_GO){
            final SDialogs tab=new SDialogs(TAB_IMPORT_MFA);
            tab._txt=toBA(_jTextArea).delBlanksL().delBlanksR().aln();
            if(runCR(RUN_GO,tab)!=null) adTab(DISPOSE_CtrlW,s(++_count),tab,_tabbed);
        }
        BREAK;
    }
    CASE_ARG(RUN_STRAP_EVENT,int[],evtType){
        final int t=evtType[0];
        if(t==EVT_SEQUENCE_REMOVED||t==EVT_SEQUENCE_ADDED||t==EVT_SEQUENCE_RENAMED) awtc(AWTC_OPT_REPAINT,_tabbed);
        return TRUEr;
    }
 }
/* <<< ChRunnable <<< */
/* ---------------------------------------- */
/* >>> Class >>> */

#undef HEADER
#undef NAME
#undef SEQUENCE
#undef OVERWRITE
#undef _fileChooser
