@*H THIS_CLASS(DIA_INFER_ALIGNMENT)
 This dialog allows to set the alignment gaps using the  result of another external  alignment program.
 The alignment text is entered in any format (MSF,Fasta,ClustalW).
 Sequences are identified by their Name or residue sequence.
 A part (section) of the entire sequences is sufficient.
*@
@*~RSC_DIA_INFER_ALIGNMENT_MSG1
 Paste a local or global alignment of all or some of the displayed sequences
*@
switch(id){
    CASE_ARGV(RUN_INIT_DIALOG){

        tcTools(pcp(KEY_IF_EMPTY,rsc(RSC_DIA_INFER_ALIGNMENT_MSG1),highlightSeqsInTA(0,_jTextArea=new ChTextArea("")))).enableUndo(true).saveInFile("InferAlignment");
        return pnl(CNSEW,scrllpn(SCRLLPN_INHERIT_SIZE,_jTextArea),null,pnl(_bb[SBUTS_DIA_INFER_ALIGNMENT_Go],_bb[SBUTS_DIA_INFER_ALIGNMENT_Undo]));
    }

    CASE_ARG(RUN_M_actionPerformed,Object,ev){
        if(bid==SBUTS_DIA_INFER_ALIGNMENT_Go || bid==SBUTS_DIA_INFER_ALIGNMENT_Undo){
            for(Protein p:strapProteins()){
                final int[]gg=derefZ(gcp(_bb[SBUTS_DIA_INFER_ALIGNMENT_Go],p),int[].class),ggSave=p.getResGap();
                if(bid==SBUTS_DIA_INFER_ALIGNMENT_Go && gg==null && ggSave!=null) pcp(_bb[SBUTS_DIA_INFER_ALIGNMENT_Go],ggSave.clone(),p);
                if(bid==SBUTS_DIA_INFER_ALIGNMENT_Undo && gg!=null) p.setResidueGap(gg.clone());
            }
            strapEvtDispatch(EVT_ALIGNMENT);
        }
        if(bid==SBUTS_DIA_INFER_ALIGNMENT_Go){
            final BA errors=new BA(999),txt=tcTools(_jTextArea).byteArray().delBlanksL();
            if(nxt(0,chrClas(LETTR),txt)<0) return null;
            CPP_synchronized(SYNC_PARSE_MSA){
                msaParse(0,txt,null);
                final Protein[]prots=strapProteins().clone(),pp0=new Protein[sze(_msaName)];
                int count=0;
                ROFt0(5){/*X  First very strict then lax */
                    FORi(0,pp0.length){
                        if(pp0[i]!=null) continue;
                        final BA noSpc=new BA(999).aFilter(LETTR,_msaSeq[i]);
                        FORiP(0,prots.length){
                            if(prots[iP]==null || pp0[i]!=null) continue;
                            final String pn=prots[iP].getName();
                            boolean match=false;
                            if(t>=2 && strEquAt(t==4?0:STR_IC,_msaName[i],pn,0))  match=chrAt(_msaName[i].length(),pn)==(t==2?'.':0);
                            if(t<=1){
                                final byte[]rt=prots[iP].getResType();
                                final int idx=strstr(STR_IC,noSpc,rt);/*X  Terminal 0 in getResidueType */
                                //if(idx>=0) match=t==1?idx==0 && iThByte(sze(noSpc),rt)==0: true;
                                if(idx>=0) match=t!=1||idx==0 && iThByte(sze(noSpc),rt)==0;
                            }
                            if(match){
                                pp0[i]=prots[iP];
                                prots[iP]=null;
                                count++;
                            }
                        }
                    }
                }/*X t*/
                final Protein[]pp=new Protein[count];
                final byte[][]gg=new byte[pp.length][];
                for(int i=0,k=0;i<pp0.length;i++){
                    if(pp0[i]==null) errors.a(_msaName[i]).aln(": No such protein");
                    else{
                        pp[k]=pp0[i];
                        gg[k++]=_msaSeq[i];
                    }
                }

                if(pp.length>0) acceptAlignment(gg,pp,0,null);
                // FORi(0,pp.length)baOut(pp[i]).a(' ').aln(gg[i]).aln();
            }
            if(sze(errors)>0) errors.special(BA_ERROR);

            awtc(AWTC_SET_ENABLED,_bb[SBUTS_DIA_INFER_ALIGNMENT_Undo]);
        }
        BREAK;
    }
 }
